/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAIconTextData;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.BackupServersCtrBO;
import com.sybase.aseplugin.bo.SDCInstanceBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.BackupServerWizard;
import com.sybase.aseplugin.bo.wiz.BackupServerWizardBase;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.ASEIntroWizGOPage;
import com.sybase.aseplugin.go.wiz.MonitorServerWizGOInstancesPage;
import com.sybase.aseplugin.so.MonitorServerSO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.plugin.AgentPluginException;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;

public class MonitorServerWizard
extends BackupServerWizard {
    protected MonitorServerSO _monitorServerSO;

    public MonitorServerWizard(MonitorServerSO monitorServerSO, BackupServersCtrBO backupServersCtrBO) {
        super((SOItemInterface)monitorServerSO, (SCContainer2)backupServersCtrBO, ASEUtils.getString("MONITOR_SERVER_SERVER_CONFIGURE_TEXT"));
        this._monitorServerSO = monitorServerSO;
    }

    public MonitorServerWizard(MonitorServerSO monitorServerSO, BackupServersCtrBO backupServersCtrBO, String string) {
        super((SOItemInterface)monitorServerSO, (SCContainer2)backupServersCtrBO, string);
        this._monitorServerSO = monitorServerSO;
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new MonitorServerWizIntroPage(this), new MonitorServerWizInstancesPage(this), new MonitorServerWizSummaryPage(this)};
    }

    class MonitorServerWizSummaryPage
    extends SummaryWizBOPage {
        public MonitorServerWizSummaryPage(MonitorServerWizard monitorServerWizard2) {
            super(monitorServerWizard2, ASEImages.getRemoteServerWizardImage());
        }

        @Override
        public void enableComponents() {
            this._goPanel.getPreviewButton().setVisible(false);
            this._goPanel.getScheduleButton().setVisible(false);
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("AUXILIARY_SERVER_SERVER_NAME_HEADER"), MonitorServerWizard.this._monitorServerSO.getName());
            Vector vector = MonitorServerWizard.this._monitorServerSO.getNodes();
            Object[] objectArray = null;
            for (int i = 0; i < vector.size(); ++i) {
                this.addSummaryItem("", "");
                objectArray = (Object[])vector.get(i);
                this.addSummaryItem(BackupServersCtrBO.HEADER_INSTANCE, objectArray[0].toString());
                this.addSummaryItem(BackupServersCtrBO.HEADER_PORT, objectArray[1].toString());
                this.addSummaryItem(BackupServersCtrBO.HEADER_ERROR_FILE, objectArray[2].toString());
            }
            this.setSummaryInfo(this.getSummary());
        }

        private boolean isMonitorScriptInstalled() throws SQLException {
            String string = SQLs.getString("select proc_name = pr.name from {0}.dbo.sysobjects pr, {0}.dbo.sysusers u where pr.type = ''P'' and pr.uid = u.uid and pr.name = ''{1}'' and  u.name = ''{2}''", "master", "mon_rpc_attach", "dbo");
            this.getConnection().getRSet().open(string);
            boolean bl = this.getConnection().getRSet().getNextRow();
            this.getConnection().getRSet().close();
            return bl;
        }

        @Override
        public boolean deploy() {
            BackupServerWizardBase.CreateServerTask createServerTask = new BackupServerWizardBase.CreateServerTask(){

                @Override
                void create() throws RemoteException, AgentPluginException, ClusterConfigException, SQLException, IOException {
                    MonitorServerWizard.this._monitorServerSO.creatServer(MonitorServerWizard.this.getCluster());
                    if (!MonitorServerWizSummaryPage.this.isMonitorScriptInstalled()) {
                        MonitorServerWizard.this.showThreadInfo(ASEUtils.getString("MONITOR_SERVER_WIZ_SYS_SP_WARN"), MonitorServerWizSummaryPage.this.getJDialog());
                    }
                }
            };
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)((Object)this._go));
            String string = ASEUtils.getString("AUXILIARY_SERVER_CFG_MS_TASK_TITLE");
            return MonitorServerWizard.this.createServer(createServerTask, jFrame, string);
        }
    }

    class MonitorServerWizInstancesPage
    extends ASEBaseWizDocPage {
        private MonitorServerWizGOInstancesPage _go;

        public MonitorServerWizInstancesPage(MonitorServerWizard monitorServerWizard2) {
            super(monitorServerWizard2, (JPanel)((Object)new MonitorServerWizGOInstancesPage()), ASEUtils.getString("MONITOR_SERVER_WIZ_SELECT_HOSTS_TITLE"));
            this._go = (MonitorServerWizGOInstancesPage)((Object)this.getJPanel());
            this._go.errorFileTextField.getDocument().addDocumentListener(this);
        }

        private boolean validateBlankErrorLogPath() {
            Object[] objectArray = null;
            Object object = null;
            for (int i = 0; i < this._go.instancesMultiList.getRowCount(); ++i) {
                if (i == this._go.instancesMultiList.getEditingRow()) {
                    object = this._go.instancesMultiList.getCellEditor(i, 2).getCellEditorValue();
                } else {
                    objectArray = this._go.instancesMultiList.getRow(i).toArray();
                    object = objectArray[2];
                }
                if (object != null && object.toString().length() != 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        private void initGO() {
            this._go.instancesMultiList.clear();
            String string = null;
            Integer n = null;
            String string2 = null;
            SDCInstanceSO sDCInstanceSO = null;
            for (int i = 0; i < MonitorServerWizard.this._monitorServerSO.getNodes().size(); ++i) {
                string = ((Object[])MonitorServerWizard.this._monitorServerSO.getNodes().get(i))[0].toString();
                n = (Integer)((Object[])MonitorServerWizard.this._monitorServerSO.getNodes().get(i))[1];
                string2 = ((Object[])MonitorServerWizard.this._monitorServerSO.getNodes().get(i))[2].toString();
                sDCInstanceSO = MonitorServerWizard.this.getSDCInstanceSO(string);
                this._go.instancesMultiList.addRow(new Object[]{new ASAIconTextData((Icon)SDCInstanceBO.getIcon(this.getConnection().getServerServerName(), sDCInstanceSO), string), n, string2});
            }
        }

        @Override
        public void init() throws Exception {
            this.initGO();
        }

        @Override
        public void enableComponents() {
            this.enableNextButton(this.validateBlankErrorLogPath());
            this.enableFinishButton(this.validateBlankErrorLogPath());
            this._goPanel.getPreviewButton().setVisible(false);
            this._goPanel.getScheduleButton().setVisible(false);
        }

        private boolean validateSO() throws AgentConnectionException, RemoteException {
            Vector vector = MonitorServerWizard.this._monitorServerSO.getNodes();
            for (int i = 0; i < vector.size(); ++i) {
                String string = ((Object[])vector.get(i))[0].toString();
                Integer n = (Integer)((Object[])vector.get(i))[1];
                String string2 = ((Object[])vector.get(i))[2].toString();
                if (!MonitorServerWizard.this.validateDuplicatePort(vector, string, n) || !MonitorServerWizard.this.validatePortForInstance(string, n) || MonitorServerWizard.this.isPortExists(string, n, BackupServerWizardBase.SERVER_TYPE_MONITOR)) {
                    return false;
                }
                if (MonitorServerWizard.this.validateErrorLog(string2, string, BackupServerWizardBase.SERVER_TYPE_MONITOR) && MonitorServerWizard.this.validateDuplicateErrorLog(vector, string, string2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean deploy() {
            MonitorServerWizard.this._monitorServerSO.clearNodes();
            Object[] objectArray = null;
            String string = null;
            for (int i = 0; i < this._go.instancesMultiList.getRowCount(); ++i) {
                objectArray = this._go.instancesMultiList.getRow(i).toArray();
                string = this._go.instancesMultiList.getValueAt(i, 2).toString();
                if (string.trim().length() > 255) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_INSTANCE_LOG_TOO_LONG"), objectArray[0].toString());
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                    return false;
                }
                objectArray[0] = objectArray[0].toString();
                MonitorServerWizard.this._monitorServerSO.addNode(objectArray);
            }
            try {
                if (!this.validateSO()) {
                    return false;
                }
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.getMessage(), exception);
                return false;
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.errorFileTextField.getDocument().removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
        }
    }

    class MonitorServerWizIntroPage
    extends ASEBaseWizardPage2 {
        public MonitorServerWizIntroPage(ASEBaseWizardDialog2 aSEBaseWizardDialog2, JPanel jPanel, String string) {
            super(aSEBaseWizardDialog2, jPanel, string);
        }

        public MonitorServerWizIntroPage(MonitorServerWizard monitorServerWizard2) {
            super(monitorServerWizard2, (JPanel)((Object)new ASEIntroWizGOPage(ASEImages.getRemoteServerWizardImage(), ASEUtils.getString("MONITOR_SERVER_WIZ_INTRO_WELCOME_TEXT"), ASEUtils.getString("MONITOR_SERVER_WIZ_INTRO_INTRO_TEXT"))), ASEUtils.getString("MONITOR_SERVER_WIZ_INTRO_TITLE"));
        }

        protected boolean initSO(final int n) {
            if (MonitorServerWizard.this._isInited) {
                return true;
            }
            MonitorServerWizard.this._monitorServerSO.clearNodes();
            BackupServerWizardBase.InitAuxiliaryServerTask initAuxiliaryServerTask = new BackupServerWizardBase.InitAuxiliaryServerTask(){

                @Override
                public void initSO() throws AgentConnectionException, RemoteException {
                    MonitorServerWizard.this._monitorServerSO.setName(MonitorServerWizard.this.getCluster().getName() + MonitorServerWizard.this.getPostPrefix(n));
                }

                @Override
                public Hashtable<String, Integer[]> discoverUnusedPorts(boolean bl) throws Exception {
                    return this.findPortsEachInstance(1, bl);
                }

                @Override
                public void initNode(IServer iServer, Hashtable<String, Integer[]> hashtable) throws Exception {
                    String string = null;
                    String string2 = hashtable.get(iServer.getName())[0].toString();
                    String string3 = MonitorServerWizard.this.getFileSeparator();
                    if (MonitorServerWizard.this.installationMode == BackupServerWizardBase.SHARED_INSTALLATION_MODE) {
                        string = MonitorServerWizard.this.getCluster().getAseHome() + string3 + "install" + string3 + iServer.getName() + MonitorServerWizard.this.getPostPrefix(n) + ".log";
                    } else {
                        SDCInstanceSO sDCInstanceSO = MonitorServerWizard.this.getSDCInstanceSO(iServer.getName());
                        string = sDCInstanceSO.getASEHome() + string3 + "install" + string3 + iServer.getName() + MonitorServerWizard.this.getPostPrefix(n) + ".log";
                    }
                    MonitorServerWizard.this._monitorServerSO.addNode(new Object[]{iServer.getName(), new Integer(string2), string});
                }
            };
            MonitorServerWizard.this._isInited = MonitorServerWizard.this.discoveryUnusedPort(initAuxiliaryServerTask, this.getJDialog());
            return MonitorServerWizard.this._isInited;
        }

        @Override
        public int onWizardNext() {
            if (!this.initSO(BackupServerWizard.SERVER_TYPE_MONITOR)) {
                return -1;
            }
            return super.onWizardNext();
        }

        public int onWizardNext(int n) {
            if (!this.initSO(n)) {
                return -1;
            }
            return super.onWizardNext();
        }
    }
}

