/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.DatabaseDeviceBO;
import com.sybase.aseplugin.bo.RemoteServerBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.dlg.AddDeviceToDatabaseDialog;
import com.sybase.aseplugin.bo.dlg.EditDeviceSizeOfDatabaseDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.NameWizBOPage;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.wiz.DatabaseWizGOPage2;
import com.sybase.aseplugin.go.wiz.ProxyDBWizDefaultLocationGOPage;
import com.sybase.aseplugin.go.wiz.ProxyDBWizForProxyUpdateGOPage;
import com.sybase.aseplugin.go.wiz.ProxyTableWizGORemoteDatabasePage;
import com.sybase.aseplugin.go.wiz.ProxyTableWizGORemoteServerPage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.DatabaseDevicesCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.aseplugin.util.ui.TableSelectionListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.text.JTextComponent;

public class ProxyDatabaseWizard
extends ASEBaseWizardDialog2 {
    private String _sRS = "";
    private String _sRDB = "";
    private boolean _bManual = true;
    private boolean blnEnableFinish;
    private DatabaseSO _dso;
    Vector _ignoreDevList = new Vector();

    public ProxyDatabaseWizard(DatabaseSO databaseSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)databaseSO, sCContainer2, ASEUtils.getString("MSG_ADD_PROXY_DATABASE"));
        this._dso = databaseSO;
        try {
            this.blnEnableFinish = ((DatabaseSO)this.getSO()).getAvailableDBDevice();
        }
        catch (SQLException sQLException) {
            this.blnEnableFinish = false;
        }
    }

    public boolean getEnableFinish() {
        return this.blnEnableFinish;
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new ProxyDBWizNamePage(this), new ProxyDBWizDevicesPage(this), new ProxyDBWizDefaultLocPage(this), new ProxyDBWizRemSrvBOPage(this), new ProxyDBWizRemDBBOPage(this), new ProxyDBWizRemUsrBOPage(this), new ProxyDBWizForProxyUpdateBOPage(this), new ProxyDBWizSummaryBOPage(this)};
    }

    public void setManualMode(boolean bl) {
        this._bManual = bl;
    }

    public boolean isManualMode() {
        return this._bManual;
    }

    public void setRemoteServerName(String string) {
        this._sRS = string;
    }

    public String getRemoteServerName() {
        return this._sRS;
    }

    public void setRemoteDBName(String string) {
        this._sRDB = string;
    }

    public String getRemoteDBName() {
        return this._sRDB;
    }

    @Override
    public void releaseResources() {
        this._dso = null;
        super.releaseResources();
    }

    class ProxyDBWizSummaryBOPage
    extends SummaryWizBOPage {
        public ProxyDBWizSummaryBOPage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, ASEImages.getDatabaseWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            DatabaseSO databaseSO = (DatabaseSO)this.getSO();
            this.addSummaryItem(ASEUtils.getString("MSG_DATABASE_NAME"), databaseSO.getName());
            this.addSummaryItem(ASEUtils.getString("MSG_DEFAULT_LOCATION"), databaseSO.getDefaultRemoteLocation());
            this.addSummaryItem(ASEUtils.getString("MSG_FOR_PROXY_UPDATE"), databaseSO.isForProxyUpdate());
            this.setSummaryInfo(this.getSummary());
        }
    }

    class ProxyDBWizForProxyUpdateBOPage
    extends ASEBaseWizardPage2 {
        private ProxyDBWizForProxyUpdateGOPage _go;

        public ProxyDBWizForProxyUpdateBOPage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, (JPanel)((Object)new ProxyDBWizForProxyUpdateGOPage()), ASEUtils.getString("MSG_DB_WIZ_PAGE4"));
            this._go = (ProxyDBWizForProxyUpdateGOPage)((Object)this.getJPanel());
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public boolean deploy() {
            ProxyDatabaseWizard.this._dso.setForProxyUpdate(this._go.guestAccountCheckBox.isSelected());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class ProxyDBWizRemUsrBOPage
    extends ASEBaseWizardPage2 {
        private String _sRemDB;
        private ProxyTableWizGORemoteDatabasePage _go;

        public ProxyDBWizRemUsrBOPage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, (JPanel)((Object)new ProxyTableWizGORemoteDatabasePage()), ASEUtils.getString("MSG_PROXYDB_WIZ_REMDB_PAGE_TITLE"));
            this._go = (ProxyTableWizGORemoteDatabasePage)((Object)this.getJPanel());
            this._go.remDBLocQuesLabel.setText(ASEUtils.getString("PROXY_DB_WIZ_REMUSR_LOC_QUES"));
            this._go.remDBComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
        }

        @Override
        public boolean showPage() {
            if (ProxyDatabaseWizard.this.isManualMode()) {
                return false;
            }
            String string = ProxyDatabaseWizard.this.getRemoteServerName();
            String string2 = ProxyDatabaseWizard.this.getRemoteDBName();
            if (!string2.equals(this._sRemDB)) {
                try {
                    this._go.remDBComboBox.removeAllItems();
                    this._go.remDBComboBox.updateUI();
                    Vector vector = ProxyDatabaseWizard.this._dso.getRemoteUsers(string, string2);
                    this._go.remDBComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
                    for (int i = 0; i < vector.size(); ++i) {
                        this._go.remDBComboBox.addItem((Object)new JLabel(vector.elementAt(i).toString(), UserBO.USER_ICON, 0));
                    }
                    this.enableFinishButton(true);
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                }
                this._sRemDB = string2;
            }
            return true;
        }

        @Override
        public boolean deploy() {
            if (!ProxyDatabaseWizard.this.isManualMode()) {
                if (this._go.remDBComboBox.getSelectedIndex() != -1) {
                    String string = ((JLabel)this._go.remDBComboBox.getSelectedItem()).getText();
                    ProxyDatabaseWizard.this._dso.setDefaultRemoteLocation(ProxyDatabaseWizard.this.getRemoteServerName() + "." + ProxyDatabaseWizard.this.getRemoteDBName() + "." + string + ".");
                } else {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class ProxyDBWizRemDBBOPage
    extends ASEBaseWizardPage2 {
        private String _sRemSrv;
        private ProxyTableWizGORemoteDatabasePage _go;

        public ProxyDBWizRemDBBOPage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, (JPanel)((Object)new ProxyTableWizGORemoteDatabasePage()), ASEUtils.getString("MSG_PROXYTABLE_WIZ_REMDB_PAGE_TITLE"));
            this._go = (ProxyTableWizGORemoteDatabasePage)((Object)this.getJPanel());
            this._go.remDBComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
        }

        @Override
        public boolean showPage() {
            if (ProxyDatabaseWizard.this.isManualMode()) {
                return false;
            }
            String string = ProxyDatabaseWizard.this.getRemoteServerName();
            if (!string.equals(this._sRemSrv)) {
                block6: {
                    try {
                        if (ProxyDatabaseWizard.this._dso.hasDBsInRemoteServer(string)) {
                            this._go.remDBComboBox.removeAllItems();
                            this._go.remDBComboBox.updateUI();
                            String[] stringArray = ProxyDatabaseWizard.this._dso.getRemoteDatabases(string);
                            for (int i = 0; i < stringArray.length; ++i) {
                                this._go.remDBComboBox.addItem((Object)new JLabel(stringArray[i], DatabaseBO.LOCAL_DATABASE_ICON, 0));
                            }
                            break block6;
                        }
                        ProxyDatabaseWizard.this.setRemoteDBName("");
                        return false;
                    }
                    catch (SQLException sQLException) {
                        this._go.remDBComboBox.removeAllItems();
                        this._go.remDBComboBox.updateUI();
                        this.enableNextButton(false);
                        Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                    }
                }
                this._sRemSrv = string;
            }
            return true;
        }

        @Override
        public boolean deploy() {
            if (!ProxyDatabaseWizard.this.isManualMode()) {
                if (this._go.remDBComboBox.getSelectedIndex() != -1) {
                    String string = ((JLabel)this._go.remDBComboBox.getSelectedItem()).getText();
                    ProxyDatabaseWizard.this.setRemoteDBName(string);
                } else {
                    ProxyDatabaseWizard.this.setRemoteDBName("");
                }
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class ProxyDBWizRemSrvBOPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private ProxyTableWizGORemoteServerPage _go;

        public ProxyDBWizRemSrvBOPage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, (JPanel)((Object)new ProxyTableWizGORemoteServerPage()), ASEUtils.getString("MSG_PROXYTABLE_WIZ_REMSRV_PAGE_TITLE"));
            this._go = (ProxyTableWizGORemoteServerPage)((Object)this.getJPanel());
            this._go.propertiesButton.addActionListener((ActionListener)this);
        }

        @Override
        public void init() throws SQLException {
            String[] stringArray = ProxyDatabaseWizard.this._dso.getProxyServerNames();
            if (stringArray.length == 0) {
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), ASEUtils.getString("PROXY_SERVERS_NOTFOUND") + ASEUtils.getString("DNAME_DATABASES"));
                this.enableNextButton(false);
            } else {
                this._go.remSrvComboBox.setRenderer((ListCellRenderer)new MyCellRenderer());
                for (int i = 0; i < stringArray.length; ++i) {
                    this._go.remSrvComboBox.addItem((Object)new JLabel(stringArray[i], RemoteServerBO.REMOTE_SERVER_ICON, 0));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JLabel)this._go.remSrvComboBox.getSelectedItem()).getText();
            ServerBO serverBO = ContainerViewBO.getServerBO(ProxyDatabaseWizard.this._dso.getConnection());
            RemoteServerBO remoteServerBO = ContainerViewBO.getRemoteServerBO(serverBO, string);
            remoteServerBO.setStartPage(ASEUtils.getString("MSG_CIS_MAPPING"));
            remoteServerBO.onCommand(Support.getViewerFrame(), 107, null, 0);
        }

        @Override
        public int onWizardNext() {
            String string = ((JLabel)this._go.remSrvComboBox.getSelectedItem()).getText();
            try {
                if (!ProxyDatabaseWizard.this._dso.hasCISMappingForRemoteServer(string)) {
                    int n = Support.showQuestionYesNo(this.getJDialog(), ASEUtils.getString("ERR_CIS_MAPPING_NOT_DEFINED"));
                    if (n == 0) {
                        this.actionPerformed(null);
                    }
                    return -1;
                }
                if (ProxyDatabaseWizard.this._dso.hasDBsInRemoteServer(string)) {
                    String[] stringArray = ProxyDatabaseWizard.this._dso.getRemoteDatabases(string);
                    if (stringArray.length == 0) {
                        return -1;
                    }
                } else {
                    ProxyDatabaseWizard.this._dso.getRemoteUsers(string, "");
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return -1;
            }
            ProxyDatabaseWizard.this.setRemoteServerName(string);
            return 0;
        }

        @Override
        public boolean showPage() {
            return !ProxyDatabaseWizard.this.isManualMode();
        }

        @Override
        public void releaseResources() {
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class ProxyDBWizDefaultLocPage
    extends ASEBaseWizardPage2
    implements ActionListener,
    DocumentListener {
        private ProxyDBWizDefaultLocationGOPage _go;

        public ProxyDBWizDefaultLocPage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, (JPanel)((Object)new ProxyDBWizDefaultLocationGOPage()), ASEUtils.getString("MSG_DB_WIZ_PAGE3"));
            this._go = (ProxyDBWizDefaultLocationGOPage)((Object)this.getJPanel());
            this._go.buildListRadioButton.addActionListener((ActionListener)this);
            this._go.specifyManuallyRadioButton.addActionListener((ActionListener)this);
            this._go.storageLocationTextField.getDocument().addDocumentListener(this);
        }

        @Override
        public void init() {
            this.enableNextButton(false);
        }

        @Override
        public void enableComponents() {
            this.textChanged();
        }

        @Override
        public boolean deploy() {
            if (this._go.specifyManuallyRadioButton.isSelected()) {
                ((DatabaseSO)this.getSO()).setDefaultRemoteLocation(this._go.storageLocationTextField.getText());
                ProxyDatabaseWizard.this.setManualMode(true);
            } else {
                ProxyDatabaseWizard.this.setManualMode(false);
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this._go.buildListRadioButton)) {
                this.buildListRadioButtonClicked();
            } else {
                this.specifyManuallyRadioButtonClicked();
            }
        }

        private void buildListRadioButtonClicked() {
            this._go.buildListRadioButton.setSelected(true);
            this._go.storageLocationTextField.setEnabled(false);
            this.enableNextButton(true);
            this.enableFinishButton(false);
        }

        private void specifyManuallyRadioButtonClicked() {
            this._go.specifyManuallyRadioButton.setSelected(true);
            this._go.storageLocationTextField.setEnabled(true);
            this.textChanged();
        }

        private void textChanged() {
            if (this._go.specifyManuallyRadioButton.isSelected()) {
                this.enableNextButton(this._go.storageLocationTextField.getText().length() > 0);
                this.enableFinishButton(this._go.storageLocationTextField.getText().length() > 0);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public int onWizardNext() {
            try {
                DatabaseSO databaseSO = (DatabaseSO)this.getSO();
                String[] stringArray = databaseSO.getProxyServerNames();
                if (stringArray.length == 0) {
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), ASEUtils.getString("PROXY_SERVERS_NOTFOUND") + ASEUtils.getString("DNAME_DATABASES"));
                    return -1;
                }
                this.deploy();
                return 0;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return -1;
            }
        }

        @Override
        public void releaseResources() {
            this._go.buildListRadioButton.removeActionListener((ActionListener)this);
            this._go.specifyManuallyRadioButton.removeActionListener((ActionListener)this);
            this._go.storageLocationTextField.getDocument().removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class ProxyDBWizDevicesPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        JLabelTableModel _tableModel;
        JTable _tblDevices;
        Vector _tableVector;
        private DatabaseWizGOPage2 _go;
        private DatabaseSO _databaseSO;
        private Map _initDBSizeMap;

        public ProxyDBWizDevicesPage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, (JPanel)((Object)new DatabaseWizGOPage2()), ASEUtils.getString("MSG_DB_WIZ_PAGE2"));
            this._initDBSizeMap = new HashMap();
            this._go = (DatabaseWizGOPage2)((Object)this.getJPanel());
            this._tblDevices = new ASETable();
            this._databaseSO = (DatabaseSO)proxyDatabaseWizard2.getSO();
            this._go.scroll.getViewport().add(this._tblDevices);
            Vector<String> vector = new Vector<String>();
            vector.addElement(ASEUtils.getString("DISP_NAME_TEXT"));
            vector.addElement(ASEUtils.getString("DISP_SIZE_MB_TEXT"));
            vector.addElement(ASEUtils.getString("MSG_FUTURE_ALLOCATIONS"));
            this._tableVector = new Vector();
            this._tableModel = new JLabelTableModel(vector, this._tableVector);
            this._tblDevices.setModel(this._tableModel);
            this._go.removeButton.addActionListener((ActionListener)this);
            this._go.editButton.addActionListener((ActionListener)this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.addButton.setEnabled(true);
            this._go.removeButton.setEnabled(false);
            this._go.editButton.setEnabled(false);
        }

        @Override
        public void init() throws SQLException {
            int n;
            Object object;
            String string;
            Object object2;
            Dimension dimension = this._tblDevices.getSize();
            Dimension dimension2 = this._tblDevices.getTableHeader().getSize();
            if (((DatabaseSO)this.getSO()).getConnection().getVersion().startsWith("12.0")) {
                object2 = new ASEMessageText(ASEUtils.getString("DATABASE_12_0_SIZE_INTRO"), ((DatabaseSO)this.getSO()).getDefaultDevicesList());
                this._go.introTextMultiLineLabel.setText(((ASEMessageText)object2).toString());
            } else {
                object2 = String.valueOf(((DatabaseSO)this.getSO()).getModelDBSize());
                string = String.valueOf(((DatabaseSO)this.getSO()).getDefaultDBSize());
                object = new ASEMessageText(ASEUtils.getString("DATABASE_12_5_SIZE_INTRO"), ((DatabaseSO)this.getSO()).getDefaultDevicesList(), Integer.parseInt((String)object2) > Integer.parseInt(string) ? object2 : string);
                this._go.introTextMultiLineLabel.setText(((ASEMessageText)object).toString());
            }
            for (n = 0; n < this._tblDevices.getRowCount(); ++n) {
                string = (String)this._tblDevices.getValueAt(n, 0);
                object = this._tblDevices.getValueAt(n, 1).toString();
                this._initDBSizeMap.put(string, object);
            }
            for (n = 0; n < this._tblDevices.getRowCount(); ++n) {
                string = (String)this._tblDevices.getValueAt(n, 0);
                object = this._tblDevices.getValueAt(n, 1).toString();
                this._initDBSizeMap.put(string, object);
            }
            this._tblDevices.setSelectionMode(0);
            TableSelectionListener tableSelectionListener = new TableSelectionListener(){

                @Override
                public void deSelectAction() {
                    ((ProxyDBWizDevicesPage)ProxyDBWizDevicesPage.this)._go.removeButton.setEnabled(false);
                    ((ProxyDBWizDevicesPage)ProxyDBWizDevicesPage.this)._go.editButton.setEnabled(false);
                }

                @Override
                public void selectAction() {
                    ((ProxyDBWizDevicesPage)ProxyDBWizDevicesPage.this)._go.removeButton.setEnabled(true);
                    ((ProxyDBWizDevicesPage)ProxyDBWizDevicesPage.this)._go.editButton.setEnabled(true);
                }
            };
            this._tblDevices.getSelectionModel().addListSelectionListener(tableSelectionListener);
            this._tblDevices.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._tblDevices.setSize(dimension);
            this._tblDevices.getTableHeader().setSize(dimension2);
            for (int i = 0; i < this._tblDevices.getRowCount(); ++i) {
                object = (String)this._tblDevices.getValueAt(i, 0);
                String string2 = this._tblDevices.getValueAt(i, 1).toString();
                this._initDBSizeMap.put(object, string2);
            }
        }

        private List getDatabaseDeviceList() throws Exception {
            DatabaseDevicesCtrSO databaseDevicesCtrSO = new DatabaseDevicesCtrSO(this._databaseSO.getConnection());
            return databaseDevicesCtrSO.open(1, null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            Vector vector = new Vector();
            try {
                vector.addAll(this.getDatabaseDeviceList());
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.toString(), exception);
            }
            if (actionEvent.getSource() == this._go.addButton) {
                new AddDeviceToDatabaseDialog(Support.createDialogSupport(this.getJDialog()), this._databaseSO, vector, this._tableModel, this._tblDevices, false, this._initDBSizeMap, ((ProxyDatabaseWizard)this.getParent())._ignoreDevList);
            } else if (actionEvent.getSource() == this._go.removeButton) {
                nArray = this._tblDevices.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    this._tableModel.removeRow(nArray[i]);
                }
                this._tblDevices.tableChanged(new TableModelEvent(this._tableModel));
                this._go.removeButton.setEnabled(false);
                this._go.editButton.setEnabled(false);
            } else if (actionEvent.getSource() == this._go.editButton) {
                nArray = this._tblDevices.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    long l = ((Double)this._tableModel.getValueAt(nArray[i], 1)).longValue();
                    String string = ((JLabel)this._tableModel.getValueAt(nArray[i], 0)).getText();
                    String string2 = (String)this._initDBSizeMap.get(string);
                    DatabaseDeviceSO databaseDeviceSO = null;
                    databaseDeviceSO = this.getEditingDatabaseDevice(string);
                    new EditDeviceSizeOfDatabaseDialog(Support.createDialogSupport(this.getJDialog()), string, databaseDeviceSO.getSize(), databaseDeviceSO.getUnusedSize(), l, this._tableModel, this._tblDevices, nArray[i], true, string2);
                }
            }
            boolean bl = this._tableModel.getRowCount() > 0;
            this.enableNextButton(((ProxyDatabaseWizard)this.getParent()).getEnableFinish() || bl);
        }

        private DatabaseDeviceSO getEditingDatabaseDevice(String string) {
            ServerBO serverBO = ContainerViewBO.getServerBO(this._databaseSO.getConnection());
            DatabaseDeviceBO databaseDeviceBO = ContainerViewBO.getDatabaseDeviceBO(serverBO, string);
            return (DatabaseDeviceSO)databaseDeviceBO.getSO();
        }

        @Override
        public boolean deploy() {
            Vector<Vector> vector = new Vector<Vector>();
            Vector<Vector> vector2 = new Vector<Vector>();
            for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
                Vector vector3 = this._tableModel.getRow(i);
                String string = (String)vector3.elementAt(2);
                if (string.equals(ASEUtils.getString("MSG_DATA"))) {
                    vector.addElement(vector3);
                    continue;
                }
                vector2.addElement(vector3);
            }
            this._databaseSO.setDBDevice(vector);
            this._databaseSO.setDBLog(vector2);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.removeButton.removeActionListener((ActionListener)this);
            this._go.editButton.removeActionListener((ActionListener)this);
            this._go.addButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            this._tableModel = null;
            this._tblDevices = null;
            this._tableVector = null;
            super.releaseResources();
        }
    }

    class ProxyDBWizNamePage
    extends NameWizBOPage {
        public ProxyDBWizNamePage(ProxyDatabaseWizard proxyDatabaseWizard2) {
            super(proxyDatabaseWizard2, ASEImages.getDatabaseWizardImage(), ASEUtils.getString("PROXY_DATABASE_WIZ_SENT_WELCOME"), "", ASEUtils.getString("PROXY_DATABASE_WIZ_QUES_NAME"));
        }

        @Override
        public void enableComponents() {
            boolean bl = this.getObjectName().length() > 0;
            this.enableNextButton(bl);
        }

        @Override
        public boolean deploy() {
            String string = this.getObjectName();
            ProxyDatabaseWizard.this._dso.setName(string);
            try {
                boolean bl = Support.verifyObjectName(ProxyDatabaseWizard.this._dso, this.getJDialog(), (JTextComponent)((Object)this._go.nameTextField));
                if (bl) {
                    ((DatabaseSO)this.getSO()).setName(this.getObjectName());
                    return true;
                }
                return false;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return false;
            }
        }
    }
}

