/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.RLImages;
import com.sybase.aseplugin.bo.ConnectionBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.wiz.PubWizGODBItemPage;
import com.sybase.aseplugin.go.wiz.PubWizGONewPubPage;
import com.sybase.aseplugin.go.wiz.PubWizGOSelectPage;
import com.sybase.aseplugin.so.ArticleSO;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.PublicationSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.RLMetaData;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class PublicationWizard
extends ASEBaseWizardDialog2 {
    private ConnectionBO _connBO = (ConnectionBO)this.getParent();
    private PublicationSO _pubSO;

    public PublicationWizard(PublicationSO publicationSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)publicationSO, sCContainer2);
        this._pubSO = publicationSO;
        this._pubSO.setServer(((ConnectionSO)this._connBO.getSO()).getServer());
        this._pubSO.setDatabase(((ConnectionSO)this._connBO.getSO()).getDatabase());
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new PubWizBOPage1(this), new PubWizBOPage2(this), new PubWizBOPage3(this), new PubWizBOPage4(this)};
    }

    public PublicationSO getMySO() {
        return this._pubSO;
    }

    public ConnectionBO getParentBO() {
        return this._connBO;
    }

    @Override
    public boolean deploy() {
        try {
            this._pubSO.create();
            this.createArticles();
            this._connBO.refresh();
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this._pubSO.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
            return false;
        }
        return true;
    }

    private void createArticles() throws Exception {
        if (this.getMySO().isAllTables() || this.getMySO().isAllProcedures()) {
            PubItemTable pubItemTable = new PubItemTable();
            for (int i = 0; i < pubItemTable.size(); ++i) {
                ArticleSO articleSO;
                if (this.getMySO().isAllTables() && pubItemTable.isTable(i)) {
                    articleSO = new ArticleSO(this.getMySO().getConnection(), this.getMySO().getDDB());
                    articleSO.setPublication(this.getMySO());
                    articleSO.setTableType();
                    articleSO.setOwner(pubItemTable.getOwner(i));
                    articleSO.setArticleName(pubItemTable.getName(i));
                    articleSO.setArticleExists(pubItemTable.articleExists(i));
                    articleSO.create();
                }
                if (!this.getMySO().isAllProcedures() || !pubItemTable.isProcedure(i)) continue;
                articleSO = new ArticleSO(this.getMySO().getConnection(), this.getMySO().getDDB());
                articleSO.setPublication(this.getMySO());
                articleSO.setProcedureType();
                articleSO.setOwner(pubItemTable.getOwner(i));
                articleSO.setArticleName(pubItemTable.getName(i));
                articleSO.setArticleExists(pubItemTable.articleExists(i));
                articleSO.create();
            }
        } else {
            PubItemTable pubItemTable = ((PubWizBOPage3)this._pageControllers[2]).getItemTable();
            Debug.wassert(pubItemTable != null, this, "Null item table");
            for (int i = 0; i < pubItemTable.size(); ++i) {
                if (!pubItemTable.isSelected(i)) continue;
                ArticleSO articleSO = new ArticleSO(this.getMySO().getConnection(), this.getMySO().getDDB());
                articleSO.setPublication(this.getMySO());
                if (pubItemTable.isTable(i)) {
                    articleSO.setTableType();
                } else if (pubItemTable.isProcedure(i)) {
                    articleSO.setProcedureType();
                } else {
                    Debug.wassert(false, this, "Invalid Article type");
                }
                articleSO.setOwner(pubItemTable.getOwner(i));
                articleSO.setArticleName(pubItemTable.getName(i));
                articleSO.setArticleExists(pubItemTable.articleExists(i));
                articleSO.setNewFields(pubItemTable.getFields(i));
                articleSO.create();
            }
        }
    }

    @Override
    public void releaseResources() {
        this._pageControllers = null;
        this._connBO = null;
        this._pubSO = null;
        super.releaseResources();
    }

    public String setSummaryPageInfo() {
        String string = ((PubWizBOPage1)this._pageControllers[0]).getSummaryInfo();
        string = string + ((PubWizBOPage2)this._pageControllers[1]).getSummaryInfo();
        string = string + ((PubWizBOPage3)this._pageControllers[2]).getSummaryInfo();
        return string;
    }

    class PubFieldTable {
        protected Vector _table;
        protected static final int SELECTION_COL = 0;
        protected static final int NAME_COL = 1;
        protected static final int DATATYPE_COL = 2;
        protected static final int COLID_COL = 3;

        public PubFieldTable(ASConnection aSConnection, String string, String string2, String string3, boolean bl) {
            Debug.wassert(aSConnection != null, this, "Null connection parameter");
            Debug.wassert(string != null && string.length() > 0, this, "Null or empty database parameter");
            Debug.wassert(string2 != null && string2.length() > 0, this, "Null or empty owner parameter");
            Debug.wassert(string3 != null && string3.length() > 0, this, "Null or empty item parameter");
            this.getFields(aSConnection, string, string2, string3, bl);
        }

        public Vector getTable() {
            return this._table;
        }

        public int size() {
            int n = 0;
            if (this._table != null) {
                n = this._table.size();
            }
            return n;
        }

        public void setSelection(boolean bl, int n) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in field table");
                vector.setElementAt(new Boolean(bl), 0);
            }
        }

        public boolean isSelected(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in field table");
                bl = (Boolean)vector.elementAt(0);
            }
            return bl;
        }

        public String getName(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 1, this, "Null or corrupt vector in field table");
                JLabel jLabel = (JLabel)vector.elementAt(1);
                if (jLabel != null) {
                    string = jLabel.getText();
                }
            }
            return string;
        }

        public String getDatatype(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 2, this, "Null or corrupt vector in field table");
                string = (String)vector.elementAt(2);
            }
            return string;
        }

        public int getColumnID(int n) throws ArrayIndexOutOfBoundsException {
            int n2 = 0;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 3, this, "Null or corrupt vector in field table");
                n2 = (Integer)vector.elementAt(3);
            }
            return n2;
        }

        public boolean anyFieldsSelected() {
            boolean bl = false;
            for (int i = 0; i < this.size() && !bl; ++i) {
                bl = this.isSelected(i);
            }
            return bl;
        }

        public String getFields() {
            String string = "";
            int n = -1;
            int n2 = -2;
            for (int i = 0; i < this.size(); ++i) {
                if (!this.isSelected(i)) continue;
                int n3 = this.getColumnID(i);
                if (n3 == n2 + 1) {
                    n2 = n3;
                    continue;
                }
                if (n == n2) {
                    string = string + String.valueOf(n) + ",";
                } else if (n < n2) {
                    string = string + String.valueOf(n) + "-" + String.valueOf(n2) + ",";
                }
                n = n3;
                n2 = n3;
            }
            if (n == n2) {
                string = string + String.valueOf(n);
            } else if (n < n2) {
                string = string + String.valueOf(n) + "-" + String.valueOf(n2);
            }
            return string;
        }

        private void getFields(ASConnection aSConnection, String string, String string2, String string3, boolean bl) {
            Debug.wassert(string2 != null && string2.length() > 0, this, "Null or empty item owner parameter");
            Debug.wassert(string3 != null && string3.length() > 0, this, "Null or empty item name parameter");
            try {
                this._table = RLMetaData.getFieldData(aSConnection, string, string2, string3);
                this.addKeyIcon(aSConnection, string, string2, string3, bl);
                for (int i = 0; i < this._table.size(); ++i) {
                    Vector vector = (Vector)this._table.elementAt(i);
                    Boolean bl2 = new Boolean(false);
                    vector.insertElementAt(bl2, 0);
                }
            }
            catch (SQLException sQLException) {
                this._table = new Vector();
            }
        }

        private void addKeyIcon(ASConnection aSConnection, String string, String string2, String string3, boolean bl) throws SQLException {
            ImageIcon imageIcon = new ImageIcon(ASEImages.getPrimaryKeySmallImage());
            ImageIcon imageIcon2 = new ImageIcon(RLImages.getEmptySmallImage());
            Vector vector = new Vector();
            if (bl) {
                vector = RLMetaData.getKeyFields(aSConnection, string, string2, string3);
            }
            for (int i = 0; i < this._table.size(); ++i) {
                Vector vector2 = (Vector)this._table.elementAt(i);
                String string4 = (String)vector2.elementAt(0);
                boolean bl2 = false;
                for (int j = 0; j < vector.size() && !bl2; ++j) {
                    if (!string4.equals(vector.elementAt(j))) continue;
                    bl2 = true;
                }
                JLabel jLabel = null;
                jLabel = bl2 ? new JLabel(string4, imageIcon, 0) : new JLabel(string4, imageIcon2, 0);
                vector2.removeElementAt(0);
                vector2.insertElementAt(jLabel, 0);
            }
        }
    }

    class PubItemTable {
        protected Vector _table;
        protected static final int SELECTION_COL = 0;
        protected static final int NAME_COL = 1;
        protected static final int OWNER_COL = 2;
        protected static final int TYPE_COL = 3;
        protected static final int ARTICLE_EXISTS_COL = 4;
        protected static final int FIELDS_COL = 5;

        public PubItemTable() throws SQLException {
            this.getItems();
        }

        public Vector getTable() {
            return this._table;
        }

        public int size() {
            int n = 0;
            if (this._table != null) {
                n = this._table.size();
            }
            return n;
        }

        public void setSelection(boolean bl, int n) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in item table");
                vector.setElementAt(new Boolean(bl), 0);
            }
        }

        public boolean isSelected(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in item table");
                bl = (Boolean)vector.elementAt(0);
            }
            return bl;
        }

        public String getName(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 1, this, "Null or corrupt vector in item table");
                JLabel jLabel = (JLabel)vector.elementAt(1);
                string = jLabel.getText();
            }
            return string;
        }

        public String getOwner(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 2, this, "Null or corrupt vector in item table");
                string = (String)vector.elementAt(2);
            }
            return string;
        }

        public String getType(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 3, this, "Null or corrupt vector in item table");
                string = (String)vector.elementAt(3);
            }
            return string;
        }

        public boolean isTable(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 3, this, "Null or corrupt vector in item table");
                bl = ((String)vector.elementAt(3)).equals("table");
            }
            return bl;
        }

        public boolean isProcedure(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 3, this, "Null or corrupt vector in item table");
                bl = ((String)vector.elementAt(3)).equals("procedure");
            }
            return bl;
        }

        public boolean articleExists(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 4, this, "Null or corrupt vector in item table");
                bl = (Boolean)vector.elementAt(4);
            }
            return bl;
        }

        public String getFields(int n) throws ArrayIndexOutOfBoundsException {
            String string = "";
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 5, this, "Null or corrupt vector in item table");
                PubFieldTable pubFieldTable = (PubFieldTable)vector.elementAt(5);
                string = pubFieldTable.getFields();
            }
            return string;
        }

        public PubFieldTable getFieldTable(int n) throws SQLException, ArrayIndexOutOfBoundsException {
            PubFieldTable pubFieldTable = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 5, this, "Null or corrupt vector in item table");
                pubFieldTable = (PubFieldTable)vector.elementAt(5);
                if (pubFieldTable == null) {
                    pubFieldTable = new PubFieldTable(PublicationWizard.this.getMySO().getConnection(), PublicationWizard.this.getMySO().getDatabase(), this.getOwner(n), this.getName(n), this.isTable(n));
                    vector.setElementAt(pubFieldTable, 5);
                    this.setExistingArticle(this.findArticle(pubFieldTable, n), n);
                }
            }
            return pubFieldTable;
        }

        public boolean anyItemsSelected() {
            boolean bl = false;
            for (int i = 0; i < this.size() && !bl; ++i) {
                bl = this.isSelected(i);
            }
            return bl;
        }

        private void setExistingArticle(boolean bl, int n) {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 4, this, "Null or corrupt vector in item table");
                vector.setElementAt(new Boolean(bl), 4);
            }
        }

        private void getItems() throws SQLException {
            try {
                Serializable serializable;
                String string;
                Vector vector;
                this._table = RLMetaData.getTables(PublicationWizard.this.getMySO().getConnection(), PublicationWizard.this.getMySO().getDatabase());
                ImageIcon imageIcon = new ImageIcon(ASEImages.getTableSmallImage());
                for (int i = 0; i < this._table.size(); ++i) {
                    vector = (Vector)this._table.elementAt(i);
                    Boolean bl = new Boolean(false);
                    vector.insertElementAt(bl, 0);
                    string = (String)vector.elementAt(1);
                    serializable = new JLabel(string, imageIcon, 0);
                    vector.removeElementAt(1);
                    vector.insertElementAt(serializable, 1);
                    vector.addElement(new String("table"));
                    vector.addElement(new Boolean(false));
                    vector.addElement(null);
                }
                Vector vector2 = RLMetaData.getProcedures(PublicationWizard.this.getMySO().getConnection(), PublicationWizard.this.getMySO().getDatabase());
                imageIcon = new ImageIcon(ASEImages.getStoredProcedureSmallImage());
                for (int i = 0; i < vector2.size(); ++i) {
                    vector = (Vector)vector2.elementAt(i);
                    serializable = new Boolean(false);
                    vector.insertElementAt(serializable, 0);
                    string = (String)vector.elementAt(1);
                    JLabel jLabel = new JLabel(string, imageIcon, 0);
                    vector.removeElementAt(1);
                    vector.insertElementAt(jLabel, 1);
                    vector.addElement(new String("procedure"));
                    vector.addElement(new Boolean(false));
                    vector.addElement(null);
                    this._table.addElement(vector);
                }
            }
            catch (SQLException sQLException) {
                this._table = new Vector();
                throw sQLException;
            }
        }

        private boolean findArticle(PubFieldTable pubFieldTable, int n) throws SQLException {
            Enumeration enumeration;
            Debug.wassert(pubFieldTable != null, this, "Invalid PubFieldTable parameter");
            Debug.wassert(n >= 0, this, "Invalid item table row index");
            boolean bl = false;
            if (pubFieldTable.size() > 0 && (enumeration = ArticleSO.getPrimaryArticles(PublicationWizard.this.getMySO().getConnection(), PublicationWizard.this.getMySO().getDDB(), PublicationWizard.this.getMySO().getServer(), PublicationWizard.this.getMySO().getDatabase(), this.getOwner(n), this.getName(n))) != null && enumeration.hasMoreElements()) {
                bl = true;
                Vector vector = ArticleSO.getFields(PublicationWizard.this.getMySO().getConnection(), PublicationWizard.this.getMySO().getDDB(), PublicationWizard.this.getMySO().getServer(), PublicationWizard.this.getMySO().getDatabase(), this.getOwner(n), this.getName(n));
                if (vector == null) {
                    vector = new Vector();
                }
                for (int i = 0; i < pubFieldTable.size(); ++i) {
                    String string = pubFieldTable.getName(i);
                    boolean bl2 = false;
                    for (int j = 0; j < vector.size() && !bl2; ++j) {
                        Vector vector2 = (Vector)vector.elementAt(j);
                        String string2 = (String)vector2.elementAt(0);
                        if (!string.equals(string2)) continue;
                        bl2 = true;
                    }
                    pubFieldTable.setSelection(bl2, i);
                }
            }
            return bl;
        }
    }

    class PubWizBOPage4
    extends SummaryWizBOPage {
        public PubWizBOPage4(PublicationWizard publicationWizard2) {
            super(publicationWizard2, ASEImages.getDatabaseWizardImage());
        }

        @Override
        public void enableComponents() {
            this.setSummaryInfo(PublicationWizard.this.setSummaryPageInfo());
        }
    }

    class PubWizBOPage3
    extends ASEBaseWizardPage2
    implements ActionListener,
    ListSelectionListener {
        PubWizGOSelectPage _panel;
        private JTable _jtItems;
        private JLabelTableModel _jItemModel;
        private PubItemTable _itemTable;
        private JTable _jtFields;
        private JLabelTableModel _jFieldModel;
        private PubFieldTable _fieldTable;
        private String _newArtInstructions;

        public PubWizBOPage3(PublicationWizard publicationWizard2) {
            super(publicationWizard2, (JPanel)((Object)new PubWizGOSelectPage()), ASEUtils.getString("MSG_ADD_PUB_WIZ_SELECT"));
            this._itemTable = null;
            this._fieldTable = null;
            this._panel = (PubWizGOSelectPage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.btnClearAll.addActionListener((ActionListener)this);
            this._panel.btnSelectAll.addActionListener((ActionListener)this);
            this._newArtInstructions = this._panel.labelDesc.getText();
        }

        @Override
        public boolean showPage() {
            if (PublicationWizard.this.getMySO().isAllTables() || PublicationWizard.this.getMySO().isAllProcedures()) {
                return false;
            }
            if (this._itemTable == null) {
                this.InitItemTable();
            }
            if (this._fieldTable == null) {
                this.InitFieldTable();
            }
            this.SetWizardButtons();
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._panel.btnClearAll || actionEvent.getSource() == this._panel.btnSelectAll) {
                this.setAllFields(actionEvent.getSource() == this._panel.btnSelectAll);
                this.checkItemSelection();
                this.SetWizardButtons();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = this._jtItems.getSelectedRow()) >= 0) {
                this.loadFields(n);
            }
        }

        @Override
        public int onWizardNext() {
            try {
                for (int i = 0; i < this._itemTable.size(); ++i) {
                    if (!this._itemTable.isSelected(i) || !this._itemTable.isTable(i)) continue;
                    boolean bl = false;
                    PubFieldTable pubFieldTable = this._itemTable.getFieldTable(i);
                    if (pubFieldTable != null) {
                        bl = pubFieldTable.anyFieldsSelected();
                    }
                    if (bl) continue;
                    String string = ASEUtils.getString("ERR_NO_FIELDS_SELECT");
                    ASEMessageText aSEMessageText = new ASEMessageText(string, this._itemTable.getOwner(i), this._itemTable.getName(i));
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                    return -1;
                }
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
                return -1;
            }
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = "";
            if (!PublicationWizard.this.getMySO().isAllTables() && !PublicationWizard.this.getMySO().isAllProcedures()) {
                for (int i = 0; i < this._itemTable.size(); ++i) {
                    if (!this._itemTable.isSelected(i)) continue;
                    string = string + "\t" + this._itemTable.getOwner(i) + "." + this._itemTable.getName(i) + "\n";
                }
            }
            return string;
        }

        private void SetWizardButtons() {
            this.enableNextButton(true);
        }

        public PubItemTable getItemTable() {
            return this._itemTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void InitItemTable() {
            Vector<String> vector = new Vector<String>();
            vector.addElement(" ");
            vector.addElement(ASEUtils.getString("DISP_ITEM_HDR"));
            vector.addElement(ASEUtils.getString("DISP_OWNER_HDR"));
            try {
                this._itemTable = new PubItemTable();
                this._jItemModel = new JLabelTableModel(vector, this._itemTable.getTable());
                this._jtItems = new ASETable(this._jItemModel);
                this._panel.scrollItems.getViewport().setView(this._jtItems);
            }
            catch (SQLException sQLException) {
                try {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
                    this._jItemModel = new JLabelTableModel(vector, this._itemTable.getTable());
                    this._jtItems = new ASETable(this._jItemModel);
                    this._panel.scrollItems.getViewport().setView(this._jtItems);
                }
                catch (Throwable throwable) {
                    this._jItemModel = new JLabelTableModel(vector, this._itemTable.getTable());
                    this._jtItems = new ASETable(this._jItemModel);
                    this._panel.scrollItems.getViewport().setView(this._jtItems);
                    this._jtItems.setBackground(SystemColor.window);
                    this._jtItems.setForeground(SystemColor.windowText);
                    this._jtItems.getTableHeader().setReorderingAllowed(false);
                    this._jtItems.setSelectionMode(0);
                    this._jtItems.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
                    TableColumnModel tableColumnModel = this._jtItems.getColumnModel();
                    Rectangle rectangle = new Rectangle();
                    this._panel.scrollItems.getBounds(rectangle);
                    int n = (int)((double)rectangle.width * 0.1);
                    tableColumnModel.getColumn(0).setWidth(n);
                    tableColumnModel.getColumn(0).setPreferredWidth(n);
                    n = (int)((double)rectangle.width * 0.55);
                    tableColumnModel.getColumn(1).setWidth(n);
                    tableColumnModel.getColumn(1).setPreferredWidth(n);
                    n = (int)((double)rectangle.width * 0.35);
                    tableColumnModel.getColumn(2).setWidth(n);
                    tableColumnModel.getColumn(2).setPreferredWidth(n);
                    this.addItemTableKeyboardActions();
                    this.addItemTableMouseActions();
                    this._jtItems.getSelectionModel().addListSelectionListener(this);
                    throw throwable;
                }
                this._jtItems.setBackground(SystemColor.window);
                this._jtItems.setForeground(SystemColor.windowText);
                this._jtItems.getTableHeader().setReorderingAllowed(false);
                this._jtItems.setSelectionMode(0);
                this._jtItems.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
                TableColumnModel tableColumnModel = this._jtItems.getColumnModel();
                Rectangle rectangle = new Rectangle();
                this._panel.scrollItems.getBounds(rectangle);
                int n = (int)((double)rectangle.width * 0.1);
                tableColumnModel.getColumn(0).setWidth(n);
                tableColumnModel.getColumn(0).setPreferredWidth(n);
                n = (int)((double)rectangle.width * 0.55);
                tableColumnModel.getColumn(1).setWidth(n);
                tableColumnModel.getColumn(1).setPreferredWidth(n);
                n = (int)((double)rectangle.width * 0.35);
                tableColumnModel.getColumn(2).setWidth(n);
                tableColumnModel.getColumn(2).setPreferredWidth(n);
                this.addItemTableKeyboardActions();
                this.addItemTableMouseActions();
                this._jtItems.getSelectionModel().addListSelectionListener(this);
            }
            this._jtItems.setBackground(SystemColor.window);
            this._jtItems.setForeground(SystemColor.windowText);
            this._jtItems.getTableHeader().setReorderingAllowed(false);
            this._jtItems.setSelectionMode(0);
            this._jtItems.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            TableColumnModel tableColumnModel = this._jtItems.getColumnModel();
            Rectangle rectangle = new Rectangle();
            this._panel.scrollItems.getBounds(rectangle);
            int n = (int)((double)rectangle.width * 0.1);
            tableColumnModel.getColumn(0).setWidth(n);
            tableColumnModel.getColumn(0).setPreferredWidth(n);
            n = (int)((double)rectangle.width * 0.55);
            tableColumnModel.getColumn(1).setWidth(n);
            tableColumnModel.getColumn(1).setPreferredWidth(n);
            n = (int)((double)rectangle.width * 0.35);
            tableColumnModel.getColumn(2).setWidth(n);
            tableColumnModel.getColumn(2).setPreferredWidth(n);
            this.addItemTableKeyboardActions();
            this.addItemTableMouseActions();
            this._jtItems.getSelectionModel().addListSelectionListener(this);
        }

        private void addItemTableKeyboardActions() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = PubWizBOPage3.this._jtItems.getSelectedRow();
                    if (n >= 0) {
                        PubWizBOPage3.this._itemTable.setSelection(!PubWizBOPage3.this._itemTable.isSelected(n), n);
                        PubWizBOPage3.this._jItemModel.fireTableCellUpdated(n, 0);
                        if (!PubWizBOPage3.this._itemTable.articleExists(n)) {
                            PubWizBOPage3.this.setAllFields(PubWizBOPage3.this._itemTable.isSelected(n));
                        }
                        PubWizBOPage3.this.SetWizardButtons();
                    }
                }
            };
            this._jtItems.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
            this._jtItems.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
        }

        private void addItemTableMouseActions() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    int n = PubWizBOPage3.this._jtItems.columnAtPoint(mouseEvent.getPoint());
                    int n2 = PubWizBOPage3.this._jtItems.rowAtPoint(mouseEvent.getPoint());
                    if (n == 0) {
                        PubWizBOPage3.this._itemTable.setSelection(!PubWizBOPage3.this._itemTable.isSelected(n2), n2);
                        PubWizBOPage3.this._jItemModel.fireTableCellUpdated(n2, 0);
                        if (!PubWizBOPage3.this._itemTable.articleExists(n2)) {
                            PubWizBOPage3.this.setAllFields(PubWizBOPage3.this._itemTable.isSelected(n2));
                        }
                        PubWizBOPage3.this.SetWizardButtons();
                    }
                }
            };
            this._jtItems.addMouseListener(mouseAdapter);
        }

        private void checkItemSelection() {
            int n = this._jtItems.getSelectedRow();
            if (n >= 0) {
                if (this._fieldTable.anyFieldsSelected()) {
                    this._itemTable.setSelection(true, n);
                } else if (this._itemTable.isTable(n)) {
                    this._itemTable.setSelection(false, n);
                }
                this._jItemModel.fireTableCellUpdated(n, 0);
            }
        }

        private void InitFieldTable() {
            Vector<String> vector = new Vector<String>();
            vector.addElement(" ");
            vector.addElement(ASEUtils.getString("DISP_FIELD_HDR"));
            vector.addElement(ASEUtils.getString("DISP_DATATYPE_HDR"));
            Vector vector2 = new Vector();
            this._jFieldModel = new JLabelTableModel(vector, vector2);
            this._jtFields = new ASETable(this._jFieldModel);
            this._jtFields.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            this._panel.scrollFields.getViewport().setView(this._jtFields);
            this._jtFields.setBackground(SystemColor.window);
            this._jtFields.setForeground(SystemColor.windowText);
            this._jtFields.getTableHeader().setReorderingAllowed(false);
            this._jtFields.setSelectionMode(2);
            TableColumnModel tableColumnModel = this._jtFields.getColumnModel();
            Rectangle rectangle = new Rectangle();
            this._panel.scrollFields.getBounds(rectangle);
            int n = (int)((double)rectangle.width * 0.1);
            tableColumnModel.getColumn(0).setWidth(n);
            tableColumnModel.getColumn(0).setPreferredWidth(n);
            n = (int)((double)rectangle.width * 0.45);
            tableColumnModel.getColumn(1).setWidth(n);
            tableColumnModel.getColumn(1).setPreferredWidth(n);
            tableColumnModel.getColumn(2).setWidth(n);
            tableColumnModel.getColumn(2).setPreferredWidth(n);
            this.addFieldTableKeyboardActions();
            this.addFieldTableMouseActions();
        }

        private void addFieldTableKeyboardActions() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = PubWizBOPage3.this._jtItems.getSelectedRow();
                    if (!PubWizBOPage3.this._itemTable.articleExists(n)) {
                        int[] nArray = PubWizBOPage3.this._jtFields.getSelectedRows();
                        for (int i = 0; i < nArray.length; ++i) {
                            PubWizBOPage3.this._fieldTable.setSelection(!PubWizBOPage3.this._fieldTable.isSelected(nArray[i]), nArray[i]);
                            PubWizBOPage3.this._jFieldModel.fireTableCellUpdated(nArray[i], 0);
                        }
                        PubWizBOPage3.this.checkItemSelection();
                        PubWizBOPage3.this.SetWizardButtons();
                    }
                }
            };
            this._jtFields.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
            this._jtFields.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
        }

        private void addFieldTableMouseActions() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    int n = PubWizBOPage3.this._jtItems.getSelectedRow();
                    if (!PubWizBOPage3.this._itemTable.articleExists(n)) {
                        int n2 = PubWizBOPage3.this._jtFields.columnAtPoint(mouseEvent.getPoint());
                        int n3 = PubWizBOPage3.this._jtFields.rowAtPoint(mouseEvent.getPoint());
                        if (n2 == 0) {
                            if (!(mouseEvent.isShiftDown() || mouseEvent.isControlDown() || mouseEvent.isMetaDown() || mouseEvent.isAltDown())) {
                                PubWizBOPage3.this._fieldTable.setSelection(!PubWizBOPage3.this._fieldTable.isSelected(n3), n3);
                                PubWizBOPage3.this._jFieldModel.fireTableCellUpdated(n3, 0);
                            }
                            PubWizBOPage3.this.checkItemSelection();
                            PubWizBOPage3.this.SetWizardButtons();
                        }
                    }
                }
            };
            this._jtFields.addMouseListener(mouseAdapter);
        }

        private void loadFields(int n) {
            Debug.wassert(n >= 0, this, "Invalid item table row number");
            try {
                this._fieldTable = this._itemTable.getFieldTable(n);
                this._jFieldModel.setData(this._fieldTable.getTable());
                if (this._itemTable.articleExists(n)) {
                    this._jtFields.setRowSelectionAllowed(false);
                    this._jtFields.setForeground(SystemColor.textInactiveText);
                    this._panel.btnClearAll.setEnabled(false);
                    this._panel.btnSelectAll.setEnabled(false);
                    this._panel.labelDesc.setText(ASEUtils.getString("LABEL_ART_READONLY_FIELDS"));
                } else {
                    this._jtFields.setRowSelectionAllowed(true);
                    this._jtFields.setForeground(SystemColor.windowText);
                    this._panel.btnClearAll.setEnabled(true);
                    this._panel.btnSelectAll.setEnabled(true);
                    this._panel.labelDesc.setText(this._newArtInstructions);
                }
                this._jtFields.updateUI();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
            }
        }

        private void setAllFields(boolean bl) {
            for (int i = 0; i < this._jFieldModel.getRowCount(); ++i) {
                this._fieldTable.setSelection(bl, i);
            }
            this._jtFields.repaint();
        }

        @Override
        public void releaseResources() {
            this._panel.btnClearAll.removeActionListener((ActionListener)this);
            this._panel.btnSelectAll.removeActionListener((ActionListener)this);
            this._jtItems.getSelectionModel().removeListSelectionListener(this);
            this._jtItems = null;
            this._jItemModel = null;
            this._itemTable = null;
            this._jtFields = null;
            this._jFieldModel = null;
            this._fieldTable = null;
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class PubWizBOPage2
    extends ASEBaseWizardPage2
    implements ActionListener {
        PubWizGODBItemPage _panel;

        public PubWizBOPage2(PublicationWizard publicationWizard2) {
            super(publicationWizard2, (JPanel)((Object)new PubWizGODBItemPage()), ASEUtils.getString("MSG_ADD_PUB_WIZ_PUBLISH"));
            this._panel = (PubWizGODBItemPage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.radioAll.addActionListener((ActionListener)this);
            this._panel.radioSelect.addActionListener((ActionListener)this);
            this._panel.cbTables.addActionListener((ActionListener)this);
            this._panel.cbProc.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._panel.radioAll) {
                this._panel.cbTables.setEnabled(true);
                this._panel.cbProc.setEnabled(true);
            } else if (actionEvent.getSource() == this._panel.radioSelect) {
                this._panel.cbTables.setSelected(false);
                this._panel.cbTables.setEnabled(false);
                this._panel.cbProc.setSelected(false);
                this._panel.cbProc.setEnabled(false);
            }
            this.enableComponents();
        }

        @Override
        public int onWizardNext() {
            PublicationWizard.this.getMySO().setAllTables(false);
            PublicationWizard.this.getMySO().setAllProcedures(false);
            if (this._panel.radioAll.isSelected()) {
                if (this._panel.cbTables.isSelected()) {
                    PublicationWizard.this.getMySO().setAllTables(true);
                }
                if (this._panel.cbProc.isSelected()) {
                    PublicationWizard.this.getMySO().setAllProcedures(true);
                }
            }
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = ASEUtils.getString("SUM_PUB_SELECTED_ART");
            if (this._panel.radioAll.isSelected()) {
                if (this._panel.cbTables.isSelected()) {
                    string = string + ASEUtils.getString("SUM_PUB_ALL_TABLES");
                }
                if (this._panel.cbProc.isSelected()) {
                    string = string + ASEUtils.getString("SUM_PUB_ALL_SP");
                }
            }
            return string;
        }

        @Override
        public void enableComponents() {
            if (this._panel.radioAll.isSelected()) {
                this.enableNextButton(this._panel.cbTables.isSelected() || this._panel.cbProc.isSelected());
            } else if (this._panel.radioSelect.isSelected()) {
                this.enableNextButton(true);
            } else {
                Debug.wassert(false, this, "Radio Buttons are not set correctly");
            }
        }

        @Override
        public void releaseResources() {
            this._panel.radioAll.removeActionListener((ActionListener)this);
            this._panel.radioSelect.removeActionListener((ActionListener)this);
            this._panel.cbTables.removeActionListener((ActionListener)this);
            this._panel.cbProc.removeActionListener((ActionListener)this);
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class PubWizBOPage1
    extends ASEBaseWizardPage2
    implements DocumentListener {
        private PubWizGONewPubPage _panel;

        public PubWizBOPage1(PublicationWizard publicationWizard2) {
            super(publicationWizard2, (JPanel)((Object)new PubWizGONewPubPage()), ASEUtils.getString("MSG_ADD_PUB_WIZ_TITLE"));
            this._panel = (PubWizGONewPubPage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.textName.getDocument().addDocumentListener(this);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public int onWizardNext() {
            PublicationWizard.this.getMySO().setPubName(this._panel.textName.getText());
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = ASEUtils.getString("SUM_PUB_NAME");
            ASEMessageText aSEMessageText = new ASEMessageText(string, PublicationWizard.this.getMySO().getDisplayName());
            String string2 = aSEMessageText.toString();
            return string2;
        }

        @Override
        public void enableComponents() {
            this.enableNextButton(this._panel.textName.getText() != null && this._panel.textName.getText().length() > 0);
        }

        @Override
        public void releaseResources() {
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }
}

