/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextUserData;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.asa.ASAMultiList;
import com.sybase.asa.ASATextUserData;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.ProfileHelper;
import com.sybase.aseplugin.bo.QPTuneDetailsBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.PreviewDialog;
import com.sybase.aseplugin.bo.dlg.QPTuneFixConfirmDialog;
import com.sybase.aseplugin.bo.dlg.QPTuneModeDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseQuickWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseQuickWizard;
import com.sybase.aseplugin.bo.wiz.ASEBaseQuickWizardPage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGOApplicationPage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGOCollectionPage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGOComparisonPage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGOConfigPage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGOModesPage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGONamePage;
import com.sybase.aseplugin.go.wiz.QPTuneWizGOResultPage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.OptGoal;
import com.sybase.aseplugin.so.QPTuneSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.central.SCPageController;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class QPTuneWizard
extends ASEBaseQuickWizard {
    private QPTuneSO _qso;
    private QPTuneSO _oldTask;
    private boolean _isExisting;
    private boolean _inProgress = false;
    private ArrayList<ASEBaseQuickWizardPage> _pages;
    private QPTuneWizNamePage _namePage;
    private QPTuneWizModesPage _modesPage;
    private QPTuneWizApplicationPage _appPage;
    private QPTuneWizResultPage _resultPage;
    private Task _task;
    int _delay = 0;

    public QPTuneWizard(QPTuneSO qPTuneSO, QPTuneDetailsBO qPTuneDetailsBO) {
        super((SOItemInterface)qPTuneSO, qPTuneDetailsBO, ASEUtils.getString("MSG_ADD_TUNING_TASK"));
        this._qso = qPTuneSO;
        this._isExisting = false;
    }

    public QPTuneWizard(QPTuneSO qPTuneSO, QPTuneDetailsBO qPTuneDetailsBO, String string) {
        super(qPTuneSO, qPTuneDetailsBO, ASEUtils.getString("MSG_EDIT_TUNING_TASK"), string);
        this._qso = qPTuneSO;
        this._isExisting = true;
        this._oldTask = (QPTuneSO)qPTuneSO.duplicate();
    }

    boolean deployAll() {
        for (int i = 0; i < this._pages.size(); ++i) {
            ASEBaseQuickWizardPage aSEBaseQuickWizardPage = this._pages.get(i);
            if (aSEBaseQuickWizardPage.deploy()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean deploy() {
        if (!this.deployAll()) {
            return false;
        }
        this._qso.setLastPageTitle(this.getLastTitle());
        this._qso.create();
        if (this._isExisting && this._oldTask != null && !this._oldTask.getName().equals(this._qso.getName())) {
            this._oldTask.remove();
        }
        return true;
    }

    @Override
    public SCPageController[] getPages() {
        if (this._pages == null) {
            this._pages = new ArrayList();
            this._namePage = new QPTuneWizNamePage(this);
            this._pages.add(this._namePage);
            this._pages.add(new QPTuneWizConfigPage(this));
            this._modesPage = new QPTuneWizModesPage(this);
            this._pages.add(this._modesPage);
            this._appPage = new QPTuneWizApplicationPage(this);
            this._pages.add(this._appPage);
            this._pages.add(new QPTuneWizCollectionPage(this));
            this._pages.add(new QPTuneWizComparisonPage(this));
            this._resultPage = new QPTuneWizResultPage(this);
            this._pages.add(this._resultPage);
        }
        return this._pages.toArray(new SCPageController[this._pages.size()]);
    }

    public void previewCommands(Container container, String string, ArrayList<String> arrayList) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append(arrayList.get(i) + "\n");
            }
            PreviewDialog previewDialog = PreviewDialog.getDialog(container, ASEUtils.getString("BTTN_PREVIEW") + " - " + string, ASEUtils.getString("LABC_COMMANDS"), stringBuffer.toString(), null);
            previewDialog.getInfoEditor().setLineWrap(true);
            previewDialog.render();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isInQPTuneProgress() {
        return this._inProgress;
    }

    void setInQPTuneProgress(boolean bl) {
        this._inProgress = bl;
    }

    boolean isOKToFinish() {
        return !this.isInQPTuneProgress() && this._namePage.isValid() && this._modesPage.isValid() && this._appPage.isValid();
    }

    String getErrorMessageForInvalidPage() {
        if (!this._namePage.isValid()) {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_EXECUTE_DISABLED_NAME");
        }
        if (!this._modesPage.isValid()) {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_EXECUTE_DISABLED_MODES");
        }
        if (!this._appPage.isValid()) {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_EXECUTE_DISABLED_APP");
        }
        return null;
    }

    class Task
    extends SwingWorker<String, Void> {
        private QPTuneSO.CompareOption _option;

        public Task(QPTuneSO.CompareOption compareOption) {
            this._option = compareOption;
        }

        @Override
        public String doInBackground() {
            QPTuneWizard.this._resultPage.getJDialog().setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.handleInProgress(true);
                this.setProgress(0);
                if (this._option == QPTuneSO.CompareOption.COMPARE) {
                    QPTuneWizard.this._qso.create();
                    QPTuneWizard.this._qso.createConfigFile();
                    QPTuneWizard.this._isExisting = true;
                    ((QPTuneDetailsBO)QPTuneWizard.this.getDetailsParent()).refresh();
                }
                this.setProgress(10);
                QPTuneWizard.this._resultPage.clearText();
                this.collect();
                this.compare();
                this.setProgress(100);
            }
            catch (Exception exception) {
                QPTuneWizard.this._resultPage.appendLine(exception.getMessage());
            }
            QPTuneWizard.this._qso.setCompareOutput(QPTuneWizard.this._resultPage.getText());
            return QPTuneWizard.this._qso.getCompareOutput();
        }

        private void collect() throws Exception {
            int n = 1;
            int n2 = 80;
            ArrayList<OptGoal> arrayList = new ArrayList<OptGoal>();
            if (this._option == QPTuneSO.CompareOption.COMPARE) {
                n = QPTuneWizard.this._qso.getNumberOfEnabledOptGoals();
                n2 = 80 / n;
                arrayList.addAll(QPTuneWizard.this._qso.getOptGoals());
            } else {
                arrayList.add(OptGoal.getFixedGoal(QPTuneWizard.this._qso.getName()));
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                OptGoal optGoal = (OptGoal)arrayList.get(i);
                if (!optGoal.getEnabled()) continue;
                QPTuneWizard.this._resultPage.appendLine(ASEUtils.getString("QPTUNE_WIZ_LABC_EXECUTING") + optGoal.getDisplayName() + " [" + Calendar.getInstance().getTime().toString() + "]");
                QPTuneWizard.this._delay = QPTuneWizard.this._qso.getCollectDelay() * 60;
                Timer timer = null;
                if (QPTuneWizard.this._delay > 0) {
                    timer = new Timer(10000, new DelayTimerListener());
                    timer.start();
                }
                if (QPTuneWizard.this._qso.getAppEnabled() && ASEUtils.isExistingFile(QPTuneWizard.this._qso.getAppPath())) {
                    QPTuneWizard.this._resultPage.appendLine(ASEUtils.getString("QPTUNE_WIZ_LABC_EXECUTING") + QPTuneWizard.this._qso.getAppPath());
                }
                if (QPTuneWizard.this._qso.getScriptEnabled() && ASEUtils.isExistingFile(QPTuneWizard.this._qso.getScriptPath())) {
                    QPTuneWizard.this._resultPage.appendLine(ASEUtils.getString("QPTUNE_WIZ_LABC_EXECUTING") + QPTuneWizard.this._qso.getScriptPath());
                }
                ArrayList<String> arrayList2 = QPTuneWizard.this._qso.startCollect(optGoal, false, this._option, QPTuneWizard.this.getJDialog());
                if (timer != null) {
                    timer.stop();
                }
                QPTuneWizard.this._resultPage.appendLines(arrayList2);
                this.setProgress(this.getProgress() + n2);
            }
        }

        private void compare() throws Exception {
            ArrayList<String> arrayList;
            String string;
            if (this._option == QPTuneSO.CompareOption.VERIFY_COMPARE) {
                string = ASEUtils.getString("QPTUNE_WIZ_BTTN_VERIFY");
                arrayList = QPTuneWizard.this._qso.verify(false);
            } else {
                string = ASEUtils.getString("QPTUNE_WIZ_COMPARISON_PAGE_TITLE");
                arrayList = QPTuneWizard.this._qso.compare(false, this._option);
            }
            QPTuneWizard.this._resultPage.appendLine(ASEUtils.getString("QPTUNE_WIZ_LABC_EXECUTING") + string + " [" + Calendar.getInstance().getTime().toString() + "]");
            QPTuneWizard.this._resultPage.appendLines(arrayList);
        }

        @Override
        public void done() {
            QPTuneWizard.this._resultPage.getJDialog().setCursor(null);
            ((QPTuneWizResultPage)((QPTuneWizard)QPTuneWizard.this)._resultPage)._go.progressBar.setVisible(false);
            this.handleInProgress(false);
        }

        public void handleInProgress(boolean bl) {
            QPTuneWizard.this.setInQPTuneProgress(bl);
            for (int i = 0; i < QPTuneWizard.this._pages.size(); ++i) {
                ((ASEBaseQuickWizardPage)QPTuneWizard.this._pages.get(i)).enableComponents();
            }
        }
    }

    class DelayTimerListener
    implements ActionListener {
        DelayTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("QPTUNE_WIZ_SENT_COLLECTION_DELAY_FOR"), String.valueOf(QPTuneWizard.this._delay));
            String string = aSEMessageText.toString();
            QPTuneWizard.this._resultPage.appendLine(string);
            QPTuneWizard.this._delay -= 10;
        }
    }

    public class QPTuneWizResultPage
    extends ASEBaseQuickWizardPage
    implements ActionListener,
    PropertyChangeListener {
        private QPTuneWizGOResultPage _go;
        private static final String NEWLINE = "\r\n|\r|\n";

        public QPTuneWizResultPage(QPTuneWizard qPTuneWizard2) {
            super(qPTuneWizard2, (JPanel)((Object)new QPTuneWizGOResultPage()), ASEUtils.getString("QPTUNE_WIZ_RESULTS_PAGE_TITLE"), new ImageIcon(ASEImages.getTuningTaskWizardImage()));
            this._go = (QPTuneWizGOResultPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._go.fixButton.addActionListener((ActionListener)this);
            this._go.previewButton.addActionListener((ActionListener)this);
            this._go.verifyButton.addActionListener((ActionListener)this);
            if (ASEUtils.isDesktopSupported(Desktop.Action.EDIT)) {
                this._go.openButton.addActionListener((ActionListener)this);
            }
            ActionListener[] actionListenerArray = this._go.openButton.getActionListeners();
            this._go.openButton.setVisible(actionListenerArray != null && actionListenerArray.length > 0);
        }

        @Override
        public String getQuickWizardPageDescription() {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_RESULTS_INTRO");
        }

        @Override
        public String getHelpID() {
            return "HELP_QPTUNE_WIZ_RESULTS_1503";
        }

        @Override
        public void enableComponents() {
            JButton jButton = this.getDialogSupport().getStandardButtonById(32);
            jButton.setText(ASEUtils.getString("STR_WIZ_NEXT_BUTTON"));
            jButton.setEnabled(false);
            this._go.resultsTextLabel.setText(QPTuneWizard.this._qso.getResultFile());
            String string = this._go.resultsTextLabel.getText().trim();
            boolean bl = string.isEmpty() || !ASEUtils.isExistingFile(string);
            this._go.defaultOptGoalCheckBox.setVisible(!bl);
            this._go.fixButton.setVisible(!bl);
            this._go.previewButton.setVisible(!bl);
            this._go.verifyButton.setVisible(!bl);
            this._go.messageMultiLineLabel.setText(bl ? ASEUtils.getString("QPTUNE_WIZ_SENT_NO_FIX") : ASEUtils.getString("QPTUNE_WIZ_SENT_FIX"));
            boolean bl2 = !bl && !QPTuneWizard.this.isInQPTuneProgress();
            this._go.openButton.setEnabled(bl2);
            this._go.fixButton.setEnabled(bl2);
            String string2 = QPTuneWizard.this.getErrorMessageForInvalidPage();
            if (string2 == null) {
                this._go.iconLabel.setVisible(false);
                this._go.verifyLabel.setText(ASEUtils.getString("QPTUNE_WIZ_SENT_VERIFY"));
                this._go.finishLabel.setVisible(true);
            } else {
                this._go.iconLabel.setVisible(true);
                this._go.verifyLabel.setText(string2);
                this._go.finishLabel.setVisible(false);
            }
            this._go.verifyButton.setEnabled(bl2 && QPTuneWizard.this.isOKToFinish());
            this._go.defaultOptGoalCheckBox.setEnabled(bl2);
            this._go.previewButton.setEnabled(bl2 && QPTuneWizard.this.isOKToFinish());
            this.enableBackButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableCancelButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableFinishButton(QPTuneWizard.this.isOKToFinish());
        }

        public void appendLines(ArrayList<String> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String[] stringArray = arrayList.get(i).split(NEWLINE);
                for (int j = 0; j < stringArray.length; ++j) {
                    this.appendLine(stringArray[j]);
                }
            }
        }

        public void appendLine(String string) {
            this.appendText(string + "\n");
        }

        public void appendText(String string) {
            if (string.startsWith(ASEUtils.getString("QPTUNE_WIZ_LABC_EXECUTING"))) {
                this.appendItalicText(string);
            } else if (string.startsWith("Query count improved")) {
                this.appendBlueText(string);
            } else if (!string.startsWith("It will start collecting process in") && !string.startsWith("Program is on hold")) {
                this.appendPlainText(string);
            }
        }

        private void appendPlainText(String string) {
            StyledDocument styledDocument = (StyledDocument)this._go.resultTextEditor.getDocument();
            try {
                styledDocument.insertString(styledDocument.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void appendBlueText(String string) {
            StyledDocument styledDocument = (StyledDocument)this._go.resultTextEditor.getDocument();
            try {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setBold(simpleAttributeSet, true);
                StyleConstants.setForeground(simpleAttributeSet, Color.blue);
                styledDocument.insertString(styledDocument.getLength(), string, simpleAttributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void appendItalicText(String string) {
            StyledDocument styledDocument = (StyledDocument)this._go.resultTextEditor.getDocument();
            try {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setItalic(simpleAttributeSet, true);
                styledDocument.insertString(styledDocument.getLength(), string, simpleAttributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void clearText() {
            this._go.resultTextEditor.setText("");
        }

        public String getText() {
            return this._go.resultTextEditor.getText();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.openButton) {
                try {
                    ASEUtils.desktopOpen(this._go.resultsTextLabel.getText(), Desktop.Action.EDIT);
                }
                catch (IOException iOException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
            } else if (object == this._go.fixButton) {
                QPTuneWizard.this.deployAll();
                QPTuneFixConfirmDialog qPTuneFixConfirmDialog = QPTuneFixConfirmDialog.getDialog((QPTuneWizard)this.getParent(), QPTuneWizard.this._qso);
                boolean bl = qPTuneFixConfirmDialog.render();
                if (bl) {
                    this.appendLines(qPTuneFixConfirmDialog.getFixOutput());
                }
            } else if (object == this._go.previewButton) {
                QPTuneWizard.this.deployAll();
                try {
                    ArrayList<String> arrayList = QPTuneWizard.this._qso.startCollect(OptGoal.getFixedGoal(QPTuneWizard.this._qso.getName()), true, QPTuneSO.CompareOption.VERIFY_COMPARE, this.getJDialog());
                    arrayList.addAll(QPTuneWizard.this._qso.verify(true));
                    QPTuneWizard.this.previewCommands(this.getJDialog(), ASEUtils.getString("QPTUNE_WIZ_BTTN_VERIFY"), arrayList);
                }
                catch (Exception exception) {}
            } else if (object == this._go.verifyButton) {
                QPTuneWizard.this.deployAll();
                QPTuneWizard.this._task = new Task(QPTuneSO.CompareOption.VERIFY_COMPARE);
                QPTuneWizard.this._task.addPropertyChangeListener(this);
                QPTuneWizard.this._task.execute();
                ((QPTuneWizard)QPTuneWizard.this)._resultPage._go.progressBar.setVisible(true);
            }
            this.enableComponents();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            if (propertyChangeEvent.getSource() == QPTuneWizard.this._task && (object = propertyChangeEvent.getNewValue()) instanceof Integer) {
                int n = (Integer)object;
                this._go.progressBar.setValue(n);
            }
        }

        @Override
        public void init() {
            if (QPTuneWizard.this._isExisting) {
                this._go.defaultOptGoalCheckBox.setSelected(QPTuneWizard.this._qso.getDefaultOptGoals());
                String string = QPTuneWizard.this._qso.getCompareOutput();
                String[] stringArray = string.split(NEWLINE);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.appendLine(stringArray[i]);
                }
            }
        }

        @Override
        public boolean deploy() {
            QPTuneWizard.this._qso.setDefaultOptGoals(this._go.defaultOptGoalCheckBox.isSelected());
            QPTuneWizard.this._qso.setCompareOutput(this._go.resultTextEditor.getText());
            return true;
        }
    }

    public class QPTuneWizComparisonPage
    extends ASEBaseQuickWizDocPage
    implements ActionListener {
        private QPTuneWizGOComparisonPage _go;

        public QPTuneWizComparisonPage(QPTuneWizard qPTuneWizard2) {
            super(qPTuneWizard2, (JPanel)((Object)new QPTuneWizGOComparisonPage()), ASEUtils.getString("QPTUNE_WIZ_COMPARISON_PAGE_TITLE"), new ImageIcon(ASEImages.getTuningTaskWizardImage()));
            this._go = (QPTuneWizGOComparisonPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._init();
            this._go.resultFileEditor.addDocumentListener(this);
            this._go.previewButton.addActionListener((ActionListener)this);
        }

        @Override
        public String getQuickWizardPageDescription() {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_COMPARISON");
        }

        @Override
        public String getHelpID() {
            return "HELP_QPTUNE_WIZ_COMPARISON_1503";
        }

        private void _init() {
            if (QPTuneWizard.this._isExisting) {
                this._go.percentSpinBox.setValue(QPTuneWizard.this._qso.getThresholdPercent());
                this._go.valueSpinBox.setValue(QPTuneWizard.this._qso.getThresholdValue());
                this._go.sortCheckBox.setSelected(QPTuneWizard.this._qso.getSortBySize());
                String string = QPTuneWizard.this._qso.getResultFile();
                if (string != null && !string.isEmpty()) {
                    this._go.resultFileEditor.setFileName(string);
                }
            }
        }

        @Override
        public void init() {
            String string = QPTuneWizard.this._namePage.getFileName();
            String string2 = ASEUtils.getDirectoryFromPath(string);
            if (ASEUtils.isExistingDirectory(string2)) {
                this._go.resultFileEditor.setInitFilePath(string2);
            }
            this._go.resultFileEditor.setParentWindow(this.getJDialog());
        }

        private void setValues() {
            QPTuneWizard.this._qso.setThresholdPercent(this._go.percentSpinBox.getValue());
            QPTuneWizard.this._qso.setThresholdValue(this._go.valueSpinBox.getValue());
            QPTuneWizard.this._qso.setSortBySize(this._go.sortCheckBox.isSelected());
            QPTuneWizard.this._qso.setResultFile(this.getResultFileName());
        }

        @Override
        public boolean onWizardFinish() {
            this.setValues();
            return true;
        }

        @Override
        public int onWizardNext() {
            this.setValues();
            if (!QPTuneWizard.this.deployAll()) {
                return -1;
            }
            this.enableNextButton(false);
            this.enableFinishButton(false);
            QPTuneWizard.this._task = new Task(QPTuneSO.CompareOption.COMPARE);
            QPTuneWizard.this._task.addPropertyChangeListener(QPTuneWizard.this._resultPage);
            QPTuneWizard.this._task.execute();
            ((QPTuneWizResultPage)((QPTuneWizard)QPTuneWizard.this)._resultPage)._go.progressBar.setVisible(true);
            return 0;
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.previewButton) {
                this.setValues();
                if (QPTuneWizard.this.deployAll()) {
                    try {
                        ArrayList<String> arrayList = QPTuneWizard.this._qso.execute(true, this.getJDialog());
                        QPTuneWizard.this.previewCommands(this.getJDialog(), ASEUtils.getString("MSG_EXECUTE"), arrayList);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.enableComponents();
        }

        private String getResultFileName() {
            return this._go.resultFileEditor.getFileName();
        }

        @Override
        public void enableComponents() {
            JButton jButton = this.getDialogSupport().getStandardButtonById(32);
            jButton.setText(ASEUtils.getString("MSG_EXECUTE"));
            jButton.setPreferredSize(null);
            boolean bl = !this.getResultFileName().isEmpty();
            String string = QPTuneWizard.this.getErrorMessageForInvalidPage();
            if (string == null) {
                this._go.iconLabel.setVisible(false);
                this._go.executeLabel.setText(ASEUtils.getString("QPTUNE_WIZ_SENT_EXECUTE"));
                this._go.finishLabel.setVisible(true);
            } else {
                this._go.iconLabel.setVisible(true);
                this._go.executeLabel.setText(string);
                this._go.finishLabel.setVisible(false);
            }
            this._go.previewButton.setEnabled(bl && !QPTuneWizard.this.isInQPTuneProgress() && QPTuneWizard.this.isOKToFinish());
            this.enableBackButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableNextButton(bl && QPTuneWizard.this.isOKToFinish());
            this.enableCancelButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableFinishButton(QPTuneWizard.this.isOKToFinish());
        }
    }

    public class QPTuneWizCollectionPage
    extends ASEBaseQuickWizDocPage
    implements ActionListener {
        private QPTuneWizGOCollectionPage _go;

        public QPTuneWizCollectionPage(QPTuneWizard qPTuneWizard2) {
            super(qPTuneWizard2, (JPanel)((Object)new QPTuneWizGOCollectionPage()), ASEUtils.getString("QPTUNE_WIZ_COLLECTION_PAGE_TITLE"), new ImageIcon(ASEImages.getTuningTaskWizardImage()));
            this._go = (QPTuneWizGOCollectionPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._init();
            this._go.delayCheckBox.addActionListener((ActionListener)this);
        }

        @Override
        public String getQuickWizardPageDescription() {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_COLLECTION");
        }

        @Override
        public String getHelpID() {
            return "HELP_QPTUNE_WIZ_COLLECTION_1503";
        }

        @Override
        public boolean deploy() {
            if (this._go.delayCheckBox.isSelected()) {
                QPTuneWizard.this._qso.setCollectDelay(this._go.delaySpinBox.getValue());
            } else {
                QPTuneWizard.this._qso.setCollectDelay(0);
            }
            if (this._go.fullRadioButton.isSelected()) {
                QPTuneWizard.this._qso.setCollectOption("collect_full");
            } else {
                QPTuneWizard.this._qso.setCollectOption("collect");
            }
            Object object = this._go.evalFieldComboBox.getSelectedUserData();
            if (object != null) {
                QPTuneWizard.this._qso.setEvalField(object.toString());
            }
            return true;
        }

        private void _init() {
            ArrayList<String[]> arrayList = QPTuneSO.getEvalFields();
            for (int i = 0; i < arrayList.size(); ++i) {
                String[] stringArray = arrayList.get(i);
                this._go.evalFieldComboBox.addItem((Object)new ASATextUserData(stringArray[0], (Object)stringArray[1]));
            }
            this._go.evalFieldComboBox.setSelectedItem(ASEUtils.getString("QMETRICS_ELAP_AVG"));
            this._go.optgoalRadioButton.setSelected(true);
            if (QPTuneWizard.this._isExisting) {
                String string = QPTuneWizard.this._qso.getCollectOption();
                if (string != null) {
                    this._go.optgoalRadioButton.setSelected(string.equals("collect"));
                    this._go.fullRadioButton.setSelected(string.equals("collect_full"));
                }
                if (QPTuneWizard.this._qso.getCollectDelay() > 0) {
                    this._go.delayCheckBox.setSelected(true);
                    this._go.delaySpinBox.setValue(QPTuneWizard.this._qso.getCollectDelay());
                }
                if (QPTuneWizard.this._qso.getEvalField() != null) {
                    this._go.evalFieldComboBox.setSelectedUserData((Object)QPTuneWizard.this._qso.getEvalField());
                }
            }
        }

        @Override
        public void init() {
            this.enableComponents();
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.delayCheckBox.isSelected();
            this._go.delaySpinBox.setEnabled(bl);
            this._go.minutesLabel.setEnabled(bl);
            if (bl) {
                this._go.delaySpinBox.requestFocusInWindow();
            }
            this.enableBackButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableNextButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableFinishButton(QPTuneWizard.this.isOKToFinish());
            this.enableCancelButton(!QPTuneWizard.this.isInQPTuneProgress());
        }
    }

    class QPTuneWizApplicationPage
    extends ASEBaseQuickWizDocPage
    implements ActionListener {
        private QPTuneWizGOApplicationPage _go;

        public QPTuneWizApplicationPage(QPTuneWizard qPTuneWizard2) {
            super(qPTuneWizard2, (JPanel)((Object)new QPTuneWizGOApplicationPage()), ASEUtils.getString("MSG_APPLICATION"), new ImageIcon(ASEImages.getTuningTaskWizardImage()));
            this._go = (QPTuneWizGOApplicationPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._init();
            this._go.isqlButton.addActionListener((ActionListener)this);
            this._go.runButton.addActionListener((ActionListener)this);
            this._go.appEditor.addDocumentListener(this);
            this._go.scriptFileEditor.addDocumentListener(this);
            this._go.appCheckBox.addActionListener((ActionListener)this);
            this._go.scriptFileCheckBox.addActionListener((ActionListener)this);
        }

        @Override
        public String getQuickWizardPageDescription() {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_RUNNING_APPS");
        }

        private void _init() {
            String string = QPTuneWizard.this._isExisting && QPTuneWizard.this._qso.getAppPath() != null ? QPTuneWizard.this._qso.getAppPath() : QPTuneWizard.this._qso.getLastAppPath();
            String string2 = QPTuneWizard.this._isExisting && QPTuneWizard.this._qso.getScriptPath() != null ? QPTuneWizard.this._qso.getScriptPath() : QPTuneWizard.this._qso.getLastScriptPath();
            this._go.appEditor.setFileName(string);
            this._go.scriptFileEditor.setFileName(string2);
            if (QPTuneWizard.this._isExisting) {
                this._go.appCheckBox.setSelected(QPTuneWizard.this._qso.getAppEnabled());
                this._go.scriptFileCheckBox.setSelected(QPTuneWizard.this._qso.getScriptEnabled());
            }
        }

        @Override
        public void init() {
            this._go.appEditor.setParentWindow(this.getJDialog());
            this._go.scriptFileEditor.setParentWindow(this.getJDialog());
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.runButton) {
                try {
                    String string = this._go.appEditor.getFileName();
                    QPTuneWizard.this._qso.runApp(string, true);
                    ProfileHelper.setPreference("Setting.LastTuningApp", string);
                }
                catch (IOException iOException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
            } else if (object == this._go.isqlButton) {
                String string = this._go.scriptFileEditor.getFileName();
                try {
                    String string2 = Support.readSQLFile(string);
                    Support.getProvider().openDBISQL(this.getJDialog(), this.getConnection(), QPTuneWizard.this._qso.getDBName(), string2, false);
                    ProfileHelper.setPreference("Setting.LastTuningScript", string);
                }
                catch (IOException iOException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
            } else if (object == this._go.appCheckBox) {
                if (this._go.appCheckBox.isSelected()) {
                    this._go.appEditor.getTextField().requestFocus();
                }
                this.enableComponents();
            } else if (object == this._go.scriptFileCheckBox) {
                if (this._go.scriptFileCheckBox.isSelected()) {
                    this._go.scriptFileEditor.getTextField().requestFocus();
                }
                this.enableComponents();
            }
        }

        @Override
        public boolean deploy() {
            QPTuneWizard.this._qso.setAppPath(this._go.appEditor.getFileName());
            QPTuneWizard.this._qso.setScriptPath(this._go.scriptFileEditor.getFileName());
            QPTuneWizard.this._qso.setAppEnabled(this._go.appCheckBox.isSelected());
            QPTuneWizard.this._qso.setScriptEnabled(this._go.scriptFileCheckBox.isSelected());
            return true;
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.appCheckBox.isSelected();
            this._go.appEditor.setEnabled(bl);
            String string = this._go.appEditor.getFileName();
            boolean bl2 = ASEUtils.isExistingFile(string);
            this._go.runButton.setEnabled(bl2);
            boolean bl3 = this._go.scriptFileCheckBox.isSelected();
            this._go.scriptFileEditor.setEnabled(bl3);
            string = this._go.scriptFileEditor.getFileName();
            boolean bl4 = ASEUtils.isExistingFile(string);
            this._go.isqlButton.setEnabled(bl4);
            this.enableBackButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableNextButton(this.isValid() && !QPTuneWizard.this.isInQPTuneProgress());
            this.enableCancelButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableFinishButton(QPTuneWizard.this.isOKToFinish());
        }

        boolean isValid() {
            boolean bl = this._go.appCheckBox.isSelected();
            boolean bl2 = ASEUtils.isExistingFile(this._go.appEditor.getFileName());
            boolean bl3 = this._go.scriptFileCheckBox.isSelected();
            boolean bl4 = ASEUtils.isExistingFile(this._go.scriptFileEditor.getFileName());
            boolean bl5 = bl && !bl2 || bl3 && !bl4;
            return !bl5;
        }

        @Override
        public String getHelpID() {
            return "HELP_QPTUNE_WIZ_APPLICATION_1503";
        }
    }

    public class QPTuneWizModesPage
    extends ASEBaseQuickWizardPage
    implements ActionListener,
    ListSelectionListener,
    ASAListCheckListener,
    MouseListener {
        private QPTuneWizGOModesPage _go;
        private ASAIconTextUserData _dss;
        private ASAIconTextUserData _oltp;
        private ASAIconTextUserData _mixed;
        private ASAIconTextData _preDefined;
        private ASAIconTextData _userDefined;

        public QPTuneWizModesPage(QPTuneWizard qPTuneWizard2) {
            super(qPTuneWizard2, (JPanel)((Object)new QPTuneWizGOModesPage()), ASEUtils.getString("QPTUNE_WIZ_MODE_PAGE_TITLE"), new ImageIcon(ASEImages.getTuningTaskWizardImage()));
            this._go = (QPTuneWizGOModesPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._init();
            this._go.modesMultiCheckList.addListSelectionListener((ListSelectionListener)this);
            this._go.modesMultiCheckList.addListCheckListener((ASAListCheckListener)this);
            this._go.modesMultiCheckList.addMouseListener((MouseListener)this);
            this._go.addButton.addActionListener((ActionListener)this);
            this._go.editButton.addActionListener((ActionListener)this);
            this._go.removeButton.addActionListener((ActionListener)this);
            this._go.upButton.addActionListener((ActionListener)this);
            this._go.downButton.addActionListener((ActionListener)this);
            this._go.selectAllButton.addActionListener((ActionListener)this);
            this._go.clearAllButton.addActionListener((ActionListener)this);
        }

        @Override
        public String getQuickWizardPageDescription() {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_MODES");
        }

        @Override
        public String getHelpID() {
            return "HELP_QPTUNE_WIZ_MODES_1503";
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                this.handleEdit();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private void handleEdit() {
            int n = this._go.modesMultiCheckList.getSelectedRow();
            Vector vector = this._go.modesMultiCheckList.getRow(n);
            ASAIconTextUserData aSAIconTextUserData = (ASAIconTextUserData)vector.get(0);
            OptGoal optGoal = (OptGoal)aSAIconTextUserData.userData;
            QPTuneModeDialog qPTuneModeDialog = QPTuneModeDialog.getDialog(this.getJDialog(), QPTuneWizard.this._qso, optGoal, true);
            boolean bl = qPTuneModeDialog.render();
            if (bl) {
                OptGoal optGoal2 = qPTuneModeDialog.getOptGoal();
                ASAIconTextUserData aSAIconTextUserData2 = new ASAIconTextUserData(optGoal2.getDisplayName());
                aSAIconTextUserData2.setUserData((Object)optGoal2);
                this._go.modesMultiCheckList.removeRow(n);
                this._go.modesMultiCheckList.insertRow(n, true, new Object[]{aSAIconTextUserData2, this._userDefined});
                this._go.modesMultiCheckList.selectRow(n);
            }
        }

        private void handleAdd() {
            OptGoal optGoal = new OptGoal("_basic_", true);
            QPTuneModeDialog qPTuneModeDialog = QPTuneModeDialog.getDialog(this.getJDialog(), QPTuneWizard.this._qso, optGoal, false);
            boolean bl = qPTuneModeDialog.render();
            if (bl) {
                OptGoal optGoal2 = qPTuneModeDialog.getOptGoal();
                ASAIconTextUserData aSAIconTextUserData = new ASAIconTextUserData(optGoal2.getDisplayName());
                aSAIconTextUserData.setUserData((Object)optGoal2);
                this._go.modesMultiCheckList.addRow(true, new Object[]{aSAIconTextUserData, this._userDefined});
                int n = this._go.modesMultiCheckList.getRowCount() - 1;
                if (n >= 0) {
                    this._go.modesMultiCheckList.selectRow(n);
                }
            }
        }

        private void handleRemove() {
            int n = this._go.modesMultiCheckList.getSelectedRow();
            this._go.modesMultiCheckList.removeRow(n);
            int n2 = this._go.modesMultiCheckList.getRowCount() - 1;
            if (n2 >= 0) {
                int n3 = n > n2 ? n2 : n;
                this._go.modesMultiCheckList.selectRow(n3);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.upButton) {
                Support.moveRows(true, (ASAMultiList)this._go.modesMultiCheckList);
            } else if (object == this._go.downButton) {
                Support.moveRows(false, (ASAMultiList)this._go.modesMultiCheckList);
            } else if (object == this._go.selectAllButton) {
                this._go.modesMultiCheckList.checkAllRows();
            } else if (object == this._go.clearAllButton) {
                this._go.modesMultiCheckList.uncheckAllRows();
            } else if (object == this._go.addButton) {
                this.handleAdd();
                this.deploy();
            } else if (object == this._go.editButton) {
                this.handleEdit();
                this.deploy();
            } else if (object == this._go.removeButton) {
                this.handleRemove();
                this.deploy();
            }
            this.enableComponents();
        }

        @Override
        public boolean deploy() {
            QPTuneWizard.this._qso.getOptGoals().clear();
            for (int i = 0; i < this._go.modesMultiCheckList.getRowCount(); ++i) {
                Vector vector = this._go.modesMultiCheckList.getRow(i);
                ASAIconTextUserData aSAIconTextUserData = (ASAIconTextUserData)vector.get(0);
                OptGoal optGoal = (OptGoal)aSAIconTextUserData.userData;
                optGoal.setEnabled(this._go.modesMultiCheckList.isRowChecked(i));
                QPTuneWizard.this._qso.getOptGoals().add(optGoal);
            }
            return true;
        }

        @Override
        public void enableComponents() {
            int n = this._go.modesMultiCheckList.getSelectedRow();
            boolean bl = n >= 0;
            boolean bl2 = false;
            if (bl) {
                String string = this._go.modesMultiCheckList.getStringAt(n, 1);
                bl2 = string.equals(ASEUtils.getString("MSG_PRE_DEFINED"));
            }
            this._go.removeButton.setEnabled(bl && !bl2);
            this._go.editButton.setEnabled(bl && !bl2);
            this._go.upButton.setEnabled(bl && this._go.modesMultiCheckList.getMinSelectionIndex() > 0);
            int n2 = this._go.modesMultiCheckList.getRowCount();
            this._go.downButton.setEnabled(bl && this._go.modesMultiCheckList.getMaxSelectionIndex() < n2 - 1);
            boolean bl3 = this.isValid();
            this.enableBackButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableNextButton(bl3 && !QPTuneWizard.this.isInQPTuneProgress());
            this.enableFinishButton(bl3 && QPTuneWizard.this.isOKToFinish());
            this.enableCancelButton(!QPTuneWizard.this.isInQPTuneProgress());
        }

        boolean isValid() {
            return this._go.modesMultiCheckList.getCheckedRowCount() > 1;
        }

        private void initDefaultModes() {
            OptGoal optGoal = new OptGoal("allrows_dss", true);
            this._dss = new ASAIconTextUserData(optGoal.getDisplayName());
            this._dss.setUserData((Object)optGoal);
            optGoal = new OptGoal("allrows_oltp", true);
            this._oltp = new ASAIconTextUserData(optGoal.getDisplayName());
            this._oltp.setUserData((Object)optGoal);
            optGoal = new OptGoal("allrows_mix", true);
            this._mixed = new ASAIconTextUserData(optGoal.getDisplayName());
            this._mixed.setUserData((Object)optGoal);
            this._preDefined = new ASAIconTextData(ASEUtils.getString("MSG_PRE_DEFINED"));
            this._userDefined = new ASAIconTextData(ASEUtils.getString("MSG_USER_DEFINED"));
        }

        private void _init() {
            this._go.modesMultiCheckList.clear();
            this.initDefaultModes();
            if (QPTuneWizard.this._isExisting && QPTuneWizard.this._qso.getOptGoals().size() > 0) {
                ArrayList<OptGoal> arrayList = QPTuneWizard.this._qso.getOptGoals();
                for (int i = 0; i < arrayList.size(); ++i) {
                    OptGoal optGoal = arrayList.get(i);
                    ASAIconTextUserData aSAIconTextUserData = new ASAIconTextUserData(optGoal.getDisplayName());
                    aSAIconTextUserData.setUserData((Object)optGoal);
                    this._go.modesMultiCheckList.addRow(optGoal.getEnabled(), new Object[]{aSAIconTextUserData, optGoal.isPredefined() ? this._preDefined : this._userDefined});
                }
            } else {
                this._go.modesMultiCheckList.addRow(true, new Object[]{this._dss, this._preDefined});
                this._go.modesMultiCheckList.addRow(true, new Object[]{this._oltp, this._preDefined});
                this._go.modesMultiCheckList.addRow(true, new Object[]{this._mixed, this._preDefined});
            }
            this._go.modesMultiCheckList.addRow(false, new Object[]{this._mixed, this._userDefined});
            this._go.modesMultiCheckList.setColumnWidthToFit(1);
            this._go.modesMultiCheckList.removeRow(this._go.modesMultiCheckList.getRowCount() - 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.enableComponents();
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            this.enableComponents();
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class QPTuneWizConfigPage
    extends ASEBaseQuickWizardPage {
        private QPTuneWizGOConfigPage _go;

        public QPTuneWizConfigPage(QPTuneWizard qPTuneWizard2) {
            super(qPTuneWizard2, (JPanel)((Object)new QPTuneWizGOConfigPage()), ASEUtils.getString("QPTUNE_WIZ_CONFIG_PAGE_TITLE"), new ImageIcon(ASEImages.getTuningTaskWizardImage()));
            this._go = (QPTuneWizGOConfigPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            this._init();
        }

        @Override
        public String getQuickWizardPageDescription() {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_SERVER_CONFIG");
        }

        @Override
        public String getHelpID() {
            return "HELP_QPTUNE_WIZ_CONFIG_1503";
        }

        @Override
        public boolean deploy() {
            QPTuneWizard.this._qso.setStartConfig(this._go.startEditor.getText());
            QPTuneWizard.this._qso.setEndConfig(this._go.endEditor.getText());
            QPTuneWizard.this._qso.setFixConfig(this._go.fixEditor.getText());
            QPTuneWizard.this._qso.setStartStatConfig(this._go.startStatEditor.getText());
            return true;
        }

        @Override
        public void enableComponents() {
            this._go.startEditor.setText(QPTuneWizard.this._qso.getStartConfig());
            this._go.endEditor.setText(QPTuneWizard.this._qso.getEndConfig());
            this._go.fixEditor.setText(QPTuneWizard.this._qso.getFixConfig());
            this._go.startStatEditor.setText(QPTuneWizard.this._qso.getStartStatConfig());
            this.enableBackButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableNextButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableCancelButton(!QPTuneWizard.this.isInQPTuneProgress());
            this.enableFinishButton(QPTuneWizard.this.isOKToFinish());
        }

        private void _init() {
            if (QPTuneWizard.this._isExisting) {
                String string = QPTuneWizard.this._qso.getStartConfig();
                this._go.startEditor.setText(string == null ? QPTuneWizard.this._qso.getInitStartConfig() : string);
                String string2 = QPTuneWizard.this._qso.getEndConfig();
                this._go.endEditor.setText(string2 == null ? QPTuneWizard.this._qso.getInitEndConfig() : string2);
                String string3 = QPTuneWizard.this._qso.getFixConfig();
                this._go.fixEditor.setText(string3 == null ? QPTuneWizard.this._qso.getInitFixConfig() : string3);
                String string4 = QPTuneWizard.this._qso.getStartStatConfig();
                this._go.startStatEditor.setText(string4 == null ? QPTuneWizard.this._qso.getInitStartStatConfig() : string4);
            } else {
                this._go.startEditor.setText(QPTuneWizard.this._qso.getInitStartConfig());
                QPTuneWizard.this._qso.setStartConfig(this._go.startEditor.getText());
                this._go.endEditor.setText(QPTuneWizard.this._qso.getInitEndConfig());
                QPTuneWizard.this._qso.setEndConfig(this._go.endEditor.getText());
                this._go.fixEditor.setText(QPTuneWizard.this._qso.getInitFixConfig());
                QPTuneWizard.this._qso.setFixConfig(this._go.fixEditor.getText());
                this._go.startStatEditor.setText(QPTuneWizard.this._qso.getInitStartStatConfig());
                QPTuneWizard.this._qso.setStartStatConfig(this._go.startStatEditor.getText());
            }
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class QPTuneWizNamePage
    extends ASEBaseQuickWizDocPage {
        private QPTuneWizGONamePage _go;

        public QPTuneWizNamePage(QPTuneWizard qPTuneWizard2) {
            super(qPTuneWizard2, (JPanel)((Object)new QPTuneWizGONamePage()), ASEUtils.getString("QPTUNE_WIZ_NAME_PAGE_TITLE"), new ImageIcon(ASEImages.getTuningTaskWizardImage()));
            this._go = (QPTuneWizGONamePage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
            try {
                this._init();
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), exception.getMessage(), exception);
            }
            this._go.nameTextField.getDocument().addDocumentListener(this);
            this._go.configFileEditor.addDocumentListener(this);
        }

        @Override
        public String getQuickWizardPageDescription() {
            return ASEUtils.getString("QPTUNE_WIZ_SENT_WELCOME");
        }

        @Override
        public String getHelpID() {
            return "HELP_QPTUNE_WIZ_NAME_1503";
        }

        @Override
        public boolean doesQuickWizardPageContainManditoryInformation() {
            return true;
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        public String getFileName() {
            return this._go.configFileEditor.getFileName();
        }

        @Override
        public boolean deploy() {
            QPTuneWizard.this._qso.setName(this._go.nameTextField.getText());
            QPTuneWizard.this._qso.setConfigFile(this.getFileName());
            String string = this.getDBName();
            if (string == null) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_DATABASE_NOT_EXIST"), QPTuneWizard.this._qso.getServer().getName(), QPTuneWizard.this._qso.getDBName());
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            QPTuneWizard.this._qso.setDBName(string);
            QPTuneWizard.this._qso.setVerbose(this._go.verboseCheckBox.isSelected());
            if (!QPTuneWizard.this._isExisting && ASEUtils.isExistingFile(this.getFileName())) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_FILE_EXISTS"), this.getFileName());
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            boolean bl = false;
            try {
                bl = Support.validateObjectName(QPTuneWizard.this._qso, this.getJDialog(), (JTextComponent)((Object)this._go.nameTextField));
                if (!QPTuneWizard.this._isExisting && bl) {
                    return Support.verifyObjectName(QPTuneWizard.this._qso, this.getJDialog(), (JTextComponent)((Object)this._go.nameTextField));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return bl;
        }

        @Override
        public void enableComponents() {
            this._go.messagePanel.setVisible(false);
            if (!this.getSO().getConnection().hasSARole()) {
                this.showErrorMessage(ASEUtils.getString("MSG_NEED_SA_ROLE_TO_QPTUNE"));
                return;
            }
            if (!this.getSO().getConnection().hasSSORole()) {
                this.showErrorMessage(ASEUtils.getString("MSG_NEED_SSO_ROLE_TO_QPTUNE"));
                return;
            }
            String string = QPTuneSO.init();
            if (string != null) {
                this.showErrorMessage(string);
                return;
            }
            boolean bl = this.isValid();
            this.enableNextButton(bl && !QPTuneWizard.this.isInQPTuneProgress());
            this.enableFinishButton(QPTuneWizard.this.isOKToFinish());
            this.enableCancelButton(!QPTuneWizard.this.isInQPTuneProgress());
        }

        boolean isValid() {
            boolean bl;
            boolean bl2 = bl = this._go.nameTextField.getText().length() > 0 && this.getFileName().length() > 0;
            if (!QPTuneWizard.this._isExisting) {
                bl = bl && !ASEUtils.isExistingFile(this.getFileName());
            }
            return bl;
        }

        private void _init() throws SQLException {
            if (QPTuneWizard.this._isExisting) {
                this._go.nameTextField.setText(QPTuneWizard.this._qso.getName());
                this._go.configFileEditor.setFileName(QPTuneWizard.this._qso.getConfigFile());
                this._go.configFileEditor.getTextField().setEditable(false);
                this._go.configFileEditor.getButton().setVisible(false);
                this._go.configFileEditor.getMultiLineLabel().setVisible(false);
                this._go.verboseCheckBox.setSelected(QPTuneWizard.this._qso.getVerbose());
            }
            this.initDatabases();
            if (QPTuneWizard.this._isExisting) {
                this._go.databaseComboBox.setSelectedItem(QPTuneWizard.this._qso.getDBName());
            }
        }

        @Override
        public void init() {
            this._go.configFileEditor.setParentWindow(this.getJDialog());
        }

        private void initDatabases() throws SQLException {
            DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
            List<DatabaseSO> list = databasesCtrSO.getNormalDBList(1);
            Support.initDatabaseDropdown(list, this._go.databaseComboBox, true);
        }

        private String getDBName() {
            Object object = this._go.databaseComboBox.getSelectedItem();
            return object != null ? object.toString() : null;
        }

        private void showErrorMessage(String string) {
            this._go.messagePanel.setVisible(true);
            this._go.messageMultiLineLabel.setText(string);
            this._go.configMultiLineLabel.setEnabled(false);
            this._go.nameLabel.setEnabled(false);
            this._go.nameTextField.setEnabled(false);
            this._go.configFileLabel.setEnabled(false);
            this._go.configFileEditor.setEnabled(false);
            this._go.databaseLabel.setEnabled(false);
            this._go.databaseComboBox.setEnabled(false);
            this._go.verboseCheckBox.setEnabled(false);
            this.enableFinishButton(false);
            this.enableNextButton(false);
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

