/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.JSBaseInterface;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.RJSScheduledJobsBO;
import com.sybase.aseplugin.bo.RJSTracer;
import com.sybase.aseplugin.bo.ScheduledJobsCtrBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.JSBaseWizard;
import com.sybase.aseplugin.bo.wiz.JSWizBOPages;
import com.sybase.aseplugin.bo.wiz.JobSchedulerSummaryWizBOPage;
import com.sybase.aseplugin.so.JSBaseSO;
import com.sybase.aseplugin.so.RemoteJobSchedulingSO;
import com.sybase.aseplugin.so.ScheduledJobSO;
import com.sybase.aseplugin.sql.SQLListener;
import com.sybase.central.SCPageController;
import java.sql.SQLException;
import java.util.Enumeration;

public class RemoteJobSchedulingWizard
extends JSBaseWizard {
    private RemoteJobSchedulingSO _rjsSO;
    private RJSTracer _tracer = null;

    public RemoteJobSchedulingWizard(RemoteJobSchedulingSO remoteJobSchedulingSO, ASEBaseContainer2 aSEBaseContainer2) {
        super(remoteJobSchedulingSO, aSEBaseContainer2, ASEUtils.getString("MSG_ADD_SCHEDULED_JOB"));
        this.setWizardType(5);
        this._rjsSO = remoteJobSchedulingSO;
        if (remoteJobSchedulingSO.getSQL() == null || remoteJobSchedulingSO.getSQL().equals("")) {
            this.startLogging();
        }
    }

    public String retrieveSQL() {
        String string = "";
        if (this._tracer != null) {
            string = this._tracer.getSQL();
        }
        return string;
    }

    private boolean startLogging() {
        this._tracer = new RJSTracer(this._rjsSO.getConnection());
        this._rjsSO.getConnection().addSQLSchedulingListener(this._tracer);
        return true;
    }

    public void removeListeners() {
        if (this._rjsSO.getConnection().hasSQLSchedulingListeners()) {
            Enumeration enumeration = this._rjsSO.getConnection().getSQLSchedulingListeners();
            while (enumeration.hasMoreElements()) {
                ((SQLListener)enumeration.nextElement()).stopTracing();
            }
        }
    }

    public boolean hasSQL() {
        return this._rjsSO.hasSQL();
    }

    @Override
    public boolean cancel() {
        this.removeListeners();
        Support.setEnableScheduling(false);
        super.cancel();
        return true;
    }

    public boolean getStatus() {
        return false;
    }

    @Override
    public SCPageController[] getPages() {
        return JSWizBOPages.getRemoteSchedulingPages(this, this.getWizParent(), false);
    }

    @Override
    public boolean deploy() {
        JSBaseInterface jSBaseInterface;
        try {
            jSBaseInterface = ((RemoteJobSchedulingSO)this.getSO()).getScheduledJobSO();
            ((ScheduledJobSO)jSBaseInterface).create();
        }
        catch (SQLException sQLException) {
            System.out.println("error creating scheduled job from remote js");
        }
        jSBaseInterface = ((RJSScheduledJobsBO)this.getParent()).getLocalJSFolder();
        if (jSBaseInterface != null) {
            try {
                if (((ScheduledJobsCtrBO)jSBaseInterface).isSchedulerInstalled()) {
                    ((ASEBaseContainer2)((Object)jSBaseInterface)).refresh();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public JSBaseSO getSO(String string) {
        RemoteJobSchedulingSO remoteJobSchedulingSO = (RemoteJobSchedulingSO)this.getSO();
        ScheduledJobSO scheduledJobSO = remoteJobSchedulingSO.getScheduledJobSO();
        if (string.equals("job")) {
            return scheduledJobSO.getJobSO();
        }
        if (string.equals("sched")) {
            return scheduledJobSO.getScheduleSO();
        }
        if (string.equals("sj")) {
            return scheduledJobSO;
        }
        return remoteJobSchedulingSO;
    }

    @Override
    public String getJSServerName() {
        return this._rjsSO.getScheduledJobSO().getConnection().getServerName();
    }

    public void setJobCmd(String string) {
        this._rjsSO.setSQL(string);
    }

    @Override
    public String getSummaryString() {
        JobSchedulerSummaryWizBOPage jobSchedulerSummaryWizBOPage = new JobSchedulerSummaryWizBOPage(this);
        jobSchedulerSummaryWizBOPage.onSetActive();
        return jobSchedulerSummaryWizBOPage.getSummary();
    }
}

