/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.UserBO;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.go.wiz.RestoreDataWizGOCopyPage;
import com.sybase.aseplugin.go.wiz.RestoreDataWizGODBPage;
import com.sybase.aseplugin.go.wiz.RestoreDataWizGOOptionsPage;
import com.sybase.aseplugin.go.wiz.RestoreDataWizGOPartitionsPage;
import com.sybase.aseplugin.go.wiz.RestoreDataWizGOPreviewPage;
import com.sybase.aseplugin.go.wiz.RestoreDataWizGOSinglePartitionPage;
import com.sybase.aseplugin.go.wiz.RestoreDataWizGOTablePage;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.PartitionSO;
import com.sybase.aseplugin.so.PartitionsCtrSO;
import com.sybase.aseplugin.so.RestoreDataSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.sql.SQLListener;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RestoreDataWizard
extends ASEBaseWizardDialog2 {
    private RestoreDataSO _dataSO;
    private boolean _isForPartition;

    public RestoreDataWizard(TableSO tableSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)tableSO, sCContainer2, ASEUtils.getString("MSG_RESTORE_TABLE_DATA"));
        this._dataSO = new RestoreDataSO(tableSO);
    }

    public RestoreDataWizard(PartitionSO partitionSO, SCContainer2 sCContainer2) {
        super((SOItemInterface)partitionSO, sCContainer2, ASEUtils.getString("MSG_RESTORE_PT_DATA"));
        this._dataSO = new RestoreDataSO(partitionSO);
        this._isForPartition = true;
    }

    @Override
    public SCPageController[] getPages() {
        Vector<ASEBaseWizardPage2> vector = new Vector<ASEBaseWizardPage2>();
        SCPageController[] sCPageControllerArray = new SCPageController[1];
        vector.add(new RestoreWizDBNamePage(this));
        vector.add(new RestoreWizTablePage(this));
        if (!this._isForPartition) {
            vector.add(new RestoreWizOptionsPage(this));
        }
        if (this._isForPartition) {
            vector.add(new RestoreWizSinglePartitionPage(this));
        } else {
            vector.add(new RestoreWizPartitionsPage(this));
        }
        if (!this._isForPartition) {
            vector.add(new RestoreWizPreviewPage(this));
        }
        vector.add(new RestoreWizCopyPage(this));
        return vector.toArray(sCPageControllerArray);
    }

    @Override
    public void releaseResources() {
        this._dataSO = null;
        super.releaseResources();
    }

    @Override
    public boolean deploy() {
        return true;
    }

    private TableSO getSourceTable() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this._dataSO.getConnection());
        DatabaseBO databaseBO = ContainerViewBO.getDatabaseBO(serverBO, this._dataSO.getSourceDB());
        TableBO tableBO = ContainerViewBO.getTableBO(databaseBO, this._dataSO.getSourceOwner(), this._dataSO.getSourceTable());
        return (TableSO)tableBO.getSO();
    }

    class RestoreWizCopyPage
    extends ASEBaseWizardPage2 {
        public RestoreDataWizGOCopyPage _go;

        public RestoreWizCopyPage(RestoreDataWizard restoreDataWizard2) {
            super(restoreDataWizard2, (JPanel)((Object)new RestoreDataWizGOCopyPage()), ASEUtils.getString("RESTORE_TABLE_WIZ_COPY_PAGE_TITLE"));
            this._go = (RestoreDataWizGOCopyPage)((Object)this.getJPanel());
            this._go.setDisplayPreviewButton(false);
            this._go.setDisplayScheduleButton(false);
        }

        @Override
        public void enableComponents() {
            block5: {
                this._go.tableNameLabel.setText(RestoreDataWizard.this._dataSO.getTargetTable().getName());
                this.enableFinishButton(true);
                SQLListener sQLListener = this.getConnection().getSQLListener();
                try {
                    if (RestoreDataWizard.this._isForPartition) {
                        this.getConnection().setSQLListener(null);
                    }
                    String string = RestoreDataWizard.this._dataSO.getSourceRows();
                    this._go.rowText.setText(string);
                    if (RestoreDataWizard.this._isForPartition) {
                        RestoreDataWizard.this._dataSO.getConnection().setSQLListener((Object)sQLListener);
                    }
                    if (string.equals("0")) {
                        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_NO_ROWS"));
                        Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                        this.enableFinishButton(false);
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                    if (!RestoreDataWizard.this._isForPartition) break block5;
                    RestoreDataWizard.this._dataSO.getConnection().setSQLListener((Object)sQLListener);
                }
            }
        }

        @Override
        public boolean onWizardFinish() {
            SCDialogSupport sCDialogSupport = this.getDialogSupport();
            JButton jButton = sCDialogSupport.getStandardButtonById(2);
            jButton.setText(ASEUtils.getString("MENU_CLOSE"));
            this._go.statusTextArea.setText(ASEUtils.getString("RESTORE_TABLE_WIZ_COPY_PAGE_INIT_STATUS"));
            SQLListener sQLListener = RestoreDataWizard.this._dataSO.getConnection().getSQLListener();
            RestoreDataWizard.this._dataSO.getConnection().setSQLListener(null);
            try {
                RestoreDataWizard.this._dataSO.copyData();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                this._go.statusTextArea.append("\n\n");
                this._go.statusTextArea.append(ASEUtils.getString("RESTORE_TABLE_WIZ_COPY_PAGE_FAIL_STATUS"));
                this._go.statusTextArea.append("\n\n");
                this._go.statusTextArea.append(sQLException.toString());
                RestoreDataWizard.this._dataSO.getConnection().setSQLListener((Object)sQLListener);
                return false;
            }
            this.enableFinishButton(false);
            this.enableNextButton(false);
            this._go.finishLabel.setVisible(false);
            RestoreDataWizard.this._dataSO.getConnection().setSQLListener((Object)sQLListener);
            this._go.statusTextArea.append("\n\n");
            this._go.statusTextArea.append(ASEUtils.getString("RESTORE_TABLE_WIZ_COPY_PAGE_FINAL_STATUS"));
            return false;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class RestoreWizPreviewPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        public RestoreDataWizGOPreviewPage _go;

        public RestoreWizPreviewPage(RestoreDataWizard restoreDataWizard2) {
            super(restoreDataWizard2, (JPanel)((Object)new RestoreDataWizGOPreviewPage()), ASEUtils.getString("RESTORE_TABLE_WIZ_PREVIEW_PAGE_TITLE"));
            this._go = (RestoreDataWizGOPreviewPage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            this._go.dbisqlButton.addActionListener((ActionListener)this);
        }

        @Override
        public void enableComponents() {
            if (RestoreDataWizard.this._dataSO.getExecutionSQL() != null) {
                this._go.sqlEditor.setText(RestoreDataWizard.this._dataSO.getExecutionSQL());
            } else {
                this._go.sqlEditor.setText(RestoreDataWizard.this._dataSO.getPreviewSQL());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Support.getProvider().openDBISQL(Support.getViewerFrame(), this.getConnection(), RestoreDataWizard.this._dataSO.getSourceDB(), RestoreDataWizard.this._dataSO.getSourceSQL(), true);
        }

        @Override
        public int onWizardNext() {
            RestoreDataWizard.this._dataSO.setExecutionSQL(this._go.sqlEditor.getText());
            return 6;
        }

        @Override
        public void releaseResources() {
            this._go.dbisqlButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class RestoreWizPartitionsPage
    extends ASEBaseWizardPage2
    implements ActionListener,
    ASAListCheckListener {
        public RestoreDataWizGOPartitionsPage _go;

        public RestoreWizPartitionsPage(RestoreDataWizard restoreDataWizard2) {
            super(restoreDataWizard2, (JPanel)((Object)new RestoreDataWizGOPartitionsPage()), ASEUtils.getString("RESTORE_TABLE_WIZ_PARTITION_PAGE_TITLE"));
            this._go = (RestoreDataWizGOPartitionsPage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            this._go.selectAllButton.addActionListener((ActionListener)this);
            this._go.clearAllButton.addActionListener((ActionListener)this);
            this._go.partitionList.addListCheckListener((ASAListCheckListener)this);
        }

        @Override
        public void enableComponents() {
            TableSO tableSO = RestoreDataWizard.this.getSourceTable();
            this._go.partitionList.clear();
            try {
                this._go.strategyTextLabel.setText(tableSO.getPartitionStrategy());
                this._go.keyTextLabel.setText(tableSO.getPartitionKey());
                PartitionsCtrSO partitionsCtrSO = new PartitionsCtrSO(RestoreDataWizard.this._dataSO.getConnection(), tableSO);
                List list = partitionsCtrSO.open(1);
                for (PartitionSO partitionSO : list) {
                    this._go.partitionList.addRow(false, new Object[]{partitionSO.getName(), partitionSO.getPartitionCondition()});
                }
                this._go.partitionList.checkAllRows();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.selectAllButton) {
                this._go.partitionList.checkAllRows();
            } else {
                this._go.partitionList.uncheckAllRows();
            }
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            if (this._go.partitionList.getCheckedRowCount() > 0) {
                this.enableNextButton(true);
                return;
            }
            this.enableNextButton(false);
        }

        @Override
        public int onWizardNext() {
            if (this._go.partitionList.getRowCount() != this._go.partitionList.getCheckedRowCount()) {
                int[] nArray = this._go.partitionList.getCheckedRows();
                StringBuffer stringBuffer = new StringBuffer();
                String string = RestoreDataWizard.this._dataSO.getPreviewSQL();
                RestoreDataWizard.this._dataSO.clearPartitions();
                for (int i = 0; i < nArray.length; ++i) {
                    String string2 = this._go.partitionList.getStringAt(nArray[i], 0);
                    RestoreDataWizard.this._dataSO.addPartition(string2);
                    stringBuffer.append(string).append(" ( ").append("partition ").append(string2).append(" )").append("\n");
                }
                RestoreDataWizard.this._dataSO.setExecutionSQL(stringBuffer.toString());
            } else {
                RestoreDataWizard.this._dataSO.setExecutionSQL(RestoreDataWizard.this._dataSO.getPreviewSQL());
            }
            return 6;
        }

        @Override
        public void releaseResources() {
            this._go.selectAllButton.removeActionListener((ActionListener)this);
            this._go.clearAllButton.removeActionListener((ActionListener)this);
            this._go.partitionList.removeListCheckListener((ASAListCheckListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class RestoreWizSinglePartitionPage
    extends ASEBaseWizardPage2
    implements ListSelectionListener {
        public RestoreDataWizGOSinglePartitionPage _go;

        public RestoreWizSinglePartitionPage(RestoreDataWizard restoreDataWizard2) {
            super(restoreDataWizard2, (JPanel)((Object)new RestoreDataWizGOSinglePartitionPage()), ASEUtils.getString("RESTORE_TABLE_WIZ_PARTITION_PAGE_TITLE"));
            this._go = (RestoreDataWizGOSinglePartitionPage)((Object)this.getJPanel());
            this.initListeners();
        }

        public void initListeners() {
            this._go.partitionList.addListSelectionListener((ListSelectionListener)this);
        }

        @Override
        public void enableComponents() {
            this.enableNextButton(false);
            this._go.partitionList.clear();
            try {
                TableSO tableSO = RestoreDataWizard.this.getSourceTable();
                this._go.strategyTextLabel.setText(tableSO.getPartitionStrategy());
                this._go.keyTextLabel.setText(tableSO.getPartitionKey());
                PartitionsCtrSO partitionsCtrSO = new PartitionsCtrSO(RestoreDataWizard.this._dataSO.getConnection(), tableSO);
                List list = partitionsCtrSO.open(1);
                this._go.partitionList.clear();
                String string = RestoreDataWizard.this._dataSO.getTargetPartition().getPartitionCondition();
                for (PartitionSO partitionSO : list) {
                    this._go.partitionList.addRow(new Object[]{partitionSO.getName(), partitionSO.getPartitionCondition()});
                    if (!string.equals(partitionSO.getPartitionCondition())) continue;
                    this._go.partitionList.selectRow(this._go.partitionList.getRowCount() - 1);
                    this.enableNextButton(true);
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this._go.partitionList.getSelectedRowCount() > 0) {
                this.enableNextButton(true);
                return;
            }
            this.enableNextButton(false);
        }

        @Override
        public int onWizardNext() {
            try {
                if (RestoreDataWizard.this.getSourceTable().getPartitionColumns().length != RestoreDataWizard.this._dataSO.getTargetTable().getPartitionColumns().length) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_PT_COLUMNS_MISMATCH"));
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                    return -1;
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string = RestoreDataWizard.this._dataSO.getPreviewSQL();
            RestoreDataWizard.this._dataSO.clearPartitions();
            int n = this._go.partitionList.getSelectedRow();
            String string2 = this._go.partitionList.getStringAt(n, 0);
            RestoreDataWizard.this._dataSO.addPartition(string2);
            stringBuffer.append(string).append(" ( ").append("partition ").append(string2).append(" )");
            RestoreDataWizard.this._dataSO.setExecutionSQL(stringBuffer.toString());
            return 4;
        }

        @Override
        public void releaseResources() {
            this._go.partitionList.removeListSelectionListener((ListSelectionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class RestoreWizOptionsPage
    extends ASEBaseWizardPage2 {
        public RestoreDataWizGOOptionsPage _go;

        public RestoreWizOptionsPage(RestoreDataWizard restoreDataWizard2) {
            super(restoreDataWizard2, (JPanel)((Object)new RestoreDataWizGOOptionsPage()), ASEUtils.getString("RESTORE_TABLE_WIZ_OPTIONS_PAGE_TITLE"));
            this._go = (RestoreDataWizGOOptionsPage)((Object)this.getJPanel());
        }

        @Override
        public void enableComponents() {
            this._go.tableButton.setSelected(true);
        }

        @Override
        public int onWizardNext() {
            if (this._go.tableButton.isSelected()) {
                return 5;
            }
            return 4;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class RestoreWizTablePage
    extends ASEBaseWizardPage2
    implements ActionListener,
    DocumentListener {
        private RestoreDataWizGOTablePage _go;

        public RestoreWizTablePage(RestoreDataWizard restoreDataWizard2) {
            super(restoreDataWizard2, (JPanel)((Object)new RestoreDataWizGOTablePage()), ASEUtils.getString("RESTORE_TABLE_WIZ_TABLE_PAGE_TITLE"));
            this._go = (RestoreDataWizGOTablePage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            this.initListeners();
        }

        private void initListeners() {
            this._go.tableSelectButton.addActionListener((ActionListener)this);
            this._go.tableNameButton.addActionListener((ActionListener)this);
            this._go.tableNameButton.setSelected(true);
            this._go.tableTextField.getDocument().addDocumentListener(this);
            this._go.tableComboBox.setEnabled(false);
        }

        @Override
        public void enableComponents() {
            this.enablePageComponents();
            try {
                RestoreDataWizard.this._dataSO.useDB(RestoreDataWizard.this._dataSO.getSourceDB());
                List list = RestoreDataWizard.this._dataSO.getUsers();
                Iterator iterator = list.iterator();
                this._go.ownerComboBox.clear();
                while (iterator.hasNext()) {
                    ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)UserBO.USER_ICON, (String)iterator.next());
                    this._go.ownerComboBox.addItem((Object)aSAIconTextData);
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                this.enableNextButton(false);
            }
            if (RestoreDataWizard.this._dataSO.getSourceOwner() != null) {
                this._go.ownerComboBox.setSelectedItem(RestoreDataWizard.this._dataSO.getSourceOwner());
            } else {
                this._go.ownerComboBox.setSelectedItem(RestoreDataWizard.this._dataSO.getTargetTable().getOwner());
            }
            if (this._go.tableNameButton.isSelected() && this._go.tableTextField.getText().equals("")) {
                this._go.tableTextField.setText(RestoreDataWizard.this._dataSO.getTargetTable().getName());
            }
            if (this._go.tableSelectButton.isSelected()) {
                this.loadTables();
            }
        }

        private void enablePageComponents() {
            if (this._go.tableNameButton.isSelected()) {
                if (this._go.tableTextField.getText().length() > 0) {
                    this.enableNextButton(true);
                } else {
                    this.enableNextButton(false);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enablePageComponents();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enablePageComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enablePageComponents();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this._go.tableNameButton.isSelected();
            this._go.tableTextField.setEnabled(bl);
            this._go.tableComboBox.setEnabled(!bl);
            this.enableNextButton(bl && this._go.tableTextField.getText().length() > 0);
            if (!bl) {
                this.loadTables();
            }
        }

        private void loadTables() {
            try {
                List list = RestoreDataWizard.this._dataSO.getTables(this._go.ownerComboBox.getSelectedString());
                Iterator iterator = list.iterator();
                this._go.tableComboBox.clear();
                while (iterator.hasNext()) {
                    ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)TableBO.TABLE_ICON, (String)iterator.next());
                    this._go.tableComboBox.addItem((Object)aSAIconTextData);
                }
                if (RestoreDataWizard.this._dataSO.getSourceTable() != null) {
                    this._go.tableComboBox.setSelectedItem(RestoreDataWizard.this._dataSO.getSourceTable());
                }
                this.enableNextButton(true);
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
        }

        @Override
        public int onWizardNext() {
            ASEMessageText aSEMessageText;
            int n;
            RestoreDataWizard.this._dataSO.setSourceOwner(this._go.ownerComboBox.getSelectedString());
            boolean bl = this._go.tableNameButton.isSelected();
            RestoreDataWizard.this._dataSO.setSourceTable(bl ? this._go.tableTextField.getText() : this._go.tableComboBox.getSelectedString());
            if (bl) {
                if (this._go.tableTextField.getText().indexOf(".") != -1) {
                    ASEMessageText aSEMessageText2 = new ASEMessageText(ASEUtils.getString("MSG_TABLE_NAME_NOT_VALID"));
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText2.toString());
                    return -1;
                }
                n = 1;
                try {
                    n = RestoreDataWizard.this._dataSO.isSourceTableValid();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (n == 0) {
                    ASEMessageText aSEMessageText3 = new ASEMessageText(ASEUtils.getString("MSG_TABLES_NOT_VALID"), RestoreDataWizard.this._dataSO.getSourceOwner(), RestoreDataWizard.this._dataSO.getSourceTable(), RestoreDataWizard.this._dataSO.getSourceDB());
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText3.toString());
                    return -1;
                }
            }
            if (RestoreDataWizard.this._dataSO.areSourceAndTargetTableSame()) {
                ASEMessageText aSEMessageText4 = new ASEMessageText(ASEUtils.getString("MSG_SOURCE_AND_TARGET_TABLE_SAME"));
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText4.toString());
                return -1;
            }
            n = 0;
            try {
                n = RestoreDataWizard.this._dataSO.compareTablesColumns(RestoreDataWizard.this.getSourceTable());
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
            }
            if (n == 1) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_TABLES_COLUMNS_NUMBER_MISMATCH"));
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return -1;
            }
            if (n == 2) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_TABLES_COLUMNS_TYPE_MISMATCH"));
                Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return -1;
            }
            if (RestoreDataWizard.this._isForPartition) {
                try {
                    if (!RestoreDataWizard.this.getSourceTable().getPartitionStrategy().equals(RestoreDataWizard.this._dataSO.getTargetTable().getPartitionStrategy())) {
                        aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_TABLES_STRATEGY_MISMATCH"));
                        Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                        return -1;
                    }
                }
                catch (SQLException sQLException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.toString(), sQLException);
                }
                return 3;
            }
            try {
                if (RestoreDataWizard.this._dataSO.getConnection().isPartitionsApplicable() && (RestoreDataWizard.this.getSourceTable().getPartitionStrategy().equals("range") || RestoreDataWizard.this.getSourceTable().getPartitionStrategy().equals("list"))) {
                    return 3;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return 5;
        }

        @Override
        public void releaseResources() {
            this._go.tableSelectButton.removeActionListener((ActionListener)this);
            this._go.tableNameButton.removeActionListener((ActionListener)this);
            this._go.tableTextField.getDocument().removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class RestoreWizDBNamePage
    extends ASEBaseWizardPage2 {
        private RestoreDataWizGODBPage _go;
        private boolean _isValidUser;

        public RestoreWizDBNamePage(RestoreDataWizard restoreDataWizard2) {
            super(restoreDataWizard2, (JPanel)((Object)new RestoreDataWizGODBPage(RestoreDataWizard.this._isForPartition)), ASEUtils.getString("RESTORE_TABLE_WIZ_WELCOME_PAGE_TITLE"));
            this._isValidUser = true;
            this._go = (RestoreDataWizGODBPage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            this._go.dbComboBox.clear();
            List list = RestoreDataWizard.this._dataSO.getAvailableDatabases();
            for (DatabaseSO databaseSO : list) {
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)DatabaseBO.getIcon(databaseSO), databaseSO.getName());
                this._go.dbComboBox.addItem((Object)aSAIconTextData);
            }
            this._go.dbComboBox.setSelectedIndex(0);
        }

        @Override
        public void enableComponents() {
            if (this._go.dbComboBox.getItemCount() == 0) {
                this.enableNextButton(false);
            }
        }

        @Override
        public boolean deploy() {
            String string = ((ASAIconTextData)this._go.dbComboBox.getSelectedItem()).toString();
            RestoreDataWizard.this._dataSO.setSourceDB(string);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

