/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAComboBox;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithSkipCancel;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOClusterNamePage;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.util.ds.uaf.DiscoverySetting;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

class SDCClusterWizBOClusterNamePage
extends ASEBaseWizDocPage
implements ActionListener {
    protected SDCClusterWizGOClusterNamePage _nameGO = (SDCClusterWizGOClusterNamePage)((Object)this.getJPanel());
    private boolean clusterNameValidated = false;
    private boolean doneDiscoveryHost = false;

    public SDCClusterWizBOClusterNamePage(ASEBaseWizardDialog2 aSEBaseWizardDialog2) {
        super(aSEBaseWizardDialog2, (JPanel)((Object)new SDCClusterWizGOClusterNamePage()), ASEUtils.getString("SDC_CLUSTER_WIZ_NAME"));
        this._nameGO.setDisplayScheduleButton(false);
        this._nameGO.setDisplayPreviewButton(false);
    }

    public SDCClusterWizBOClusterNamePage(ASEBaseWizardDialog2 aSEBaseWizardDialog2, String string, Image image) {
        super(aSEBaseWizardDialog2, (JPanel)((Object)new SDCClusterWizGOClusterNamePage()), string);
        this._nameGO.setImage(image);
        this._nameGO.setDisplayScheduleButton(false);
        this._nameGO.setDisplayPreviewButton(false);
    }

    @Override
    public void init() throws SQLException {
        this.enableComponents();
        this._nameGO.addListeners(this);
    }

    @Override
    public boolean onSetActive() {
        String string = ((SDCClusterSO)this.getSO()).getClusterName();
        if (string != null && string.length() > 0) {
            this._nameGO.nameTextField.setEnabled(false);
        }
        return super.onSetActive();
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        Document document;
        Document document2 = documentEvent.getDocument();
        if (document2 == (document = this._nameGO.getNameDocument())) {
            this.enableComponents();
            this.clusterNameValidated = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ASAComboBox) {
            this.enableComponents();
        }
    }

    @Override
    public void enableComponents() {
        boolean bl = this._nameGO.getName().length() > 0;
        this.enableNextButton(bl);
    }

    @Override
    public void releaseResources() {
        this._nameGO.removeListeners(this);
        this._nameGO.releaseResources();
        this._nameGO = null;
        super.releaseResources();
    }

    @Override
    public int onWizardNext() {
        Object object;
        Object object2;
        String string = this._nameGO.getName();
        if (!this.clusterNameValidated && this._nameGO.nameTextField.isEnabled()) {
            if (!SDCClusterSO.validateIdentifier(string)) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_NAME"), string);
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return -1;
            }
            if (string.equalsIgnoreCase("cluster")) {
                String string2 = ASEUtils.getString("SDC_ERROR_CLUSTER_NAME_CANNOT_BE_RESERVED_WORD");
                Support.showError(null, this.getClass(), this.getJDialog(), string2.toString());
                return -1;
            }
            class CheckClusterNameExistsTask
            implements Runnable {
                private boolean clusterExists = false;
                private String clusterName;
                private HashSet hosts = new HashSet();

                public CheckClusterNameExistsTask(String string) {
                    this.clusterName = string;
                }

                public boolean clusterExists() {
                    return this.clusterExists;
                }

                public HashSet getHosts() {
                    return this.hosts;
                }

                @Override
                public void run() {
                    this.clusterExists = SDCClusterAgentUtils.clusterExists(this.clusterName, this.hosts);
                }
            }
            object2 = new CheckClusterNameExistsTask(string);
            object = new WorkingDialogWithSkipCancel((Dialog)this.getJDialog(), (Runnable)object2, ASEUtils.getString("SDC_TITLE_VALIDATE_CLUSTER_NAME"), ASEUtils.getString("SDC_MSG_VALIDATE_CLUSTER_NAME"));
            ((Window)object).dispose();
            if (((WorkingDialogWithSkipCancel)object).isCancelled()) {
                object2 = null;
                return -1;
            }
            if (((WorkingDialogWithSkipCancel)object).isSkipped()) {
                object2 = null;
            } else {
                if (((CheckClusterNameExistsTask)object2).clusterExists()) {
                    HashSet hashSet = ((CheckClusterNameExistsTask)object2).getHosts();
                    String string3 = Utility.stringArrayToString(hashSet.toArray(), true);
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_CLUSTER_NAME_EXISTS"), string, string3);
                    String string4 = aSEMessageText.toString();
                    Support.showError(null, this.getClass(), this.getJDialog(), string4);
                    this._nameGO.nameTextField.requestFocus();
                    this._nameGO.nameTextField.selectAll();
                    return -1;
                }
                this.clusterNameValidated = true;
            }
        }
        if (!this.doneDiscoveryHost) {
            object2 = (SDCClusterWizard)this.getParent();
            object = new Runnable((SDCClusterWizard)object2){
                final /* synthetic */ SDCClusterWizard val$wiz;
                {
                    this.val$wiz = sDCClusterWizard;
                }

                @Override
                public void run() {
                    Support.getTopBO().initServerDiscovery(false);
                    List list = DiscoverySetting.getDiscoverySettings();
                    this.val$wiz.discoverAgents(list);
                }
            };
            WorkingDialogWithSkipCancel workingDialogWithSkipCancel = new WorkingDialogWithSkipCancel((Dialog)this.getJDialog(), (Runnable)object, ASEUtils.getString("SDC_TITLE_DISCOVERING_AGENTS"), ASEUtils.getString("SDC_MSG_DISCOVERING_AGENTS"));
            workingDialogWithSkipCancel.dispose();
            if (workingDialogWithSkipCancel.isCancelled()) {
                object = null;
                return -1;
            }
            if (workingDialogWithSkipCancel.isSkipped()) {
                object = null;
            } else {
                this.doneDiscoveryHost = true;
            }
        }
        if (((SDCClusterSO)(object2 = (SDCClusterSO)this.getSO())).getCluster() == null) {
            ((ASEBaseSO)object2).setName(string);
            ((SDCClusterSO)object2).setCluster(ClusterConfigFactory.createCluster((String)string));
        }
        try {
            ((SDCClusterSO)object2).setClusterPlatform(this._nameGO.getPlatform());
            ((SDCClusterSO)object2).setClusterOS(this._nameGO.getOSName());
        }
        catch (ClusterConfigException clusterConfigException) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(clusterConfigException.getMessage());
        }
        object = "shared";
        if (this._nameGO.installationLocalRadioBtn.isSelected()) {
            object = "private";
        }
        ((SDCClusterSO)object2).getCluster().setInstallationMode((String)object);
        int n = this._nameGO.getMaxInstances();
        ((SDCClusterSO)object2).getCluster().setMaxInstances(new Integer(n));
        return super.onWizardNext();
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }
}

