/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOGlobalSettingsPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.DeviceValidator;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.JMXException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

class SDCClusterWizBOGlobalEnvironmentPage
extends ASEBaseWizDocPage
implements ItemListener,
ActionListener {
    protected SDCClusterWizGOGlobalSettingsPage _go = (SDCClusterWizGOGlobalSettingsPage)((Object)this.getJPanel());
    private List sybaseHomeList;
    private SDCClusterAgentProxy agentProxy = null;
    private int wizardFlag;
    private static final int ON_ERR_EXIT = 999;
    private int MAX_CFG_FILE_LENGTH = 256;
    private String _currSybaseHome;
    private boolean doneDeployPlugin = false;

    public SDCClusterWizBOGlobalEnvironmentPage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOGlobalSettingsPage()), ASEUtils.getString("SDC_CLUSTER_WIZ_ENVIRONMENT"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
        this.wizardFlag = sDCClusterWizard.wizardFlag;
        this._go.sybaseHomeTextField.getDocument().addDocumentListener(this);
        this._go.aseHomeTextField.getDocument().addDocumentListener(this);
        this._go.interfaceTextField.getDocument().addDocumentListener(this);
        this._go.configTextField.getDocument().addDocumentListener(this);
        this._go.envScriptTextField.getDocument().addDocumentListener(this);
        this._go.sybaseHomeComboBox.addItemListener((ItemListener)this);
    }

    @Override
    public void init() {
        this._go.showMultiPlatformControls(false);
    }

    @Override
    public void releaseResources() {
        this._go.sybaseHomeTextField.getDocument().removeDocumentListener(this);
        this._go.aseHomeTextField.getDocument().removeDocumentListener(this);
        this._go.interfaceTextField.getDocument().removeDocumentListener(this);
        this._go.configTextField.getDocument().removeDocumentListener(this);
        this._go.envScriptTextField.getDocument().removeDocumentListener(this);
        this._go.sybaseHomeComboBox.removeItemListener((ItemListener)this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public void enableComponents() {
        this.enableNextButton(this.getSybaseHome().length() > 0 && this._go.getASEHome().length() > 0 && this._go.getInterfacesDir().length() > 0 && this._go.getClusterConfigFile().length() > 0 && this._go.getEnvironmentFile().length() > 0);
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        this.enableComponents();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._go.isSybaseHomeCombo(itemEvent.getSource())) {
            this.onSybaseHomeChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._go.isSybaseHomeCombo(actionEvent.getSource())) {
            this.onSybaseHomeChanged();
        }
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onSetActive() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        sDCClusterAgentProxy = this.getSelectedAgent();
        if (this.isNewProxySelected(sDCClusterAgentProxy)) {
            this.agentProxy = sDCClusterAgentProxy;
            this.loadSybaseHome(this.agentProxy);
            this._go.setStartParameters(this.agentProxy.getStartParameters());
            this._go.setTraceFlags(this.agentProxy.getTraceFlags());
        }
        return super.onSetActive();
    }

    private boolean isNewProxySelected(SDCClusterAgentProxy sDCClusterAgentProxy) {
        boolean bl = false;
        if (this.agentProxy == null) {
            bl = true;
        } else if (!this.agentProxy.getAgentUrl().equals(sDCClusterAgentProxy.getAgentUrl())) {
            bl = true;
        }
        return bl;
    }

    private void loadSybaseHome(SDCClusterAgentProxy sDCClusterAgentProxy) {
        Support.getViewerSupport().startWait();
        try {
            if (sDCClusterAgentProxy == null) {
                return;
            }
            this.sybaseHomeList = sDCClusterAgentProxy.getSybaseHomeList();
        }
        catch (JMXException jMXException) {
            Support.getViewerSupport().endWait();
            SDCClusterWizard.handleJMXException(jMXException, sDCClusterAgentProxy, this.getClass(), this.getJDialog());
            return;
        }
        catch (Exception exception) {
            Support.getViewerSupport().endWait();
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_GET_AGENT_PROPERTY"), "sybaseHomeList", exception.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return;
        }
        if (this.sybaseHomeList == null || this.sybaseHomeList.isEmpty()) {
            try {
                String string = sDCClusterAgentProxy.discoverySybaseHome();
                if (string != null && !string.trim().equals("")) {
                    this.sybaseHomeList.add(string);
                }
            }
            catch (Exception exception) {
                Support.getViewerSupport().endWait();
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), exception.getMessage());
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return;
            }
        }
        Support.getViewerSupport().endWait();
        this._go.loadSybaseHomeCombo(this.sybaseHomeList);
        this._currSybaseHome = this.getSybaseHome();
    }

    private String getSybaseHome() {
        String string = this._go.sybaseHomeComboBox.getSelectedString();
        return string == null ? "" : string.trim();
    }

    private void onSybaseHomeChanged() {
        String string = this.getSybaseHome();
        if (string.length() == 0) {
            return;
        }
        if (string.equals(this._currSybaseHome)) {
            return;
        }
        this._currSybaseHome = string;
        if (!this.validateSybaseHome((SDCClusterSO)this.getSO(), string)) {
            return;
        }
        Support.getViewerSupport().startWait();
        String string2 = null;
        boolean bl = true;
        try {
            string2 = this.agentProxy.getASEHome(string);
            bl = false;
        }
        catch (JMXException jMXException) {
            Support.getViewerSupport().endWait();
            SDCClusterWizard.handleJMXException(jMXException, this.agentProxy, this.getClass(), this.getJDialog());
        }
        catch (Exception exception) {
            Support.getViewerSupport().endWait();
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_RETRIEVE_ENV_VAR"), "SYBASE_ASE", exception.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        if (bl) {
            this._go.sybaseHomeComboBox.getEditor().selectAll();
            this._go.sybaseHomeComboBox.requestFocus();
            return;
        }
        Support.getViewerSupport().endWait();
        this._go.setASEHome(string2);
        this._go.setInterfacesDir(string);
        this._go.setClusterConfigFile(string + this.agentProxy.getServerFileSeparator() + ((SDCClusterSO)this.getSO()).getCluster().getName() + ".cfg");
        this._go.setEnvironmentFile(string + this.agentProxy.getServerFileSeparator() + "SYBASE.sh");
    }

    public String formatTraceFlags(String string) {
        String string2 = string;
        if (string != null && string.trim().length() > 0) {
            if ((string = string.trim()).indexOf(",,") > -1) {
                Pattern pattern = Pattern.compile(",,+");
                Matcher matcher = pattern.matcher(string);
                string2 = matcher.replaceAll(",");
            }
            if (string2.startsWith(",")) {
                string2 = string2.replaceFirst(",", "");
            }
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    @Override
    public int onWizardNext() {
        SDCClusterAgentProxy[] sDCClusterAgentProxyArray;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        String string = this.getSybaseHome();
        String string2 = this._go.getASEHome();
        String string3 = this._go.getInterfacesDir();
        String string4 = this._go.getClusterConfigFile();
        String string5 = this._go.getEnvironmentFile();
        String string6 = this._go.getStartParameters();
        String string7 = this.formatTraceFlags(this._go.getTraceFlags());
        this._go.setTraceFlags(string7);
        if (!this.validateSybaseHome(sDCClusterSO, string)) {
            return -1;
        }
        Support.getViewerSupport().startWait();
        boolean bl = true;
        try {
            this.agentProxy.getASEHome(string);
            bl = false;
        }
        catch (JMXException jMXException) {
            Support.getViewerSupport().endWait();
            SDCClusterWizard.handleJMXException(jMXException, this.agentProxy, this.getClass(), this.getJDialog());
        }
        catch (Exception exception) {
            Support.getViewerSupport().endWait();
            sDCClusterAgentProxyArray = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_RETRIEVE_ENV_VAR"), "SYBASE_ASE", exception.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), sDCClusterAgentProxyArray.toString());
        }
        if (bl) {
            this._go.sybaseHomeComboBox.getEditor().selectAll();
            this._go.sybaseHomeComboBox.requestFocus();
            return -1;
        }
        Support.getViewerSupport().endWait();
        boolean bl2 = false;
        try {
            bl2 = !sDCClusterSO.isLocalInstallation() ? this.validateAndSaveSettingsSharingSamePath(sDCClusterSO, string, string2, string3, string4, string5, string6, string7) : true;
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), exception.toString());
        }
        if (!bl2) {
            return -1;
        }
        sDCClusterAgentProxyArray = sDCClusterSO.getParticipatingAgentsAsArray();
        try {
            if (!sDCClusterSO.isLocalInstallation()) {
                SDCClusterWizard sDCClusterWizard = (SDCClusterWizard)this.getParent();
                ICluster iCluster = sDCClusterSO.getCluster();
                if (sDCClusterWizard.wizardFlag != 1) {
                    iCluster.setSybaseHome(string);
                    iCluster.setAseHome(string2);
                    iCluster.setInterfacesPath(string3);
                    iCluster.setConfigFile(string4);
                    iCluster.setAddlRunParameters(string6);
                    iCluster.setTraceflags(string7);
                }
                if (!sDCClusterWizard.prepareClusterAgentPlugins()) {
                    return -1;
                }
                sDCClusterWizard.checkVCSStatus();
                sDCClusterWizard.checkLDAPStatus();
            }
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), exception.toString());
        }
        return super.onWizardNext();
    }

    private boolean validateAndSaveSettingsSharingSamePath(SDCClusterSO sDCClusterSO, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        boolean bl = false;
        Set set = sDCClusterSO.getParticipatingAgents().entrySet();
        for (Map.Entry entry : set) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            bl = this.validateAndSaveSettings(sDCClusterAgentProxy, string, string2, string3, string4, string5, string6, string7);
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean validateAndSaveSettingsNotSharingSamePath(SDCClusterSO sDCClusterSO, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (this.agentProxy == null) {
            return false;
        }
        boolean bl = this.validateAndSaveSettings(this.agentProxy, string, string2, string3, string4, string5, string6, string7);
        if (!bl) {
            return false;
        }
        String string8 = this.agentProxy.getNodeName();
        Set set = sDCClusterSO.getParticipatingAgents().entrySet();
        for (Map.Entry entry : set) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            String string9 = sDCClusterAgentProxy.getNodeName();
            if (string9.equals(string8)) continue;
            if (sDCClusterAgentProxy.getSybaseHome() == null || sDCClusterAgentProxy.getSybaseHome().trim().equals("")) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FIELD_NOT_SET"), ASEUtils.getString("LABC_SYBASE_HOME"), string9);
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            if (sDCClusterAgentProxy.getAseHome() == null || sDCClusterAgentProxy.getAseHome().trim().equals("")) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FIELD_NOT_SET"), ASEUtils.getString("LABC_ASE_HOME"), string9);
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            if (sDCClusterAgentProxy.getInterfacesFileHome() == null || sDCClusterAgentProxy.getInterfacesFileHome().trim().equals("")) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FIELD_NOT_SET"), ASEUtils.getString("LABC_INTERFACE_DIR"), string9);
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            if (sDCClusterAgentProxy.getClusterConfigFile() == null || sDCClusterAgentProxy.getClusterConfigFile().trim().equals("")) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FIELD_NOT_SET"), ASEUtils.getString("LABC_CLUSTER_CONFIG_FILE"), string9);
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            if (sDCClusterAgentProxy.getEnvironmentScript() != null && !sDCClusterAgentProxy.getEnvironmentScript().trim().equals("")) continue;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FIELD_NOT_SET"), ASEUtils.getString("LABC_ENV_SCRIPT"), string9);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        return true;
    }

    private boolean validateSybaseHome(SDCClusterSO sDCClusterSO, String string) {
        try {
            if (sDCClusterSO.isLocalInstallation()) {
                return true;
            }
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), exception.toString());
        }
        boolean bl = false;
        Set set = sDCClusterSO.getParticipatingAgents().entrySet();
        for (Map.Entry entry : set) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            bl = this.validateSybaseHome(sDCClusterAgentProxy, string);
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean validateSybaseHome(SDCClusterAgentProxy sDCClusterAgentProxy, String string) {
        String string2 = SDCClusterAgentUtils.getNodeAddress(sDCClusterAgentProxy.getHost(), sDCClusterAgentProxy.getPort());
        int n = 0;
        boolean bl = false;
        n = this.validateDirectory(string, string2, sDCClusterAgentProxy);
        if (n == 999) {
            bl = true;
        } else if (n != 4) {
            this.displayError(n, string, string2);
            bl = true;
        }
        if (bl) {
            this._go.sybaseHomeComboBox.getEditor().selectAll();
            this._go.sybaseHomeComboBox.requestFocus();
            return false;
        }
        return true;
    }

    private int validateDirectory(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateDirectoryPath(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private int validateFileReadable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateFileReadable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private boolean validateAndSaveSettings(SDCClusterAgentProxy sDCClusterAgentProxy, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ASEMessageText aSEMessageText;
        String string8 = SDCClusterAgentUtils.getNodeAddress(sDCClusterAgentProxy.getHost(), sDCClusterAgentProxy.getPort());
        int n = 0;
        boolean bl = false;
        n = this.isAbsolutePath(string, string8, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string, string8);
            bl = true;
        }
        if (!bl && (n = this.validateFileDirectory(string, string8, sDCClusterAgentProxy)) == 999) {
            bl = true;
        }
        if (n == 201) {
            if (!bl && (n = this.isDevicePathReadable(string, string8, sDCClusterAgentProxy)) != 2) {
                this.displayError(n, string, string8);
                bl = true;
            }
            if (!bl && (n = this.isDevicePathWritable(string, string8, sDCClusterAgentProxy)) != 3) {
                this.displayError(n, string, string8);
                bl = true;
            }
        } else if (!bl) {
            this.displayError(n, string, string8);
            bl = true;
        }
        if (bl) {
            this._go.sybaseHomeComboBox.getEditor().selectAll();
            this._go.sybaseHomeComboBox.requestFocus();
            return false;
        }
        n = this.isAbsolutePath(string2, string8, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string2, string8);
            bl = true;
        }
        if (!bl && (n = this.validateFileDirectory(string2, string8, sDCClusterAgentProxy)) == 999) {
            bl = true;
        }
        if (n == 201) {
            if (!bl && (n = this.isDevicePathReadable(string2, string8, sDCClusterAgentProxy)) != 2) {
                this.displayError(n, string2, string8);
                bl = true;
            }
            if (!bl && (n = this.isDevicePathWritable(string2, string8, sDCClusterAgentProxy)) != 3) {
                this.displayError(n, string2, string8);
                bl = true;
            }
        } else if (!bl) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DIRECTORY_IS_FILE"), string2, string8);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            bl = true;
        }
        if (bl) {
            this._go.aseHomeTextField.selectAll();
            this._go.aseHomeTextField.requestFocus();
            return false;
        }
        n = this.isAbsolutePath(string3, string8, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string3, string8);
            bl = true;
        }
        if (!bl && (n = this.validateFileDirectory(string3, string8, sDCClusterAgentProxy)) == 999) {
            bl = true;
        }
        if (n == 201) {
            if (!bl && (n = this.isDevicePathReadable(string3, string8, sDCClusterAgentProxy)) != 2) {
                this.displayError(n, string3, string8);
                bl = true;
            }
            if (!bl && (n = this.isDevicePathWritable(string3, string8, sDCClusterAgentProxy)) != 3) {
                this.displayError(n, string3, string8);
                bl = true;
            }
        } else if (!bl) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DIRECTORY_IS_FILE"), string3, string8);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            bl = true;
        }
        if (bl) {
            this._go.interfaceTextField.selectAll();
            this._go.interfaceTextField.requestFocus();
            return false;
        }
        n = this.isAbsolutePath(string4, string8, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string4, string8);
            bl = true;
        }
        if (!bl && (n = this.validateFileDirectory(string4, string8, sDCClusterAgentProxy)) == 999) {
            bl = true;
        }
        if (!bl && string4.trim().length() >= this.MAX_CFG_FILE_LENGTH) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_CONFIG_FILE_LENGTH"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            bl = true;
        }
        if (n == 200) {
            if (this.wizardFlag == 1) {
                if (!bl && (n = this.isDevicePathReadable(string4, string8, sDCClusterAgentProxy)) != 2) {
                    this.displayError(n, string4, string8);
                    bl = true;
                }
                if (!bl && (n = this.isDevicePathWritable(string4, string8, sDCClusterAgentProxy)) != 3) {
                    this.displayError(n, string4, string8);
                    bl = true;
                }
            } else if (!bl) {
                this.displayError(n, string4, string8);
                this._go.setFocusOnConfig("end", false);
                bl = true;
            }
        } else if (!bl && n != 0) {
            this.displayError(n, string4, string8);
            bl = true;
        }
        if (bl) {
            this._go.configTextField.selectAll();
            this._go.configTextField.requestFocus();
            return false;
        }
        n = this.validateFileReadable(string5, string8, sDCClusterAgentProxy);
        if (n != 2) {
            if (n != 999) {
                this.displayError(n, string5, string8);
            }
            bl = true;
        }
        if (bl) {
            this._go.envScriptTextField.selectAll();
            this._go.envScriptTextField.requestFocus();
            return false;
        }
        this.updateAgentProxySettings(sDCClusterAgentProxy, string, string2, string3, string4, string5, string6, string7);
        return true;
    }

    public int validatePath(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = -1;
        try {
            n = DeviceValidator.validateDevicePath(sDCClusterAgentProxy, string);
            if (n == 201 || n == 1) {
                n = -1;
            }
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    public int validateFile(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = -1;
        try {
            n = DeviceValidator.validateDevicePath(sDCClusterAgentProxy, string);
            if (n == 0 || n == 1) {
                n = -1;
            }
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    public int isDevicePathReadable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 102;
        try {
            n = DeviceValidator.isDevicePathReadable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    public int isDevicePathWritable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 103;
        try {
            n = DeviceValidator.isDevicePathWritable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    public int isAbsolutePath(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        try {
            String string3 = DeviceValidator.getAbsolutePath(sDCClusterAgentProxy, string);
            if (string3.equals(string)) {
                return 0;
            }
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return 204;
    }

    private int validateFileDirectory(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateDevicePath(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    public void displayError(int n, String string, String string2) {
        ASEMessageText aSEMessageText = null;
        switch (n) {
            case 203: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_WRITABLE"), string, string2);
                break;
            }
            case 209: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_READABLE"), string, string2);
                break;
            }
            case 202: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_EXIST"), string, string2);
                break;
            }
            case 200: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_ALREADY_EXISTS"), string, string2);
                break;
            }
            case 201: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_IS_DIRECTORY"), string, string2);
                break;
            }
            case 100: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_READABLE"), string, string2);
                break;
            }
            case 101: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_WRITABLE"), string, string2);
                break;
            }
            case 104: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_EXIST"), string, string2);
                break;
            }
            case 102: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_READABLE"), string, string2);
                break;
            }
            case 103: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_WRITABLE"), string, string2);
                break;
            }
            case 204: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_INVALID_ABSOLUTE_PATH"), string, string2);
                break;
            }
            case 205: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DIRECTORY_NOT_EXIST"), string, string2);
                break;
            }
            case 206: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_IS_NOT_DIRECTORY"), string, string2);
                break;
            }
            case 210: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_IS_NOT_FILE"), string, string2);
                break;
            }
            case 207: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_READABLE"), string, string2);
                break;
            }
            case 208: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_WRITABLE"), string, string2);
                break;
            }
            default: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_UNKNOWN"), string);
            }
        }
        Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
    }

    private void updateAgentProxySettings(SDCClusterAgentProxy sDCClusterAgentProxy, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        sDCClusterAgentProxy.setSybaseHome(string);
        sDCClusterAgentProxy.setAseHome(string2);
        sDCClusterAgentProxy.setInterfacesFileHome(string3);
        sDCClusterAgentProxy.setClusterConfigFile(string4);
        sDCClusterAgentProxy.setEnvironmentScript(string5);
        sDCClusterAgentProxy.setStartParameters(string6);
        sDCClusterAgentProxy.setTraceFlags(string7);
        try {
            if (!sDCClusterAgentProxy.getSybaseHomeList().contains(string)) {
                sDCClusterAgentProxy.addSybaseHome(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean validateTraceFlags(String string) {
        boolean bl = true;
        if (string != null && string.trim().length() > 0) {
            if ((string = string.trim()).startsWith(",") || string.endsWith(",") || string.indexOf(",,") > -1) {
                return false;
            }
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    int n = Integer.parseInt(stringArray[i]);
                    if (n <= Integer.MAX_VALUE) continue;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return bl;
    }

    private SDCClusterAgentProxy getSelectedAgent() {
        Map.Entry entry;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        Object var3_3 = null;
        Iterator iterator = sDCClusterSO.getParticipatingAgents().entrySet().iterator();
        if (iterator.hasNext() && (sDCClusterAgentProxy = (SDCClusterAgentProxy)(entry = iterator.next()).getValue()) == null) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_NODE_NOT_FOUND"), (Object)var3_3);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return sDCClusterAgentProxy;
        }
        return sDCClusterAgentProxy;
    }
}

