/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithSkipCancel;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.bo.wiz.SDCInstanceWizard;
import com.sybase.aseplugin.go.wiz.ASEIntroWizGOPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.util.ds.uaf.DiscoverySetting;
import java.awt.Dialog;
import java.util.List;
import javax.swing.JPanel;

class SDCClusterWizBOIntroPage
extends ASEBaseWizardPage2 {
    private ASEIntroWizGOPage _go = (ASEIntroWizGOPage)((Object)this.getJPanel());
    private boolean doneDiscoveryHost = false;

    public SDCClusterWizBOIntroPage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new ASEIntroWizGOPage(ASEImages.getUtilityWizardImage(), ASEUtils.getString("SDC_INSTANCE_WIZ_INTRO_WELCOME"), "")), ASEUtils.getString("WIZ_INTRO_PAGE_TITLE"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
    }

    @Override
    public void init() {
        Integer n = this.getMaxInstances();
        Integer n2 = this.getCurrentInstances();
        String string = "";
        if (n != null && n2 != null) {
            string = new ASEMessageText(ASEUtils.getString("SDC_INSTANCE_WIZ_INTRO_TEXT"), n, n2).toString();
            if (this.isMaxInstancesExceeded()) {
                string = string + "\n\n" + ASEUtils.getString("SDC_INSTANCE_WIZ_MAX_INSTANCE_EXCEEDED");
            }
        } else {
            string = ASEUtils.getString("SDC_INSTANCE_ERROR_CLUSTER_XML");
        }
        this._go.introTextMultiLineLabel.setText(string);
        IServer iServer = this.getAnyServerInstance();
        if (iServer == null) {
            this.enableNextButton(false);
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), ASEUtils.getString("ERR_AUXILIARY_SERVER_CHECK_UAF"));
        } else {
            String string2 = iServer.getPublicAddress();
            ((SDCClusterSO)this.getSO()).setIsPrivateNetwork(string2 == null || string2.length() == 0);
            this.enableComponents();
        }
    }

    @Override
    public void releaseResources() {
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public void enableComponents() {
        this.enableNextButton(!this.isMaxInstancesExceeded());
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public int onWizardNext() {
        if (!this.doneDiscoveryHost) {
            final SDCClusterWizard sDCClusterWizard = (SDCClusterWizard)this.getParent();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Support.getTopBO().initServerDiscovery(false);
                    List list = DiscoverySetting.getDiscoverySettings();
                    sDCClusterWizard.discoverAgents(list);
                }
            };
            WorkingDialogWithSkipCancel workingDialogWithSkipCancel = new WorkingDialogWithSkipCancel((Dialog)this.getJDialog(), runnable, ASEUtils.getString("SDC_TITLE_DISCOVERING_AGENTS"), ASEUtils.getString("SDC_MSG_DISCOVERING_AGENTS"));
            workingDialogWithSkipCancel.dispose();
            if (workingDialogWithSkipCancel.isCancelled()) {
                runnable = null;
                return -1;
            }
            if (workingDialogWithSkipCancel.isSkipped()) {
                runnable = null;
            } else {
                this.doneDiscoveryHost = true;
            }
        }
        return super.onWizardNext();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    public boolean isMaxInstancesExceeded() {
        SDCInstanceWizard sDCInstanceWizard = (SDCInstanceWizard)this.getParent();
        return sDCInstanceWizard.getAvailableInstanceNumber() <= 0;
    }

    public Integer getMaxInstances() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        if (iCluster == null) {
            return null;
        }
        Integer n = iCluster.getMaxInstances();
        return n;
    }

    public Integer getCurrentInstances() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        if (iCluster == null) {
            return null;
        }
        int n = iCluster.getServersArray().length;
        return new Integer(n);
    }

    public IServer getAnyServerInstance() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        if (iCluster == null) {
            return null;
        }
        IServer[] iServerArray = iCluster.getServersArray();
        if (iServerArray != null) {
            return iServerArray[0];
        }
        return null;
    }
}

