/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOMasterDevicePage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCDefaultsInterface;
import com.sybase.aseplugin.util.DBSizeUtil;
import com.sybase.aseplugin.util.DeviceValidator;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentConnectionException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

class SDCClusterWizBOMasterDevicePage
extends ASEBaseWizDocPage
implements SDCDefaultsInterface,
ItemListener {
    protected SDCClusterWizGOMasterDevicePage _go = (SDCClusterWizGOMasterDevicePage)((Object)this.getJPanel());
    int _pageSize = 2;

    public SDCClusterWizBOMasterDevicePage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOMasterDevicePage()), ASEUtils.getString("SDC_CLUSTER_WIZ_MASTER_DEVICE"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
        this._go.pathTextField.getDocument().addDocumentListener(this);
    }

    public void addListeners(Object object) {
        if (object instanceof ItemListener) {
            this._go.pageSizeComboBox.addItemListener((ItemListener)object);
        }
    }

    public void removeListeners(Object object) {
        if (object instanceof ItemListener) {
            this._go.pageSizeComboBox.removeItemListener((ItemListener)object);
        }
    }

    public int getMasterDBMinSize() {
        return 13 * this._pageSize * 1024 / 2048;
    }

    public int getMasterDBDefaultSize() {
        return 13 * this._pageSize * 1024 / 2048;
    }

    public int getMasterDevMinSize(int n) {
        return n + DBSizeUtil.getAdditionalDevSizeForMasterIntMB(this._pageSize);
    }

    public int getMasterDevDefaultSize() {
        return 30 * this._pageSize * 1024 / 2048;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this._go.pageSizeComboBox) {
            int n = this.getMasterDBDefaultSize();
            int n2 = this.getMasterDevDefaultSize();
            String string = (String)this._go.pageSizeComboBox.getSelectedItem();
            String string2 = string.substring(0, string.length() - 1);
            try {
                this._pageSize = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                this._pageSize = 2;
            }
            if (this._go.deviceSizeTextField.getValue() == n2) {
                this._go.deviceSizeTextField.setValue(this.getMasterDevDefaultSize());
            }
            if (this._go.databaseSizeTextField.getValue() == n) {
                this._go.databaseSizeTextField.setValue(this.getMasterDBDefaultSize());
            }
        }
    }

    @Override
    public void enableComponents() {
        this.enableNextButton(this._go.pathTextField.getText().trim().length() > 0 && this._go.deviceSizeTextField.getValue() > 0 && this._go.databaseSizeTextField.getValue() > 0);
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        this.enableComponents();
    }

    @Override
    public void init() {
        this.removeListeners(this);
        this._go.deviceSizeTextField.setMinimum(1);
        this._go.deviceSizeTextField.setValue(30);
        this._go.databaseSizeTextField.setMinimum(1);
        this._go.databaseSizeTextField.setValue(13);
        this.addListeners(this);
    }

    public void initVCSLabel() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        this._go.noteVCSLabel.setVisible(sDCClusterSO.isVCSMode());
        SDCClusterWizard sDCClusterWizard = (SDCClusterWizard)this.getParent();
    }

    @Override
    public boolean onSetActive() {
        this.initVCSLabel();
        this._go.pathTextField.requestFocus();
        this._go.pathTextField.selectAll();
        return super.onSetActive();
    }

    @Override
    public void releaseResources() {
        this._go.pathTextField.getDocument().removeDocumentListener(this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public int onWizardNext() {
        boolean bl;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        int n = this._go.deviceSizeTextField.getValue();
        String string = this._go.deviceUnitComboBox.getSelectedString();
        int n2 = this._go.databaseSizeTextField.getValue();
        String string2 = this._go.databaseUnitComboBox.getSelectedString();
        int n3 = DBSizeUtil.toIntMB(n, string);
        int n4 = DBSizeUtil.toIntMB(n2, string2);
        int n5 = this.getMasterDBMinSize();
        int n6 = this.getMasterDevMinSize(n4);
        if (n3 <= 0) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_INVALID_DEVICE_SIZE"));
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        if (n4 <= 0) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_INVALID_DB_SIZE"));
            this._go.databaseSizeTextField.requestFocus();
            return -1;
        }
        if (n4 < n5) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_MASTER_DATABASE_SIZE_MIN"), n5, new Integer(this._pageSize));
            ((SDCClusterWizard)this.getParent()).showErrorDialog(aSEMessageText.toString());
            this._go.databaseSizeTextField.requestFocus();
            return -1;
        }
        if (n3 < n6) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_MASTER_DEVICE_SIZE_TOO_SMALL"), n6, new Integer(this._pageSize));
            ((SDCClusterWizard)this.getParent()).showErrorDialog(aSEMessageText.toString());
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        String string3 = this._go.pathTextField.getText().trim();
        String string4 = new File(string3).getParent();
        if (string4 != null) {
            string4 = string4.replace('\\', '/');
            this.mkdirs(sDCClusterSO, string4);
        }
        if (!(bl = this.validateDevicePath(string3))) {
            return -1;
        }
        String string5 = null;
        try {
            string5 = DBSizeUtil.toString(n, string);
        }
        catch (Exception exception) {
            Support.addLogEntry(0, null, this.getClass(), exception.getMessage(), exception.toString());
            ((SDCClusterWizard)this.getParent()).showErrorDialog(exception.getMessage());
            return -1;
        }
        int n7 = 0;
        n7 = !sDCClusterSO.isVCSMode() ? ((SDCClusterWizard)this.getParent()).getUsrConfirmForIOFencing(string3, true) : ((SDCClusterWizard)this.getParent()).getUsrConfirmForVCS(string3, true);
        if (n7 != 0) {
            this._go.pathTextField.selectAll();
            this._go.pathTextField.requestFocus();
            return -1;
        }
        DatabaseDeviceSO databaseDeviceSO = new DatabaseDeviceSO(null, "master");
        databaseDeviceSO.setMirrorPath(string3);
        databaseDeviceSO.setDatabaseDeviceSize(string5);
        sDCClusterSO.addDevice(databaseDeviceSO);
        iCluster.setMasterDevice(string3);
        iCluster.setMasterDeviceSize(new Integer(n3).toString());
        iCluster.setMasterDatabaseSize(new Integer(n4).toString());
        iCluster.setPageSize(Integer.toString(this._pageSize));
        return 0;
    }

    public boolean mkdirs(SDCClusterSO sDCClusterSO, String string) {
        for (Map.Entry entry : sDCClusterSO.getParticipatingAgents().entrySet()) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            try {
                return DeviceValidator.mkdirs(sDCClusterAgentProxy, string);
            }
            catch (AgentConnectionException agentConnectionException) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            }
        }
        return false;
    }

    private boolean validateDevicePath(String string) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        if (sDCClusterSO.getCluster().getQuorum().equals(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DUPLICATE"), string, ASEUtils.getString("LABC_SDC_QUORUM_DEVICE1"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        return DeviceValidator.validateDevicePathOnAllNodes(string, sDCClusterSO, this.getClass(), this.getJDialog());
    }
}

