/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOPCIDevicePage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCDefaultsInterface;
import com.sybase.aseplugin.util.DBSizeUtil;
import com.sybase.aseplugin.util.DeviceValidator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

class SDCClusterWizBOPCIDevicePage
extends ASEBaseWizDocPage
implements ActionListener,
SDCDefaultsInterface {
    private SDCClusterWizGOPCIDevicePage _go = (SDCClusterWizGOPCIDevicePage)((Object)this.getJPanel());
    int _pageSize = 2;

    public SDCClusterWizBOPCIDevicePage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOPCIDevicePage()), ASEUtils.getString("SDC_CLUSTER_WIZ_PCI_DEVICE"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
        this._go.pathTextField.getDocument().addDocumentListener(this);
        this._go.pciCheckBox.addActionListener((ActionListener)this);
        this._go.setPCIDeviceEnable(false);
    }

    public int getPCIDBMinSize() {
        return 12 * this._pageSize;
    }

    public int getPCIDBDefaultSize() {
        return 12 * this._pageSize;
    }

    public int getPCIDBDefaultSizeForPageSize(int n) {
        return 12 * n;
    }

    public int getPCIDevMinSize() {
        return 12 * this._pageSize;
    }

    public int getPCIDevDefaultSize() {
        return 12 * this._pageSize;
    }

    public int getPCIDevDefaultSizeForPageSize(int n) {
        return 12 * n;
    }

    @Override
    public void enableComponents() {
        this._go.setPCIDeviceEnable(this._go.pciCheckBox.isSelected());
        if (this._go.pciCheckBox.isSelected()) {
            this.enableNextButton(this._go.pathTextField.getText().trim().length() > 0 && this._go.deviceSizeTextField.getValue() > 0 && this._go.databaseSizeTextField.getValue() > 0);
        } else {
            this.enableNextButton(true);
        }
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        this.enableComponents();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void init() {
        this._go.deviceSizeTextField.setMinimum(1);
        this._go.databaseSizeTextField.setMinimum(1);
    }

    @Override
    public boolean onSetActive() {
        this._go.pciCheckBox.requestFocus();
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        int n = this._pageSize;
        this._pageSize = sDCClusterSO.getClusterPageSize();
        int n2 = this.getPCIDBDefaultSize();
        int n3 = this.getPCIDevDefaultSize();
        try {
            int n4 = this._go.databaseSizeTextField.getValue();
            int n5 = this._go.deviceSizeTextField.getValue();
            if (n4 == 1 || n4 == this.getPCIDBDefaultSizeForPageSize(n) || n4 == this.getPCIDBDefaultSizeForPageSize(this._pageSize)) {
                this._go.databaseSizeTextField.setValue(n2);
            }
            if (n5 == 1 || n5 == this.getPCIDevDefaultSizeForPageSize(n) || n5 == this.getPCIDevDefaultSizeForPageSize(this._pageSize)) {
                this._go.deviceSizeTextField.setValue(n3);
            }
        }
        catch (Exception exception) {
            this._go.databaseSizeTextField.setValue(n2);
            this._go.deviceSizeTextField.setValue(n3);
        }
        return super.onSetActive();
    }

    @Override
    public void releaseResources() {
        this._go.pathTextField.getDocument().removeDocumentListener(this);
        this._go.pciCheckBox.removeActionListener((ActionListener)this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public int onWizardNext() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        String string = this._go.pathTextField.getText().trim();
        int n = this._go.deviceSizeTextField.getValue();
        String string2 = this._go.deviceUnitComboBox.getSelectedString();
        int n2 = this._go.databaseSizeTextField.getValue();
        String string3 = this._go.databaseUnitComboBox.getSelectedString();
        if (!this._go.pciCheckBox.isSelected()) {
            sDCClusterSO.getCluster().setPCIDevice(null);
            sDCClusterSO.getCluster().setPCIDeviceSize(null);
            sDCClusterSO.getCluster().setPCIDatabaseSize(null);
            sDCClusterSO.removeDevice("pci");
            return 0;
        }
        String string4 = null;
        try {
            string4 = DBSizeUtil.toString(n, string2);
        }
        catch (Exception exception) {
            Support.addLogEntry(0, null, this.getClass(), exception.getMessage(), exception.toString());
            ((SDCClusterWizard)this.getParent()).showErrorDialog(exception.getMessage());
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        int n3 = DBSizeUtil.toIntMB(n, string2);
        int n4 = DBSizeUtil.toIntMB(n2, string3);
        if (n3 <= 0) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_INVALID_DEVICE_SIZE"));
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        if (n4 <= 0) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_INVALID_DB_SIZE"));
            this._go.databaseSizeTextField.requestFocus();
            return -1;
        }
        int n5 = this.getPCIDBMinSize();
        int n6 = this.getPCIDBMinSize();
        if (n4 < n5) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_PCI_DATABASE_SIZE_MIN"), n5, new Integer(this._pageSize));
            ((SDCClusterWizard)this.getParent()).showErrorDialog(aSEMessageText.toString());
            this._go.databaseSizeTextField.requestFocus();
            return -1;
        }
        if (n3 < n6) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_PCI_DATABASE_DEVICE_SIZE_MIN"), n6, new Integer(this._pageSize));
            ((SDCClusterWizard)this.getParent()).showErrorDialog(aSEMessageText.toString());
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        if (n3 < n4) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_DEVICE_SIZE_LESS_THAN_DATABASE_SIZE"));
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        boolean bl = this.validateDevicePath(string);
        if (!bl) {
            return -1;
        }
        int n7 = 0;
        n7 = !sDCClusterSO.isVCSMode() ? ((SDCClusterWizard)this.getParent()).getUsrConfirmForIOFencing(string, true) : ((SDCClusterWizard)this.getParent()).getUsrConfirmForVCS(string, true);
        if (n7 != 0) {
            this._go.pathTextField.selectAll();
            this._go.pathTextField.requestFocus();
            return -1;
        }
        if (this._go.pciCheckBox.isSelected()) {
            sDCClusterSO.getCluster().setPCIDevice(string);
            sDCClusterSO.getCluster().setPCIDeviceSize(new Integer(n3).toString());
            sDCClusterSO.getCluster().setPCIDatabaseSize(new Integer(n4).toString());
        }
        DatabaseDeviceSO databaseDeviceSO = new DatabaseDeviceSO(null, "pci");
        databaseDeviceSO.setMirrorPath(string);
        databaseDeviceSO.setDatabaseDeviceSize(string4);
        sDCClusterSO.addDevice(databaseDeviceSO);
        return 0;
    }

    private boolean validateDevicePath(String string) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)((SDCClusterWizard)this.getParent()).getSO();
        if (sDCClusterSO.getCluster().getQuorum().equals(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DUPLICATE"), string, ASEUtils.getString("LABC_SDC_QUORUM_DEVICE1"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (sDCClusterSO.getCluster().getMasterDevice().equals(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DUPLICATE"), string, ASEUtils.getString("LABC_MASTER_DEVICE1"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (sDCClusterSO.getCluster().getSystemProcedureDevice().equals(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DUPLICATE"), string, ASEUtils.getString("LABC_SYSTEM_PROCS_DEVICE1"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (sDCClusterSO.getCluster().getSystemDevice().equals(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DUPLICATE"), string, ASEUtils.getString("LABC_SYSTEM_DB_DEVICE1"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        return DeviceValidator.validateDevicePathOnAllNodes(string, sDCClusterSO, this.getClass(), this.getJDialog());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.enableComponents();
    }
}

