/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOProtocolPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCDefaultsInterface;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;

class SDCClusterWizBOProtocolPage
extends ASEBaseWizDocPage
implements SDCDefaultsInterface,
ActionListener,
ChangeListener {
    protected SDCClusterWizGOProtocolPage _go = (SDCClusterWizGOProtocolPage)((Object)this.getJPanel());
    private boolean isPortValidated = false;
    int portsRequired;

    public SDCClusterWizBOProtocolPage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOProtocolPage()), ASEUtils.getString("CLUSTER_WIZ_NETWORK_PROTOCOL"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
    }

    @Override
    public void init() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        this._go.startingPortSpinBox.setValue(sDCClusterSO.getStartingPort());
        this._go.addListeners(this);
    }

    @Override
    public boolean onSetActive() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        this._go.toggleNetworkControls(sDCClusterSO.getNumberOfInstances() == 0);
        this.portsRequired = this.getPortsRequired();
        int n = 65535 - this.portsRequired + 1;
        this._go.startingPortSpinBox.setMaximum(n);
        return super.onSetActive();
    }

    @Override
    public void releaseResources() {
        this._go.removeListenters(this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void enableComponents() {
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.checkPortButton) {
            boolean bl = this.validatePortAvailability();
            if (bl) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORTS_AVAILABLE"));
                Support.getViewerSupport().messageBoxString((Container)this.getJDialog(), aSEMessageText.toString(), 1);
                this.isPortValidated = true;
            }
        } else if (actionEvent.getSource() == this._go.secProtocolCheckBox) {
            this.portsRequired = this.getPortsRequired();
            int n = 65535 - this.portsRequired + 1;
            this._go.startingPortSpinBox.setMaximum(n);
        }
    }

    private boolean validatePortAvailability() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        for (Map.Entry entry : sDCClusterSO.getParticipatingAgents().entrySet()) {
            int n;
            CharSequence charSequence;
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            Integer[] integerArray = new Integer[]{};
            try {
                charSequence = this._go.getProtocol();
                n = this._go.startingPortSpinBox.getValue();
                int n2 = n + this.portsRequired - 1;
                integerArray = ((String)charSequence).equalsIgnoreCase("UDP") ? sDCClusterAgentProxy.getUDPPortsInUse(n, n2) : (((String)charSequence).equalsIgnoreCase(ASEUtils.getString("SDC_CLUSTER_PROTOCOL_TCP")) ? sDCClusterAgentProxy.getTCPPortsInUse(n, n2) : sDCClusterAgentProxy.getPortsInUse(n, n2));
            }
            catch (Exception exception) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_TO_CHECK_PORTS"), exception.getMessage(), sDCClusterAgentProxy.getNodeName());
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            if (integerArray == null || integerArray.length <= 0) continue;
            charSequence = new StringBuffer();
            for (n = 0; n < integerArray.length; ++n) {
                ((StringBuffer)charSequence).append(integerArray[n].toString());
                if (n >= integerArray.length - 1) continue;
                ((StringBuffer)charSequence).append(", ");
            }
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORTS_UNAVAILABLE_CHANGE_STARTING_PORT"), ((StringBuffer)charSequence).toString(), sDCClusterAgentProxy.getNodeName());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        return true;
    }

    public int getPortsRequired() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        int n = PortUtil.getPortsRequiredPerInstancePerInterconnect((ICluster)sDCClusterSO.getCluster());
        n *= sDCClusterSO.getMaxInstances();
        if (this._go.hasSecondaryNetwork()) {
            n *= 2;
        }
        return n;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.isPortValidated = false;
    }

    @Override
    public int onWizardNext() {
        boolean bl;
        if (!this.isPortValidated && !(bl = this.validatePortAvailability())) {
            return -1;
        }
        this.isPortValidated = true;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        String string = this._go.getProtocol();
        int n = this._go.startingPortSpinBox.getValue();
        sDCClusterSO.setStartingPort(n);
        sDCClusterSO.setPrimaryProtocol(string);
        sDCClusterSO.getCluster().setPrimaryInterconnect(string);
        if (this._go.hasSecondaryNetwork()) {
            sDCClusterSO.setSecondaryProtocol(string);
            sDCClusterSO.getCluster().setSecondaryInterconnect(string);
            sDCClusterSO.setHasSecondaryNetwork(true);
        } else {
            sDCClusterSO.setHasSecondaryNetwork(false);
        }
        return 0;
    }
}

