/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOQuorumDiskPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.DeviceValidator;
import com.sybase.ua.AuthorizationException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

class SDCClusterWizBOQuorumPage
extends ASEBaseWizDocPage {
    protected SDCClusterWizGOQuorumDiskPage _go = (SDCClusterWizGOQuorumDiskPage)((Object)this.getJPanel());

    public SDCClusterWizBOQuorumPage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOQuorumDiskPage()), ASEUtils.getString("SDC_CLUSTER_WIZ_QUORUM"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
        this._go.pathTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public void init() {
    }

    @Override
    public boolean onSetActive() {
        return super.onSetActive();
    }

    private void initLDAPWanning(SDCClusterSO sDCClusterSO) {
        ASEMessageText aSEMessageText = null;
        try {
            String string = sDCClusterSO.getLDAPServer();
            if (null != string && string.trim().length() > 0) {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_CLUSTER_VALID_LDAP_DESC"), string);
            } else {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_CLUSTER_INVALID_LDAP_DESC"));
                this._go.noteMultiLineLabel.setVisible(sDCClusterSO.isLocalInstallation());
            }
            this._go.ldapMultiLineLabel.setText(aSEMessageText.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void releaseResources() {
        this._go.pathTextField.getDocument().removeDocumentListener(this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void enableComponents() {
        this.enableNextButton(this._go.pathTextField.getText().trim().length() != 0);
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        this.enableNextButton(this._go.pathTextField.getText().trim().length() != 0);
    }

    @Override
    public int onWizardNext() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        String string = this._go.pathTextField.getText().trim();
        boolean bl = this.validateDevicePath(string);
        if (!bl) {
            return -1;
        }
        sDCClusterSO.getCluster().setQuorum(string);
        SDCClusterWizard sDCClusterWizard = (SDCClusterWizard)this.getParent();
        try {
            if (sDCClusterSO.isLocalInstallation()) {
                if (!sDCClusterWizard.prepareClusterAgentPlugins()) {
                    return -1;
                }
                sDCClusterWizard.checkVCSStatus();
                sDCClusterWizard.checkLDAPStatus();
                return this.getNextPageForLocalInstall();
            }
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), exception.toString());
        }
        return 0;
    }

    int getNextPageForLocalInstall() {
        return SDCClusterWizard.WIZ_MASTER_DEVICE_PAGE_INDEX;
    }

    private boolean validateDevicePath(String string) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        return DeviceValidator.validateDevicePathOnAllNodes(string, sDCClusterSO, this.getClass(), this.getJDialog());
    }
}

