/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.AddAgentDialog;
import com.sybase.aseplugin.bo.dlg.WorkingDialog;
import com.sybase.aseplugin.bo.dlg.WorkingDialogWithCancel;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.bo.wiz.UpgradeWizBOAgentPage;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOSelectAgentsPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.AgentURL;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.util.ds.Settings;
import com.sybase.util.ds.lang.DSResourceBase;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import com.sybase.util.ds.uaf.SyUAFEntry;
import com.sybase.util.ds.ui.SettingsDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;

class SDCClusterWizBOSelectNodesPage
extends ASEBaseWizDocPage
implements ActionListener,
ASAListCheckListener {
    private boolean doneDiscoveryHost = false;
    protected SDCClusterWizGOSelectAgentsPage _go = (SDCClusterWizGOSelectAgentsPage)((Object)this.getJPanel());

    public SDCClusterWizBOSelectNodesPage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOSelectAgentsPage()), ASEUtils.getString("MSG_CREATE_CLUSTER_WIZ_NODE_PAGE"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
    }

    public SDCClusterWizBOSelectNodesPage(SDCClusterWizard sDCClusterWizard, String string, Image image) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOSelectAgentsPage()), string);
        this._go.setImage(image);
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
    }

    @Override
    public void init() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SDCClusterWizBOSelectNodesPage.this._go.setName("uafadmin");
            }
        });
        this._go.addListeners(this);
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void enableComponents() {
        boolean bl = this.rowsSelected();
        this.enableNextButton(this._go.getName().length() > 0 && bl);
        this._go.addAgentButton.setEnabled(this.getCurrSelectedNodeNumber() < this.getMaxSelectedNodeNumber());
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        this.resetValidationFlags((SDCClusterSO)this.getSO());
        this.enableComponents();
    }

    public int getMaxSelectedNodeNumber() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        return sDCClusterSO.getCluster().getMaxInstances();
    }

    public int getCurrSelectedNodeNumber() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        return sDCClusterSO.getParticipatingAgents().size();
    }

    public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        int n = this.getCurrSelectedNodeNumber();
        this._go.agentMultiList.removeListCheckListener((ASAListCheckListener)this);
        int n2 = aSAListCheckEvent.getFirstIndex();
        int n3 = aSAListCheckEvent.getLastIndex();
        for (int i = n2; i <= n3; ++i) {
            Object[] objectArray = this._go.agentMultiList.getRowAsArray(i);
            String string = (String)objectArray[1];
            String string2 = (String)objectArray[2];
            if (this._go.agentMultiList.isRowChecked(i)) {
                try {
                    if (n >= this.getMaxSelectedNodeNumber()) {
                        this.handleUnCheckAgent(string, string2);
                        this._go.agentMultiList.setRowChecked(i, false);
                        this.ShowSelectedNodesExceedInstancesError(n);
                        continue;
                    }
                    sDCClusterSO.addParticipatingAgent(string, string2, this._go.getName(), this._go.getPassword());
                    this.resetValidationFlags((SDCClusterSO)this.getSO());
                }
                catch (Exception exception) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_ADD_AGENT"), string + ":" + string2);
                    Support.showDetailsError(sDCClusterSO.getConnection(), this.getClass(), (Container)this.getJDialog(), aSEMessageText.toString(), exception);
                }
                continue;
            }
            this.handleUnCheckAgent(string, string2);
        }
        this._go.agentMultiList.addListCheckListener((ASAListCheckListener)this);
        this.enableComponents();
    }

    protected boolean handleUnCheckAgent(String string, String string2) {
        boolean bl = false;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        List list = this.getServerByAgent(string, string2);
        if (null != list && list.size() > 0) {
            if (this.getClass().equals(SDCClusterWizBOSelectNodesPage.class)) {
                String string3 = new ASEMessageText(ASEUtils.getString("MSG_REMOVE_SDC_INSTANCE_CONFIRM"), string + ":" + string2).toString();
                bl = Support.showQuestionYesNo(string3) == 1;
            } else if (this.getClass().equals(UpgradeWizBOAgentPage.class)) {
                bl = false;
            }
            if (bl) {
                int n = this.getRowByAgent(string, string2);
                if (n >= 0) {
                    this._go.agentMultiList.setRowChecked(n, true);
                }
            } else {
                sDCClusterSO.removeParticipatingAgent(string, string2);
                try {
                    for (int i = 0; i < list.size(); ++i) {
                        sDCClusterSO.getCluster().dropServer(((IServer)list.get(i)).getName());
                    }
                }
                catch (ClusterConfigException clusterConfigException) {
                    ((SDCClusterWizard)this.getParent()).showErrorDialog(clusterConfigException.getMessage());
                }
            }
        } else {
            sDCClusterSO.removeParticipatingAgent(string, string2);
        }
        return !bl;
    }

    private List getServerByAgent(String string, String string2) {
        Vector<IServer> vector = new Vector<IServer>();
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        IServer[] iServerArray = sDCClusterSO.getCluster().getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            IServer iServer = iServerArray[i];
            if (iServer.getAgentPort() == null || !iServer.getNode().equals(string) || !iServer.getAgentPort().equals(string2)) continue;
            vector.add(iServer);
        }
        return vector;
    }

    protected int getRowByAgent(String string, String string2) {
        for (int i = 0; i < this._go.agentMultiList.getRowCount(); ++i) {
            String string3 = (String)this._go.agentMultiList.getValueAt(i, 1);
            String string4 = (String)this._go.agentMultiList.getValueAt(i, 2);
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    protected Vector getExistAgentList() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this._go.agentMultiList.getRowCount(); ++i) {
            String string = (String)this._go.agentMultiList.getValueAt(i, 1);
            String string2 = (String)this._go.agentMultiList.getValueAt(i, 2);
            vector.add(string + ":" + string2);
        }
        return vector;
    }

    private boolean rowsSelected() {
        boolean bl = false;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        bl = !sDCClusterSO.getParticipatingAgents().isEmpty();
        return bl;
    }

    protected String getUpgradeServer() {
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._go.discoveryButton) {
            boolean bl = Settings.getEnableServerDiscovery();
            Settings.setEnableServerDiscovery((boolean)true);
            SettingsDialog settingsDialog = new SettingsDialog(this.getJDialog());
            settingsDialog.setInitialPage(DSResourceBase.getBundle().get("SERVER_DISCOVERY"));
            settingsDialog.setEnableServerDiscoveryVisible(false);
            List list = settingsDialog.create();
            Settings.setEnableServerDiscovery((boolean)bl);
            boolean bl2 = list.isEmpty();
            if (!bl2) {
                boolean bl3;
                boolean bl4 = bl3 = list.size() > 2 && (Boolean)list.get(0) != false;
                if (!this.doneDiscoveryHost || bl3) {
                    try {
                        this.doneDiscoveryHost = this.discoverHosts();
                        this.onSetActive();
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (actionEvent.getSource() == this._go.addAgentButton) {
            SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
            AddAgentDialog addAgentDialog = AddAgentDialog.showDialog(sDCClusterSO, this.getJDialog(), this.getExistAgentList(), this._go.getName(), this._go.getPassword(), this.getUpgradeServer());
            if (!addAgentDialog.getCloseState()) {
                return;
            }
            if (this.getUpgradeServer().length() > 0) {
                for (int i = 0; i < this._go.agentMultiList.getRowCount(); ++i) {
                    boolean bl = this._go.agentMultiList.isRowChecked(i);
                    if (!bl) continue;
                    this._go.agentMultiList.removeListCheckListener((ASAListCheckListener)this);
                    this._go.agentMultiList.setRowChecked(i, false);
                    this._go.agentMultiList.addListCheckListener((ASAListCheckListener)this);
                }
                sDCClusterSO.removeAllParticipatingAgents();
            }
            SDCClusterAgentProxy sDCClusterAgentProxy = addAgentDialog.getSDCClusterAgentProxy();
            AgentInfo agentInfo = addAgentDialog.getAgentInfo();
            String string = sDCClusterAgentProxy.getHost();
            String string2 = sDCClusterAgentProxy.getPort();
            try {
                SyUAFASEEntry syUAFASEEntry = this.getAgentEntry(agentInfo);
                if (syUAFASEEntry != null) {
                    sDCClusterAgentProxy.setUafEntry((SyUAFEntry)syUAFASEEntry);
                    sDCClusterSO.cacheAgent(sDCClusterAgentProxy);
                    sDCClusterSO.addSpecifiedAgent(SDCClusterSO.getMapKey(string, string2), (SyUAFEntry)syUAFASEEntry);
                    sDCClusterSO.addDiscoveredAgent(string, string2, (SyUAFEntry)syUAFASEEntry);
                    sDCClusterSO.addParticipatingAgent(string, string2, this._go.getName(), this._go.getPassword());
                    this._go.addHost(true, string, string2);
                }
            }
            catch (Exception exception) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_ADD_AGENT"), string + ":" + string2);
                Support.showDetailsError(sDCClusterSO.getConnection(), this.getClass(), (Container)this.getJDialog(), aSEMessageText.toString(), exception);
            }
            this.resetValidationFlags((SDCClusterSO)this.getSO());
            this.enableComponents();
            return;
        }
    }

    private boolean validateAgents(SDCClusterSO sDCClusterSO, String string, String string2) {
        boolean bl = false;
        int n = this._go.agentMultiList.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this._go.agentMultiList.getRowAsArray(i);
            boolean bl2 = this._go.agentMultiList.isRowChecked(i);
            if (bl2 && !(bl = this.validateAgent(sDCClusterSO, (String)objectArray[1], (String)objectArray[2], i, string, string2))) break;
        }
        return bl;
    }

    private SyUAFASEEntry getAgentEntry(AgentInfo agentInfo) {
        SyUAFASEEntry syUAFASEEntry = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = true;
        String string = "com.sybase.ase.cluster";
        ServiceInfo serviceInfo = agentInfo.getServiceInfo("RMIService");
        if (serviceInfo != null && (serviceInfo.getDiscoveryProperty("port") == null || serviceInfo.getDiscoveryProperty("port").equals(""))) {
            bl = false;
        }
        if (bl) {
            if (hashMap.get("host") == null || hashMap.get("host").toString().trim().equals("")) {
                hashMap.put("host", agentInfo.getHost());
            }
            if (hashMap.get("hostPorts") == null || hashMap.get("hostPorts").toString().trim().equals("")) {
                hashMap.put("hostPorts", agentInfo.getHost() + ":" + agentInfo.getRMIPort());
            }
            if (hashMap.get("OSArchitecture") == null || hashMap.get("OSArchitecture").toString().trim().equals("")) {
                hashMap.put("OSArchitecture", agentInfo.getOSArchitecture());
            }
            if (hashMap.get("OSName") == null || hashMap.get("OSName").toString().trim().equals("")) {
                hashMap.put("OSName", agentInfo.getOSName());
            }
            String string2 = "15.0.1";
            int n = 1;
            try {
                List list = agentInfo.getPluginInfosWithLatestVersion(string);
                if (!list.isEmpty()) {
                    PluginInfo pluginInfo = (PluginInfo)list.get(0);
                    string2 = pluginInfo.getVersion();
                    n = pluginInfo.getInstanceNumber();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            syUAFASEEntry = new SyUAFASEEntry(hashMap, string, string2, n, agentInfo);
        }
        return syUAFASEEntry;
    }

    private boolean validateAgent(SDCClusterSO sDCClusterSO, String string, String string2, int n, String string3, String string4) {
        String string5 = string + ":" + string2;
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        try {
            sDCClusterAgentProxy = sDCClusterSO.getAgent(string, string2, string3, string4);
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_CONNECT_AGENT"), string5);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (sDCClusterAgentProxy == null) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_CONNECT_AGENT"), string5);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (sDCClusterAgentProxy.isAlreadyValidated()) {
            return true;
        }
        ValidateAgentTask validateAgentTask = new ValidateAgentTask(sDCClusterSO, sDCClusterAgentProxy, string5);
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)((Object)this._go));
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_VALIDATE_AGENT"), string5);
        WorkingDialog workingDialog = new WorkingDialog((Frame)jFrame, validateAgentTask, ASEUtils.getString("SDC_TITLE_VALIDATE_AGENT"), aSEMessageText.toString());
        workingDialog.dispose();
        if (null != validateAgentTask.getErrorMsg()) {
            Support.showError(null, this.getClass(), this.getJDialog(), validateAgentTask.getErrorMsg());
        }
        return validateAgentTask.isSucceeded();
    }

    protected void resetValidationFlags(SDCClusterSO sDCClusterSO) {
        SDCClusterAgentProxy sDCClusterAgentProxy = null;
        for (Map.Entry entry : sDCClusterSO.getParticipatingAgents().entrySet()) {
            sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            if (sDCClusterAgentProxy == null) continue;
            sDCClusterAgentProxy.setRevalidate();
        }
    }

    @Override
    public boolean onSetActive() {
        JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)this._go));
        jDialog.requestFocusInWindow();
        String string = ((SDCClusterSO)this.getSO()).getClusterPlatform();
        String string2 = ((SDCClusterSO)this.getSO()).getClusterOS();
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_CLUSTER_WIZ_NODE_INTRO"), string, string2);
        this._go.setNodesIntro(aSEMessageText.toString());
        this.refreshNodes();
        this.enableComponents();
        return super.onSetActive();
    }

    private void refreshNodes() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        Map map = sDCClusterSO.getDiscoveredAgents();
        while (this._go.agentMultiList.getRowCount() > 0) {
            this._go.agentMultiList.clear();
        }
        for (Map.Entry entry : map.entrySet()) {
            String string;
            String string2;
            String string3 = (String)entry.getKey();
            SyUAFEntry syUAFEntry = (SyUAFEntry)entry.getValue();
            String string4 = syUAFEntry.getAgentInfo().getVersion();
            if (string4.compareTo("2.5.0") < 0) continue;
            String string5 = syUAFEntry.getAgentInfo().getHost();
            String string6 = "9999";
            try {
                AgentURL agentURL = new AgentURL(syUAFEntry.getAgentURL());
                string6 = agentURL.getPort();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            boolean bl = false;
            try {
                if (sDCClusterSO.getParticipatingAgent(string3) != null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!sDCClusterSO.isMatchingArchitecture(string2 = syUAFEntry.getAgentInfo().getOSArchitecture(), string = syUAFEntry.getAgentInfo().getOSName())) continue;
            this._go.addHost(bl, string5, string6);
        }
        Object object = ASEUtils.getString("SDC_CLUSTER_WIZ_DISCOVERY_DESC");
        if (this._go.agentMultiList.getRowCount() == 0) {
            object = (String)object + " " + ASEUtils.getString("SDC_CLUSTER_WIZ_DISCOVERY_UDP");
        }
        this._go.discoveryMultiLineLabel.setText((String)object);
    }

    @Override
    public void releaseResources() {
        this._go.removeListeners(this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    protected void ShowSelectedNodesExceedInstancesError(int n) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_AGENTS_EXCEED_INSTANCES"), sDCClusterSO.getCluster().getMaxInstances(), n);
        Support.showError(this.getSO().getConnection(), this.getClass(), aSEMessageText.toString());
    }

    @Override
    public int onWizardNext() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        String string = this._go.getName();
        String string2 = this._go.getPassword();
        int n = this.getMaxSelectedNodeNumber();
        if (this.getCurrSelectedNodeNumber() > n) {
            this.ShowSelectedNodesExceedInstancesError(n);
            return -1;
        }
        boolean bl = this.validateAgents(sDCClusterSO, string, string2);
        int n2 = 0;
        if (bl) {
            sDCClusterSO.setAgentUsername(string);
            sDCClusterSO.setAgentPassword(string2);
            n2 = 0;
        } else {
            n2 = -1;
        }
        try {
            if (n2 == 0 && !sDCClusterSO.isLocalInstallation()) {
                bl = this.validateCommonSybaseHome();
                n2 = bl ? 0 : -1;
            }
        }
        catch (AuthorizationException authorizationException) {
            Support.showError(this.getConnection(), this.getClass(), ASEUtils.getString("MSG_NEED_AGENT_AUTHENTICATION"));
        }
        catch (Exception exception) {
            Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), exception.toString());
        }
        return n2;
    }

    private boolean validateCommonSybaseHome() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        List list = null;
        for (Map.Entry entry : sDCClusterSO.getParticipatingAgents().entrySet()) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            try {
                List list2 = sDCClusterAgentProxy.getSybaseHomeList();
                if (list == null) {
                    list = list2;
                    continue;
                }
                list.retainAll(list2);
            }
            catch (AgentConnectionException agentConnectionException) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_GET_AGENT_PROPERTY"), "sybaseHomeList", agentConnectionException.getMessage());
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
        }
        if (list.isEmpty()) {
            Support.showError(null, this.getClass(), this.getJDialog(), ASEUtils.getString("SDC_ERROR_DIFFERENT_SYBASE_HOME"));
            return false;
        }
        return true;
    }

    public boolean discoverHosts() {
        final SDCClusterWizard sDCClusterWizard = (SDCClusterWizard)this.getParent();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Support.getTopBO().initServerDiscovery(false);
                List list = DiscoverySetting.getDiscoverySettings();
                sDCClusterWizard.discoverAgents(list);
            }
        };
        WorkingDialogWithCancel workingDialogWithCancel = new WorkingDialogWithCancel((Dialog)this.getJDialog(), runnable, ASEUtils.getString("SDC_TITLE_DISCOVERING_AGENTS"), ASEUtils.getString("SDC_MSG_DISCOVERING_AGENTS"));
        workingDialogWithCancel.dispose();
        if (workingDialogWithCancel.isCancelled()) {
            runnable = null;
            return false;
        }
        this.refreshNodes();
        return true;
    }

    class ValidateAgentTask
    implements Runnable {
        private SDCClusterAgentProxy agentProxy;
        private SDCClusterSO _so;
        private String agentUrl;
        private boolean succeeded = false;
        private String errorMsg = null;

        public ValidateAgentTask(SDCClusterSO sDCClusterSO, SDCClusterAgentProxy sDCClusterAgentProxy, String string) {
            this._so = sDCClusterSO;
            this.agentProxy = sDCClusterAgentProxy;
            this.agentUrl = string;
        }

        public boolean isSucceeded() {
            return this.succeeded;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        @Override
        public void run() {
            try {
                List list;
                this.succeeded = this.agentProxy.validateClusterAgent();
                String string = this.agentProxy.getHost();
                String[] stringArray = (String[])this._so.getLocalAddressesMap().get(string);
                if (stringArray == null && (stringArray = this.agentProxy.getLocalAddresses()) != null) {
                    this._so.addLocalAddressesMap(string, stringArray);
                }
                if ((list = (List)this._so.getLLTAddressesMap().get(string)) == null && (list = this.agentProxy.getVCSClusterInterconnects()) != null) {
                    this._so.addLLTAddressesMap(string, list);
                }
            }
            catch (AgentConnectionException agentConnectionException) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_LOGIN_FAILED"), this.agentUrl, agentConnectionException.getMessage());
                this.errorMsg = aSEMessageText.toString();
                return;
            }
            catch (Exception exception) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_CLUSTER_AGENT"), this.agentUrl, exception.getMessage());
                this.errorMsg = aSEMessageText.toString();
                return;
            }
        }
    }
}

