/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOSummaryPage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.DBSizeUtil;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentConnectionException;
import java.util.List;
import javax.swing.JPanel;

class SDCClusterWizBOSummaryPage
extends ASEBaseWizardPage2 {
    protected SDCClusterWizGOSummaryPage _go = (SDCClusterWizGOSummaryPage)((Object)this.getJPanel());
    protected static final String INDENT = "    ";

    public SDCClusterWizBOSummaryPage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOSummaryPage()), ASEUtils.getString("SDC_CLUSTER_WIZ_SUMMARY"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
    }

    @Override
    public void enableComponents() {
    }

    @Override
    public void init() {
        this.enableComponents();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void releaseResources() {
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public boolean onSetActive() {
        IServer[] iServerArray2;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + ASEUtils.getString("LABC_CLUSTER_NAME") + " " + iCluster.getName());
        stringBuffer.append("\n" + ASEUtils.getString("LABC_MAX_INSTANCES") + " " + iCluster.getMaxInstances().toString());
        String string = ASEUtils.getString("SDC_INSTALLATION_MODE_SHARED");
        if (iCluster.getInstallationMode().equalsIgnoreCase("private")) {
            string = ASEUtils.getString("SDC_INSTALLATION_MODE_LOCAL");
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SDC_INSTALLATION_MODE") + " " + string);
        String string2 = ASEUtils.getString("SDC_MEMBERSHIP_MODE_NATIVE");
        if (sDCClusterSO.isVCSMode()) {
            this._go.startClusterCheckbox.setVisible(false);
            string2 = ASEUtils.getString("SDC_MEMBERSHIP_MODE_VCS");
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_MEMBERSHIP_MODE") + " " + string2);
        if (sDCClusterSO.isLDAPConfigured()) {
            stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SDC_LDAP_SERVER") + " " + sDCClusterSO.getLDAPServer());
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SDC_PARTICIPATING_HOSTS") + " ");
        List list = sDCClusterSO.getParticipatingNodeNames();
        if (list != null && !list.isEmpty()) {
            for (IServer[] iServerArray2 : list) {
                stringBuffer.append("\n    " + (String)iServerArray2);
            }
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_CLUSTER_WIDE_START_UP_PARAMETERS"));
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_START_PARAMETERS") + " " + iCluster.getAddlRunParameters());
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_CLUSTER_WIDE_TRACE_FLAGS"));
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_TRACE_FLAGS") + " " + iCluster.getTraceflagsString());
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_NETWORK_PROTOCOL") + " " + iCluster.getPrimaryInterconnect());
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SDC_QUORUM_DEVICE") + " " + iCluster.getQuorum());
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_MASTER_DEVICE") + " " + iCluster.getMasterDevice());
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_DEVICE_SIZE") + " " + iCluster.getMasterDeviceSize());
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_DATABASE_SIZE") + " " + iCluster.getMasterDatabaseSize());
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_PAGE_SIZE") + " " + iCluster.getPageSize());
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SYSTEM_PROCS_DEVICE") + " " + iCluster.getSystemProcedureDevice());
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_DEVICE_SIZE") + " " + iCluster.getSystemProcedureDeviceSize());
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_DATABASE_SIZE") + " " + iCluster.getSystemProcedureDatabaseSize());
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SYSTEM_DB_DEVICE") + " " + iCluster.getSystemDevice());
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_DEVICE_SIZE") + " " + iCluster.getSystemDeviceSize());
        stringBuffer.append("\n    " + ASEUtils.getString("LABC_DATABASE_SIZE") + " " + iCluster.getSystemDatabaseSize());
        List list2 = sDCClusterSO.getExtraUserDevices();
        if (!list2.isEmpty()) {
            stringBuffer.append("\n\n" + ASEUtils.getString("LABC_ADDTIONAL_USER_DEVICES") + " ");
        }
        iServerArray2 = list2.iterator();
        while (iServerArray2.hasNext()) {
            DatabaseDeviceSO databaseDeviceSO = (DatabaseDeviceSO)iServerArray2.next();
            String string3 = databaseDeviceSO.getName();
            String string4 = databaseDeviceSO.getMirrorPath();
            String string5 = databaseDeviceSO.getDatabaseDeviceSize();
            string5 = new Integer(DBSizeUtil.toIntMB(string5)).toString();
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_NAME") + " " + string3);
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_PATH") + " " + string4);
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_SIZE") + " " + string5);
        }
        iServerArray2 = iCluster.getServersArray();
        for (int i = 0; i < iServerArray2.length; ++i) {
            stringBuffer.append("\n\n" + ASEUtils.getString("SDC_CLUSTER_INSTANCE_DLG") + " #" + iServerArray2[i].getId().toString());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_INSTANCE_NAME") + " " + iServerArray2[i].getName());
            stringBuffer.append("\n    " + ASEUtils.getString("LOG_PROP_LABC_SDC_INSTANCE_ID") + " " + iServerArray2[i].getId().toString());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_NODE") + " " + iServerArray2[i].getNode());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_AGENT_PORT") + " " + iServerArray2[i].getAgentPort());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_QUERY_PORT") + " " + iServerArray2[i].getQueryPort());
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_PRIMARY_NETWORK_ADDRESS") + " " + iServerArray2[i].getPrimaryAddress());
            if (sDCClusterSO.hasSecondaryNetwork()) {
                stringBuffer.append("\n    " + ASEUtils.getString("LABC_SECONDARY_NETWORK_ADDRESS") + " " + iServerArray2[i].getSecondaryAddress());
            } else {
                stringBuffer.append("\n    " + ASEUtils.getString("LABC_SECONDARY_NETWORK_ADDRESS") + " " + ASEUtils.getString("DISP_NO_SECONDARY_NETWORK_ADDR"));
            }
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_SYBASE_HOME") + " " + iServerArray2[i].getSybaseHome());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_ASE_HOME") + " " + iServerArray2[i].getAseHome());
            if (!sDCClusterSO.isLDAPConfigured()) {
                stringBuffer.append("\n    " + ASEUtils.getString("LABC_INTERFACES_FILE_DIR") + " " + iServerArray2[i].getInterfacesPath());
            }
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_ENV_SCRIPT") + " " + iServerArray2[i].getEnvShellPath());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_CONFIG_FILE") + " " + iServerArray2[i].getConfigFile());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_LOG_FILE") + " " + iServerArray2[i].getLogFile());
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_START_PARAMETERS") + " " + iServerArray2[i].getAddlRunParameters());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_TRACE_FLAGS") + " " + iServerArray2[i].getTraceflagsString());
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_LSTDB"));
            stringBuffer.append("\n        " + ASEUtils.getString("LABC_DATABASE_NAME") + " " + iServerArray2[i].getTempdbDbName());
            stringBuffer.append("\n        " + ASEUtils.getString("LABC_DATABASE_SIZE") + " " + iServerArray2[i].getTempdbDbSize());
            stringBuffer.append("\n        " + ASEUtils.getString("LABC_DEVICE_NAME") + " " + iServerArray2[i].getTempdbDeviceName());
        }
        this._go.summaryTextArea.setText(ASEUtils.getString("SDC_CLUSTER_SUMMARY_MESSAGE") + stringBuffer.toString());
        return super.onSetActive();
    }

    @Override
    public int onWizardNext() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        sDCClusterSO.setAutoStartCluster(this._go.startClusterCheckbox.isSelected());
        for (SDCClusterAgentProxy sDCClusterAgentProxy : sDCClusterSO.getParticipatingAgents().values()) {
            boolean bl = sDCClusterAgentProxy.isConnectionValid();
            if (bl) continue;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_QUESTION_REESTABLISH_LOST_AGENT_CONNECTION"), sDCClusterAgentProxy.getHostPort());
            int n = Support.showQuestionYesNo(this.getJDialog(), aSEMessageText.toString());
            if (n == 0) {
                try {
                    sDCClusterAgentProxy.reconnect();
                    continue;
                }
                catch (AgentConnectionException agentConnectionException) {
                    ASEMessageText aSEMessageText2 = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
                    Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText2.toString());
                    return -1;
                }
            }
            return -1;
        }
        return 0;
    }
}

