/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOSummaryPage;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentConnectionException;
import java.util.List;
import javax.swing.JPanel;

class SDCClusterWizBOSummaryPage2
extends ASEBaseWizardPage2 {
    protected SDCClusterWizGOSummaryPage _go = (SDCClusterWizGOSummaryPage)((Object)this.getJPanel());
    private static final String INDENT = "    ";

    public SDCClusterWizBOSummaryPage2(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOSummaryPage()), ASEUtils.getString("SDC_CLUSTER_WIZ_SUMMARY"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
    }

    @Override
    public void enableComponents() {
    }

    @Override
    public void init() {
        this.enableComponents();
        this._go.startClusterCheckbox.setVisible(false);
        this._go.createClusterDescLabel.setText(ASEUtils.getString("SDC_INSTANCE_CREATE_INSTANCE_DESC"));
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void releaseResources() {
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public boolean onSetActive() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)((SDCClusterWizard)this.getParent()).getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + ASEUtils.getString("LABC_CLUSTER_NAME") + " " + iCluster.getName());
        stringBuffer.append("\n" + ASEUtils.getString("LABC_MAX_INSTANCES") + " " + iCluster.getMaxInstances().toString());
        String string = ASEUtils.getString("SDC_INSTALLATION_MODE_SHARED");
        if (iCluster.getInstallationMode().equalsIgnoreCase("private")) {
            string = ASEUtils.getString("SDC_INSTALLATION_MODE_LOCAL");
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SDC_INSTALLATION_MODE") + " " + string);
        String string2 = ASEUtils.getString("SDC_MEMBERSHIP_MODE_NATIVE");
        if (sDCClusterSO.isVCSMode()) {
            string2 = ASEUtils.getString("SDC_MEMBERSHIP_MODE_VCS");
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_MEMBERSHIP_MODE") + " " + string2);
        if (sDCClusterSO.isLDAPConfigured()) {
            stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SDC_LDAP_SERVER") + " " + sDCClusterSO.getLDAPServer());
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_SDC_PARTICIPATING_HOSTS") + " ");
        List list = sDCClusterSO.getParticipatingNodeNames();
        if (list != null && !list.isEmpty()) {
            for (String string3 : list) {
                stringBuffer.append("\n    " + string3);
            }
        }
        stringBuffer.append("\n\n" + ASEUtils.getString("LABC_NETWORK_PROTOCOL") + " " + iCluster.getPrimaryInterconnect());
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (iServerArray[i].getAgentPort() == null) continue;
            stringBuffer.append("\n\n" + ASEUtils.getString("SDC_CLUSTER_INSTANCE_DLG") + " #" + iServerArray[i].getId().toString());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_INSTANCE_NAME") + " " + iServerArray[i].getName());
            stringBuffer.append("\n    " + ASEUtils.getString("LOG_PROP_LABC_SDC_INSTANCE_ID") + " " + iServerArray[i].getId().toString());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_HOST") + " " + iServerArray[i].getNode());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_AGENT_PORT") + " " + iServerArray[i].getAgentPort());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_QUERY_PORT") + " " + iServerArray[i].getQueryPort());
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_PRIMARY_NETWORK_ADDRESS") + " " + iServerArray[i].getPrimaryAddress());
            if (sDCClusterSO.hasSecondaryNetwork()) {
                stringBuffer.append("\n    " + ASEUtils.getString("LABC_SECONDARY_NETWORK_ADDRESS") + " " + iServerArray[i].getSecondaryAddress());
            } else {
                stringBuffer.append("\n    " + ASEUtils.getString("LABC_SECONDARY_NETWORK_ADDRESS") + " " + ASEUtils.getString("DISP_NO_SECONDARY_NETWORK_ADDR"));
            }
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_SYBASE_HOME") + " " + iServerArray[i].getSybaseHome());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_ASE_HOME") + " " + iServerArray[i].getAseHome());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_INTERFACE_DIR") + " " + iServerArray[i].getInterfacesPath());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_ENV_SCRIPT") + " " + iServerArray[i].getEnvShellPath());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_CONFIG_FILE") + " " + iServerArray[i].getConfigFile());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_LOG_FILE") + " " + iServerArray[i].getLogFile());
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_START_PARAMETERS") + " " + iServerArray[i].getAddlRunParameters());
            stringBuffer.append("\n    " + ASEUtils.getString("LABC_TRACE_FLAGS") + " " + iServerArray[i].getTraceflagsString());
            stringBuffer.append("\n\n    " + ASEUtils.getString("LABC_LSTDB"));
            stringBuffer.append("\n        " + ASEUtils.getString("LABC_DATABASE_NAME") + " " + iServerArray[i].getTempdbDbName());
            stringBuffer.append("\n        " + ASEUtils.getString("LABC_DATABASE_SIZE") + " " + iServerArray[i].getTempdbDbSize());
            stringBuffer.append("\n        " + ASEUtils.getString("LABC_DEVICE_NAME") + " " + iServerArray[i].getTempdbDeviceName());
        }
        this._go.summaryTextArea.setText(ASEUtils.getString("SDC_INSTANCE_SUMMARY_MESSAGE") + stringBuffer.toString());
        return super.onSetActive();
    }

    @Override
    public int onWizardNext() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)((SDCClusterWizard)this.getParent()).getSO();
        sDCClusterSO.setAutoStartCluster(this._go.startClusterCheckbox.isSelected());
        for (SDCClusterAgentProxy sDCClusterAgentProxy : sDCClusterSO.getParticipatingAgents().values()) {
            boolean bl = sDCClusterAgentProxy.isConnectionValid();
            if (bl) continue;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_QUESTION_REESTABLISH_LOST_AGENT_CONNECTION"), sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort());
            int n = Support.showQuestionYesNo(this.getJDialog(), aSEMessageText.toString());
            if (n == 0) {
                try {
                    sDCClusterAgentProxy.reconnect();
                    continue;
                }
                catch (AgentConnectionException agentConnectionException) {
                    ASEMessageText aSEMessageText2 = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
                    Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText2.toString());
                    return -1;
                }
            }
            return -1;
        }
        return 0;
    }
}

