/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOSystemProcsDevicePage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCDefaultsInterface;
import com.sybase.aseplugin.util.DBSizeUtil;
import com.sybase.aseplugin.util.DeviceValidator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

class SDCClusterWizBOSystemProcsDevicePage
extends ASEBaseWizDocPage
implements SDCDefaultsInterface {
    private SDCClusterWizGOSystemProcsDevicePage _go = (SDCClusterWizGOSystemProcsDevicePage)((Object)this.getJPanel());

    public SDCClusterWizBOSystemProcsDevicePage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOSystemProcsDevicePage()), ASEUtils.getString("SDC_CLUSTER_WIZ_SYSTEMPROCSDEV"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
        this._go.pathTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public void enableComponents() {
        this.enableNextButton(this._go.pathTextField.getText().trim().length() > 0 && this._go.deviceSizeTextField.getValue() > 0 && this._go.databaseSizeTextField.getValue() > 0);
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        this.enableComponents();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void init() {
        this._go.deviceSizeTextField.setMinimum(1);
        this._go.deviceSizeTextField.setValue(152);
        this._go.databaseSizeTextField.setMinimum(1);
        this._go.databaseSizeTextField.setValue(152);
    }

    @Override
    public boolean onSetActive() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        this._go.noteVCSLabel.setVisible(sDCClusterSO.isVCSMode());
        this._go.pathTextField.requestFocus();
        this._go.pathTextField.selectAll();
        return super.onSetActive();
    }

    @Override
    public void releaseResources() {
        this._go.pathTextField.getDocument().removeDocumentListener(this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public int onWizardNext() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        String string = this._go.pathTextField.getText().trim();
        int n = this._go.deviceSizeTextField.getValue();
        String string2 = this._go.deviceUnitComboBox.getSelectedString();
        String string3 = null;
        try {
            string3 = DBSizeUtil.toString(n, string2);
        }
        catch (Exception exception) {
            Support.addLogEntry(0, null, this.getClass(), exception.getMessage(), exception.toString());
            ((SDCClusterWizard)this.getParent()).showErrorDialog(exception.getMessage());
            return -1;
        }
        int n2 = this._go.databaseSizeTextField.getValue();
        String string4 = this._go.databaseUnitComboBox.getSelectedString();
        int n3 = DBSizeUtil.toIntMB(n, string2);
        int n4 = DBSizeUtil.toIntMB(n2, string4);
        if (n3 <= 0) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_INVALID_DEVICE_SIZE"));
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        if (n4 <= 0) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_INVALID_DB_SIZE"));
            this._go.databaseSizeTextField.requestFocus();
            return -1;
        }
        if (n4 < 140) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_SYSTEM_PROCEDURES_DATABASE_SIZE_MIN"), new Integer(140));
            ((SDCClusterWizard)this.getParent()).showErrorDialog(aSEMessageText.toString());
            this._go.databaseSizeTextField.requestFocus();
            return -1;
        }
        if (n3 < 140) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_SYSTEM_PROCEDURES_DEVICE_SIZE_MIN"), new Integer(140));
            ((SDCClusterWizard)this.getParent()).showErrorDialog(aSEMessageText.toString());
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        if (n3 < n4) {
            ((SDCClusterWizard)this.getParent()).showErrorDialog(ASEUtils.getString("SDC_ERROR_DEVICE_SIZE_LESS_THAN_DATABASE_SIZE"));
            this._go.deviceSizeTextField.requestFocus();
            return -1;
        }
        boolean bl = this.validateDevicePath(string);
        if (!bl) {
            return -1;
        }
        int n5 = 0;
        n5 = !sDCClusterSO.isVCSMode() ? ((SDCClusterWizard)this.getParent()).getUsrConfirmForIOFencing(string, true) : ((SDCClusterWizard)this.getParent()).getUsrConfirmForVCS(string, true);
        if (n5 != 0) {
            this._go.pathTextField.selectAll();
            this._go.pathTextField.requestFocus();
            return -1;
        }
        sDCClusterSO.getCluster().setSystemProcedureDevice(string);
        sDCClusterSO.getCluster().setSystemProcedureDeviceSize(new Integer(n3).toString());
        sDCClusterSO.getCluster().setSystemProcedureDatabaseSize(new Integer(n4).toString());
        DatabaseDeviceSO databaseDeviceSO = new DatabaseDeviceSO(null, "sysprocsdev");
        databaseDeviceSO.setMirrorPath(string);
        databaseDeviceSO.setDatabaseDeviceSize(string3);
        sDCClusterSO.addDevice(databaseDeviceSO);
        return 0;
    }

    private boolean validateDevicePath(String string) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        if (sDCClusterSO.getCluster().getQuorum().equals(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DUPLICATE"), string, ASEUtils.getString("LABC_SDC_QUORUM_DEVICE1"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        if (sDCClusterSO.getCluster().getMasterDevice().equals(string)) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DUPLICATE"), string, ASEUtils.getString("LABC_MASTER_DEVICE1"));
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        return DeviceValidator.validateDevicePathOnAllNodes(string, sDCClusterSO, this.getClass(), this.getJDialog());
    }
}

