/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAPropertyData;
import com.sybase.asa.ASAPropertyDataTableCellEditor;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.dlg.SDCCreateDeviceDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.go.wiz.SDCClusterWizGOTempDBDevicePage;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.DatabaseDevicesCtrSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCDefaultsInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.util.DBSizeUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

class SDCClusterWizBOTempDBDevicePage
extends ASEBaseWizardPage2
implements ActionListener,
SDCDefaultsInterface {
    protected SDCClusterWizGOTempDBDevicePage _go = (SDCClusterWizGOTempDBDevicePage)((Object)this.getJPanel());
    int _pageSize = 2;

    public SDCClusterWizBOTempDBDevicePage(SDCClusterWizard sDCClusterWizard) {
        super(sDCClusterWizard, (JPanel)((Object)new SDCClusterWizGOTempDBDevicePage()), ASEUtils.getString("SDC_CLUSTER_WIZ_TEMPDBDEV"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
        this._go.createDeviceButton.addActionListener((ActionListener)this);
    }

    @Override
    public void enableComponents() {
    }

    protected void updateDeviceColumnCellEditor(String string) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : sDCClusterSO.getDevices().entrySet()) {
            arrayList.add(((DatabaseDeviceSO)entry.getValue()).getName());
        }
        for (int i = 0; i < this._go.matrix.getRowCount(); ++i) {
            ASAPropertyData aSAPropertyData = new ASAPropertyData(4, (Object)string, (Object[])arrayList.toArray(new String[arrayList.size()]));
            this._go.matrix.setValueAt((Object)aSAPropertyData, i, 2);
        }
        TableColumn tableColumn = this._go.matrix.getColumnModel().getColumn(2);
        tableColumn.setCellEditor((TableCellEditor)new ASAPropertyDataTableCellEditor(this._go.matrix));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        if (actionEvent.getSource() == this._go.createDeviceButton) {
            DatabaseDeviceSO databaseDeviceSO = new DatabaseDeviceSO(null, null);
            SDCCreateDeviceDialog.showDialog(((SDCClusterWizard)this.getParent()).getJDialog(), sDCClusterSO, databaseDeviceSO, this._go.matrix.getRowCount(), (SDCClusterWizard)this.getParent());
            if (databaseDeviceSO.getName() != null) {
                if (this._go.matrix.getCellEditor() != null) {
                    this._go.matrix.getCellEditor().stopCellEditing();
                }
                this.updateDeviceColumnCellEditor(databaseDeviceSO.getName());
            }
        }
    }

    @Override
    public boolean onSetActive() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        this._pageSize = sDCClusterSO.getClusterPageSize();
        IServer[] iServerArray = sDCClusterSO.getCluster().getServersArray();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < iServerArray.length; ++i) {
            String string = iServerArray[i].getName();
            if (iServerArray[i].getAgentPort() == null) continue;
            hashSet.add(string);
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        int n = this._go.matrix.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this._go.matrix.getRowAsArray(i);
            String string = (String)objectArray[0];
            hashSet2.add(string);
        }
        if (!((Object)hashSet).equals(hashSet2)) {
            this.populateMatrix(sDCClusterSO);
        }
        return super.onSetActive();
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public void releaseResources() {
        this._go.createDeviceButton.removeActionListener((ActionListener)this);
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    private void populateMatrix(SDCClusterSO sDCClusterSO) {
        while (this._go.matrix.getRowCount() > 0) {
            this._go.matrix.removeRow(0);
        }
        IServer[] iServerArray = sDCClusterSO.getCluster().getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            Object object;
            if (iServerArray[i].getAgentPort() == null) continue;
            String string = iServerArray[i].getName();
            Integer n = iServerArray[i].getId();
            String string2 = "lstdb_" + n.toString();
            Object object2 = "master";
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry entry : sDCClusterSO.getDevices().entrySet()) {
                object = (DatabaseDeviceSO)entry.getValue();
                arrayList.add(((ASEBaseSO)object).getName());
            }
            IServer iServer2 = sDCClusterSO.getCluster().getServer(string);
            if (null != iServer2 && null != (object = iServer2.getTempdbDeviceName()) && ((String)object).length() > 0) {
                object2 = object;
            }
            object = new ASAPropertyData(4, object2, (Object[])arrayList.toArray(new String[arrayList.size()]));
            this._go.matrix.addRow(new Object[]{string, new ASAPropertyData(2, (Object)string2), object, new ASAPropertyData(2, (Object)(new Integer(30).toString() + "MB".substring(0, 1)))});
        }
    }

    @Override
    public int onWizardNext() {
        boolean bl = this.saveTempDBInfo();
        if (bl) {
            return 0;
        }
        return -1;
    }

    public int getMinLSTDBSize(String string) {
        int n = 3;
        int n2 = 2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        switch (n2) {
            case 2: {
                n = 3;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            case 8: {
                n = 12;
                break;
            }
            case 16: {
                n = 24;
                break;
            }
        }
        return n;
    }

    protected Vector getDatabaseDevices(ASConnection aSConnection) {
        Vector vector = new Vector();
        if (aSConnection == null) {
            return vector;
        }
        DatabaseDevicesCtrSO databaseDevicesCtrSO = new DatabaseDevicesCtrSO(aSConnection);
        try {
            vector = (Vector)databaseDevicesCtrSO.open(1);
        }
        catch (SQLException sQLException) {
            Support.showError(null, this.getClass(), this.getJDialog(), sQLException.getMessage());
        }
        return vector;
    }

    protected boolean saveTempDBInfo() {
        Object object;
        Object object2;
        if (this._go.matrix.getCellEditor() != null) {
            this._go.matrix.getCellEditor().stopCellEditing();
        }
        int n = this._go.matrix.getRowCount();
        for (int i = 0; i < n; ++i) {
            object2 = this._go.matrix.getRowAsArray(i);
            object = (String)((ASAPropertyData)object2[1]).value;
            if (SDCClusterSO.validateIdentifier((String)object)) continue;
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_NAME"), object);
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
            return false;
        }
        String string = this.getDuplicatedDevName();
        if (null != string && string.length() > 0) {
            object2 = new ASEMessageText(ASEUtils.getString("SDC_ERROR_DUPLICATE_TEMPDB_NAME"), string);
            Support.showError(null, this.getClass(), this.getJDialog(), ((ASEMessageText)object2).toString());
            return false;
        }
        object2 = (SDCClusterSO)this.getSO();
        object = ((SDCClusterSO)object2).getDeviceAvailableSizeMap();
        HashMap hashMap = new HashMap(object.size());
        hashMap.putAll(object);
        Vector vector = new Vector();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            Object object3;
            Object object4;
            int n4;
            Object object5;
            Object object6;
            Object object7;
            Object[] objectArray = this._go.matrix.getRowAsArray(i);
            String string2 = (String)objectArray[0];
            String string3 = (String)((ASAPropertyData)objectArray[1]).value;
            if (string3 != null) {
                string3 = string3.trim();
            }
            String string4 = (String)((ASAPropertyData)objectArray[2]).value;
            String string5 = ((ASAPropertyData)objectArray[3]).value.toString().trim();
            int n5 = 0;
            try {
                n5 = DBSizeUtil.toIntMB(string5);
            }
            catch (NumberFormatException numberFormatException) {
                object7 = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_DB_SIZE"), string5);
                Support.showError(null, this.getClass(), this.getJDialog(), ((ASEMessageText)object7).toString());
                return false;
            }
            if (string4 == null || string4.trim().length() == 0) {
                object6 = new ASEMessageText(ASEUtils.getString("SDC_ERROR_DEVICE_NAME_EMPTY"), string4);
                Support.showError(null, this.getClass(), this.getJDialog(), ((ASEMessageText)object6).toString());
                return false;
            }
            object6 = ((SDCClusterSO)object2).getDevice(string4);
            if (bl) {
                vector = this.getDatabaseDevices(((ASEBaseSO)object6).getConnection());
                bl = false;
            }
            for (int j = 0; j < vector.size(); ++j) {
                object5 = (DatabaseDeviceSO)vector.get(j);
                if (!((ASEBaseSO)object5).getName().equals(string4)) continue;
                object6 = object5;
                break;
            }
            if ((object7 = ((DatabaseDeviceSO)object6).getDatabaseDeviceSize()) == null) {
                object5 = new Float(((DatabaseDeviceSO)object6).getSize());
                n4 = ((Float)object5).intValue();
                object7 = Integer.toString(n4);
            }
            int n6 = 0;
            try {
                n6 = DBSizeUtil.toIntMB((String)object7);
            }
            catch (NumberFormatException numberFormatException) {
                object4 = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_DEVICE_SIZE"), string5);
                Support.showError(null, this.getClass(), this.getJDialog(), ((ASEMessageText)object4).toString());
                return false;
            }
            object4 = ((DatabaseDeviceSO)object6).getUnusedSize();
            if (object4 == null) {
                n4 = SDCClusterWizBOTempDBDevicePage.getDeviceSizeAvailable(string4, (DatabaseDeviceSO)object6, ((SDCClusterSO)object2).getCluster(), hashMap);
            } else {
                object3 = new Float((String)object4);
                n4 = ((Float)object3).intValue();
            }
            object3 = ((SDCClusterSO)object2).getCluster().getPageSize();
            if (null != object3 && ((String)object3).length() > 0 && n5 < (n3 = this.getMinLSTDBSize((String)object3))) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_DB_SIZE_LESS_THAN_MIN"), new Integer(n3), new Integer((String)object3));
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            if (n5 > n4) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_DB_SIZE_GREATER_THAN_AVAILABLE_DEVICE_SIZE"), string3, string4, new Integer(n4));
                Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
                return false;
            }
            SDCClusterWizBOTempDBDevicePage.setDeviceSizeAvailable(string4, n4 - n5, hashMap);
            if (this.containsMasterDev() && (n3 = SDCClusterWizBOTempDBDevicePage.getDeviceSizeAvailable("master", (DatabaseDeviceSO)object6, ((SDCClusterSO)object2).getCluster(), hashMap)) < (n2 = DBSizeUtil.getAdditionalDevSizeForMasterIntMB(this._pageSize))) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_MASTER_DEVICE_AVAILABLE_SIZE_TOO_SMALL"), new Integer(n2), new Integer(this._pageSize));
                ((SDCClusterWizard)this.getParent()).showErrorDialog(aSEMessageText.toString());
                return false;
            }
            IServer iServer = ((SDCClusterSO)object2).getCluster().getServer(string2);
            if (iServer == null) continue;
            iServer.setTempdbDeviceName(string4);
            iServer.setTempdbDevicePath(((DatabaseDeviceSO)object6).getMirrorPath());
            iServer.setTempdbDeviceSize(new Integer(n6).toString());
            iServer.setTempdbDbName(string3);
            iServer.setTempdbDbSize(new Integer(n5).toString());
        }
        return true;
    }

    protected String getDuplicatedDevName() {
        int n = this._go.matrix.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this._go.matrix.getRowAsArray(i);
            String string = (String)((ASAPropertyData)objectArray[1]).value;
            string = string.trim();
            for (int j = i + 1; j < n; ++j) {
                Object[] objectArray2 = this._go.matrix.getRowAsArray(j);
                String string2 = (String)((ASAPropertyData)objectArray2[1]).value;
                if (!string.equals(string2 = string2.trim())) continue;
                return string;
            }
        }
        return "";
    }

    private boolean containsMasterDev() {
        int n = this._go.matrix.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this._go.matrix.getRowAsArray(i);
            String string = (String)((ASAPropertyData)objectArray[2]).value;
            if (!string.equals("master")) continue;
            return true;
        }
        return false;
    }

    protected static int getDeviceSizeAvailable(String string, DatabaseDeviceSO databaseDeviceSO, ICluster iCluster, Map map) {
        Integer n = (Integer)map.get(string);
        if (n != null) {
            return n;
        }
        string = string.trim();
        if (databaseDeviceSO == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = DBSizeUtil.toIntMB(databaseDeviceSO.getDatabaseDeviceSize());
        if (string.equals("master")) {
            n2 = DBSizeUtil.toIntMB(iCluster.getMasterDatabaseSize());
        } else if (string.equals("sysprocsdev")) {
            n2 = DBSizeUtil.toIntMB(iCluster.getSystemProcedureDatabaseSize());
        } else if (string.equals("systemdbdev")) {
            n2 = DBSizeUtil.toIntMB(iCluster.getSystemDatabaseSize());
        }
        int n4 = n3 - n2;
        map.put(string, new Integer(n4));
        return n4;
    }

    private static void setDeviceSizeAvailable(String string, int n, Map map) {
        map.put(string, new Integer(n));
    }
}

