/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCMessageListener;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.security.crypto.SecureObject;
import com.sybase.ua.util.AgentClientUtil;
import com.sybase.ua.util.MessageListener;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;

public class SDCClusterWizardSession {
    private SDCClusterSO clusterSO;
    private SDCMessageListener messageListener;
    private SDCClusterWizard wizard;
    private Map<String, Properties> deployedAgentsPropertiesMap = new HashMap<String, Properties>();
    private Map pluginVersionInstanceNumberMap = new HashMap();

    public SDCClusterWizardSession(SDCClusterSO sDCClusterSO, SDCMessageListener sDCMessageListener, SDCClusterWizard sDCClusterWizard) {
        this.clusterSO = sDCClusterSO;
        this.messageListener = sDCMessageListener;
        this.wizard = sDCClusterWizard;
    }

    protected void finalize() throws Throwable {
        this.clusterSO = null;
        this.messageListener = null;
        this.wizard = null;
    }

    public boolean upgradeServer(String string, String string2, JDialog jDialog) throws Exception {
        Object object;
        if (this.pluginVersionInstanceNumberMap == null || this.pluginVersionInstanceNumberMap.isEmpty()) {
            String string3 = ASEUtils.getString("MSG_PLUGIN_NOT_DEPLOYED");
            this.messageListener.getCallback().handleMessage(4, string3);
            return false;
        }
        ICluster iCluster = this.clusterSO.getCluster();
        String string4 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (Debug.isOn()) {
            object = "The server upgrade XML is as follows:\n" + string4;
            Support.addLogEntry(2, this.getClass().getName(), (String)object, (String)object);
        }
        object = iCluster.getServer(new Integer(1));
        String string5 = object.getNode();
        String string6 = object.getAgentPort();
        SDCClusterAgentProxy sDCClusterAgentProxy = this.clusterSO.getParticipatingAgent(SDCClusterSO.getMapKey(string5, string6));
        if (jDialog != null && jDialog.isVisible()) {
            jDialog.dispose();
        }
        this.doUpgradeServer(sDCClusterAgentProxy, iCluster, string4, string, string2);
        return true;
    }

    private void doUpgradeServer(SDCClusterAgentProxy sDCClusterAgentProxy, ICluster iCluster, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{iCluster.getOldServerName(), iCluster.getName(), string2, new SecureObject((Serializable)((Object)string3)), string, this.getMessageListener()};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "java.lang.String", "com.sybase.ua.util.MessageListener"};
        String string4 = ASEUtils.getString("SDC_MSG_UPGRADING_SERVER");
        this.messageListener.getCallback().handleMessage(5, string4);
        String string5 = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
        String string6 = this.getPluginMBeanName(string5);
        sDCClusterAgentProxy.invokePluginMethod(string6, "upgradeServer", objectArray, stringArray);
    }

    public void createCluster() throws Exception {
        String string;
        int n;
        String string2;
        String string3;
        SDCClusterAgentProxy sDCClusterAgentProxy;
        boolean bl;
        Object object;
        if (this.pluginVersionInstanceNumberMap == null || this.pluginVersionInstanceNumberMap.isEmpty()) {
            String string4 = ASEUtils.getString("MSG_PLUGIN_NOT_DEPLOYED");
            this.messageListener.getCallback().handleMessage(4, string4);
            return;
        }
        ICluster iCluster = this.clusterSO.getCluster();
        String string5 = XMLCluster.getXMLClusterString((ICluster)iCluster);
        if (Debug.isOn()) {
            object = "The cluster creation XML is as follows:\n" + string5;
            Support.addLogEntry(2, this.getClass().getName(), (String)object, (String)object);
        }
        if (!(bl = (sDCClusterAgentProxy = this.clusterSO.getParticipatingAgent(SDCClusterSO.getMapKey(string3 = (object = iCluster.getServer(new Integer(1))).getNode(), string2 = object.getAgentPort()))).isPortAvailable(n = Integer.parseInt(string = object.getQueryPort())))) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_UNAVAILABLE"), new Integer(string));
            throw new Exception(aSEMessageText.toString());
        }
        this.doCreateCluster(sDCClusterAgentProxy, iCluster, string5);
    }

    public String getInstanceXMLString(String string, IServer iServer) throws ClusterConfigException {
        ICluster iCluster = XMLCluster.getICluster((String)string);
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            iCluster.dropServer(iServerArray[i].getName());
        }
        iCluster.addServer(iServer.getId(), iServer);
        return XMLCluster.getXMLClusterString((ICluster)iCluster);
    }

    public void createInstance() throws Exception {
        Object object;
        if (this.pluginVersionInstanceNumberMap == null || this.pluginVersionInstanceNumberMap.isEmpty()) {
            String string = ASEUtils.getString("MSG_PLUGIN_NOT_DEPLOYED");
            this.messageListener.getCallback().handleMessage(4, string);
            return;
        }
        ICluster iCluster = this.clusterSO.getCluster();
        String string = XMLCluster.getXMLClusterString((ICluster)iCluster);
        ICluster iCluster2 = this.clusterSO.getClusterConfiguration();
        if (this.clusterSO.isLocalInstallation()) {
            this.clusterSO.setClusterAgentPort(iCluster2, this.clusterSO.getUAFInfo().getRMIPort());
        }
        if (Debug.isOn()) {
            object = "The cluster creation XML is as follows:\n" + string;
            Support.addLogEntry(2, this.getClass().getName(), (String)object, (String)object);
        }
        object = this.clusterSO.getAgentInfo();
        String string2 = object.getHost();
        String string3 = object.getRMIPort();
        SDCClusterAgentProxy sDCClusterAgentProxy = this.clusterSO.getAgent(string2, string3, this.clusterSO.getAgentUsername(), this.clusterSO.getAgentPassword());
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            Object object2;
            IServer iServer = iServerArray[i];
            String string4 = iServer.getNode();
            String string5 = iServer.getAgentPort();
            if (null == string5 || iCluster2.containsServer(iServer)) continue;
            String string6 = this.getInstanceXMLString(string, iServer);
            SDCClusterAgentProxy sDCClusterAgentProxy2 = this.clusterSO.getParticipatingAgent(SDCClusterSO.getMapKey(string4, string5));
            if (null == sDCClusterAgentProxy2) continue;
            String string7 = iServer.getQueryPort();
            int n = Integer.parseInt(string7);
            boolean bl = sDCClusterAgentProxy2.isPortAvailable(n);
            if (!bl) {
                object2 = new ASEMessageText(ASEUtils.getString("SDC_MSG_PORT_UNAVAILABLE"), new Integer(string7));
                throw new Exception(((ASEMessageText)object2).toString());
            }
            if (this.clusterSO.isLocalInstallation()) {
                object2 = XMLCluster.getXMLClusterString((ICluster)iCluster2);
                this.doCreateClusterInstance(sDCClusterAgentProxy, iCluster, iServer, string6, (String)object2);
                iCluster2.addServer(iServer.getId(), iServer);
                continue;
            }
            this.doCreateClusterInstance(sDCClusterAgentProxy, iCluster, iServer, string6);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deployClusterAgentPlugins() throws Exception {
        ICluster iCluster = this.clusterSO.getCluster();
        IServer[] iServerArray = iCluster.getServersArray();
        int n = 0;
        while (n < iServerArray.length) {
            String string = iServerArray[n].getHost();
            String string2 = iServerArray[n].getAgentPort();
            String string3 = string + ":" + string2;
            if (!this.pluginVersionInstanceNumberMap.containsKey(string3) && string2 != null) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_DEPLOYING_CLAP"), string3);
                String string4 = aSEMessageText.toString();
                this.messageListener.getCallback().handleMessage(4, string4);
                SDCClusterAgentProxy sDCClusterAgentProxy = this.clusterSO.getParticipatingAgent(SDCClusterSO.getMapKey(string, string2));
                Properties properties = SDCClusterWizardSession.makeClusterAgentPluginProperties(iCluster, iServerArray[n]);
                sDCClusterAgentProxy.reconnect();
                String string5 = null;
                int n2 = 0;
                PluginInfo pluginInfo = this.findASEClap(sDCClusterAgentProxy, iCluster.getName());
                if (pluginInfo != null) {
                    string5 = pluginInfo.getVersion();
                    n2 = pluginInfo.getInstanceNumber();
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_QUESTION_REUSE_CLAP"), this.clusterSO.getCluster().getName(), string3);
                    int n3 = Support.showQuestionYesNo(this.wizard.getJDialog(), aSEMessageText.toString());
                    if (n3 != 0) {
                        aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_CLAP_EXISTS_CHANGE_NAME"), this.clusterSO.getCluster().getName(), string3);
                        throw new Exception(aSEMessageText.toString());
                    }
                    aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_REUSE_CLAP"), this.clusterSO.getCluster().getName(), string3);
                    this.messageListener.getCallback().handleMessage(4, aSEMessageText.toString());
                } else {
                    String string6 = sDCClusterAgentProxy.getTemplatePluginLatestVersion("com.sybase.ase.cluster", "15.0.1");
                    if (string6 == null) {
                        aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_CANNOT_FIND_ASECLAP_IN_TEMPLATES"), "15.0.1");
                        throw new Exception(aSEMessageText.toString());
                    }
                    string5 = string6;
                    n2 = sDCClusterAgentProxy.deployPluginFromTemplate("com.sybase.ase.cluster", string5, iCluster.getName(), properties, new Boolean(true));
                    sDCClusterAgentProxy.getAgentConnection().reloadACLCache();
                    if (Debug.isOn()) {
                        Support.addLogEntry(2, null, this.getClass(), "Node " + string3 + ": ARL reloaded so that the new plugin can be accessed.", "");
                    }
                    sDCClusterAgentProxy.refreshDiscoveryServers();
                }
                this.pluginVersionInstanceNumberMap.put(string3, new Object[]{string5, new Integer(n2)});
            }
            ++n;
        }
        return;
    }

    private PluginInfo findASEClap(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws Exception {
        PluginInfo pluginInfo = null;
        List list = new ArrayList(1);
        try {
            list = sDCClusterAgentProxy.getAgentInfo().getPluginInfosWithLatestVersion("com.sybase.ase.cluster");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!list.isEmpty()) {
            for (PluginInfo pluginInfo2 : list) {
                String string2 = (String)pluginInfo2.getDiscoveryProperty("clusterName");
                if (string2 == null || !string2.equals(string)) continue;
                pluginInfo = pluginInfo2;
                break;
            }
        }
        return pluginInfo;
    }

    private static Properties makeClusterAgentPluginProperties(ICluster iCluster, IServer iServer) {
        Properties properties = new Properties();
        properties.setProperty("ase.cluster.name", iCluster.getName());
        properties.setProperty("ase.env.script", iServer.getEnvShellPath());
        String string = iServer.getEnvShellPath().substring(iServer.getEnvShellPath().lastIndexOf(".") + 1);
        properties.setProperty("ase.env.script.type", string);
        properties.setProperty("ase.home", iServer.getAseHome());
        properties.setProperty("ase.master.device", iCluster.getMasterDevice());
        properties.setProperty("ase.quorum.device", iCluster.getQuorum());
        properties.setProperty("ase.user", "sa");
        properties.setProperty("ase.password", "");
        properties.setProperty("com.sybase.home", iServer.getSybaseHome());
        properties.setProperty("ase.installation.mode", iCluster.getInstallationMode());
        properties.setProperty("ase.interfaces.path", iServer.getInterfacesPath());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("ase.password") || !Debug.isOn()) continue;
            String string3 = "Param: " + string2 + " = " + properties.getProperty(string2);
            Support.addLogEntry(2, "com.sybase.aseplugin.bo.wiz.SDCClusterWizardSession", string3, string3);
        }
        return properties;
    }

    public PluginInfo getDeployedClusterAgentPlugin(ICluster iCluster, SDCClusterAgentProxy sDCClusterAgentProxy) throws AgentConnectionException {
        PluginInfo pluginInfo = sDCClusterAgentProxy.getASEClustAgentPlugin(iCluster.getName());
        if (pluginInfo != null) {
            String string = pluginInfo.getVersion();
            int n = pluginInfo.getInstanceNumber();
            sDCClusterAgentProxy.getUafEntry().setPluginVersion(string);
            sDCClusterAgentProxy.getUafEntry().setPluginInstanceNumber(n);
            this.cachePluginVersionInstanceNumber(sDCClusterAgentProxy, string, n);
        }
        return pluginInfo;
    }

    public boolean needUpdateClusterAgentPlugin(ICluster iCluster, SDCClusterAgentProxy sDCClusterAgentProxy) throws AgentConnectionException {
        String string = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
        Properties properties = this.getDeployedAgentPluginProperties(string);
        if (properties != null) {
            String string2 = properties.getProperty("ase.quorum.device");
            String string3 = properties.getProperty("ase.master.device");
            if (null == string3) {
                string3 = "";
            }
            String string4 = properties.getProperty("com.sybase.home");
            String string5 = properties.getProperty("ase.home");
            String string6 = properties.getProperty("ase.env.script");
            String string7 = properties.getProperty("use.ldap");
            String string8 = properties.getProperty("ase.interfaces.path");
            if (null == string8) {
                string8 = "";
            }
            String string9 = iCluster.getQuorum();
            String string10 = iCluster.getMasterDevice();
            if (null == string10) {
                string10 = "";
            }
            String string11 = sDCClusterAgentProxy.getSybaseHome();
            String string12 = sDCClusterAgentProxy.getAseHome();
            String string13 = sDCClusterAgentProxy.getEnvironmentScript();
            boolean bl = iCluster.isLDAPconfigured();
            String string14 = sDCClusterAgentProxy.getInterfacesFileHome();
            if (null == string14) {
                string14 = "";
            }
            return !string2.equals(string9) || !string3.equals(string10) || !string4.equals(string11) || !string5.equals(string12) || !string6.equals(string13) || null == string7 && bl || null != string7 && !bl || !string8.equals(string14);
        }
        return true;
    }

    public void deployClusterAgentPlugin(ICluster iCluster, SDCClusterAgentProxy sDCClusterAgentProxy) throws Exception {
        String string = sDCClusterAgentProxy.getHost();
        String string2 = sDCClusterAgentProxy.getPort();
        String string3 = string + ":" + string2;
        if (this.pluginVersionInstanceNumberMap.containsKey(string3) || string2 == null) {
            return;
        }
        sDCClusterAgentProxy.deployAgentPlugin(iCluster);
        this.cachePluginVersionInstanceNumber(sDCClusterAgentProxy, sDCClusterAgentProxy.getUafEntry().getPluginVersion(), sDCClusterAgentProxy.getUafEntry().getInstanceNumber());
        this.cacheDeployedAgentPluginProperties(string3, sDCClusterAgentProxy.getAgentPluginProperties(iCluster));
    }

    public void updateClusterAgentPlugin(ICluster iCluster, SDCClusterAgentProxy sDCClusterAgentProxy) throws Exception {
        PluginInfo pluginInfo = sDCClusterAgentProxy.getASEClustAgentPlugin(iCluster.getName());
        String string = pluginInfo.getVersion();
        int n = pluginInfo.getInstanceNumber();
        sDCClusterAgentProxy.getUafEntry().setPluginVersion(string);
        sDCClusterAgentProxy.getUafEntry().setPluginInstanceNumber(n);
        sDCClusterAgentProxy.updateAgentPluginProperties(iCluster);
        this.cachePluginVersionInstanceNumber(sDCClusterAgentProxy, string, n);
        String string2 = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
        this.cacheDeployedAgentPluginProperties(string2, sDCClusterAgentProxy.getAgentPluginProperties(iCluster));
    }

    public void cachePluginVersionInstanceNumber(SDCClusterAgentProxy sDCClusterAgentProxy, String string, int n) {
        String string2 = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
        this.pluginVersionInstanceNumberMap.put(string2, new Object[]{string, n});
    }

    public void cacheDeployedAgentPluginProperties(String string, Properties properties) {
        this.deployedAgentsPropertiesMap.put(string, properties);
    }

    public Properties getDeployedAgentPluginProperties(String string) {
        return this.deployedAgentsPropertiesMap.get(string);
    }

    private void doCreateCluster(SDCClusterAgentProxy sDCClusterAgentProxy, ICluster iCluster, String string) throws Exception {
        Object[] objectArray = new Object[5];
        objectArray[0] = iCluster.getName();
        objectArray[1] = string;
        objectArray[2] = sDCClusterAgentProxy.getCLAPAdmin();
        objectArray[3] = sDCClusterAgentProxy.getCLAPCryptPass();
        objectArray[4] = this.getMessageListener();
        Object[] objectArray2 = objectArray;
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
        String string2 = ASEUtils.getString("SDC_MSG_CREATING_CLUSTER");
        this.messageListener.getCallback().handleMessage(5, string2);
        String string3 = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
        String string4 = this.getPluginMBeanName(string3);
        sDCClusterAgentProxy.invokePluginMethod(string4, "createCluster", objectArray2, stringArray);
    }

    private void doCreateClusterInstance(SDCClusterAgentProxy sDCClusterAgentProxy, ICluster iCluster, IServer iServer, String string) throws Exception {
        Object[] objectArray = new Object[]{iCluster.getName(), iServer.getName(), string, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), this.getMessageListener()};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
        String string2 = ASEUtils.getString("SDC_MSG_CREATING_CLUSTER_INSTANCE");
        this.messageListener.getCallback().handleMessage(5, string2);
        String string3 = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
        String string4 = this.getPluginMBeanName(string3);
        sDCClusterAgentProxy.invokePluginMethod(string4, "addInstance", objectArray, stringArray);
    }

    private void doCreateClusterInstance(SDCClusterAgentProxy sDCClusterAgentProxy, ICluster iCluster, IServer iServer, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{iCluster.getName(), iServer.getName(), string, string2, SDCClusterAgentProxy.getCLAPAdmin(), SDCClusterAgentProxy.getCLAPCryptPass(), this.getMessageListener()};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.security.crypto.SecureObject", "com.sybase.ua.util.MessageListener"};
        String string3 = ASEUtils.getString("SDC_MSG_CREATING_CLUSTER_INSTANCE");
        this.messageListener.getCallback().handleMessage(5, string3);
        String string4 = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
        String string5 = this.getPluginMBeanName(string4);
        sDCClusterAgentProxy.invokePluginMethod(string5, "addInstance", objectArray, stringArray);
    }

    private String getPluginMBeanName(String string) {
        String string2 = this.getPluginVersion(string);
        int n = this.getPluginInstanceNumber(string);
        if (string2 == null && n == 0) {
            try {
                string2 = this.clusterSO.getPluginInfo().getVersion();
                n = this.clusterSO.getPluginInfo().getInstanceNumber();
            }
            catch (RemoteException remoteException) {
                Support.addLogEntry(0, this.getClass().getName(), remoteException.getMessage(), remoteException.getMessage());
            }
        }
        String string3 = AgentClientUtil.getPluginMBeanName((String)"com.sybase.ase.cluster", (String)string2, (int)n);
        return string3;
    }

    public SDCMessageListener getMessageListener() {
        return this.messageListener;
    }

    public String getPluginVersion(String string) {
        Object[] objectArray = (Object[])this.pluginVersionInstanceNumberMap.get(string);
        if (objectArray == null || objectArray.length < 1) {
            return null;
        }
        String string2 = (String)objectArray[0];
        return string2;
    }

    public void setMessageListener(SDCMessageListener sDCMessageListener) {
        this.messageListener = sDCMessageListener;
    }

    public void startCluster() throws Exception {
        ICluster iCluster = this.clusterSO.getCluster();
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_MSG_STARTING_CLUSTER"), iCluster.getName());
        this.messageListener.getCallback().handleMessage(5, aSEMessageText.toString());
        String string = this.clusterSO.getCluster().getName();
        IServer[] iServerArray = this.clusterSO.getCluster().getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            Object object;
            String string2;
            String string3 = iServerArray[i].getName();
            String string4 = iServerArray[i].getHost();
            SDCClusterAgentProxy sDCClusterAgentProxy = this.clusterSO.getParticipatingAgent(SDCClusterSO.getMapKey(string4, string2 = iServerArray[i].getAgentPort()));
            if (sDCClusterAgentProxy == null) continue;
            String string5 = sDCClusterAgentProxy.getHost() + ":" + sDCClusterAgentProxy.getPort();
            if (sDCClusterAgentProxy.getUafEntry() instanceof SyUAFASEEntry) {
                object = (SyUAFASEEntry)sDCClusterAgentProxy.getUafEntry();
                object.setPluginVersion(this.getPluginVersion(string5));
                object.setPluginInstanceNumber(this.getPluginInstanceNumber(string5));
            }
            object = this.getPluginMBeanName(string5);
            sDCClusterAgentProxy.startInstance((String)object, string, string3, (MessageListener)this.messageListener);
        }
    }

    public int getPluginInstanceNumber(String string) {
        Object[] objectArray = (Object[])this.pluginVersionInstanceNumberMap.get(string);
        if (objectArray == null || objectArray.length < 2) {
            return 0;
        }
        Integer n = (Integer)objectArray[1];
        return n;
    }
}

