/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.RLImages;
import com.sybase.aseplugin.bo.ArticleBO;
import com.sybase.aseplugin.bo.ConnectionBO;
import com.sybase.aseplugin.bo.PublicationBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.prop.SubAdvancedDialog;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.wiz.SubWizGOPage1;
import com.sybase.aseplugin.go.wiz.SubWizGOPage2;
import com.sybase.aseplugin.go.wiz.SubWizGOPage3;
import com.sybase.aseplugin.go.wiz.SubWizGOPage4;
import com.sybase.aseplugin.go.wiz.SubWizGOPage5;
import com.sybase.aseplugin.so.ArticleSO;
import com.sybase.aseplugin.so.ConnectionSO;
import com.sybase.aseplugin.so.PublicationSO;
import com.sybase.aseplugin.so.RepArticleSO;
import com.sybase.aseplugin.so.ReplicationSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.SubscriptionSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.ui.JLabelTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class SubscriptionWizard
extends ASEBaseWizardDialog2 {
    private ConnectionBO _connBO;
    private PublicationBO _pubBO;
    private SubscriptionSO _subSO;
    private SCContainer2 _parentContainer;

    public static boolean showDialog(Container container, ASEBaseWizardDialog2 aSEBaseWizardDialog2) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        aSEBaseWizardDialog2.setDialogSupport(sCDialogSupport);
        sCDialogSupport.setDialogController((SCDialogController)aSEBaseWizardDialog2);
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setStandardButtons(true);
        sCDialogSupport.setHelpButton(false);
        sCDialogSupport.setModal(true);
        return sCDialogSupport.render();
    }

    public static boolean myshowDialog(Container container, ASEBaseWizardDialog2 aSEBaseWizardDialog2) {
        SCDialogSupport sCDialogSupport = Support.createDialogSupport(container);
        aSEBaseWizardDialog2.setDialogSupport(sCDialogSupport);
        sCDialogSupport.setDialogController((SCDialogController)aSEBaseWizardDialog2);
        sCDialogSupport.setResizable(true);
        sCDialogSupport.setStandardButtons(true);
        sCDialogSupport.setHelpButton(false);
        sCDialogSupport.setModal(true);
        return sCDialogSupport.render();
    }

    public SubscriptionWizard(SubscriptionSO subscriptionSO, SCContainer2 sCContainer2, ConnectionBO connectionBO) {
        super((SOItemInterface)subscriptionSO, sCContainer2);
        this._connBO = connectionBO;
        this._pubBO = null;
        this._parentContainer = sCContainer2;
        this._subSO = subscriptionSO;
        this._subSO.setServer(((ConnectionSO)this._connBO.getSO()).getServer());
        this._subSO.setDatabase(((ConnectionSO)this._connBO.getSO()).getDatabase());
    }

    public SubscriptionWizard(SubscriptionSO subscriptionSO, SCContainer2 sCContainer2, PublicationBO publicationBO) {
        super((SOItemInterface)subscriptionSO, sCContainer2);
        this._pubBO = publicationBO;
        this._connBO = null;
        this._parentContainer = sCContainer2;
        this._subSO = subscriptionSO;
        this._subSO.setPublication(this._pubBO.getSO().getDisplayName());
    }

    @Override
    public SCPageController[] getPages() {
        SCPageController[] sCPageControllerArray = new SCPageController[5];
        if (this._connBO == null) {
            sCPageControllerArray[0] = new SubWizBOPage1(this);
            sCPageControllerArray[1] = new SubWizBOPage2(this);
            sCPageControllerArray[2] = new SubWizBOPage4(this);
            sCPageControllerArray[3] = new SubWizBOPage5(this);
            sCPageControllerArray[4] = new SubWizSummaryPage(this);
        } else {
            sCPageControllerArray[0] = new SubWizBOPage1(this);
            sCPageControllerArray[1] = new SubWizBOPage3(this);
            sCPageControllerArray[2] = new SubWizBOPage4(this);
            sCPageControllerArray[3] = new SubWizBOPage5(this);
            sCPageControllerArray[4] = new SubWizSummaryPage(this);
        }
        return sCPageControllerArray;
    }

    public SubscriptionSO getMySO() {
        return this._subSO;
    }

    public ConnectionBO getParentBO() {
        return this._connBO;
    }

    public SCContainer2 getFrame() {
        return this._parentContainer;
    }

    @Override
    public boolean deploy() {
        try {
            this._subSO.create();
            this.createRepArticles();
            if (this._connBO != null) {
                this._connBO.refresh();
            } else if (this._pubBO != null) {
                this._pubBO.refresh();
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
            return false;
        }
        return true;
    }

    private void createRepArticles() {
        try {
            if (this.getMySO().isAllArticles()) {
                Enumeration enumeration = ArticleSO.getPrimaryArticles(this.getMySO().getConnection(), this.getMySO().getDDB(), this.getMySO().getPublication());
                while (enumeration.hasMoreElements()) {
                    ArticleSO articleSO = (ArticleSO)enumeration.nextElement();
                    try {
                        RepArticleSO repArticleSO = new RepArticleSO(this.getMySO().getConnection(), this.getMySO().getDDB());
                        repArticleSO.setArticleType(articleSO.getTypeString());
                        repArticleSO.setPrimaryArticleOwner(articleSO.getOwner());
                        repArticleSO.setPrimaryArticle(articleSO.getDisplayName());
                        repArticleSO.setSubscription(this.getMySO().getDisplayName());
                        repArticleSO.create();
                    }
                    catch (Exception exception) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
                    }
                }
                if (this.getMySO().isMaterializeAll()) {
                    this.getMySO().doMaterialize();
                } else if (this.getMySO().isValidateAll()) {
                    this.getMySO().doValidate();
                }
            } else {
                ArticleTable articleTable = ((SubWizBOPage5)this._pageControllers[3]).getArticleTable();
                Debug.wassert(articleTable != null, this, "Null article table");
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < articleTable.size(); ++i) {
                    try {
                        String string;
                        if (!articleTable.isSelected(i)) continue;
                        RepArticleSO repArticleSO = new RepArticleSO(this.getMySO().getConnection(), this.getMySO().getDDB());
                        repArticleSO.setArticleType(articleTable.getType(i));
                        repArticleSO.setPrimaryArticleOwner(articleTable.getOwner(i));
                        repArticleSO.setPrimaryArticle(articleTable.getName(i));
                        repArticleSO.setSubscription(this.getMySO().getDisplayName());
                        String string2 = articleTable.getReplicateName(i);
                        if (string2 == null || string2.length() == 0) {
                            repArticleSO.setRepArtName(articleTable.getName(i));
                        } else {
                            repArticleSO.setOwner(articleTable.getReplicateOwner(i));
                            repArticleSO.setRepArtName(articleTable.getReplicateName(i));
                        }
                        repArticleSO.setNewFields(articleTable.getFields(i));
                        repArticleSO.setWhereClause(articleTable.getWhereClause(i));
                        repArticleSO.create();
                        if (articleTable.isMaterialize(i)) {
                            string = this.getMaterializeCmd(repArticleSO.getDDB(), this.getMySO().getDisplayName(), repArticleSO.getOwner(), repArticleSO.getDisplayName());
                            vector.addElement(string);
                            continue;
                        }
                        if (!articleTable.isValidate(i)) continue;
                        string = this.getValidateCmd(repArticleSO.getDDB(), this.getMySO().getDisplayName(), repArticleSO.getOwner(), repArticleSO.getDisplayName());
                        vector.addElement(string);
                        continue;
                    }
                    catch (Exception exception) {
                        Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
                    }
                }
                if (vector.size() > 0) {
                    this.getMySO().submitCmds(vector);
                }
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
        }
    }

    private String getValidateCmd(String string, String string2, String string3, String string4) {
        String string5 = null;
        String string6 = "";
        if (string3 != null && string3.length() > 0) {
            string6 = string3 + ".";
        }
        if ((string6 = string6 + string4) != null && string6.length() > 0) {
            Object[] objectArray = new String[]{string, string2, string6};
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            string5 = rLSQLResourceBundle.getString("VALIDATE_REP_ARTICLE", objectArray);
            Debug.wassert(string5 != null && string5.length() > 0, this, "Invalid SQL Resource");
        }
        return string5;
    }

    protected String getMaterializeCmd(String string, String string2, String string3, String string4) {
        String string5 = null;
        String string6 = "";
        if (string3 != null && string3.length() > 0) {
            string6 = string3 + ".";
        }
        if ((string6 = string6 + string4) != null && string6.length() > 0) {
            Object[] objectArray = new String[]{string, string2, string6};
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            string5 = rLSQLResourceBundle.getString("MATERIALIZE_REP_ARTICLE", objectArray);
            Debug.wassert(string5 != null && string5.length() > 0, this, "Invalid SQL Resource");
        }
        return string5;
    }

    @Override
    public void releaseResources() {
        this._connBO = null;
        this._pubBO = null;
        this._subSO = null;
        this._parentContainer = null;
        super.releaseResources();
    }

    public String setSummaryPageInfo() {
        String string = ((SubWizBOPage1)this._pageControllers[0]).getSummaryInfo();
        if (this._pageControllers[1] instanceof SubWizBOPage2) {
            string = string + ((SubWizBOPage2)this._pageControllers[1]).getSummaryInfo();
        } else if (this._pageControllers[1] instanceof SubWizBOPage3) {
            string = string + ((SubWizBOPage3)this._pageControllers[1]).getSummaryInfo();
        }
        string = string + ((SubWizBOPage4)this._pageControllers[2]).getSummaryInfo();
        string = string + ((SubWizBOPage5)this._pageControllers[3]).getSummaryInfo();
        return string;
    }

    class ArtFieldTable {
        protected Vector _table;
        protected static final int SELECTION_COL = 0;
        protected static final int NAME_COL = 1;
        protected static final int DATATYPE_COL = 2;
        protected static final int ID_COL = 3;

        public ArtFieldTable(ASConnection aSConnection, SubscriptionSO subscriptionSO, String string, String string2) {
            Debug.wassert(aSConnection != null, this, "Null connection parameter");
            Debug.wassert(subscriptionSO != null, this, "Null SubscriptionSO parameter");
            this.loadFields(aSConnection, subscriptionSO, string, string2);
        }

        public Vector getTable() {
            return this._table;
        }

        public int size() {
            int n = 0;
            if (this._table != null) {
                n = this._table.size();
            }
            return n;
        }

        public void setSelection(boolean bl, int n) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in field table");
                vector.setElementAt(new Boolean(bl), 0);
            }
        }

        public boolean isSelected(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in field table");
                bl = (Boolean)vector.elementAt(0);
            }
            return bl;
        }

        public String getName(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 1, this, "Null or corrupt vector in field table");
                string = (String)vector.elementAt(1);
            }
            return string;
        }

        public String getDatatype(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 2, this, "Null or corrupt vector in field table");
                string = (String)vector.elementAt(2);
            }
            return string;
        }

        public Integer getID(int n) throws ArrayIndexOutOfBoundsException {
            Integer n2 = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 3, this, "Null or corrupt vector in field table");
                n2 = (Integer)vector.elementAt(3);
            }
            return n2;
        }

        public boolean anyFieldsSelected() {
            boolean bl = false;
            for (int i = 0; i < this.size() && !bl; ++i) {
                bl = this.isSelected(i);
            }
            return bl;
        }

        public String getFields() {
            String string = "";
            int n = -1;
            int n2 = -2;
            for (int i = 0; i < this._table.size(); ++i) {
                if (!this.isSelected(i)) continue;
                int n3 = this.getID(i);
                if (n3 == n2 + 1) {
                    n2 = n3;
                    continue;
                }
                if (n == n2) {
                    string = string + String.valueOf(n) + ",";
                } else if (n < n2) {
                    string = string + String.valueOf(n) + "-" + String.valueOf(n2) + ",";
                }
                n = n3;
                n2 = n3;
            }
            if (n == n2) {
                string = string + String.valueOf(n);
            } else if (n < n2) {
                string = string + String.valueOf(n) + "-" + String.valueOf(n2);
            }
            return string;
        }

        private void loadFields(ASConnection aSConnection, SubscriptionSO subscriptionSO, String string, String string2) {
            Debug.wassert(aSConnection != null, this, "Null connection parameter");
            Debug.wassert(subscriptionSO != null, this, "Null Subscription parameter");
            Debug.wassert(string != null && string.length() > 0, this, "Null or empty article owner parameter");
            Debug.wassert(string2 != null && string2.length() > 0, this, "Null or empty article name parameter");
            try {
                this._table = ArticleSO.getFields(aSConnection, subscriptionSO.getDDB(), subscriptionSO.getPublication(), string, string2);
                for (int i = 0; i < this._table.size(); ++i) {
                    Vector vector = (Vector)this._table.elementAt(i);
                    Boolean bl = new Boolean(false);
                    vector.insertElementAt(bl, 0);
                }
            }
            catch (SQLException sQLException) {
                this._table = new Vector();
            }
        }
    }

    class ArticleTable {
        protected Vector _table;
        protected static final int SELECTION_COL = 0;
        protected static final int NAME_COL = 1;
        protected static final int OWNER_COL = 2;
        protected static final int TYPE_COL = 3;
        protected static final int REMOTE_OWNER_COL = 4;
        protected static final int REMOTE_NAME_COL = 5;
        protected static final int WHERE_CLAUSE_COL = 6;
        protected static final int VALIDATE_COL = 7;
        protected static final int MATERIALIZE_COL = 8;
        protected static final int FIELDS_COL = 9;

        public ArticleTable() throws SQLException {
            this.loadArticles();
        }

        public Vector getTable() {
            return this._table;
        }

        public int size() {
            int n = 0;
            if (this._table != null) {
                n = this._table.size();
            }
            return n;
        }

        public void setSelection(boolean bl, int n) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in article table");
                vector.setElementAt(new Boolean(bl), 0);
            }
        }

        public boolean isSelected(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 0, this, "Null or corrupt vector in article table");
                bl = (Boolean)vector.elementAt(0);
            }
            return bl;
        }

        public String getName(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 1, this, "Null or corrupt vector in article table");
                JLabel jLabel = (JLabel)vector.elementAt(1);
                string = jLabel.getText();
            }
            return string;
        }

        public String getOwner(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 2, this, "Null or corrupt vector in article table");
                string = (String)vector.elementAt(2);
            }
            return string;
        }

        public String getType(int n) throws ArrayIndexOutOfBoundsException {
            String string = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 3, this, "Null or corrupt vector in item table");
                string = (String)vector.elementAt(3);
            }
            return string;
        }

        public boolean isTable(int n) throws ArrayIndexOutOfBoundsException {
            return this.getType(n).equals("table");
        }

        public boolean isProcedure(int n) throws ArrayIndexOutOfBoundsException {
            return this.getType(n).equals("procedure");
        }

        public String getFields(int n) throws ArrayIndexOutOfBoundsException {
            String string = "";
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                ArtFieldTable artFieldTable = (ArtFieldTable)vector.elementAt(9);
                string = artFieldTable.getFields();
            }
            return string;
        }

        public String getReplicateOwner(int n) throws ArrayIndexOutOfBoundsException {
            String string = "";
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                string = (String)vector.elementAt(4);
            }
            return string;
        }

        public void setReplicateOwner(int n, String string) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                vector.setElementAt(string, 4);
            }
        }

        public String getReplicateName(int n) throws ArrayIndexOutOfBoundsException {
            String string = "";
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                string = (String)vector.elementAt(5);
            }
            return string;
        }

        public void setReplicateName(int n, String string) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                vector.setElementAt(string, 5);
            }
        }

        public String getWhereClause(int n) throws ArrayIndexOutOfBoundsException {
            String string = "";
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                string = (String)vector.elementAt(6);
            }
            return string;
        }

        public void setWhereClause(int n, String string) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                vector.setElementAt(string, 6);
            }
        }

        public boolean isValidate(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                bl = (Boolean)vector.elementAt(7);
            }
            return bl;
        }

        public void setValidate(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                vector.setElementAt(new Boolean(bl), 7);
            }
        }

        public boolean isMaterialize(int n) throws ArrayIndexOutOfBoundsException {
            boolean bl = false;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                bl = (Boolean)vector.elementAt(8);
            }
            return bl;
        }

        public void setMaterialize(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                vector.setElementAt(new Boolean(bl), 8);
            }
        }

        public ArtFieldTable getFieldTable(int n) throws ArrayIndexOutOfBoundsException {
            ArtFieldTable artFieldTable = null;
            if (this._table != null) {
                Vector vector = (Vector)this._table.elementAt(n);
                Debug.wassert(vector != null && vector.size() > 9, this, "Null or corrupt vector in article table");
                artFieldTable = (ArtFieldTable)vector.elementAt(9);
                if (artFieldTable == null) {
                    artFieldTable = new ArtFieldTable(SubscriptionWizard.this.getMySO().getConnection(), SubscriptionWizard.this.getMySO(), this.getOwner(n), this.getName(n));
                    vector.setElementAt(artFieldTable, 9);
                }
            }
            return artFieldTable;
        }

        public boolean anyArticlesSelected() {
            boolean bl = false;
            for (int i = 0; i < this.size() && !bl; ++i) {
                bl = this.isSelected(i);
            }
            return bl;
        }

        private void loadArticles() throws SQLException {
            try {
                this._table = new Vector();
                Enumeration enumeration = ArticleSO.getPrimaryArticles(SubscriptionWizard.this.getMySO().getConnection(), SubscriptionWizard.this.getMySO().getDDB(), SubscriptionWizard.this.getMySO().getPublication());
                while (enumeration.hasMoreElements()) {
                    ArticleSO articleSO = (ArticleSO)enumeration.nextElement();
                    Vector<Object> vector = new Vector<Object>(10);
                    vector.addElement(new Boolean(false));
                    JLabel jLabel = articleSO.isTable() ? new JLabel(articleSO.getDisplayName(), ArticleBO.PRIMARY_ARTICLE_TABLE_ICON, 0) : new JLabel(articleSO.getDisplayName(), ArticleBO.PRIMARY_ARTICLE_PROC_ICON, 0);
                    vector.addElement(jLabel);
                    vector.addElement(articleSO.getOwner());
                    vector.addElement(articleSO.getArticleType());
                    vector.addElement(null);
                    vector.addElement(null);
                    vector.addElement(null);
                    vector.addElement(new Boolean(false));
                    vector.addElement(new Boolean(false));
                    vector.addElement(null);
                    this._table.addElement(vector);
                }
            }
            catch (SQLException sQLException) {
                this._table = new Vector();
                throw sQLException;
            }
        }
    }

    class SubWizSummaryPage
    extends SummaryWizBOPage {
        public SubWizSummaryPage(SubscriptionWizard subscriptionWizard2) {
            super(subscriptionWizard2, ASEImages.getDatabaseWizardImage());
        }

        @Override
        public void enableComponents() {
            this.setSummaryInfo(SubscriptionWizard.this.setSummaryPageInfo());
        }
    }

    class SubWizBOPage5
    extends ASEBaseWizardPage2
    implements ActionListener,
    ListSelectionListener {
        private SubWizGOPage5 _panel;
        private JTable _jtArticles;
        private JLabelTableModel _jArticleModel;
        private ArticleTable _articleTable;
        private JTable _jtFields;
        private JLabelTableModel _jFieldModel;
        private ArtFieldTable _fieldTable;

        public SubWizBOPage5(SubscriptionWizard subscriptionWizard2) {
            super(subscriptionWizard2, (JPanel)((Object)new SubWizGOPage5()), ASEUtils.getString("MSG_ADD_SUB_WIZ_SELECT"));
            this._articleTable = null;
            this._fieldTable = null;
            this._panel = (SubWizGOPage5)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.cbClearAll.addActionListener((ActionListener)this);
            this._panel.cbSelectAll.addActionListener((ActionListener)this);
            this._panel.cbAdvanced.addActionListener((ActionListener)this);
        }

        @Override
        public boolean showPage() {
            if (SubscriptionWizard.this.getMySO().isAllArticles()) {
                return false;
            }
            if (this._articleTable == null) {
                this.InitArticleTable();
                this.InitFieldTable();
            }
            this.SetWizardButtons();
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (actionEvent.getSource() == this._panel.cbClearAll || actionEvent.getSource() == this._panel.cbSelectAll) {
                this.setAllFields(actionEvent.getSource() == this._panel.cbSelectAll);
                this.checkItemSelection();
                this.SetWizardButtons();
            }
            if (actionEvent.getSource() == this._panel.cbAdvanced && (n = this._jtArticles.getSelectedRow()) >= 0) {
                SCDialogSupport sCDialogSupport = Support.createDialogSupport(Support.getViewerFrame());
                SubAdvancedDialog subAdvancedDialog = new SubAdvancedDialog(SubscriptionWizard.this.getMySO(), SubscriptionWizard.this.getFrame());
                subAdvancedDialog.init(this._articleTable.isTable(n), this._articleTable.getOwner(n), this._articleTable.getName(n), this._articleTable.getReplicateOwner(n), this._articleTable.getReplicateName(n), this._articleTable.getWhereClause(n), this._articleTable.isMaterialize(n), this._articleTable.isValidate(n));
                sCDialogSupport.setDialogController((SCDialogController)subAdvancedDialog);
                sCDialogSupport.setTitle(ASEUtils.getString("DISP_ADV_SUB_PROP") + " [ " + SubscriptionWizard.this.getMySO().getDisplayName() + " ]");
                sCDialogSupport.setResizable(true);
                sCDialogSupport.setModal(true);
                sCDialogSupport.setStandardButtons(true);
                sCDialogSupport.setHelpButton(false);
                sCDialogSupport.render();
                if (subAdvancedDialog.isOK()) {
                    this._articleTable.setReplicateOwner(n, subAdvancedDialog.getRemoteOwner());
                    this._articleTable.setReplicateName(n, subAdvancedDialog.getRemoteName());
                    this._articleTable.setWhereClause(n, subAdvancedDialog.getWhereClause());
                    this._articleTable.setMaterialize(n, subAdvancedDialog.isMaterialize());
                    this._articleTable.setValidate(n, subAdvancedDialog.isValidate());
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = this._jtArticles.getSelectedRow()) >= 0) {
                this.loadFields(n);
            }
        }

        @Override
        public int onWizardNext() {
            try {
                for (int i = 0; i < this._articleTable.size(); ++i) {
                    if (!this._articleTable.isSelected(i) || !this._articleTable.isTable(i)) continue;
                    boolean bl = false;
                    ArtFieldTable artFieldTable = this._articleTable.getFieldTable(i);
                    if (artFieldTable != null) {
                        bl = artFieldTable.anyFieldsSelected();
                    }
                    if (bl) continue;
                    String string = ASEUtils.getString("ERR_NO_FIELDS_SELECT");
                    ASEMessageText aSEMessageText = new ASEMessageText(string, this._articleTable.getOwner(i), this._articleTable.getName(i));
                    Support.showError(this.getConnection(), this.getClass(), this.getJDialog(), aSEMessageText.toString());
                    return -1;
                }
            }
            catch (Exception exception) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(exception), exception);
                return -1;
            }
            Support.showWarning(this.getConnection(), this.getClass(), this.getJDialog(), ASEUtils.getString("WARN_REP_ARTICLE_TABLE"));
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = "";
            if (!SubscriptionWizard.this.getMySO().isAllArticles()) {
                for (int i = 0; i < this._articleTable.size(); ++i) {
                    String string2;
                    if (!this._articleTable.isSelected(i)) continue;
                    String string3 = this._articleTable.getReplicateName(i);
                    string = string3 == null || string3.length() == 0 ? string + "\t" + this._articleTable.getName(i) + "\n" : ((string2 = this._articleTable.getReplicateOwner(i)) == null || string2.length() == 0 ? string + "\t" + string3 + "\n" : string + "\t" + string2 + "." + string3 + "\n");
                }
            }
            return string;
        }

        private void SetWizardButtons() {
            this.enableNextButton(true);
        }

        public ArticleTable getArticleTable() {
            return this._articleTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void InitArticleTable() {
            Vector<String> vector = new Vector<String>();
            vector.addElement(" ");
            vector.addElement(ASEUtils.getString("DISP_ITEM_HDR"));
            vector.addElement(ASEUtils.getString("DISP_OWNER_HDR"));
            try {
                this._articleTable = new ArticleTable();
                this._jArticleModel = new JLabelTableModel(vector, this._articleTable.getTable());
                this._jtArticles = new ASETable(this._jArticleModel);
                this._panel.scrollpArticles.getViewport().setView(this._jtArticles);
            }
            catch (SQLException sQLException) {
                try {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
                    this._jArticleModel = new JLabelTableModel(vector, this._articleTable.getTable());
                    this._jtArticles = new ASETable(this._jArticleModel);
                    this._panel.scrollpArticles.getViewport().setView(this._jtArticles);
                }
                catch (Throwable throwable) {
                    this._jArticleModel = new JLabelTableModel(vector, this._articleTable.getTable());
                    this._jtArticles = new ASETable(this._jArticleModel);
                    this._panel.scrollpArticles.getViewport().setView(this._jtArticles);
                    this._jtArticles.setBackground(SystemColor.window);
                    this._jtArticles.setForeground(SystemColor.windowText);
                    this._jtArticles.getTableHeader().setReorderingAllowed(false);
                    this._jtArticles.setSelectionMode(0);
                    this._jtArticles.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
                    TableColumnModel tableColumnModel = this._jtArticles.getColumnModel();
                    Rectangle rectangle = new Rectangle();
                    this._panel.scrollpArticles.getBounds(rectangle);
                    int n = (int)((double)rectangle.width * 0.1);
                    tableColumnModel.getColumn(0).setWidth(n);
                    tableColumnModel.getColumn(0).setPreferredWidth(n);
                    n = (int)((double)rectangle.width * 0.55);
                    tableColumnModel.getColumn(1).setWidth(n);
                    tableColumnModel.getColumn(1).setPreferredWidth(n);
                    n = (int)((double)rectangle.width * 0.35);
                    tableColumnModel.getColumn(2).setWidth(n);
                    tableColumnModel.getColumn(2).setPreferredWidth(n);
                    this.addArticleTableKeyboardActions();
                    this.addArticleTableMouseActions();
                    this._jtArticles.getSelectionModel().addListSelectionListener(this);
                    throw throwable;
                }
                this._jtArticles.setBackground(SystemColor.window);
                this._jtArticles.setForeground(SystemColor.windowText);
                this._jtArticles.getTableHeader().setReorderingAllowed(false);
                this._jtArticles.setSelectionMode(0);
                this._jtArticles.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
                TableColumnModel tableColumnModel = this._jtArticles.getColumnModel();
                Rectangle rectangle = new Rectangle();
                this._panel.scrollpArticles.getBounds(rectangle);
                int n = (int)((double)rectangle.width * 0.1);
                tableColumnModel.getColumn(0).setWidth(n);
                tableColumnModel.getColumn(0).setPreferredWidth(n);
                n = (int)((double)rectangle.width * 0.55);
                tableColumnModel.getColumn(1).setWidth(n);
                tableColumnModel.getColumn(1).setPreferredWidth(n);
                n = (int)((double)rectangle.width * 0.35);
                tableColumnModel.getColumn(2).setWidth(n);
                tableColumnModel.getColumn(2).setPreferredWidth(n);
                this.addArticleTableKeyboardActions();
                this.addArticleTableMouseActions();
                this._jtArticles.getSelectionModel().addListSelectionListener(this);
            }
            this._jtArticles.setBackground(SystemColor.window);
            this._jtArticles.setForeground(SystemColor.windowText);
            this._jtArticles.getTableHeader().setReorderingAllowed(false);
            this._jtArticles.setSelectionMode(0);
            this._jtArticles.setDefaultRenderer(new JLabel().getClass(), new MyCellRenderer());
            TableColumnModel tableColumnModel = this._jtArticles.getColumnModel();
            Rectangle rectangle = new Rectangle();
            this._panel.scrollpArticles.getBounds(rectangle);
            int n = (int)((double)rectangle.width * 0.1);
            tableColumnModel.getColumn(0).setWidth(n);
            tableColumnModel.getColumn(0).setPreferredWidth(n);
            n = (int)((double)rectangle.width * 0.55);
            tableColumnModel.getColumn(1).setWidth(n);
            tableColumnModel.getColumn(1).setPreferredWidth(n);
            n = (int)((double)rectangle.width * 0.35);
            tableColumnModel.getColumn(2).setWidth(n);
            tableColumnModel.getColumn(2).setPreferredWidth(n);
            this.addArticleTableKeyboardActions();
            this.addArticleTableMouseActions();
            this._jtArticles.getSelectionModel().addListSelectionListener(this);
        }

        private void addArticleTableKeyboardActions() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SubWizBOPage5.this._jtArticles.getSelectedRow();
                    if (n >= 0) {
                        SubWizBOPage5.this._articleTable.setSelection(!SubWizBOPage5.this._articleTable.isSelected(n), n);
                        SubWizBOPage5.this._jArticleModel.fireTableCellUpdated(n, 0);
                        SubWizBOPage5.this.setAllFields(SubWizBOPage5.this._articleTable.isSelected(n));
                        SubWizBOPage5.this.SetWizardButtons();
                    }
                }
            };
            this._jtArticles.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
            this._jtArticles.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
        }

        private void addArticleTableMouseActions() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    int n = SubWizBOPage5.this._jtArticles.columnAtPoint(mouseEvent.getPoint());
                    int n2 = SubWizBOPage5.this._jtArticles.rowAtPoint(mouseEvent.getPoint());
                    if (n == 0) {
                        SubWizBOPage5.this._articleTable.setSelection(!SubWizBOPage5.this._articleTable.isSelected(n2), n2);
                        SubWizBOPage5.this._jArticleModel.fireTableCellUpdated(n2, 0);
                        SubWizBOPage5.this.setAllFields(SubWizBOPage5.this._articleTable.isSelected(n2));
                        SubWizBOPage5.this.SetWizardButtons();
                    }
                }
            };
            this._jtArticles.addMouseListener(mouseAdapter);
        }

        private void checkItemSelection() {
            int n = this._jtArticles.getSelectedRow();
            if (n >= 0) {
                if (this._fieldTable.anyFieldsSelected()) {
                    this._articleTable.setSelection(true, n);
                } else if (this._articleTable.isTable(n)) {
                    this._articleTable.setSelection(false, n);
                }
                this._jArticleModel.fireTableCellUpdated(n, 0);
            }
        }

        private void InitFieldTable() {
            Vector<String> vector = new Vector<String>();
            vector.addElement(" ");
            vector.addElement(ASEUtils.getString("DISP_FIELD_HDR"));
            vector.addElement(ASEUtils.getString("DISP_DATATYPE_HDR"));
            Vector vector2 = new Vector();
            this._jFieldModel = new JLabelTableModel(vector, vector2);
            this._jtFields = new ASETable(this._jFieldModel);
            this._panel.scrollpFields.getViewport().setView(this._jtFields);
            this._jtFields.setBackground(SystemColor.window);
            this._jtFields.setForeground(SystemColor.windowText);
            this._jtFields.getTableHeader().setReorderingAllowed(false);
            this._jtFields.setSelectionMode(2);
            TableColumnModel tableColumnModel = this._jtFields.getColumnModel();
            Rectangle rectangle = new Rectangle();
            this._panel.scrollpFields.getBounds(rectangle);
            int n = (int)((double)rectangle.width * 0.1);
            tableColumnModel.getColumn(0).setWidth(n);
            tableColumnModel.getColumn(0).setPreferredWidth(n);
            n = (int)((double)rectangle.width * 0.45);
            tableColumnModel.getColumn(1).setWidth(n);
            tableColumnModel.getColumn(1).setPreferredWidth(n);
            tableColumnModel.getColumn(2).setWidth(n);
            tableColumnModel.getColumn(2).setPreferredWidth(n);
            this.addFieldTableKeyboardActions();
            this.addFieldTableMouseActions();
        }

        private void addFieldTableKeyboardActions() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = SubWizBOPage5.this._jtFields.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        SubWizBOPage5.this._fieldTable.setSelection(!SubWizBOPage5.this._fieldTable.isSelected(nArray[i]), nArray[i]);
                        SubWizBOPage5.this._jFieldModel.fireTableCellUpdated(nArray[i], 0);
                    }
                    SubWizBOPage5.this.checkItemSelection();
                    SubWizBOPage5.this.SetWizardButtons();
                }
            };
            this._jtFields.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 0);
            this._jtFields.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
        }

        private void addFieldTableMouseActions() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    int n = SubWizBOPage5.this._jtFields.columnAtPoint(mouseEvent.getPoint());
                    int n2 = SubWizBOPage5.this._jtFields.rowAtPoint(mouseEvent.getPoint());
                    if (n == 0) {
                        if (!(mouseEvent.isShiftDown() || mouseEvent.isControlDown() || mouseEvent.isMetaDown() || mouseEvent.isAltDown())) {
                            SubWizBOPage5.this._fieldTable.setSelection(!SubWizBOPage5.this._fieldTable.isSelected(n2), n2);
                            SubWizBOPage5.this._jFieldModel.fireTableCellUpdated(n2, 0);
                        }
                        SubWizBOPage5.this.checkItemSelection();
                        SubWizBOPage5.this.SetWizardButtons();
                    }
                }
            };
            this._jtFields.addMouseListener(mouseAdapter);
        }

        private void loadFields(int n) {
            Debug.wassert(n >= 0, this, "Invalid article table row number");
            this._fieldTable = this._articleTable.getFieldTable(n);
            this._jFieldModel.setData(this._fieldTable.getTable());
            this._jtFields.updateUI();
        }

        private void setAllFields(boolean bl) {
            for (int i = 0; i < this._jFieldModel.getRowCount(); ++i) {
                this._fieldTable.setSelection(bl, i);
            }
            this._jtFields.repaint();
        }

        @Override
        public void releaseResources() {
            this._jtArticles = null;
            this._jArticleModel = null;
            this._articleTable = null;
            this._jtFields = null;
            this._jFieldModel = null;
            this._fieldTable = null;
            this._panel.cbClearAll.removeActionListener((ActionListener)this);
            this._panel.cbSelectAll.removeActionListener((ActionListener)this);
            this._panel.cbAdvanced.removeActionListener((ActionListener)this);
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class SubWizBOPage4
    extends ASEBaseWizardPage2
    implements ActionListener {
        private SubWizGOPage4 _panel;

        public SubWizBOPage4(SubscriptionWizard subscriptionWizard2) {
            super(subscriptionWizard2, (JPanel)((Object)new SubWizGOPage4()), ASEUtils.getString("MSG_ADD_SUB_WIZ_SUBSCRIBE"));
            this._panel = (SubWizGOPage4)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.radiobAll.addActionListener((ActionListener)this);
            this._panel.radiobSelected.addActionListener((ActionListener)this);
            this._panel.checkbMaterialize.addActionListener((ActionListener)this);
            this._panel.checkbValidate.addActionListener((ActionListener)this);
        }

        @Override
        public void enableComponents() {
            this.SetWizardButtons();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._panel.radiobAll) {
                this._panel.checkbMaterialize.setEnabled(true);
                this._panel.checkbValidate.setEnabled(true);
            } else if (actionEvent.getSource() == this._panel.radiobSelected) {
                this._panel.checkbMaterialize.setEnabled(false);
                this._panel.checkbValidate.setEnabled(false);
            } else if (actionEvent.getSource() == this._panel.checkbMaterialize) {
                if (this._panel.checkbMaterialize.isSelected()) {
                    this._panel.checkbValidate.setSelected(false);
                }
            } else if (actionEvent.getSource() == this._panel.checkbValidate && this._panel.checkbValidate.isSelected()) {
                this._panel.checkbMaterialize.setSelected(false);
            }
            this.SetWizardButtons();
        }

        @Override
        public int onWizardNext() {
            if (this._panel.radiobAll.isSelected()) {
                SubscriptionWizard.this.getMySO().setAllArticles(true);
                SubscriptionWizard.this.getMySO().setMaterializeAll(this._panel.checkbMaterialize.isSelected());
                SubscriptionWizard.this.getMySO().setValidateAll(this._panel.checkbValidate.isSelected());
                SubscriptionWizard.this.setSummaryPageInfo();
            } else {
                SubscriptionWizard.this.getMySO().setAllArticles(false);
                SubscriptionWizard.this.getMySO().setMaterializeAll(false);
                SubscriptionWizard.this.getMySO().setValidateAll(false);
            }
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = "";
            if (this._panel.radiobAll.isSelected()) {
                string = ASEUtils.getString("SUM_SUB_SELECT_ALL");
                if (this._panel.checkbMaterialize.isSelected()) {
                    string = string + ASEUtils.getString("SUM_SUB_MATERIALIZE");
                } else if (this._panel.checkbValidate.isSelected()) {
                    string = string + ASEUtils.getString("SUM_SUB_VALIDATE");
                }
            }
            return string;
        }

        private void SetWizardButtons() {
            this.enableNextButton(true);
        }

        @Override
        public void releaseResources() {
            this._panel.radiobAll.removeActionListener((ActionListener)this);
            this._panel.radiobSelected.removeActionListener((ActionListener)this);
            this._panel.checkbMaterialize.removeActionListener((ActionListener)this);
            this._panel.checkbValidate.removeActionListener((ActionListener)this);
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class SubWizBOPage3
    extends ASEBaseWizardPage2 {
        private SubWizGOPage3 _panel;

        public SubWizBOPage3(SubscriptionWizard subscriptionWizard2) {
            super(subscriptionWizard2, (JPanel)((Object)new SubWizGOPage3()), ASEUtils.getString("MSG_ADD_SUB_WIZ_PUB"));
            this._panel = (SubWizGOPage3)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.comboPublication.setRenderer((ListCellRenderer)new MyCellRenderer());
            this.loadPublications();
            this._panel.Connection.setText(SubscriptionWizard.this._connBO.getConnSO().getDisplayName());
        }

        @Override
        public void enableComponents() {
            this.SetWizardButtons();
        }

        @Override
        public int onWizardNext() {
            SubscriptionWizard.this.getMySO().setPublication(this.getPublication());
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = ASEUtils.getString("SUM_SUB_CONN");
            ASEMessageText aSEMessageText = new ASEMessageText(string, this._panel.Connection.getText());
            String string2 = aSEMessageText.toString();
            string = ASEUtils.getString("SUM_SUB_PUB");
            aSEMessageText = new ASEMessageText(string, this.getPublication());
            string2 = string2 + aSEMessageText.toString();
            return string2;
        }

        private void SetWizardButtons() {
            this.enableNextButton(this.getPublication() != null && this.getPublication().length() > 0);
        }

        private void loadPublications() {
            try {
                Enumeration enumeration = SubscriptionWizard.this._connBO != null ? PublicationSO.getPublications(SubscriptionWizard.this.getMySO().getConnection(), SubscriptionWizard.this.getMySO().getDDB()) : PublicationSO.getPublications(SubscriptionWizard.this.getMySO().getConnection(), SubscriptionWizard.this.getMySO().getDDB());
                if (this._panel.comboPublication.getItemCount() > 0) {
                    this._panel.comboPublication.removeAllItems();
                }
                while (enumeration.hasMoreElements()) {
                    String string = ((PublicationSO)enumeration.nextElement()).getDisplayName();
                    JLabel jLabel = new JLabel(string, PublicationBO.PUBLICATION_ICON, 0);
                    this._panel.comboPublication.addItem((Object)jLabel);
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
            }
        }

        private String getPublication() {
            String string = null;
            JLabel jLabel = (JLabel)this._panel.comboPublication.getSelectedItem();
            if (jLabel != null) {
                string = jLabel.getText();
            }
            return string;
        }

        @Override
        public void releaseResources() {
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class SubWizBOPage2
    extends ASEBaseWizardPage2 {
        private SubWizGOPage2 _panel;

        public SubWizBOPage2(SubscriptionWizard subscriptionWizard2) {
            super(subscriptionWizard2, (JPanel)((Object)new SubWizGOPage2()), ASEUtils.getString("MSG_ADD_SUB_WIZ_CONN"));
            this._panel = (SubWizGOPage2)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.Publication.setText(SubscriptionWizard.this._subSO.getPublication());
            this._panel.comboConnection.setRenderer((ListCellRenderer)new MyCellRenderer());
            this.loadConnections();
        }

        @Override
        public void enableComponents() {
            this.SetWizardButtons();
        }

        @Override
        public int onWizardNext() {
            SubscriptionWizard.this.getMySO().setServer(this.getServer());
            SubscriptionWizard.this.getMySO().setDatabase(this.getDatabase());
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = ASEUtils.getString("SUM_SUB_CONN");
            ASEMessageText aSEMessageText = new ASEMessageText(string, this.getSelectedConnection());
            String string2 = aSEMessageText.toString();
            string = ASEUtils.getString("SUM_SUB_PUB");
            aSEMessageText = new ASEMessageText(string, this._panel.Publication.getText());
            string2 = string2 + aSEMessageText.toString();
            return string2;
        }

        private void SetWizardButtons() {
            this.enableNextButton(this.getConnection() != null && this.getSelectedConnection().length() > 0);
        }

        private void loadConnections() {
            try {
                SubscriptionSO subscriptionSO = SubscriptionWizard.this.getMySO();
                ConnectionSO connectionSO = subscriptionSO.getConnectionSO();
                ReplicationSO replicationSO = connectionSO.getReplicationSO();
                Enumeration enumeration = ConnectionSO.getReplicateConnections(SubscriptionWizard.this.getMySO().getConnection(), SubscriptionWizard.this.getMySO().getDDB(), replicationSO);
                if (this._panel.comboConnection.getItemCount() > 0) {
                    this._panel.comboConnection.removeAllItems();
                }
                ImageIcon imageIcon = new ImageIcon(RLImages.getRConnUpSmallImage());
                while (enumeration.hasMoreElements()) {
                    String string = ((ConnectionSO)enumeration.nextElement()).getDisplayName();
                    JLabel jLabel = new JLabel(string, imageIcon, 0);
                    this._panel.comboConnection.addItem((Object)jLabel);
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), ASEMessageText.toString(sQLException), sQLException);
            }
        }

        private String getSelectedConnection() {
            String string = "";
            JLabel jLabel = (JLabel)this._panel.comboConnection.getSelectedItem();
            if (jLabel != null) {
                string = jLabel.getText();
            }
            return string;
        }

        private String getServer() {
            String string = this.getSelectedConnection();
            Debug.wassert(string != null && string.length() > 0, this, "Null or empty connection");
            String string2 = string.substring(0, string.indexOf("."));
            return string2;
        }

        private String getDatabase() {
            String string = this.getSelectedConnection();
            Debug.wassert(string != null && string.length() > 0, this, "Null or empty connection");
            String string2 = string.substring(string.indexOf(".") + 1);
            return string2;
        }

        @Override
        public void releaseResources() {
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }

    class SubWizBOPage1
    extends ASEBaseWizardPage2
    implements DocumentListener {
        private SubWizGOPage1 _panel;

        public SubWizBOPage1(SubscriptionWizard subscriptionWizard2) {
            super(subscriptionWizard2, (JPanel)((Object)new SubWizGOPage1()), ASEUtils.getString("MSG_ADD_SUB_WIZ_TITLE"));
            this._panel = (SubWizGOPage1)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._panel.textfName.getDocument().addDocumentListener(this);
        }

        @Override
        public void enableComponents() {
            this.SetWizardButtons();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.SetWizardButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.SetWizardButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.SetWizardButtons();
        }

        @Override
        public int onWizardNext() {
            SubscriptionWizard.this.getMySO().setSubName(this._panel.textfName.getText());
            return super.onWizardNext();
        }

        public String getSummaryInfo() {
            String string = ASEUtils.getString("SUM_SUB_NAME");
            ASEMessageText aSEMessageText = new ASEMessageText(string, this._panel.textfName.getText());
            String string2 = aSEMessageText.toString();
            return string2;
        }

        private void SetWizardButtons() {
            this.enableNextButton(this._panel.textfName.getText() != null && this._panel.textfName.getText().length() > 0);
        }

        @Override
        public void releaseResources() {
            this._panel.textfName.getDocument().removeDocumentListener(this);
            this._panel.releaseResources();
            this._panel = null;
            super.releaseResources();
        }
    }
}

