/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.go.wiz.SummaryWizGOPage;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.PlainParser;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JPanel;

class SummaryWizBOPage
extends ASEBaseWizardPage2 {
    protected SummaryWizGOPage _go = (SummaryWizGOPage)((Object)this.getJPanel());
    private ArrayList<String> _labels;
    private ArrayList<String> _values;

    public SummaryWizBOPage(ASEBaseWizardDialog2 aSEBaseWizardDialog2, Image image) {
        this(aSEBaseWizardDialog2, image, ASEUtils.getString("MSG_SUMMARY_PAGE_WIZ"), false);
    }

    public SummaryWizBOPage(ASEBaseWizardDialog2 aSEBaseWizardDialog2, Image image, String string, boolean bl) {
        super(aSEBaseWizardDialog2, (JPanel)((Object)new SummaryWizGOPage(image)), string);
        if (!bl) {
            this._go.summaryTextEditor.setEditorType((Parser)PlainParser.getInstance());
        }
    }

    @Override
    public void releaseResources() {
        this._go.releaseResources();
        this._go = null;
        this._labels = null;
        this._values = null;
        super.releaseResources();
    }

    public void setSummaryInfo(String string) {
        this._go.summaryTextEditor.setText(string);
        this._go.summaryTextEditor.setCaretPosition(0);
    }

    public void setSummaryInfo() {
        this.setSummaryInfo(this.getSummary());
    }

    public void clearSummaryItems() {
        if (this._labels != null) {
            this._labels.clear();
        }
        if (this._values != null) {
            this._values.clear();
        }
    }

    public void addSummaryItem() {
        this.addSummaryItem("", "");
    }

    public void addSummaryItem(String string, String string2) {
        String string3;
        if (string == null) {
            return;
        }
        if (this._labels == null) {
            this._labels = new ArrayList();
            this._values = new ArrayList();
        }
        if ((string3 = string).endsWith(":")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        this._labels.add(string3);
        this._values.add(string2);
    }

    public void addSummaryItem(String string, int n) {
        this.addSummaryItem(string, String.valueOf(n));
    }

    public void addSummaryItem(String string, boolean bl) {
        this.addSummaryItem(string, Support.getYesNoString(bl));
    }

    public String getSummary() {
        this._go.summaryTextEditor.setLineWrap(false);
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getMaxLabelWidth();
        int n2 = this.getMaxValueWidth();
        if (n + n2 > 65 && n > 20) {
            n = 10;
        }
        for (int i = 0; i < this._labels.size(); ++i) {
            String string = this._labels.get(i);
            String string2 = this._values.get(i);
            stringBuffer.append(this.spacePad(string, n) + (string.length() > 0 ? " : " : "   ") + string2 + "\n");
        }
        return stringBuffer.toString();
    }

    private int getMaxWidth(ArrayList<String> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            String[] stringArray = string.split("\r\n|\r|\n");
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                if (string2.length() <= n) continue;
                n = string2.length();
            }
        }
        return n;
    }

    private int getMaxLabelWidth() {
        return this.getMaxWidth(this._labels);
    }

    private int getMaxValueWidth() {
        return this.getMaxWidth(this._values);
    }

    private String spacePad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Locale locale = Locale.getDefault();
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            if (locale.getLanguage().equals("en")) {
                stringBuffer.append(" ");
                continue;
            }
            if (!locale.getLanguage().equals("zh") && !locale.getLanguage().equals("ja")) continue;
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    public String getFinishLineText() {
        return this._go.finishMultiLineLabel.getText();
    }

    public String getSummaryLineText() {
        return this._go.summaryMultiLineLabel.getText();
    }

    public void setFinishLineText(String string) {
        this._go.finishMultiLineLabel.setText(string);
    }

    public void setSummaryLineText(String string) {
        this._go.summaryMultiLineLabel.setText(string);
    }
}

