/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.ColumnBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TriggerBO;
import com.sybase.aseplugin.bo.TriggersCtrBO;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.ASECodeWizardDialog;
import com.sybase.aseplugin.bo.wiz.NameOwnerTemplateWizPage;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.TriggerWizGOTypePage;
import com.sybase.aseplugin.go.wiz.WizEditorGOPage;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.ColumnsCtrSO;
import com.sybase.aseplugin.so.TriggerSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import com.sybase.central.editor.EditorEvent;
import com.sybase.central.editor.EditorListener;
import com.sybase.central.editor.SCEditorFrame;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JPanel;

public class TriggerWizard
extends ASECodeWizardDialog {
    private TriggerSO _tso;
    public boolean _eventAlt;

    public TriggerWizard(TriggerSO triggerSO, TriggersCtrBO triggersCtrBO) {
        super(triggerSO, (SCContainer2)triggersCtrBO, ASEUtils.getString("MSG_ADD_TRIGGER"), new TriggerBO(triggerSO, triggersCtrBO));
        this._tso = triggerSO;
    }

    @Override
    NameOwnerTemplateWizPage getNamePage() {
        return new TriggerWizNamePage(this);
    }

    @Override
    SCPageController[] getOtherPages() {
        return new SCPageController[]{new TriggerWizTypePage(this), new TriggerWizSQLPage(this), new TriggerWizSummaryPage(this)};
    }

    @Override
    public void releaseResources() {
        this._tso = null;
        super.releaseResources();
    }

    class TriggerWizSummaryPage
    extends SummaryWizBOPage {
        public TriggerWizSummaryPage(TriggerWizard triggerWizard2) {
            super(triggerWizard2, ASEImages.getTriggerWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("DISP_NAME_TEXT"), TriggerWizard.this._tso.getName());
            ArrayList<String> arrayList = new ArrayList<String>();
            if (TriggerWizard.this._tso.isDeleteTrigger()) {
                arrayList.add("Delete");
            }
            if (TriggerWizard.this._tso.isInsertTrigger()) {
                arrayList.add("Insert");
            }
            if (TriggerWizard.this._tso.isUpdateTrigger()) {
                arrayList.add("Update");
            }
            if (TriggerWizard.this._tso.isUpdateOfTrigger()) {
                arrayList.add("Update Columns");
            }
            this.addSummaryItem(ASEUtils.getString("MSG_TYPE_OF_TRIGGER"), Utility.stringArrayToString(arrayList.toArray(), ", "));
            this.addSummaryItem();
            this.addSummaryItem(ASEUtils.getString("LOG_SQL_EDIT_TITLE"), "\n" + TriggerWizard.this._tso.getSQLText());
            this.setSummaryInfo(this.getSummary());
        }
    }

    class TriggerWizSQLPage
    extends ASEBaseWizardPage2
    implements ActionListener,
    EditorListener {
        private WizEditorGOPage _go;
        TriggerBO _bo;

        public TriggerWizSQLPage(TriggerWizard triggerWizard2) {
            super(triggerWizard2, (JPanel)((Object)new WizEditorGOPage(ASEImages.getTriggerWizardImage())), ASEUtils.getString("MSG_EDITOR_WIZ_PAGE"));
            this._go = (WizEditorGOPage)((Object)this.getJPanel());
            this._bo = new TriggerBO(TriggerWizard.this._tso, (TriggersCtrBO)((TriggerWizard)this.getParent()).getParent());
            this._bo.setMenuToolTipText(ASEUtils.getString("EDIT_MENU_SAVE_SQL"), Support.getMnemonic("EDIT_MNEM_SAVE_SQL"), ASEUtils.getString("EDIT_TTIP_SAVE_SQL"), TriggerSO.TMPL_DEFAULT_NAME);
        }

        @Override
        public void init() {
            this._go.sqlEditorButton.addActionListener((ActionListener)this);
            this._go.loadButton.addActionListener((ActionListener)this);
        }

        @Override
        public void enableComponents() {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("LABC_PROVIDE_SQL"), this._so.getName());
            this._go.introLabel.setText(aSEMessageText.toString());
            this.setWizardText();
            this.enableNextButton(true);
            this.enableFinishButton(true);
        }

        private void setWizardText() {
            if (TriggerWizard.this._eventAlt) {
                this._go.sqlEditor.setText(this.getWizardText());
                TriggerWizard.this._eventAlt = false;
            } else {
                this._go.sqlEditor.setText(TriggerWizard.this._tso.getSQLText());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.sqlEditorButton) {
                TriggerWizard.this._tso.setSQLText(this._go.sqlEditor.getText());
                if (this._bo.getEditor() == null) {
                    this.setComponentsEnabled(false);
                    this._bo.openEditor(false);
                    this._bo.getEditor().addEditorListener((EditorListener)this);
                } else {
                    this.setComponentsEnabled(true);
                    ((SCEditorFrame)this._bo.getEditor()).exitActionPerformed();
                }
            } else {
                try {
                    int n = 2;
                    String string = Support.browseForFile(Support.getViewerFrame(), ASEProvider.getSybaseOrSybrootDir(), null, n);
                    if (string != null) {
                        this._go.sqlEditor.setText(Support.readSQLFile(string));
                    }
                }
                catch (IOException iOException) {
                    Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
                }
            }
        }

        private String getWizardText() {
            Pattern pattern;
            Matcher matcher;
            String string = this._go.sqlEditor.getText();
            String[] stringArray = null;
            String[] stringArray2 = TriggerWizard.this._tso.getColumns();
            if (stringArray2 != null && stringArray2.length > 0) {
                stringArray = new String[stringArray2.length];
            }
            if ((matcher = (pattern = Pattern.compile("[/\\s]+as[/\\s]+", 2)).matcher(string)).find()) {
                string = (string.charAt(matcher.end() - 1) == '/' ? "/" : "") + string.substring(matcher.end());
                if (TriggerWizard.this._tso.isUpdateOfTrigger()) {
                    pattern = Pattern.compile("if[\\s]+update", 2);
                    String[] stringArray3 = pattern.split(string);
                    block0: for (int i = 0; i < stringArray2.length; ++i) {
                        for (int j = 0; j < stringArray3.length; ++j) {
                            pattern = Pattern.compile("[(][\\s]*" + stringArray2[i] + "[\\s]*[)]", 2);
                            if (!pattern.matcher(stringArray3[j]).find()) continue;
                            stringArray[i] = stringArray3[j];
                            continue block0;
                        }
                    }
                } else {
                    pattern = Pattern.compile("if[\\s]+update", 2);
                    if (pattern.matcher(string).find()) {
                        string = "begin\n    \nend";
                    }
                }
            } else {
                string = "begin\n    \nend";
            }
            String string2 = "create trigger " + TriggerWizard.this._tso.getOwner() + "." + this._so.getName() + " on " + TriggerWizard.this._tso.getTable().getOwner() + "." + TriggerWizard.this._tso.getTableName();
            String string3 = "";
            if (TriggerWizard.this._tso.isInsertTrigger()) {
                string3 = string3 + "insert";
            }
            if (TriggerWizard.this._tso.isDeleteTrigger()) {
                if (string3.length() != 0) {
                    string3 = string3 + ", ";
                }
                string3 = string3 + "delete";
            }
            if (TriggerWizard.this._tso.isUpdateTrigger() || TriggerWizard.this._tso.isUpdateOfTrigger()) {
                if (string3.length() != 0) {
                    string3 = string3 + ", ";
                }
                string3 = string3 + "update";
            }
            string3 = string3 + " as";
            String string4 = "";
            if (TriggerWizard.this._tso.isUpdateOfTrigger()) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray[i] == null) {
                        string4 = string4 + "if update (" + stringArray2[i] + ")" + "\n";
                        string4 = string4 + "begin\n    \nend" + "\n\n";
                        continue;
                    }
                    string4 = string4 + "if update" + stringArray[i];
                }
            } else {
                string4 = string4 + string;
            }
            String string5 = string2 + "\n" + "for " + string3 + "\n" + string4;
            return string5;
        }

        public void editorClosed(EditorEvent editorEvent) {
            this.setComponentsEnabled(true);
            this._bo.editorClosed(editorEvent);
        }

        public void editorSaveRequested(EditorEvent editorEvent) {
            this._go.sqlEditor.setText(editorEvent.getEditor().getText());
            this.setComponentsEnabled(true);
            this._bo.setSaveObject(false);
        }

        @Override
        public boolean deploy() {
            TriggerWizard.this._tso.setSQLText(this._go.sqlEditor.getText());
            return true;
        }

        @Override
        public void releaseResources() {
            if (this._bo.getEditor() != null) {
                ((SCEditorFrame)this._bo.getEditor()).setChanged(false);
                ((SCEditorFrame)this._bo.getEditor()).exitActionPerformed();
            }
            this._go.sqlEditorButton.removeActionListener((ActionListener)this);
            this._go.loadButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }

        private void setComponentsEnabled(boolean bl) {
            if (bl) {
                this._go.sqlEditorButton.setText(ASEUtils.getString("BTTN_SQL_EDITOR"));
                this._go.sqlEditorButton.setMnemonic(ASEUtils.getMnemonic("MNEM_SQL_EDITOR"));
            } else {
                this._go.sqlEditorButton.setText(ASEUtils.getString("BTTN_CLOSE_SQL_EDITOR"));
                this._go.sqlEditorButton.setMnemonic(ASEUtils.getMnemonic("MNEM_CLOSE_SQL_EDITOR"));
            }
            this._go.sqlEditor.setEnabled(bl);
            this._go.loadButton.setEnabled(bl);
            this._go.setEnabledPreviewButton(bl);
            this._go.setEnabledScheduleButton(bl);
            this.enableBackButton(bl);
            this.enableNextButton(bl);
            this.enableFinishButton(bl);
        }
    }

    class TriggerWizTypePage
    extends ASEBaseWizardPage2
    implements ActionListener,
    ItemListener,
    ASAListCheckListener {
        private TriggerWizGOTypePage _go;
        private boolean _asked;

        public TriggerWizTypePage(TriggerWizard triggerWizard2) {
            super(triggerWizard2, (JPanel)((Object)new TriggerWizGOTypePage()), ASEUtils.getString("MSG_TRIG_WIZ_PAGE2"));
            this._go = (TriggerWizGOTypePage)((Object)this.getJPanel());
            this._go.insertCheckBox.addItemListener((ItemListener)this);
            this._go.deleteCheckBox.addItemListener((ItemListener)this);
            this._go.updateCheckBox.addItemListener((ItemListener)this);
            this._go.updateOfColumnsCheckBox.addItemListener((ItemListener)this);
            this._go.columnsMultiCheckList.addListCheckListener((ASAListCheckListener)this);
            this._go.selectAllButton.addActionListener((ActionListener)this);
            this._go.clearAllButton.addActionListener((ActionListener)this);
            this._asked = false;
            this.initColumns();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._go.selectAllButton) {
                this.selectAllColumns();
            } else if (object == this._go.clearAllButton) {
                this.clearAllColumns();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.enableComponents();
        }

        public void valueChanged(ASAListCheckEvent aSAListCheckEvent) {
            this.enableComponents();
        }

        private void initColumns() {
            ColumnsCtrSO columnsCtrSO = new ColumnsCtrSO(TriggerWizard.this._tso.getConnection(), TriggerWizard.this._tso.getTable());
            try {
                List list = columnsCtrSO.open(1);
                this._go.columnsMultiCheckList.clear();
                for (ColumnSO columnSO : list) {
                    String string = columnSO.getName();
                    ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)ColumnBO.getIcon(columnSO), string);
                    this._go.columnsMultiCheckList.addRow(new Object[]{aSAIconTextData});
                }
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            }
        }

        private void selectAllColumns() {
            this._go.columnsMultiCheckList.checkAllRows();
            this.enableComponents();
        }

        private void clearAllColumns() {
            this._go.columnsMultiCheckList.uncheckAllRows();
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.insertCheckBox.isSelected();
            boolean bl2 = this._go.deleteCheckBox.isSelected();
            boolean bl3 = this._go.updateCheckBox.isSelected();
            boolean bl4 = this._go.updateOfColumnsCheckBox.isSelected();
            this._go.insertCheckBox.setEnabled(!bl4);
            this._go.deleteCheckBox.setEnabled(!bl4);
            this._go.updateCheckBox.setEnabled(!bl4);
            this._go.updateOfColumnsCheckBox.setEnabled(!bl && !bl2 && !bl3);
            this._go.columnsMultiCheckList.setEnabled(bl4);
            this._go.selectAllButton.setEnabled(bl4);
            this._go.clearAllButton.setEnabled(bl4);
            boolean bl5 = bl || bl2 || bl3 || bl4 && this._go.columnsMultiCheckList.getCheckedRowCount() > 0;
            this.enableNextButton(bl5);
            this._asked = false;
        }

        @Override
        public boolean deploy() {
            if (TriggerWizard.this._namePage.usingTemplate()) {
                return true;
            }
            TriggerWizard.this._eventAlt = true;
            try {
                boolean bl = this._go.insertCheckBox.isSelected();
                boolean bl2 = this._go.deleteCheckBox.isSelected();
                boolean bl3 = this._go.updateCheckBox.isSelected();
                boolean bl4 = this._go.updateOfColumnsCheckBox.isSelected();
                if (bl4) {
                    int[] nArray = this._go.columnsMultiCheckList.getCheckedRows();
                    int n = nArray.length;
                    Object[] objectArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = this._go.columnsMultiCheckList.getStringAt(nArray[i], 0);
                    }
                    TriggerWizard.this._tso.setColumns(objectArray);
                    TriggerWizard.this._tso.setTriggerType(8);
                } else {
                    int n = 0;
                    if (bl) {
                        n |= 1;
                    }
                    if (bl2) {
                        n |= 4;
                    }
                    if (bl3) {
                        n |= 2;
                    }
                    TriggerWizard.this._tso.setTriggerType(n);
                }
                boolean bl5 = TriggerWizard.this._tso.typeExists();
                if (bl5 && !this._asked) {
                    String string = ASEUtils.getString("ERR_OVERWRITE_TRIGGER");
                    int n = Support.showQuestionYesNo(this.getJDialog(), string);
                    this._asked = n == 0;
                    return this._asked;
                }
                return true;
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return false;
            }
        }

        @Override
        public void releaseResources() {
            this._go.insertCheckBox.removeItemListener((ItemListener)this);
            this._go.deleteCheckBox.removeItemListener((ItemListener)this);
            this._go.updateCheckBox.removeItemListener((ItemListener)this);
            this._go.updateOfColumnsCheckBox.removeItemListener((ItemListener)this);
            this._go.columnsMultiCheckList.removeListCheckListener((ASAListCheckListener)this);
            this._go.selectAllButton.removeActionListener((ActionListener)this);
            this._go.clearAllButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class TriggerWizNamePage
    extends NameOwnerTemplateWizPage {
        public TriggerWizNamePage(TriggerWizard triggerWizard2) {
            super(triggerWizard2, ASEImages.getTriggerWizardImage(), ASEUtils.getString("TRIGGER_WIZ_SENT_WELCOME"), ASEUtils.getString("TRIGGER_WIZ_SENT_INTRO"), ASEUtils.getString("TRIGGER_WIZ_QUES_NAME"), ASEUtils.getString("TRIGGER_WIZ_QUES_CREATOR"), TriggerWizard.this._tso);
        }

        @Override
        public List<String[]> getOwnerList() throws SQLException {
            this.setDefaultOwner(TriggerWizard.this._tso.getDatabaseSO().getCurrentUser());
            return TriggerWizard.this._tso.getOwnerList();
        }
    }
}

