/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextUserData;
import com.sybase.asa.ASAMultiListTableModel;
import com.sybase.asa.ASAUtils;
import com.sybase.asa.MessageText;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEBaseContainer2;
import com.sybase.aseplugin.bo.ASEBaseHeader;
import com.sybase.aseplugin.bo.ASEBaseItem2;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.IndexBO;
import com.sybase.aseplugin.bo.IndexesCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.TableBO;
import com.sybase.aseplugin.bo.UniqueConstraintBO;
import com.sybase.aseplugin.bo.UniqueConstraintDetailsBO;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.UpdateStatPartitionWizGOOptionsPage;
import com.sybase.aseplugin.go.wiz.UpdateStatWizGOConsumersPage;
import com.sybase.aseplugin.go.wiz.UpdateStatWizGOIntroPage;
import com.sybase.aseplugin.go.wiz.UpdateStatWizGOSamplingPage;
import com.sybase.aseplugin.go.wiz.UpdateStatWizGOStepsPage;
import com.sybase.aseplugin.go.wiz.UpdateStatWizGOTablePage;
import com.sybase.aseplugin.go.wiz.UpdateStatWizGOThresholdPage;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.ASEBaseSO;
import com.sybase.aseplugin.so.ColumnSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.IndexSO;
import com.sybase.aseplugin.so.PartitionSO;
import com.sybase.aseplugin.so.PartitionsCtrSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.UniqueConstraintSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCPageController;
import com.sybase.ua.util.ProcessInfo;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UpdateStatWizard
extends ASEBaseWizardDialog2 {
    private UpdateStatWizIntroPage _introPage;
    private UpdateStatWizTablePage _tablePage;
    private UpdateStatWizSamplingPage _samplingPage;
    private UpdateStatWizStepsPage _stepsPage;
    private UpdateStatWizConsumersPage _consumersPage;
    private UpdateStatWizThresholdPage _thresholdPage;
    private Integer _cmdId;
    private HashMap _introTitleMap;
    private HashMap _introTextMap;
    private HashMap _introLabelMap;
    private boolean _isUpdate = false;
    private boolean _isDelete = false;
    private boolean _isDisplay = false;
    private DatabaseSO _dbSO = null;
    private TableSO _tableSO = null;
    private IndexSO _indexSO = null;
    private ColumnSO _columnSO = null;
    private PartitionSO _partitionSO = null;
    private IndexesCtrBO _indexesCtrBO;
    private UniqueConstraintDetailsBO _uniquesCtrBO;
    private ASConnection _asConn;
    private ArrayList _targets;
    private String _optdiagPath;
    private String _aseHome;

    public UpdateStatWizard(TableSO tableSO, ArrayList arrayList, IndexesCtrBO indexesCtrBO, int n, SCContainer2 sCContainer2) {
        super((SOItemInterface)tableSO, sCContainer2);
        this._tableSO = tableSO;
        this._asConn = this._tableSO.getConnection();
        this._targets = arrayList;
        this._indexesCtrBO = indexesCtrBO;
        this._uniquesCtrBO = indexesCtrBO.getUniqueContraintDetailsBO();
        this._cmdId = new Integer(n);
        this.initMaps();
    }

    public UpdateStatWizard(IndexSO indexSO, ArrayList arrayList, int n, SCContainer2 sCContainer2) {
        super((SOItemInterface)indexSO, sCContainer2);
        this._indexSO = indexSO;
        this._asConn = this._indexSO.getConnection();
        this._targets = arrayList;
        this._cmdId = new Integer(n);
        this.initMaps();
    }

    public UpdateStatWizard(ColumnSO columnSO, ArrayList arrayList, int n, SCContainer2 sCContainer2) {
        super((SOItemInterface)columnSO, sCContainer2);
        this._columnSO = columnSO;
        this._asConn = this._columnSO.getConnection();
        this._targets = arrayList;
        this._cmdId = new Integer(n);
        this.initMaps();
    }

    public UpdateStatWizard(PartitionSO partitionSO, ArrayList arrayList, int n, SCContainer2 sCContainer2) {
        super((SOItemInterface)partitionSO, sCContainer2);
        this._partitionSO = partitionSO;
        this._asConn = this._partitionSO.getConnection();
        this._targets = arrayList;
        this._cmdId = new Integer(n);
        this.initMaps();
    }

    public UpdateStatWizard(DatabaseSO databaseSO, ArrayList arrayList, int n, SCContainer2 sCContainer2) {
        super((SOItemInterface)databaseSO, sCContainer2);
        this._dbSO = databaseSO;
        this._asConn = this._dbSO.getConnection();
        this._targets = arrayList;
        this._cmdId = new Integer(n);
        this.initMaps();
    }

    public ServerSO getServerSO() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        return (ServerSO)serverBO.getSO();
    }

    public String getASEHome() {
        if (this._aseHome == null) {
            try {
                this._aseHome = this.getServerSO().getDiscoveryProperty("aseHome");
            }
            catch (Exception exception) {
                this._aseHome = null;
            }
        }
        return this._aseHome;
    }

    public String getOptdiagPath() {
        if (this._optdiagPath == null) {
            ServerSO serverSO = this.getServerSO();
            try {
                String string = serverSO.getFileSeparator();
                String string2 = string.equals("/") ? "optdiag" : "optdiag.exe";
                this._optdiagPath = this.getASEHome() + string + "bin" + string + string2;
            }
            catch (Exception exception) {
                this._optdiagPath = null;
            }
        }
        return this._optdiagPath;
    }

    @Override
    public SCPageController[] getPages() {
        this._introPage = new UpdateStatWizIntroPage(this);
        ArrayList<ASEBaseWizardPage2> arrayList = new ArrayList<ASEBaseWizardPage2>();
        arrayList.add(this._introPage);
        if (this._isDelete || this._isDisplay) {
            arrayList.add(new UpdateStatWizSummaryPage(this));
        } else if (this._partitionSO == null) {
            if (this._tableSO != null) {
                this._tablePage = new UpdateStatWizTablePage(this);
                arrayList.add(this._tablePage);
            }
            if (this._asConn.getVersion().compareTo("12.5.0.3") >= 0) {
                this._samplingPage = new UpdateStatWizSamplingPage(this);
                arrayList.add(this._samplingPage);
            }
            this._stepsPage = new UpdateStatWizStepsPage(this);
            arrayList.add(this._stepsPage);
            boolean bl = false;
            try {
                bl = this.getTableSO().updateStatCanUseConsumers();
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), sQLException.getMessage(), sQLException);
            }
            if (this._columnSO != null && bl) {
                this._consumersPage = new UpdateStatWizConsumersPage(this);
                arrayList.add(this._consumersPage);
            }
            if (this._asConn.getVersion().compareTo("15") >= 0) {
                this._thresholdPage = new UpdateStatWizThresholdPage(this);
                arrayList.add(this._thresholdPage);
            }
            arrayList.add(new UpdateStatWizSummaryPage(this));
        } else {
            arrayList.add(new UpdateStatWizPartitionPage(this));
            if (this._asConn.getVersion().compareTo("12.5.0.3") >= 0) {
                this._samplingPage = new UpdateStatWizSamplingPage(this);
                arrayList.add(this._samplingPage);
            }
            this._stepsPage = new UpdateStatWizStepsPage(this);
            arrayList.add(this._stepsPage);
            arrayList.add(new UpdateStatWizSummaryPage(this));
        }
        return arrayList.toArray(new SCPageController[arrayList.size()]);
    }

    private void updateStat() throws SQLException {
        if (this._tableSO != null) {
            this._tableSO.updateStat(this._tableSO);
        } else if (this._columnSO != null) {
            this.getTableSO().updateStat(this._columnSO, Support.getItemNames(this._targets, false, false));
        } else if (this._indexSO != null) {
            this.getTableSO().updateStat(this._indexSO, this._targets);
        } else if (this._partitionSO != null) {
            this.getTableSO().updateStat(this._partitionSO, this._targets);
        }
    }

    private void deleteStat() throws SQLException {
        if (this._tableSO != null) {
            this._tableSO.deleteStat(this._tableSO, Support.getItemNames(this._targets, true, true));
        } else if (this._columnSO != null) {
            this.getTableSO().deleteStat(this._columnSO, Support.getItemNames(this._targets, false, false));
        } else if (this._partitionSO != null) {
            this.getTableSO().deleteStat(this._partitionSO, Support.getItemNames(this._targets, false, false));
        }
    }

    private void appendDisplayStatHeading(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string2 + "--------------------------------------------------------------- \n-- ");
        stringBuffer.append(string + " " + ASEUtils.getString("DISPLAY_STAT_EDITOR_TITLE"));
        stringBuffer.append("\n");
        stringBuffer.append("--------------------------------------------------------------- \n");
    }

    private void displayStat() throws IOException {
        String string = Support.getFullTitle(ASEUtils.getString("DISPLAY_STAT_EDITOR_TITLE"), this._asConn);
        String string2 = this._asConn.getDisplayName() + " Optdiag";
        String string3 = "";
        for (int i = 0; i < this._targets.size(); ++i) {
            String string4;
            Object object;
            ASEBaseItem2 aSEBaseItem2 = (ASEBaseItem2)this._targets.get(i);
            String string5 = "";
            if (this._dbSO != null) {
                object = (DatabaseSO)aSEBaseItem2.getSO();
                string5 = ((ASEBaseSO)object).getName();
            } else if (this._tableSO != null) {
                object = (TableSO)aSEBaseItem2.getSO();
                string5 = ((TableSO)object).getFullyQualifiedName();
            } else if (this._columnSO != null) {
                object = (ColumnSO)aSEBaseItem2.getSO();
                string5 = this.getTableSO().getFullyQualifiedName() + "." + ((ASEBaseSO)object).getName();
            }
            object = TableSO.getDisplayStatCommand(this.getOptdiagPath(), this._asConn, string5, false, null);
            String string6 = this.getASEHome();
            Object[] objectArray = new Object[]{object, string6};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
            try {
                ProcessInfo processInfo = this.getServerSO().executeRemoteShell(objectArray, stringArray);
                string4 = processInfo.getOutput();
                continue;
            }
            catch (RemoteException remoteException) {
                string4 = TableSO.getDisplayStatCommand(this.getOptdiagPath(), this._asConn, string5, true, null);
                MessageText messageText = new MessageText(ASEUtils.getString("MSG_ERROR_EXECUTE_AGENT"), (Object)string4);
                Support.showDetailsError(this._asConn, this.getClass(), (Container)this.getJDialog(), messageText.toString(), remoteException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deploy() {
        SCDialogSupport sCDialogSupport = this.getDialogSupport();
        sCDialogSupport.startWait();
        try {
            if (this._isUpdate) {
                this.updateStat();
            } else if (this._isDelete) {
                this.deleteStat();
            } else if (this._isDisplay) {
                this.displayStat();
            }
        }
        catch (SQLException sQLException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), iOException.getMessage(), iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            sCDialogSupport.endWait();
        }
        return true;
    }

    @Override
    public String getTitle() {
        return this._introTitleMap.get(this._cmdId).toString();
    }

    private void initMaps() {
        this._introTitleMap = new HashMap();
        this._introTextMap = new HashMap();
        this._introLabelMap = new HashMap();
        if (this._cmdId == 3081) {
            this._introTitleMap.put(this._cmdId, ASEUtils.getString("CONTEXT_MENU_DELETE_STATISTICS_TEXT"));
            this._introTextMap.put(this._cmdId, ASEUtils.getString("UPDATE_STAT_WIZ_SENT_INTRO_DELETE"));
            this._introLabelMap.put(this._cmdId, ASEUtils.getString("UPDATE_STAT_WIZ_SENT_DELETE"));
            this._isDelete = true;
        } else if (this._cmdId == 3080) {
            this._introTitleMap.put(this._cmdId, ASEUtils.getString("CONTEXT_MENU_UPDATE_STATISTICS_TEXT"));
            this._introTextMap.put(this._cmdId, ASEUtils.getString("UPDATE_STAT_WIZ_SENT_INTRO_UPDATE"));
            this._introLabelMap.put(this._cmdId, ASEUtils.getString("UPDATE_STAT_WIZ_SENT_UPDATE"));
            this._isUpdate = true;
        } else if (this._cmdId == 3082) {
            this._introTitleMap.put(this._cmdId, ASEUtils.getString("CONTEXT_MENU_DISPLAY_STATISTICS_TEXT"));
            this._introTextMap.put(this._cmdId, ASEUtils.getString("UPDATE_STAT_WIZ_SENT_INTRO_DISPLAY"));
            this._introLabelMap.put(this._cmdId, ASEUtils.getString("UPDATE_STAT_WIZ_SENT_DISPLAY"));
            this._isDisplay = true;
        }
    }

    private TableSO getTableSO() {
        TableSO tableSO = this._tableSO;
        if (tableSO == null) {
            if (this._columnSO != null) {
                tableSO = this._columnSO.getTableSO();
            } else if (this._indexSO != null) {
                tableSO = this._indexSO.getTableSO();
            } else if (this._partitionSO != null) {
                tableSO = this._partitionSO.getTableSO();
            }
        }
        return tableSO;
    }

    @Override
    public void releaseResources() {
        this._introPage = null;
        this._tablePage = null;
        this._samplingPage = null;
        this._stepsPage = null;
        this._consumersPage = null;
        this._thresholdPage = null;
        this._introTitleMap = null;
        this._introTextMap = null;
        this._introLabelMap = null;
        this._dbSO = null;
        this._tableSO = null;
        this._indexSO = null;
        this._columnSO = null;
        this._indexesCtrBO = null;
        this._uniquesCtrBO = null;
        this._asConn = null;
        this._targets = null;
        super.releaseResources();
    }

    public class UpdateStatWizSummaryPage
    extends SummaryWizBOPage {
        public UpdateStatWizSummaryPage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, ASEImages.getDefaultWizardImage());
            if (UpdateStatWizard.this._isDisplay) {
                this._go.setDisplayPreviewButton(false);
                this._go.setDisplayScheduleButton(false);
            }
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            TableSO tableSO = UpdateStatWizard.this.getTableSO();
            ArrayList arrayList = Support.getItemNames(UpdateStatWizard.this._targets, false, true);
            String string = ASAUtils.buildStringList((Collection)arrayList, (String)", ", (char)'\u0000', (char)'\u0000', (boolean)false, (boolean)false);
            if (UpdateStatWizard.this._isUpdate) {
                this.addSummaryItem(ASEUtils.getString("LABC_TABLE"), tableSO.getName());
                if (UpdateStatWizard.this._tableSO == null) {
                    if (UpdateStatWizard.this._columnSO != null) {
                        this.addSummaryItem(ASEUtils.getString("LABC_COLUMNS"), string);
                    } else if (UpdateStatWizard.this._indexSO != null) {
                        this.addSummaryItem(ASEUtils.getString("DNAME_INDEXES"), string);
                    }
                    this.addSummaryItem(ASEUtils.getString("LABC_COMMAND"), "update statistics");
                } else {
                    String string2 = tableSO.getUpdateStatAllColumns() ? ASEUtils.getString("UPDATE_STAT_WIZ_TABLE_RADB_ALL_COLUMNS_INDEX") : ASEUtils.getString("UPDATE_STAT_WIZ_TABLE_RADB_LEADING_COLUMN_INDEX");
                    this.addSummaryItem(ASEUtils.getString("LABC_COMMAND"), tableSO.getUpdateStatAllColumns() ? "update index statistics" : "update statistics");
                    this.addSummaryItem("", string2);
                }
                if (tableSO.getUpdateStatSampling() != null) {
                    this.addSummaryItem(ASEUtils.getString("UPDATE_STAT_WIZ_LABC_SAMPLING"), tableSO.getUpdateStatSampling());
                }
                if (tableSO.getUpdateStatSteps() != null) {
                    this.addSummaryItem(ASEUtils.getString("UPDATE_STAT_WIZ_LABC_STEP_NUMBER"), tableSO.getUpdateStatSteps());
                }
                if (tableSO.getUpdateStatConsumers() > 1) {
                    this.addSummaryItem(ASEUtils.getString("UPDATE_STAT_WIZ_LABC_CONSUMER"), tableSO.getUpdateStatConsumers());
                }
                if (tableSO.getUpdateStatConsumers() > 1) {
                    this.addSummaryItem(ASEUtils.getString("UPDATE_STAT_WIZ_LABC_CONSUMER"), tableSO.getUpdateStatConsumers());
                }
                if (tableSO.getUseDataChange()) {
                    this.addSummaryItem(ASEUtils.getString("UPDATE_STAT_WIZ_LABC_DATAVALUE_THRESHOLD"), tableSO.getDatachangeThreshold());
                    this.addSummaryItem(ASEUtils.getString("UPDATE_STAT_WIZ_LABC_PARTITION"), tableSO.getDatachangePartition());
                }
            }
            if (UpdateStatWizard.this._isDelete) {
                if (UpdateStatWizard.this._tableSO != null) {
                    this.addSummaryItem(ASEUtils.getString("LABC_TABLE"), string);
                } else if (UpdateStatWizard.this._columnSO != null) {
                    this.addSummaryItem(ASEUtils.getString("LABC_COLUMNS"), string);
                }
                this.addSummaryItem(ASEUtils.getString("LABC_COMMAND"), "delete statistics");
            }
            if (UpdateStatWizard.this._isDisplay) {
                if (UpdateStatWizard.this._dbSO != null) {
                    this.addSummaryItem(ASEUtils.getString("DISP_DATABASE_TEXT"), string);
                } else if (UpdateStatWizard.this._tableSO != null) {
                    this.addSummaryItem(ASEUtils.getString("LABC_TABLE"), string);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.addSummaryItem(ASEUtils.getString("LABC_COMMAND"), TableSO.getDisplayStatCommand(UpdateStatWizard.this.getOptdiagPath(), UpdateStatWizard.this._asConn, arrayList.get(i).toString(), true, null));
                }
            }
            this.setSummaryInfo(this.getSummary());
        }
    }

    public class UpdateStatWizPartitionPage
    extends ASEBaseWizardPage2 {
        private UpdateStatPartitionWizGOOptionsPage _go;

        public UpdateStatWizPartitionPage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, (JPanel)((Object)new UpdateStatPartitionWizGOOptionsPage()), ASEUtils.getString("DISP_TYPE_TEXT"));
            this._go = (UpdateStatPartitionWizGOOptionsPage)((Object)this.getJPanel());
        }

        @Override
        public void init() {
            this._go.statsTypeLabel.setText(ASEUtils.getString("UPDATE_STAT_WIZ_PT_LABC_TYPE"));
            if (UpdateStatWizard.this._partitionSO.getPartitionType() == 2) {
                this._go.updateAllStatisticsRadioButton.setVisible(false);
                this._go.updateTableStatisticsRadioButton.setVisible(false);
            }
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public boolean deploy() {
            if (UpdateStatWizard.this._partitionSO.getPartitionType() == 2) {
                UpdateStatWizard.this.getTableSO().setUpdateStatPartitionType(2);
            }
            if (this._go.updateStatisticsRadioButton.isSelected()) {
                UpdateStatWizard.this.getTableSO().setUpdateStatType("update statistics");
            } else if (this._go.updateIndexStatisticsRadioButton.isSelected()) {
                UpdateStatWizard.this.getTableSO().setUpdateStatType("update index statistics");
            } else if (this._go.updateAllStatisticsRadioButton.isSelected()) {
                UpdateStatWizard.this.getTableSO().setUpdateStatType("update all statistics");
            } else {
                UpdateStatWizard.this.getTableSO().setUpdateStatType("update table statistics");
            }
            return true;
        }
    }

    public class UpdateStatWizThresholdPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private UpdateStatWizGOThresholdPage _go;

        public UpdateStatWizThresholdPage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, (JPanel)((Object)new UpdateStatWizGOThresholdPage()), ASEUtils.getString("UPDATE_STAT_WIZ_TITL_AUTO_UPDATE"));
            this._go = (UpdateStatWizGOThresholdPage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            this._go.datachangeThresholdCheckBox.addActionListener((ActionListener)this);
            PartitionsCtrSO partitionsCtrSO = new PartitionsCtrSO(this.getConnection(), UpdateStatWizard.this.getTableSO());
            List list = partitionsCtrSO.open(1, 1);
            for (PartitionSO partitionSO : list) {
                this._go.partitionComboBox.addItem((Object)partitionSO.getName());
            }
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this._go.datachangeThresholdCheckBox.isSelected();
            this._go.thresholdLabel.setEnabled(bl);
            this._go.thresholdSpinBox.setEnabled(bl);
            this._go.partitionLabel.setEnabled(bl);
            this._go.partitionComboBox.setEnabled(bl);
            if (this._go.getDisplayScheduleButton()) {
                this._go.datachangeThresholdLabel.setEnabled(bl);
            }
        }

        @Override
        public boolean deploy() {
            UpdateStatWizard.this.getTableSO().setUseDataChange(this._go.datachangeThresholdCheckBox.isSelected());
            UpdateStatWizard.this.getTableSO().setDatachangePartition((String)this._go.partitionComboBox.getSelectedItem());
            UpdateStatWizard.this.getTableSO().setDatachangeThreshold(this._go.thresholdSpinBox.getValue());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.datachangeThresholdCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class UpdateStatWizConsumersPage
    extends ASEBaseWizardPage2 {
        private UpdateStatWizGOConsumersPage _go;

        public UpdateStatWizConsumersPage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, (JPanel)((Object)new UpdateStatWizGOConsumersPage()), ASEUtils.getString("UPDATE_STAT_WIZ_TITL_CONSUMER"));
            this._go = (UpdateStatWizGOConsumersPage)((Object)this.getJPanel());
        }

        @Override
        public void init() throws SQLException {
            this._go.consumersSpinBox.setMaximum(UpdateStatWizard.this.getTableSO().getMaxOnlineEngines());
        }

        @Override
        public boolean deploy() {
            int n = this._go.consumersSpinBox.getValue();
            UpdateStatWizard.this.getTableSO().setUpdateStatConsumers(n);
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class UpdateStatWizStepsPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private UpdateStatWizGOStepsPage _go;

        public UpdateStatWizStepsPage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, (JPanel)((Object)new UpdateStatWizGOStepsPage()), ASEUtils.getString("UPDATE_STAT_WIZ_TITL_STEP_NUMBER"));
            this._go = (UpdateStatWizGOStepsPage)((Object)this.getJPanel());
            this._go.stepsCheckBox.addActionListener((ActionListener)this);
        }

        private boolean useSteps() {
            boolean bl = this._go.stepsCheckBox.isSelected();
            return bl;
        }

        @Override
        public void enableComponents() {
            boolean bl = this.useSteps();
            this._go.stepsLabel.setEnabled(bl);
            this._go.stepsSpinBox.setEnabled(bl);
            this.enableFinishButton(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.stepsCheckBox) {
                this.enableComponents();
                this._go.stepsSpinBox.requestFocusInWindow();
            }
        }

        @Override
        public boolean deploy() {
            if (this.useSteps()) {
                String string = this._go.stepsSpinBox.getTextField().getText();
                UpdateStatWizard.this.getTableSO().setUpdateStatSteps(string);
            } else {
                UpdateStatWizard.this.getTableSO().setUpdateStatSteps(null);
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.stepsCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class UpdateStatWizSamplingPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private UpdateStatWizGOSamplingPage _go;

        public UpdateStatWizSamplingPage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, (JPanel)((Object)new UpdateStatWizGOSamplingPage()), ASEUtils.getString("UPDATE_STAT_WIZ_TITL_SAMPLING"));
            this._go = (UpdateStatWizGOSamplingPage)((Object)this.getJPanel());
            this._go.samplingCheckBox.addActionListener((ActionListener)this);
        }

        private boolean useSampling() {
            boolean bl = this._go.samplingCheckBox.isSelected();
            return bl;
        }

        @Override
        public void enableComponents() {
            boolean bl = this.useSampling();
            this._go.samplingLabel.setEnabled(bl);
            this._go.samplingSpinBox.setEnabled(bl);
            this.enableFinishButton(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.samplingCheckBox) {
                this.enableComponents();
                this._go.samplingSpinBox.requestFocusInWindow();
            }
        }

        @Override
        public boolean deploy() {
            if (this.useSampling()) {
                String string = this._go.samplingSpinBox.getTextField().getText();
                UpdateStatWizard.this.getTableSO().setUpdateStatSampling(string);
            } else {
                UpdateStatWizard.this.getTableSO().setUpdateStatSampling(null);
            }
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.samplingCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class UpdateStatWizTablePage
    extends ASEBaseWizardPage2
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        private UpdateStatWizGOTablePage _go;

        public UpdateStatWizTablePage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, (JPanel)((Object)new UpdateStatWizGOTablePage()), ASEUtils.getString("MSG_OPTIONS"));
            this._go = (UpdateStatWizGOTablePage)((Object)this.getJPanel());
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("UPDATE_STAT_WIZ_TABLE_LABC_INDEXES"), UpdateStatWizard.this._tableSO.getName());
            this._go.indexesLabel.setText(aSEMessageText.toString());
            String string = "<HTML>" + ASEUtils.getString("UPDATE_STAT_WIZ_TABLE_RADB_LEADING_COLUMN_INDEX") + "<BR>('update statistics')</HTML>";
            this._go.leadingColumnRadioButton.setText(string);
            string = "<HTML>" + ASEUtils.getString("UPDATE_STAT_WIZ_TABLE_RADB_ALL_COLUMNS_INDEX") + "<BR>('update index statistics')</HTML>";
            this._go.indexColumnsRadioButton.setText(string);
        }

        @Override
        public void init() throws SQLException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            String string2;
            Object object5;
            String string3;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            UpdateStatWizard.this._indexesCtrBO.open(1);
            ArrayList arrayList = Support.enumToArrayList(UpdateStatWizard.this._indexesCtrBO.getItems());
            if (arrayList.size() > 0) {
                arrayList.remove(0);
            }
            ASEBaseHeader[] aSEBaseHeaderArray = UpdateStatWizard.this._indexesCtrBO.getHeadings();
            Vector<String> vector = new Vector<String>();
            vector.add(aSEBaseHeaderArray[0].getText());
            vector.add(aSEBaseHeaderArray[1].getText());
            vector.add(ASEUtils.getString("MSG_COLUMNS"));
            this._go.indexesMultiList.setModel(new ASAMultiListTableModel(vector, 0));
            for (int i = 0; i < arrayList.size(); ++i) {
                Vector<Object> vector2 = new Vector<Object>();
                if (!(arrayList.get(i) instanceof IndexBO)) continue;
                object10 = (IndexBO)arrayList.get(i);
                object9 = (ImageIcon)((ASEBaseContainer2)object10).getImage(false);
                object8 = ((ASEBaseContainer2)object10).getDisplayName(0);
                object7 = (IndexSO)((ASEBaseItem2)object10).getSO();
                object6 = new ASAIconTextUserData((Icon)object9, (String)object8, object7);
                vector2.add(object6);
                string3 = ((ASEBaseContainer2)object10).getDisplayName(1);
                object5 = new ASAIconTextData(string3);
                vector2.add(object5);
                string2 = "";
                string = "";
                object4 = ((IndexSO)object7).getColumnNameOrderList();
                object3 = ((Vector)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (Vector)object3.next();
                    object = (String)((Vector)object2).elementAt(0);
                    string2 = string2 + string + (String)object;
                    string = ", ";
                }
                object3 = new ASAIconTextData(string2);
                vector2.add(object3);
                this._go.indexesMultiList.addRow(vector2);
            }
            UpdateStatWizard.this._uniquesCtrBO.open(1);
            ArrayList arrayList2 = Support.enumToArrayList(UpdateStatWizard.this._uniquesCtrBO.getItems());
            if (arrayList2.size() > 0) {
                arrayList2.remove(0);
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                object10 = new Vector();
                object9 = (UniqueConstraintBO)arrayList2.get(i);
                object8 = (ImageIcon)((ASEBaseItem2)object9).getImage(false);
                object7 = ((ASEBaseItem2)object9).getDisplayName(0);
                object6 = (UniqueConstraintSO)((ASEBaseItem2)object9).getSO();
                string3 = new ASAIconTextUserData((Icon)object8, (String)object7, object6);
                ((Vector)object10).add(string3);
                object5 = ((ASEBaseItem2)object9).getDisplayName(1);
                string2 = new ASAIconTextData((String)object5);
                ((Vector)object10).add(string2);
                string = "";
                object4 = "";
                object3 = ((UniqueConstraintSO)object6).getIndexedColumns();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (ColumnSO)object2.next();
                    String string4 = ((ASEBaseSO)object).getName();
                    string = string + (String)object4 + string4;
                    object4 = ", ";
                }
                object2 = new ASAIconTextData(string);
                ((Vector)object10).add(object2);
                this._go.indexesMultiList.addRow((Vector)object10);
            }
            this._go.indexesMultiList.setColumnHasIconTextData(0, true);
            this._go.propertiesButton.setEnabled(false);
            this._go.indexesMultiList.addListSelectionListener((ListSelectionListener)this);
            this._go.indexesMultiList.addMouseListener((MouseListener)this);
            this._go.propertiesButton.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.propertiesButton) {
                this.showProperties();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                this.showProperties();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = this._go.indexesMultiList.getSelectedRowCount() > 0;
            this._go.propertiesButton.setEnabled(bl);
        }

        private void showProperties() {
            int[] nArray = this._go.indexesMultiList.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                ASEBaseItemSO aSEBaseItemSO = (ASEBaseItemSO)this._go.indexesMultiList.getUserDataAt(nArray[i], 0);
                TableBO tableBO = (TableBO)UpdateStatWizard.this._indexesCtrBO.getParent();
                DatabaseBO databaseBO = (DatabaseBO)tableBO.getParent().getParent();
                String string = this._go.indexesMultiList.getStringAt(nArray[i], 0);
                if (aSEBaseItemSO instanceof UniqueConstraintSO) {
                    ContainerViewBO.openUCProperties(databaseBO, tableBO, string);
                    continue;
                }
                ContainerViewBO.openIndexProperties(databaseBO, tableBO, string);
            }
        }

        @Override
        public void enableComponents() {
            this.enableFinishButton(true);
        }

        @Override
        public boolean deploy() {
            UpdateStatWizard.this._tableSO.setUpdateStatAllColumns(this._go.indexColumnsRadioButton.isSelected());
            return true;
        }

        @Override
        public void releaseResources() {
            this._go.indexesMultiList.removeListSelectionListener((ListSelectionListener)this);
            this._go.indexesMultiList.removeMouseListener((MouseListener)this);
            this._go.propertiesButton.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    public class UpdateStatWizIntroPage
    extends ASEBaseWizardPage2 {
        private UpdateStatWizGOIntroPage _go;
        private boolean _useClientOptdiag;
        private ServerSO _sso;
        private String _aseHome;
        private String _optdiagPath;
        private String _serverServerName;

        public UpdateStatWizIntroPage(UpdateStatWizard updateStatWizard2) {
            super(updateStatWizard2, (JPanel)((Object)new UpdateStatWizGOIntroPage((String)UpdateStatWizard.this._introTextMap.get(UpdateStatWizard.this._cmdId), UpdateStatWizard.this._isUpdate && UpdateStatWizard.this._tableSO != null ? new ASEMessageText(ASEUtils.getString("UPDATE_STAT_WIZ_TABLE_LABC_COLUMNS"), UpdateStatWizard.this._tableSO.getName()).toString() : (String)UpdateStatWizard.this._introLabelMap.get(UpdateStatWizard.this._cmdId))), ASEUtils.getString("WIZ_INTRO_PAGE_TITLE"));
            this._useClientOptdiag = true;
            this._go = (UpdateStatWizGOIntroPage)((Object)this.getJPanel());
            ASEBaseContainer2 aSEBaseContainer2 = ((ASEBaseItem2)UpdateStatWizard.this._targets.get(0)).getParent();
            Support.fillListWithItems(this._go.objectsMultiList, UpdateStatWizard.this._targets, UpdateStatWizard.this._tableSO != null && !UpdateStatWizard.this._isUpdate, aSEBaseContainer2.getHeadings());
            if (UpdateStatWizard.this._isDisplay) {
                this._go.setDisplayPreviewButton(false);
                this._go.setDisplayScheduleButton(false);
                this._go.rowsMultiLineLabel.setVisible(false);
            }
        }

        public boolean useClientOptdiag() {
            return this._useClientOptdiag;
        }

        public ServerSO getServerSO() {
            return this._sso;
        }

        public String getASEHome() {
            return this._aseHome;
        }

        public String getOptdiagPath() {
            return this._optdiagPath;
        }

        public String getServerServerName() {
            return this._serverServerName;
        }

        private void showErrorMessage(String string) {
            this._go.messagePanel.setVisible(true);
            this._go.messagePanel.setVisible(true);
            this._go.messageMultiLineLabel.setText(string);
            this._go.objectsLabel.setEnabled(false);
            this._go.objectsMultiList.setEnabled(false);
            this._go.introMultiLineLabel.setEnabled(false);
            this.enableFinishButton(false);
            this.enableNextButton(false);
        }

        @Override
        public void init() throws SQLException {
            if (UpdateStatWizard.this._isUpdate || UpdateStatWizard.this._columnSO != null) {
                TableSO tableSO = UpdateStatWizard.this.getTableSO();
                tableSO.refreshAllocations();
                if (UpdateStatWizard.this._isUpdate) {
                    String string = tableSO.getRowCount();
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("UPDATE_STAT_WIZ_LABC_TABLE_ROWS"), tableSO.getName(), string);
                    this._go.rowsMultiLineLabel.setText(aSEMessageText.toString());
                } else {
                    this._go.rowsMultiLineLabel.setVisible(false);
                }
            } else {
                this._go.rowsMultiLineLabel.setVisible(false);
            }
        }

        @Override
        public void enableComponents() {
            this._go.messagePanel.setVisible(false);
            if (!(UpdateStatWizard.this._isDisplay || UpdateStatWizard.this._isUpdate && UpdateStatWizard.this._tableSO != null)) {
                this.enableFinishButton(true);
            }
            if (UpdateStatWizard.this._isDisplay) {
                Object object;
                Object object2;
                boolean bl;
                boolean bl2 = UpdateStatWizard.this._asConn.hasSARole();
                if (!bl2) {
                    this.showErrorMessage(ASEUtils.getString("MSG_NEED_SA_ROLE_TO_OPTDIAG"));
                    return;
                }
                ServerBO serverBO = ContainerViewBO.getServerBO(UpdateStatWizard.this._asConn);
                this._sso = (ServerSO)serverBO.getSO();
                boolean bl3 = this._sso.isUAFMonitored();
                this._serverServerName = UpdateStatWizard.this._asConn.getServerServerName();
                boolean bl4 = bl = this._serverServerName != null && this._serverServerName.length() > 0;
                if (!bl && bl3) {
                    try {
                        this._serverServerName = this._sso.getServerServerName(this._sso.getHostName(), this._sso.getPortNumber());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bl = this._serverServerName != null && this._serverServerName.length() > 0;
                boolean bl5 = false;
                if (bl3) {
                    try {
                        this._aseHome = this._sso.getDiscoveryProperty("ASEHome");
                        bl5 = this._aseHome != null && this._aseHome.length() > 0;
                        boolean bl6 = this._sso.getOperatingSystem().toLowerCase().startsWith("win");
                        object2 = bl6 ? "\\" : "/";
                        object = bl6 ? "optdiag.exe" : "optdiag";
                        this._optdiagPath = this._aseHome + (String)object2 + "bin" + (String)object2 + (String)object;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                if (!bl || !bl5) {
                    bl3 = false;
                }
                if (!this.getServerSO().isUAFMonitored()) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("MSG_OPERATION_FAILED"), ASEUtils.getString("CONTEXT_MENU_DISPLAY_STATISTICS_TEXT"), this.getServerSO().getName());
                    this.showErrorMessage(aSEMessageText.toString());
                } else {
                    String string = this.getOptdiagPath();
                    try {
                        object2 = (Boolean)this.getServerSO().invokeAgentServiceMethod("FileTransferService", "exists", new Object[]{string}, new String[]{"java.lang.String"});
                    }
                    catch (Exception exception) {
                        object2 = new Boolean(false);
                    }
                    if (object2 != null && !((Boolean)object2).booleanValue()) {
                        object = new ASEMessageText(ASEUtils.getString("MSG_OPTDIAG_NOT_FOUND"), string);
                        this.showErrorMessage(((ASEMessageText)object).toString());
                    } else {
                        this.enableFinishButton(true);
                        this.enableNextButton(true);
                    }
                }
            }
        }

        @Override
        public void releaseResources() {
            this._go.releaseResources();
            this._go = null;
            this._sso = null;
            super.releaseResources();
        }
    }
}

