/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizBOProgressPage;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizardSession;
import com.sybase.aseplugin.bo.wiz.UpgradeWizard;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.ServerGroupSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.SDCMessageListener;
import com.sybase.central.SCPageController;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

class UpgradeThread
extends Thread {
    private SDCClusterWizard wizard;
    private SDCMessageListener messageListener;
    private SDCClusterWizBOProgressPage progressPage;
    private SDCClusterWizardSession session;
    private boolean running = false;
    private JDialog dialog;

    protected void finalized() throws Throwable {
        this.wizard = null;
        this.messageListener = null;
        this.progressPage = null;
        super.finalize();
    }

    public boolean isRunning() {
        return this.running;
    }

    public UpgradeThread(SDCClusterWizard sDCClusterWizard, SDCMessageListener sDCMessageListener, SDCClusterWizardSession sDCClusterWizardSession, JDialog jDialog) {
        this.wizard = sDCClusterWizard;
        this.messageListener = sDCMessageListener;
        this.session = sDCClusterWizardSession;
        this.dialog = jDialog;
        SCPageController[] sCPageControllerArray = sDCClusterWizard.getPages();
        this.progressPage = (SDCClusterWizBOProgressPage)sCPageControllerArray[sCPageControllerArray.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        boolean bl;
        this.running = true;
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.wizard.getSO();
        ServerSO serverSO = ((UpgradeWizard)this.wizard).getSourceSO();
        try {
            bl = this.session.upgradeServer(serverSO.getUserName(), serverSO.getPassword(), this.dialog);
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            object = this;
            synchronized (object) {
                this.running = false;
            }
        }
        if (!bl) {
            if (this.dialog != null && this.dialog.isVisible()) {
                this.dialog.dispose();
            }
            this.progressPage.enableNextButton(true);
            this.progressPage.setNextButtonText(ASEUtils.getString("STR_WIZ_RETRY_BUTTON"));
            this.progressPage.enableBackButton(true);
            this.progressPage.enableCancelButton(true);
            Support.showError(null, this.getClass(), this.wizard.getJDialog(), ASEUtils.getString("UPGRADE_SERVER_RETRY_INFO"));
            return;
        }
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialog.dispose();
        }
        if (sDCClusterSO.isAutoStartCluster()) {
            object = new ASEMessageText(ASEUtils.getString("SDC_MSG_START_CLUSTER"), sDCClusterSO.getCluster().getName());
            this.messageListener.getCallback().handleMessage(4, ((ASEMessageText)object).toString());
            try {
                this.session.startCluster();
            }
            catch (Exception exception) {
                object = new ASEMessageText(ASEUtils.getString("SDC_ERROR_START_CLUSTER"), sDCClusterSO.getCluster().getName(), exception.getMessage());
                this.messageListener.getCallback().handleMessage(2, ((ASEMessageText)object).toString());
                Support.getTopBO().removeServerFromGroup(serverSO, Support.getTopBO().getDefaultServerGroup());
                this.registerCluster(sDCClusterSO);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new ASEMessageText(ASEUtils.getString("SDC_MSG_CLUSTER_STARTED"), sDCClusterSO.getCluster().getName());
            this.messageListener.getCallback().handleMessage(4, ((ASEMessageText)object).toString());
        }
        Support.getTopBO().removeServerFromGroup(serverSO, Support.getTopBO().getDefaultServerGroup());
        this.registerCluster(sDCClusterSO);
    }

    private void registerCluster(SDCClusterSO sDCClusterSO) {
        Object object;
        Support.getTopBO().initServerDiscovery(true);
        Support.getTopBO().updateServers();
        ASEConnectionInfo aSEConnectionInfo = null;
        try {
            aSEConnectionInfo = sDCClusterSO.createClusterConnectionInfo();
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_ASE_CONNECTION"), exception.toString());
            Support.showError(null, this.getClass(), this.wizard.getJDialog(), aSEMessageText.toString());
            return;
        }
        sDCClusterSO.setConnectionInfo(aSEConnectionInfo);
        try {
            object = sDCClusterSO.getFirstUAFEntry();
            if (object != null) {
                sDCClusterSO.setUAFInfo((SyUAFASEEntry)object);
            }
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_GET_UAF_ENTRY"), exception.toString());
            Support.showError(null, this.getClass(), this.wizard.getJDialog(), aSEMessageText.toString());
            return;
        }
        sDCClusterSO.setConnInfoServerName(sDCClusterSO.getName());
        object = Support.getTopBO().getDefaultServerGroup();
        sDCClusterSO.addToServerGroup((ServerGroupSO)object);
        Support.getTopBO().registerServer(sDCClusterSO);
        if (Debug.isOn()) {
            Support.addLogEntry(2, null, this.getClass(), "Added the server SO to TopBO's server list.", "");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Support.getTopBO().refresh(true);
            }
        });
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Support.getTopBO().refresh(true);
                UpgradeThread.this.progressPage.enableFinishButton(true);
                UpgradeThread.this.progressPage.enableCancelButton(true);
            }
        });
    }
}

