/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.DatabaseDeviceBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.UpgradeWizard;
import com.sybase.aseplugin.go.wiz.UpgradeWizGOEnvironmentPage;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.so.SDCDefaultsInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.util.DeviceValidator;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.ua.AgentConnectionException;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;

class UpgradeWizBOEnvironmentPage
extends ASEBaseWizDocPage
implements SDCDefaultsInterface {
    private UpgradeWizGOEnvironmentPage _go = (UpgradeWizGOEnvironmentPage)((Object)this.getJPanel());
    private SDCClusterAgentProxy agentProxy = null;
    private static final int ON_ERR_EXIT = 999;
    private String oldServerName = "";

    public UpgradeWizBOEnvironmentPage(ASEBaseWizardDialog2 aSEBaseWizardDialog2) {
        super(aSEBaseWizardDialog2, (JPanel)((Object)new UpgradeWizGOEnvironmentPage()), ASEUtils.getString("UPGRADE_WIZ_ENVIRONMENT_PAGE"));
        this._go.setDisplayScheduleButton(false);
        this._go.setDisplayPreviewButton(false);
    }

    @Override
    public void init() throws SQLException {
        this.gatherOldServerInfo();
        this.loadOldSybaseHome();
        this._go.addListeners(this);
    }

    @Override
    public boolean onSetActive() {
        this.agentProxy = ((UpgradeWizard)this.getParent()).getSelectedAgent();
        return super.onSetActive();
    }

    private void loadOldSybaseHome() throws SQLException {
        ServerSO serverSO = ((UpgradeWizard)this.getParent()).getSourceSO();
        boolean bl = false;
        if (serverSO.isUAFMonitored()) {
            String string = serverSO.getUAFInfo().getValue("sybaseHome");
            this._go.oldSybaseHomeTextField.setText(string);
            String string2 = serverSO.getUAFInfo().getValue("ASEHome");
            if (string.length() > 0 && string2.length() > 0) {
                String string3 = string2.substring(string.length() + 1);
                this._go.oldASEHomeTextField.setText(string3);
                String string4 = string3.replaceFirst("ASE", "OCS");
                this._go.oldOCSHomeTextField.setText(string4);
                bl = true;
            } else {
                bl = false;
            }
        }
        if (!bl) {
            if (serverSO.getVersion().startsWith("12.5")) {
                this._go.oldASEHomeTextField.setText("ASE-12_5");
                this._go.oldOCSHomeTextField.setText("OCS-12_5");
            } else if (serverSO.getVersion().startsWith("15")) {
                this._go.oldASEHomeTextField.setText("ASE-15_0");
                this._go.oldOCSHomeTextField.setText("OCS-15_0");
            }
        }
    }

    private void gatherOldServerInfo() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        this.oldServerName = ((UpgradeWizard)this.getParent()).getSourceSO().getConnection().getServerServerName();
        iCluster.setOldServerName(this.oldServerName);
        DatabaseDeviceBO databaseDeviceBO = ContainerViewBO.getDatabaseDeviceBO((ServerBO)this.getParent().getParent(), "master");
        DatabaseDeviceSO databaseDeviceSO = (DatabaseDeviceSO)databaseDeviceBO.getSO();
        String string = databaseDeviceSO.getPhysicalName();
        String string2 = databaseDeviceSO.getSize();
        Float f = new Float(string2);
        string2 = String.valueOf(f.intValue());
        sDCClusterSO.addDevice(databaseDeviceSO);
        int n = databaseDeviceSO.getConnection().getPageSize();
        int n2 = n / 1024;
        iCluster.setPageSize("" + n2);
        iCluster.setMasterDevice(string);
        iCluster.setMasterDeviceSize(string2);
    }

    @Override
    public void enableComponents() {
        boolean bl = this._go.getOldASEHome().length() > 0 && this._go.getOldSybaseHome().length() > 0 && this._go.getOldOCSHome().length() > 0;
        this.enableNextButton(bl);
    }

    @Override
    public void releaseResources() {
        this._go.releaseResources();
        this._go = null;
        super.releaseResources();
    }

    @Override
    public int onWizardNext() {
        SDCClusterSO sDCClusterSO = (SDCClusterSO)this.getSO();
        ICluster iCluster = sDCClusterSO.getCluster();
        iCluster.setOldServerName(this.oldServerName);
        String string = this._go.getOldSybaseHome();
        String string2 = this._go.getOldASEHome();
        String string3 = this._go.getOldOCSHome();
        boolean bl = false;
        bl = this.validateAndSaveSettingsSharingSamePath(sDCClusterSO, string, string2, string3);
        if (!bl) {
            return -1;
        }
        return super.onWizardNext();
    }

    private boolean validateAndSaveSettingsSharingSamePath(SDCClusterSO sDCClusterSO, String string, String string2, String string3) {
        boolean bl = false;
        bl = this.validateAndSaveSettings(this.agentProxy, string, string2, string3);
        return bl;
    }

    public int isAbsolutePath(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        try {
            boolean bl = DeviceValidator.isAbsolutePath(sDCClusterAgentProxy, string);
            if (bl) {
                return 0;
            }
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return 204;
    }

    public void displayError(int n, String string, String string2) {
        ASEMessageText aSEMessageText = null;
        switch (n) {
            case 203: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_WRITABLE"), string, string2);
                break;
            }
            case 209: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_READABLE"), string, string2);
                break;
            }
            case 202: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_PARENT_DIR_NOT_EXIST"), string, string2);
                break;
            }
            case 200: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_ALREADY_EXISTS"), string, string2);
                break;
            }
            case 201: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_FILE_IS_DIRECTORY"), string, string2);
                break;
            }
            case 100: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_READABLE"), string, string2);
                break;
            }
            case 101: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_WRITABLE"), string, string2);
                break;
            }
            case 104: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_EXIST"), string, string2);
                break;
            }
            case 102: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_READABLE"), string, string2);
                break;
            }
            case 103: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_WRITABLE"), string, string2);
                break;
            }
            case 204: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_INVALID_ABSOLUTE_PATH"), string, string2);
                break;
            }
            case 205: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DIRECTORY_NOT_EXIST"), string, string2);
                break;
            }
            case 206: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_IS_NOT_DIRECTORY"), string, string2);
                break;
            }
            case 207: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_READABLE"), string, string2);
                break;
            }
            case 208: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_PATH_NOT_WRITABLE"), string, string2);
                break;
            }
            default: {
                aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_UNKNOWN"), string);
            }
        }
        Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
    }

    private int validateFileDirectory(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 999;
        try {
            n = DeviceValidator.validateDirectoryPath(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    public int isDevicePathReadable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 102;
        try {
            n = DeviceValidator.isDevicePathReadable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    public int isDevicePathWritable(String string, String string2, SDCClusterAgentProxy sDCClusterAgentProxy) {
        int n = 103;
        try {
            n = DeviceValidator.isDevicePathWritable(sDCClusterAgentProxy, string);
        }
        catch (AgentConnectionException agentConnectionException) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR"), agentConnectionException.getMessage());
            Support.showError(null, this.getClass(), this.getJDialog(), aSEMessageText.toString());
        }
        return n;
    }

    private boolean validateAndSaveSettings(SDCClusterAgentProxy sDCClusterAgentProxy, String string, String string2, String string3) {
        String string4 = SDCClusterAgentUtils.getNodeAddress(sDCClusterAgentProxy.getHost(), sDCClusterAgentProxy.getPort());
        int n = 0;
        n = this.isAbsolutePath(string, string4, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string, string4);
            return false;
        }
        n = this.validateFileDirectory(string, string4, sDCClusterAgentProxy);
        if (n == 999) {
            return false;
        }
        if (n != 4) {
            this.displayError(n, string, string4);
            return false;
        }
        n = this.isAbsolutePath(string + sDCClusterAgentProxy.getServerFileSeparator() + string2, string4, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string + sDCClusterAgentProxy.getServerFileSeparator() + string2, string4);
            return false;
        }
        n = this.validateFileDirectory(string + sDCClusterAgentProxy.getServerFileSeparator() + string2, string4, sDCClusterAgentProxy);
        if (n == 999) {
            return false;
        }
        if (n != 4) {
            this.displayError(n, string + sDCClusterAgentProxy.getServerFileSeparator() + string2, string4);
            return false;
        }
        n = this.isAbsolutePath(string + sDCClusterAgentProxy.getServerFileSeparator() + string3, string4, sDCClusterAgentProxy);
        if (n == 204) {
            this.displayError(n, string + sDCClusterAgentProxy.getServerFileSeparator() + string3, string4);
            return false;
        }
        n = this.validateFileDirectory(string + sDCClusterAgentProxy.getServerFileSeparator() + string3, string4, sDCClusterAgentProxy);
        if (n == 999) {
            return false;
        }
        if (n != 4) {
            this.displayError(n, string + sDCClusterAgentProxy.getServerFileSeparator() + string3, string4);
            return false;
        }
        this.updateClusterSettings(string, string2, string3);
        return true;
    }

    private void updateClusterSettings(String string, String string2, String string3) {
        ICluster iCluster = ((SDCClusterSO)this.getSO()).getCluster();
        iCluster.setOldSybaseHome(string);
        iCluster.setOldASEHome(string2);
        iCluster.setOldOCSHome(string3);
    }

    @Override
    public boolean onWizardFinish() {
        this.releaseResources();
        return true;
    }

    @Override
    public boolean onCancel() {
        this.releaseResources();
        return true;
    }

    @Override
    public void textValueChanged(DocumentEvent documentEvent) {
        this.enableComponents();
    }
}

