/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.bo.wiz;

import com.sybase.asa.ASAIconTextData;
import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.GroupBO;
import com.sybase.aseplugin.bo.LoginBO;
import com.sybase.aseplugin.bo.LoginsCtrBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.UsersCtrBO;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizDocPage;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardDialog2;
import com.sybase.aseplugin.bo.wiz.ASEBaseWizardPage2;
import com.sybase.aseplugin.bo.wiz.SummaryWizBOPage;
import com.sybase.aseplugin.go.wiz.UserWizGOGroupPage;
import com.sybase.aseplugin.go.wiz.UserWizGONamePage;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.UserSO;
import com.sybase.central.SCContainer2;
import com.sybase.central.SCPageController;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;

public class UserWizard
extends ASEBaseWizardDialog2 {
    private UserSO _uso;

    public UserWizard(UserSO userSO, UsersCtrBO usersCtrBO) {
        super((SOItemInterface)userSO, (SCContainer2)usersCtrBO, ASEUtils.getString("MSG_ADD_USER"));
        this._uso = userSO;
    }

    @Override
    public SCPageController[] getPages() {
        return new SCPageController[]{new UserWizNamePage(this), new UserGroupWizBOPage(this), new SummaryUserWizBOPage(this)};
    }

    @Override
    public void releaseResources() {
        this._uso = null;
        super.releaseResources();
    }

    @Override
    public void refresh() {
        ServerBO serverBO = ContainerViewBO.getServerBO(this.getConnection());
        LoginsCtrBO loginsCtrBO = (LoginsCtrBO)serverBO.getItem(ASEUtils.getString("DNAME_LOGINS"));
        loginsCtrBO.refresh();
    }

    class SummaryUserWizBOPage
    extends SummaryWizBOPage {
        public SummaryUserWizBOPage(UserWizard userWizard2) {
            super(userWizard2, ASEImages.getUserWizardImage());
        }

        @Override
        public void enableComponents() {
            this.clearSummaryItems();
            this.addSummaryItem(ASEUtils.getString("MSG_USER_NAME"), UserWizard.this._uso.getName());
            if (!UserWizard.this._uso.getName().equals("guest")) {
                this.addSummaryItem(ASEUtils.getString("MSG_LOGIN_NAME"), UserWizard.this._uso.getLoginName());
                this.addSummaryItem(ASEUtils.getString("MSG_GROUP_NAME"), UserWizard.this._uso.getGroupName());
            }
            this.setSummaryInfo(this.getSummary());
        }
    }

    class UserGroupWizBOPage
    extends ASEBaseWizardPage2
    implements ActionListener {
        private UserWizGOGroupPage _go;

        public UserGroupWizBOPage(UserWizard userWizard2) {
            super(userWizard2, (JPanel)((Object)new UserWizGOGroupPage()), ASEUtils.getString("MSG_USERS_WIZ_GROUP"));
            this._go = (UserWizGOGroupPage)((Object)this.getJPanel());
            this._go.groupComboBox.setEnabled(false);
            this._go.assignCheckBox.addActionListener((ActionListener)this);
        }

        @Override
        public void init() throws SQLException {
            this.setAvailableGroups(UserWizard.this._uso.getAvailableGroups());
        }

        @Override
        public boolean showPage() {
            String string = UserWizard.this._uso.getName();
            if (string != null && string.equals("guest")) {
                return false;
            }
            this.enableFinishButton(true);
            return true;
        }

        private void setAvailableGroups(Vector vector) {
            int n = -1;
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)GroupBO.GROUP_ICON, string);
                this._go.groupComboBox.addItem((Object)aSAIconTextData);
                if (n >= 0 || string.equals("public")) continue;
                n = i;
            }
            if (n >= 0) {
                this._go.groupComboBox.setSelectedIndex(n);
            }
        }

        public String getGroupName() {
            String string = this._go.groupComboBox.getSelectedItem().toString();
            return string;
        }

        @Override
        public boolean deploy() {
            if (this._go.assignCheckBox.isSelected()) {
                UserWizard.this._uso.setGroupName(this.getGroupName());
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.assignCheckBox) {
                this._go.groupLabel.setEnabled(this.isGroupSelected());
                this._go.groupComboBox.setEnabled(this.isGroupSelected());
            }
        }

        private boolean isGroupSelected() {
            return this._go.assignCheckBox.isSelected();
        }

        @Override
        public void releaseResources() {
            this._go.assignCheckBox.removeActionListener((ActionListener)this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }

    class UserWizNamePage
    extends ASEBaseWizDocPage
    implements ActionListener {
        private UserWizGONamePage _go;

        public UserWizNamePage(UserWizard userWizard2) {
            super(userWizard2, (JPanel)((Object)new UserWizGONamePage()), ASEUtils.getString("MSG_USERS_WIZ_NAME"));
            this._go = (UserWizGONamePage)((Object)this.getJPanel());
            this._go.loginComboBox.addActionListener((ActionListener)this);
            this._go.guestCheckBox.addActionListener((ActionListener)this);
            this._go.nameTextField.getDocument().addDocumentListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._go.loginComboBox) {
                this._go.nameTextField.setText(this.getLoginName());
            } else if (actionEvent.getSource() == this._go.guestCheckBox) {
                boolean bl = this._go.guestCheckBox.isSelected();
                this._go.loginLabel.setEnabled(!bl);
                this._go.loginComboBox.setEnabled(!bl);
                this._go.nameLabel.setEnabled(!bl);
                this._go.nameTextField.setEnabled(!bl);
                this._go.nameTextField.setText(bl ? "guest" : this.getLoginName());
            }
        }

        @Override
        public void init() throws SQLException {
            if (UserWizard.this._uso.getConnection().hasSSORole() && !UserWizard.this._uso.getConnection().hasSARole()) {
                this._go.loginComboBox.setVisible(false);
                return;
            }
            this._go.loginTextField.setVisible(false);
            this.setAvailableLogins(UserWizard.this._uso.getAvailableLogins());
            if (UserWizard.this._uso.dbHasGuest()) {
                this._go.guestMultiLineLabel.setVisible(false);
                this._go.guestCheckBox.setVisible(false);
            }
        }

        @Override
        public void textValueChanged(DocumentEvent documentEvent) {
            this.enableComponents();
        }

        @Override
        public void enableComponents() {
            boolean bl = this._go.nameTextField.getText().length() > 0;
            this.enableNextButton(bl);
            this.enableFinishButton(bl);
        }

        private void setAvailableLogins(Vector vector) {
            int n = -1;
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                ASAIconTextData aSAIconTextData = new ASAIconTextData((Icon)LoginBO.LOGIN_ICON, string);
                this._go.loginComboBox.addItem((Object)aSAIconTextData);
                if (n >= 0 || string.equals("probe")) continue;
                n = i;
            }
            if (n >= 0) {
                this._go.loginComboBox.setSelectedIndex(n);
            }
        }

        @Override
        public boolean deploy() {
            UserWizard.this._uso.setName(this.getUserName());
            UserWizard.this._uso.setLoginName(this.getLoginName());
            try {
                return Support.verifyObjectName(UserWizard.this._uso, this.getJDialog(), (JTextComponent)((Object)this._go.nameTextField));
            }
            catch (SQLException sQLException) {
                Support.showDetailsError(this.getConnection(), this.getClass(), (Container)this.getJDialog(), sQLException.getMessage(), sQLException);
                return false;
            }
        }

        private String getLoginName() {
            String string = this._go.loginComboBox.isVisible() ? this._go.loginComboBox.getSelectedString() : this._go.loginTextField.getText();
            return string;
        }

        private String getUserName() {
            String string = this._go.nameTextField.getText();
            return string;
        }

        @Override
        public void releaseResources() {
            this._go.loginComboBox.removeActionListener((ActionListener)this);
            this._go.guestCheckBox.removeActionListener((ActionListener)this);
            this._go.nameTextField.getDocument().removeDocumentListener(this);
            this._go.releaseResources();
            this._go = null;
            super.releaseResources();
        }
    }
}

