/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.asa.ASAListCheckEvent;
import com.sybase.asa.ASAListCheckListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ASECheckList
extends JTable {
    ASECheckListTableModel _model;
    Vector _listCheckListeners = new Vector();

    public ASECheckList(String[] stringArray, int n) {
        this._model = new ASECheckListTableModel(stringArray, n);
        this.setModel(this._model);
    }

    public void addRow(Object[] objectArray) {
        this._model.addRow(objectArray);
    }

    public void addListCheckListener(ASAListCheckListener aSAListCheckListener) {
        this._listCheckListeners.add(aSAListCheckListener);
    }

    public void checkAll() {
        this._model.setAllCheckBoxes(true);
    }

    public void uncheckAll() {
        this._model.setAllCheckBoxes(false);
    }

    public boolean isCellChecked(int n, int n2) {
        return this._model.isCellChecked(n, n2);
    }

    protected void fireCheckValueChanged(int n, int n2) {
        ASAListCheckEvent aSAListCheckEvent = new ASAListCheckEvent((Object)this, n, n2);
        this._model.fireTableChanged(new TableModelEvent(this._model, n, n2));
        int n3 = this._listCheckListeners.size();
        for (int i = 0; i < n3; ++i) {
            ((ASAListCheckListener)this._listCheckListeners.get(i)).valueChanged(aSAListCheckEvent);
        }
    }

    public void removeAllRows() {
        this._model.removeAllData();
    }

    class ASECheckListTableModel
    extends AbstractTableModel {
        private String[] _columnNames = null;
        private Vector _data = new Vector();
        private int _checkBoxesColIndex;

        ASECheckListTableModel(String[] stringArray, int n) {
            this._checkBoxesColIndex = n;
            this._columnNames = stringArray;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames == null ? 0 : this._columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames == null ? "" : this._columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object[] objectArray = (Object[])this._data.elementAt(n);
            return objectArray[n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= this._checkBoxesColIndex;
        }

        public void addRow(Object[] objectArray) {
            this._data.addElement(objectArray);
            this.fireTableChanged(new TableModelEvent(this));
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object[] objectArray = (Object[])this._data.elementAt(n);
            objectArray[n2] = object;
            this.fireTableCellUpdated(n, n2);
            if (n2 >= this._checkBoxesColIndex) {
                ASECheckList.this.fireCheckValueChanged(n, n);
            }
        }

        public void setAllCheckBoxes(boolean bl) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Object[] objectArray = (Object[])this._data.elementAt(i);
                for (int j = this._checkBoxesColIndex; j < this.getColumnCount(); ++j) {
                    objectArray[j] = new Boolean(bl);
                    this.fireTableCellUpdated(i, j);
                }
            }
            ASECheckList.this.fireCheckValueChanged(0, this.getRowCount());
        }

        public boolean isCellChecked(int n, int n2) {
            Object[] objectArray = (Object[])this._data.elementAt(n);
            if (n2 < this._checkBoxesColIndex) {
                return false;
            }
            Boolean bl = (Boolean)objectArray[n2];
            return bl;
        }

        public void removeAllData() {
            this._data.clear();
        }
    }
}

