/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.asa.ASACellCheckEvent;
import com.sybase.asa.ASACellCheckListener;
import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASACheckedData;
import com.sybase.asa.ASALabel;
import com.sybase.aseplugin.ASEConstants;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ASEDaysOfTheMonthChooser
extends ASEMnemGridBagPanel
implements ActionListener,
MouseListener,
ASEConstants {
    private static final int DAY_COUNT = 32;
    private static final int ROW_COUNT = 5;
    private static final int COLUMN_COUNT = 7;
    private static final Border BORDER = new CompoundBorder(new EtchedBorder(1), new EmptyBorder(INSETS));
    private boolean _isMyManagingFocus = false;
    private Vector _cellCheckListeners = new Vector();
    private DaysTable _daysTable;
    private LastDayTable _lastDayTable;
    private DefaultTableModel _daysTableModel;
    private DefaultTableModel _lastDayTableModel;
    int _pressedRow = -1;
    int _pressedColumn = -1;

    public ASEDaysOfTheMonthChooser() {
        this.init();
    }

    private void init() {
        this.setManagingFocus(false);
        this._daysTable = new DaysTable();
        this._daysTableModel = (DefaultTableModel)this._daysTable.getModel();
        this.add(this._daysTable, 0, 0, 0, 1, 0.0, 0.0, 17, 0, INSETS_NONE, 0, 0);
        this._lastDayTable = new LastDayTable();
        this._lastDayTableModel = (DefaultTableModel)this._lastDayTable.getModel();
        this.add(this._lastDayTable, 0, 1, 0, 1, 0.0, 0.0, 17, 0, INSETS_NONE, 0, 0);
        this._daysTable.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
        this._daysTable.addMouseListener(this);
        this._lastDayTable.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
        this._lastDayTable.addMouseListener(this);
    }

    void releaseResources() {
        this._daysTable.releaseResources();
        this._lastDayTable.releaseResources();
        this._daysTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this._daysTable.removeMouseListener(this);
        this._lastDayTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this._lastDayTable.removeMouseListener(this);
        this._cellCheckListeners = null;
        this._daysTable = null;
        this._lastDayTable = null;
        this._daysTableModel = null;
        this._lastDayTableModel = null;
    }

    public void showBorder(boolean bl) {
        if (bl) {
            this.setBorder(BORDER);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._daysTable.setEnabled(bl);
        this._lastDayTable.setEnabled(bl);
    }

    public boolean isDayChecked(int n) {
        if (n < 0 || n >= 32) {
            throw new IllegalArgumentException("Invalid day : " + n);
        }
        ASACheckedData aSACheckedData = n == 0 ? (ASACheckedData)this._lastDayTable.getValueAt(0, 0) : (ASACheckedData)this._daysTable.getValueAt(this._daysTable.getRowForDay(n), this._daysTable.getColumnForDay(n));
        return aSACheckedData.isChecked;
    }

    public void setDayChecked(int n, boolean bl) {
        int n2;
        int n3;
        if (n < 0 || n >= 32) {
            throw new IllegalArgumentException("Invalid day : " + n);
        }
        if (n == 0) {
            n3 = 5;
            n2 = 0;
            ASACheckedData aSACheckedData = (ASACheckedData)this._lastDayTable.getValueAt(0, 0);
            aSACheckedData.isChecked = bl;
            this._lastDayTable.setValueAt(aSACheckedData, 0, 0);
        } else {
            n3 = this._daysTable.getRowForDay(n);
            n2 = this._daysTable.getColumnForDay(n);
            ASACheckedData aSACheckedData = (ASACheckedData)this._daysTable.getValueAt(n3, n2);
            aSACheckedData.isChecked = bl;
            this._daysTable.setValueAt(aSACheckedData, n3, n2);
        }
        this.fireCheckValueChanged(n3, n2);
    }

    public void toggleDayChecked(int n) {
        int n2;
        int n3;
        if (n < 0 || n >= 32) {
            throw new IllegalArgumentException("Invalid day : " + n);
        }
        if (n == 0) {
            n3 = 5;
            n2 = 0;
            ASACheckedData aSACheckedData = (ASACheckedData)this._lastDayTable.getValueAt(0, 0);
            aSACheckedData.isChecked = !aSACheckedData.isChecked;
            this._lastDayTable.setValueAt(aSACheckedData, 0, 0);
        } else {
            n3 = this._daysTable.getRowForDay(n);
            n2 = this._daysTable.getColumnForDay(n);
            ASACheckedData aSACheckedData = (ASACheckedData)this._daysTable.getValueAt(n3, n2);
            aSACheckedData.isChecked = !aSACheckedData.isChecked;
            this._daysTable.setValueAt(aSACheckedData, n3, n2);
        }
        this.fireCheckValueChanged(n3, n2);
    }

    public void checkAllDays() {
        for (int i = 0; i < 32; ++i) {
            this.setDayChecked(i, true);
        }
    }

    public void uncheckAllDays() {
        for (int i = 0; i < 32; ++i) {
            this.setDayChecked(i, false);
        }
    }

    public int getCheckedDayCount() {
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            if (!this.isDayChecked(i)) continue;
            ++n;
        }
        return n;
    }

    public int[] getCheckedDays() {
        int[] nArray = new int[32];
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            if (!this.isDayChecked(i)) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public int getUncheckedDayCount() {
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            if (this.isDayChecked(i)) continue;
            ++n;
        }
        return n;
    }

    public int[] getUncheckedDays() {
        int[] nArray = new int[32];
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            if (this.isDayChecked(i)) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public void setManagingFocus(boolean bl) {
        this._isMyManagingFocus = bl;
    }

    public void addCellCheckListener(ASACellCheckListener aSACellCheckListener) {
        this._cellCheckListeners.add(aSACellCheckListener);
    }

    public void removeCellCheckListener(ASACellCheckListener aSACellCheckListener) {
        this._cellCheckListeners.remove(aSACellCheckListener);
    }

    protected void fireCheckValueChanged(int n, int n2) {
        ASACellCheckEvent aSACellCheckEvent = new ASACellCheckEvent((Object)this, n, n2);
        if (n == 5 && n2 == 0) {
            this._lastDayTableModel.fireTableCellUpdated(0, 0);
        } else {
            this._daysTableModel.fireTableCellUpdated(n, n2);
        }
        int n3 = this._cellCheckListeners.size();
        for (int i = 0; i < n3; ++i) {
            ((ASACellCheckListener)this._cellCheckListeners.get(i)).valueChanged(aSACellCheckEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.isEnabled()) {
            if (object == this._daysTable) {
                int n = this._daysTable.getDayAt(this._daysTable.getSelectedRow(), this._daysTable.getSelectedColumn());
                if (n != -1) {
                    this.toggleDayChecked(n);
                }
            } else if (object == this._lastDayTable) {
                this.toggleDayChecked(0);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._daysTable) {
            this._pressedRow = this._daysTable.rowAtPoint(mouseEvent.getPoint());
            this._pressedColumn = this._daysTable.columnAtPoint(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        if (this.isEnabled()) {
            if (object == this._daysTable) {
                int n;
                int n2;
                int n3 = this._daysTable.rowAtPoint(point);
                if (n3 >= 0 && n3 == this._pressedRow && (n2 = this._daysTable.columnAtPoint(point)) >= 0 && n2 == this._pressedColumn && (n = this._daysTable.getDayAt(n3, n2)) != -1) {
                    this.toggleDayChecked(n);
                }
            } else if (object == this._lastDayTable) {
                this.toggleDayChecked(0);
            }
        }
    }

    static class ASEDaysOfTheMonthCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final Border PANEL_BORDER = new EmptyBorder(2, 2, 2, 2);
        private static final Insets INSETS_CHECKBOX = new Insets(0, 0, 0, 0);
        protected ASACheckBox checkBox = new ASACheckBox();
        protected ASALabel label = new ASALabel();

        ASEDaysOfTheMonthCellRenderer() {
            this.setLayout(new BorderLayout());
            this.setBorder(PANEL_BORDER);
            this.setOpaque(true);
            this.checkBox.setOpaque(true);
            this.checkBox.setMargin(INSETS_CHECKBOX);
            this.add((Component)this.checkBox, "West");
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(0);
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                this.setVisible(false);
                this.checkBox.setVisible(false);
                this.label.setVisible(false);
            } else {
                this.setVisible(true);
                this.checkBox.setVisible(true);
                this.label.setVisible(true);
                ASACheckedData aSACheckedData = (ASACheckedData)object;
                this.checkBox.setEnabled(jTable.isEnabled() && aSACheckedData.isEnabled);
                this.checkBox.setSelected(aSACheckedData.isChecked);
                this.label.setText(aSACheckedData.toString());
                if (jTable.hasFocus() && bl) {
                    this.label.setBackground(jTable.getSelectionBackground());
                    this.label.setForeground(jTable.getSelectionForeground());
                } else {
                    this.label.setBackground(this.checkBox.getBackground());
                    this.label.setForeground(this.checkBox.getForeground());
                }
            }
            return this;
        }
    }

    class LastDayTable
    extends JTable
    implements FocusListener {
        private boolean _isInitialized;

        public LastDayTable() {
            super(1, 1);
            this._isInitialized = false;
            this.init();
            this._isInitialized = true;
        }

        private void init() {
            ASACheckedData aSACheckedData = new ASACheckedData(false, (Object)ASEUtils.getString("MSG_LAST_DAY_OF_MONTH"));
            this.setValueAt(aSACheckedData, 0, 0);
            this.getColumnModel().getColumn(0).setCellRenderer(new ASEDaysOfTheMonthCellRenderer());
            this.setSelectionMode(0);
            this.setCellSelectionEnabled(true);
            this.setShowGrid(false);
            this.setRowHeight(20);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.setColumnWidth();
            this.addFocusListener(this);
        }

        void releaseResources() {
            this.removeFocusListener(this);
        }

        private void setColumnWidth() {
            int n = 0;
            Object object = this.getValueAt(0, 0);
            if (object != null) {
                TableCellRenderer tableCellRenderer = this.getCellRenderer(0, 0);
                Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, 0, 0);
                n = component.getPreferredSize().width;
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(n);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(n);
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }

        @Override
        public boolean isManagingFocus() {
            if (!this._isInitialized) {
                return false;
            }
            return ASEDaysOfTheMonthChooser.this._isMyManagingFocus;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
                this.setColumnSelectionInterval(0, 0);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class DaysTable
    extends JTable
    implements FocusListener {
        private TableColumnModel _tableColumnModel;
        private boolean _isInitialized;

        DaysTable() {
            super(5, 7);
            this._isInitialized = false;
            this.init();
            this._isInitialized = true;
        }

        private void init() {
            this._tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 7; ++i) {
                this._tableColumnModel.getColumn(i).setCellRenderer(new ASEDaysOfTheMonthCellRenderer());
                for (int j = 0; j < 5; ++j) {
                    int n = this.getDayAt(j, i);
                    if (n == -1) continue;
                    this.setValueAt(new ASACheckedData(false, (Object)String.valueOf(n)), j, i);
                }
            }
            this.setSelectionMode(0);
            this.setCellSelectionEnabled(true);
            this.setShowGrid(false);
            this.setRowHeight(20);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.setColumnWidths();
            this.addFocusListener(this);
        }

        void releaseResources() {
            this.removeFocusListener(this);
        }

        private void setColumnWidths() {
            for (int i = 0; i < 7; ++i) {
                int n = 0;
                for (int j = 0; j < 5; ++j) {
                    Object object = this.getValueAt(j, i);
                    if (object == null) continue;
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(j, i);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, j, i);
                    int n2 = component.getPreferredSize().width;
                    n = Math.max(n, n2);
                }
                TableColumn tableColumn = this._tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(n);
                tableColumn.setMinWidth(n);
                tableColumn.setMaxWidth(n);
            }
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }

        private int getDayAt(int n, int n2) {
            int n3 = n * 7 + n2 + 1;
            return n3 < 1 || n3 > 31 ? -1 : n3;
        }

        private int getRowForDay(int n) {
            if (n < 1 || n > 31) {
                throw new IllegalArgumentException("Invalid day : " + n);
            }
            return (n - 1) / 7;
        }

        private int getColumnForDay(int n) {
            if (n < 1 || n > 31) {
                throw new IllegalArgumentException("Invalid day : " + n);
            }
            return (n - 1) % 7;
        }

        @Override
        public boolean isManagingFocus() {
            if (!this._isInitialized) {
                return false;
            }
            return ASEDaysOfTheMonthChooser.this._isMyManagingFocus;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = this.getDayAt(n, n2);
            if (n3 != -1) {
                return super.getValueAt(n, n2);
            }
            return null;
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && this.getValueAt(n, n2) == null) {
                    mouseEvent.consume();
                    return;
                }
            }
            super.processMouseEvent(mouseEvent);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && this.getValueAt(n, n2) == null) {
                    mouseEvent.consume();
                    return;
                }
            }
            super.processMouseMotionEvent(mouseEvent);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                int n = this.getSelectedRow();
                int n2 = this.getSelectedColumn();
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        this.handleArrowKeyPressed(keyEvent, n, --n2);
                        break;
                    }
                    case 39: {
                        this.handleArrowKeyPressed(keyEvent, n, ++n2);
                        break;
                    }
                    case 38: {
                        this.handleArrowKeyPressed(keyEvent, --n, n2);
                        break;
                    }
                    case 40: {
                        this.handleArrowKeyPressed(keyEvent, ++n, n2);
                        break;
                    }
                    case 36: {
                        this.handleHomeOrEndKeyPressed(keyEvent, n, true);
                        break;
                    }
                    case 35: {
                        this.handleHomeOrEndKeyPressed(keyEvent, n, false);
                        break;
                    }
                    case 33: {
                        this.handlePageUpOrPageDownKeyPressed(keyEvent, n2, true);
                        break;
                    }
                    case 34: {
                        this.handlePageUpOrPageDownKeyPressed(keyEvent, n2, false);
                        break;
                    }
                    case 9: {
                        this.handleTabOrShiftTabKeyPressed(keyEvent, n, n2);
                        break;
                    }
                    default: {
                        super.processKeyEvent(keyEvent);
                    }
                }
                return;
            }
            super.processKeyEvent(keyEvent);
        }

        private void handleArrowKeyPressed(KeyEvent keyEvent, int n, int n2) {
            if (n >= 0 && n < 5 && n2 >= 0 && n2 < 7 && this.getValueAt(n, n2) == null) {
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        private void handleHomeOrEndKeyPressed(KeyEvent keyEvent, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = 0;
                n3 = 7;
                n2 = 1;
            } else {
                n4 = 6;
                n3 = -1;
                n2 = -1;
            }
            for (int i = n4; i != n3; i += n2) {
                if (this.getValueAt(n, i) == null) continue;
                this.setRowSelectionInterval(n, n);
                this.setColumnSelectionInterval(i, i);
                keyEvent.consume();
                return;
            }
            keyEvent.consume();
        }

        private void handlePageUpOrPageDownKeyPressed(KeyEvent keyEvent, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = 0;
                n3 = 5;
                n2 = 1;
            } else {
                n4 = 4;
                n3 = -1;
                n2 = -1;
            }
            for (int i = n4; i != n3; i += n2) {
                if (this.getValueAt(i, n) == null) continue;
                this.setRowSelectionInterval(i, i);
                this.setColumnSelectionInterval(n, n);
                keyEvent.consume();
                return;
            }
            keyEvent.consume();
        }

        private void handleTabOrShiftTabKeyPressed(KeyEvent keyEvent, int n, int n2) {
            int n3;
            if (!this.isManagingFocus()) {
                return;
            }
            int n4 = keyEvent.getModifiers();
            if (n4 == 0) {
                int n5 = this.getDayAt(n, n2);
                n3 = n5 == -1 || n5 == 31 ? 1 : n5 + 1;
            } else if (n4 == 1) {
                int n6 = this.getDayAt(n, n2);
                n3 = n6 == -1 || n6 == 1 ? 31 : n6 - 1;
            } else {
                super.processKeyEvent(keyEvent);
                return;
            }
            int n7 = this.getRowForDay(n3);
            int n8 = this.getColumnForDay(n3);
            this.setRowSelectionInterval(n7, n7);
            this.setColumnSelectionInterval(n8, n8);
            keyEvent.consume();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.getDayAt(this.getSelectedRow(), this.getSelectedColumn()) == -1) {
                int n = this.getRowForDay(1);
                int n2 = this.getColumnForDay(1);
                this.setRowSelectionInterval(n, n);
                this.setColumnSelectionInterval(n2, n2);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

