/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.asa.ASACellCheckEvent;
import com.sybase.asa.ASACellCheckListener;
import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASACheckedData;
import com.sybase.asa.ASALabel;
import com.sybase.aseplugin.ASEConstants;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ASEDaysOfTheWeekChooser
extends ASEMnemGridBagPanel
implements ActionListener,
MouseListener,
ASEConstants {
    private static final int DAY_COUNT = 7;
    private static final int ROW_COUNT = 3;
    private static final int COLUMN_COUNT = 3;
    private static final Border BORDER = new CompoundBorder(new EtchedBorder(1), new EmptyBorder(INSETS));
    private boolean _isManagingFocus = false;
    private Vector _cellCheckListeners = new Vector();
    private DaysTable _daysTable;
    private DefaultTableModel _daysTableModel;
    int _pressedRow = -1;
    int _pressedColumn = -1;

    public ASEDaysOfTheWeekChooser() {
        this.init();
    }

    private void init() {
        this._daysTable = new DaysTable();
        this._daysTableModel = (DefaultTableModel)this._daysTable.getModel();
        this.add(this._daysTable, 0, 0, 0, 1, 0.0, 0.0, 17, 0, INSETS_NONE, 0, 0);
        this._daysTable.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
        this._daysTable.addMouseListener(this);
    }

    public void releaseResources() {
        this._daysTable.releaseResources();
        this._daysTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this._daysTable.removeMouseListener(this);
        this._cellCheckListeners = null;
        this._daysTable = null;
        this._daysTableModel = null;
    }

    public void showBorder(boolean bl) {
        if (bl) {
            this.setBorder(BORDER);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._daysTable.setEnabled(bl);
    }

    public boolean isDayChecked(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Invalid day : " + n);
        }
        ASACheckedData aSACheckedData = (ASACheckedData)this._daysTable.getValueAt(this._daysTable.getRowForDay(n), this._daysTable.getColumnForDay(n));
        return aSACheckedData.isChecked;
    }

    public void setDayChecked(int n, boolean bl) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Invalid day : " + n);
        }
        int n2 = this._daysTable.getRowForDay(n);
        int n3 = this._daysTable.getColumnForDay(n);
        ASACheckedData aSACheckedData = (ASACheckedData)this._daysTable.getValueAt(n2, n3);
        aSACheckedData.isChecked = bl;
        this._daysTable.setValueAt(aSACheckedData, n2, n3);
        this.fireCheckValueChanged(n2, n3);
    }

    public void toggleDayChecked(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Invalid day : " + n);
        }
        int n2 = this._daysTable.getRowForDay(n);
        int n3 = this._daysTable.getColumnForDay(n);
        ASACheckedData aSACheckedData = (ASACheckedData)this._daysTable.getValueAt(n2, n3);
        aSACheckedData.isChecked = !aSACheckedData.isChecked;
        this._daysTable.setValueAt(aSACheckedData, n2, n3);
        this.fireCheckValueChanged(n2, n3);
    }

    public void checkAllDays() {
        for (int i = 1; i <= 7; ++i) {
            this.setDayChecked(i, true);
        }
    }

    public void uncheckAllDays() {
        for (int i = 1; i <= 7; ++i) {
            this.setDayChecked(i, false);
        }
    }

    public int getCheckedDayCount() {
        int n = 0;
        for (int i = 1; i <= 7; ++i) {
            if (!this.isDayChecked(i)) continue;
            ++n;
        }
        return n;
    }

    public int[] getCheckedDays() {
        int[] nArray = new int[7];
        int n = 0;
        for (int i = 1; i <= 7; ++i) {
            if (!this.isDayChecked(i)) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public int getUncheckedDayCount() {
        int n = 0;
        for (int i = 1; i <= 7; ++i) {
            if (this.isDayChecked(i)) continue;
            ++n;
        }
        return n;
    }

    public int[] getUncheckedDays() {
        int[] nArray = new int[7];
        int n = 0;
        for (int i = 1; i <= 7; ++i) {
            if (this.isDayChecked(i)) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public boolean isManagingFocus() {
        return false;
    }

    void setManagingFocus(boolean bl) {
        this._isManagingFocus = bl;
    }

    public void addCellCheckListener(ASACellCheckListener aSACellCheckListener) {
        this._cellCheckListeners.add(aSACellCheckListener);
    }

    public void removeCellCheckListener(ASACellCheckListener aSACellCheckListener) {
        this._cellCheckListeners.remove(aSACellCheckListener);
    }

    protected void fireCheckValueChanged(int n, int n2) {
        ASACellCheckEvent aSACellCheckEvent = new ASACellCheckEvent((Object)this, n, n2);
        this._daysTableModel.fireTableCellUpdated(n, n2);
        int n3 = this._cellCheckListeners.size();
        for (int i = 0; i < n3; ++i) {
            ((ASACellCheckListener)this._cellCheckListeners.get(i)).valueChanged(aSACellCheckEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this._daysTable.getDayAt(this._daysTable.getSelectedRow(), this._daysTable.getSelectedColumn());
        if (this.isEnabled() && n != -1) {
            this.toggleDayChecked(n);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._pressedRow = this._daysTable.rowAtPoint(mouseEvent.getPoint());
        this._pressedColumn = this._daysTable.columnAtPoint(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        Point point = mouseEvent.getPoint();
        if (this.isEnabled() && (n3 = this._daysTable.rowAtPoint(point)) >= 0 && n3 == this._pressedRow && (n2 = this._daysTable.columnAtPoint(point)) >= 0 && n2 == this._pressedColumn && (n = this._daysTable.getDayAt(n3, n2)) != -1) {
            this.toggleDayChecked(n);
        }
    }

    static class ASEDaysOfTheWeekCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final Border PANEL_BORDER = new EmptyBorder(2, 2, 2, 4);
        private static final Insets INSETS_CHECKBOX = new Insets(0, 0, 0, 0);
        protected ASACheckBox checkBox = new ASACheckBox();
        protected ASALabel label = new ASALabel();

        ASEDaysOfTheWeekCellRenderer() {
            this.setLayout(new BorderLayout());
            this.setBorder(PANEL_BORDER);
            this.setOpaque(true);
            this.checkBox.setOpaque(true);
            this.checkBox.setMargin(INSETS_CHECKBOX);
            this.add((Component)this.checkBox, "West");
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(2);
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                this.setVisible(false);
                this.checkBox.setVisible(false);
                this.label.setVisible(false);
            } else {
                this.setVisible(true);
                this.checkBox.setVisible(true);
                this.label.setVisible(true);
                ASACheckedData aSACheckedData = (ASACheckedData)object;
                this.checkBox.setEnabled(jTable.isEnabled() && aSACheckedData.isEnabled);
                this.checkBox.setSelected(aSACheckedData.isChecked);
                this.label.setText(aSACheckedData.toString());
                if (jTable.hasFocus() && bl) {
                    this.label.setBackground(jTable.getSelectionBackground());
                    this.label.setForeground(jTable.getSelectionForeground());
                } else {
                    this.label.setBackground(this.checkBox.getBackground());
                    this.label.setForeground(this.checkBox.getForeground());
                }
            }
            return this;
        }
    }

    class DaysTable
    extends JTable
    implements FocusListener {
        private TableColumnModel _tableColumnModel;
        private boolean _isInitialized;

        DaysTable() {
            super(3, 3);
            this._isInitialized = false;
            this.init();
            this._isInitialized = true;
        }

        private void init() {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
            String[] stringArray = dateFormatSymbols.getWeekdays();
            this._tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 3; ++i) {
                this._tableColumnModel.getColumn(i).setCellRenderer(new ASEDaysOfTheWeekCellRenderer());
                for (int j = 0; j < 3; ++j) {
                    int n = this.getDayAt(j, i);
                    if (n == -1) continue;
                    this.setValueAt(new ASACheckedData(false, (Object)stringArray[n]), j, i);
                }
            }
            this.setSelectionMode(0);
            this.setCellSelectionEnabled(true);
            this.setShowGrid(false);
            this.setRowHeight(20);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.setColumnWidths();
            this.addFocusListener(this);
        }

        public void releaseResources() {
            this.removeFocusListener(this);
        }

        private void setColumnWidths() {
            for (int i = 0; i < 3; ++i) {
                int n = 0;
                for (int j = 0; j < 3; ++j) {
                    Object object = this.getValueAt(j, i);
                    if (object == null) continue;
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(j, i);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, j, i);
                    int n2 = component.getPreferredSize().width;
                    n = Math.max(n, n2);
                }
                TableColumn tableColumn = this._tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(n);
                tableColumn.setMinWidth(n);
                tableColumn.setMaxWidth(n);
            }
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }

        public int getDayAt(int n, int n2) {
            int n3 = n * 3 + n2 + 1;
            return n3 < 1 || n3 > 7 ? -1 : n3;
        }

        public int getRowForDay(int n) {
            if (n < 1 || n > 7) {
                throw new IllegalArgumentException("Invalid day : " + n);
            }
            return (n - 1) / 3;
        }

        int getColumnForDay(int n) {
            if (n < 1 || n > 7) {
                throw new IllegalArgumentException("Invalid day : " + n);
            }
            return (n - 1) % 3;
        }

        @Override
        public boolean isManagingFocus() {
            if (!this._isInitialized) {
                return false;
            }
            return ASEDaysOfTheWeekChooser.this._isManagingFocus;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = this.getDayAt(n, n2);
            if (n3 != -1) {
                return super.getValueAt(n, n2);
            }
            return null;
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && this.getValueAt(n, n2) == null) {
                    mouseEvent.consume();
                    return;
                }
            }
            super.processMouseEvent(mouseEvent);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && this.getValueAt(n, n2) == null) {
                    mouseEvent.consume();
                    return;
                }
            }
            super.processMouseMotionEvent(mouseEvent);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                int n = this.getSelectedRow();
                int n2 = this.getSelectedColumn();
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        this.handleArrowKeyPressed(keyEvent, n, --n2);
                        break;
                    }
                    case 39: {
                        this.handleArrowKeyPressed(keyEvent, n, ++n2);
                        break;
                    }
                    case 38: {
                        this.handleArrowKeyPressed(keyEvent, --n, n2);
                        break;
                    }
                    case 40: {
                        this.handleArrowKeyPressed(keyEvent, ++n, n2);
                        break;
                    }
                    case 36: {
                        this.handleHomeOrEndKeyPressed(keyEvent, n, true);
                        break;
                    }
                    case 35: {
                        this.handleHomeOrEndKeyPressed(keyEvent, n, false);
                        break;
                    }
                    case 33: {
                        this.handlePageUpOrPageDownKeyPressed(keyEvent, n2, true);
                        break;
                    }
                    case 34: {
                        this.handlePageUpOrPageDownKeyPressed(keyEvent, n2, false);
                        break;
                    }
                    case 9: {
                        this.handleTabOrShiftTabKeyPressed(keyEvent, n, n2);
                        break;
                    }
                    default: {
                        super.processKeyEvent(keyEvent);
                    }
                }
                return;
            }
            super.processKeyEvent(keyEvent);
        }

        private void handleArrowKeyPressed(KeyEvent keyEvent, int n, int n2) {
            if (n >= 0 && n < 3 && n2 >= 0 && n2 < 3 && this.getValueAt(n, n2) == null) {
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        private void handleHomeOrEndKeyPressed(KeyEvent keyEvent, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = 0;
                n3 = 3;
                n2 = 1;
            } else {
                n4 = 2;
                n3 = -1;
                n2 = -1;
            }
            for (int i = n4; i != n3; i += n2) {
                if (this.getValueAt(n, i) == null) continue;
                this.setRowSelectionInterval(n, n);
                this.setColumnSelectionInterval(i, i);
                keyEvent.consume();
                return;
            }
            keyEvent.consume();
        }

        private void handlePageUpOrPageDownKeyPressed(KeyEvent keyEvent, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = 0;
                n3 = 3;
                n2 = 1;
            } else {
                n4 = 2;
                n3 = -1;
                n2 = -1;
            }
            for (int i = n4; i != n3; i += n2) {
                if (this.getValueAt(i, n) == null) continue;
                this.setRowSelectionInterval(i, i);
                this.setColumnSelectionInterval(n, n);
                keyEvent.consume();
                return;
            }
            keyEvent.consume();
        }

        private void handleTabOrShiftTabKeyPressed(KeyEvent keyEvent, int n, int n2) {
            int n3;
            if (!this.isManagingFocus()) {
                return;
            }
            int n4 = keyEvent.getModifiers();
            if (n4 == 0) {
                int n5 = this.getDayAt(n, n2);
                n3 = n5 == -1 || n5 == 7 ? 1 : n5 + 1;
            } else if (n4 == 1) {
                int n6 = this.getDayAt(n, n2);
                n3 = n6 == -1 || n6 == 1 ? 7 : n6 - 1;
            } else {
                super.processKeyEvent(keyEvent);
                return;
            }
            int n7 = this.getRowForDay(n3);
            int n8 = this.getColumnForDay(n3);
            this.setRowSelectionInterval(n7, n7);
            this.setColumnSelectionInterval(n8, n8);
            keyEvent.consume();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.getDayAt(this.getSelectedRow(), this.getSelectedColumn()) == -1) {
                int n = this.getRowForDay(1);
                int n2 = this.getColumnForDay(1);
                this.setRowSelectionInterval(n, n);
                this.setColumnSelectionInterval(n2, n2);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

