/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.asa.ASAButton;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import com.sybase.aseplugin.go.ASEMultiLineLabel;
import com.sybase.aseplugin.go.ASETextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ASEFileNameEditor
extends ASEMnemGridBagPanel
implements ActionListener,
DocumentListener {
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE_MUST_EXIST = 0;
    public static final int FILE_MUST_NOT_EXIST = 1;
    private static final Border BORDER = new EmptyBorder(INSETS_NONE);
    private Window _parentWindow;
    private int _type = 1;
    private int _buttonPosition = 3;
    private int _checkExist = -1;
    private int _fileFilter = 0;
    private boolean _simpleButton = false;
    private boolean _seperateLabel = false;
    private String _defaultExtension;
    private int _defaultExtensionLength;
    private boolean _isConnectionLocal = true;
    private String _initFilePath = "";
    private String _additionalNote;
    private ASETextField _textField;
    private ASAButton _button;
    private ASEMultiLineLabel _multiLineLabel;

    public ASEFileNameEditor(int n, int n2) {
        this(n, -1, n2);
    }

    public ASEFileNameEditor(int n, int n2, int n3) {
        this(n, n2, n3, false, false);
    }

    public ASEFileNameEditor(int n, int n2, int n3, boolean bl, boolean bl2) {
        this(n, n2, n3, bl, bl2, null);
    }

    public ASEFileNameEditor(int n, int n2, int n3, boolean bl, boolean bl2, String string) {
        this._buttonPosition = n;
        this._checkExist = n2;
        this._fileFilter = n3;
        this._simpleButton = bl;
        this._seperateLabel = bl2;
        this._additionalNote = string;
        this._init();
    }

    private void _init() {
        String string;
        this.setBorder(BORDER);
        this._textField = new ASETextField();
        if (!this._simpleButton) {
            this._button = new ASAButton(ASEUtils.getString("BTTN_BROWSE"));
            this._button.setMnemonic(ASEUtils.getMnemonic("MNEM_BROWSE"));
        } else {
            this._button = new ASAButton("...");
        }
        if (!this._seperateLabel) {
            this._multiLineLabel = new ASEMultiLineLabel(this.getMessageText());
        }
        if (this._simpleButton) {
            this._button.setMargin(new Insets(1, 1, 1, 1));
        }
        Insets insets = this._simpleButton ? new Insets(1, 1, 1, 1) : INSETS;
        switch (this._buttonPosition) {
            case 4: {
                this.add((Component)((Object)this._textField), 0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
                this.add((Component)this._button, 1, 0, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0);
                if (this._seperateLabel) break;
                this.add(this._multiLineLabel, 0, 1, 0, 1, 1.0, 0.0, 18, 2, INSETS_LAST, 0, 0);
                break;
            }
            case 3: {
                this.add((Component)((Object)this._textField), 0, 0, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
                if (!this._seperateLabel) {
                    this.add(this._multiLineLabel, 0, 1, 1, 1, 1.0, 0.0, 18, 2, INSETS_LAST, 0, 0);
                }
                this.add((Component)this._button, 1, 1, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setConnectionLocal(this._isConnectionLocal);
        this._button.addActionListener((ActionListener)this);
        if (this._isConnectionLocal && (string = Support.getInitDirectory()) != null) {
            this._initFilePath = string;
        }
    }

    private String getMessageText() {
        String string = "";
        if (this._isConnectionLocal) {
            String string2 = this.getFileName();
            if (string2 == null || string2.length() != 0) {
                if (this._checkExist == 0) {
                    if (this._type == 2 && !ASEUtils.isExistingDirectory(string2)) {
                        string = ASEUtils.getString("FILENAMEEDIT_NOTE_DIRECTORY_NOT_EXIST");
                    } else if (this._type == 1 && !ASEUtils.isExistingFile(string2)) {
                        string = ASEUtils.getString("FILENAMEEDIT_NOTE_FILE_NOT_EXIST");
                    }
                } else if (this._checkExist == 1) {
                    if (string2 != null && string2.length() > 0 && ASEUtils.isExistingDirectory(string2)) {
                        string = ASEUtils.getString("FILENAMEEDIT_NOTE_DIRECTORY_EXISTS");
                    } else if (ASEUtils.isExistingFile(string2)) {
                        string = ASEUtils.getString("FILENAMEEDIT_NOTE_FILE_EXISTS");
                    }
                }
            }
        } else {
            switch (this._type) {
                case 1: {
                    string = ASEUtils.getString("FILENAMEEDIT_NOTE_FILE_NAME_RELATIVE_TO_SERVER");
                    break;
                }
                case 2: {
                    string = ASEUtils.getString("FILENAMEEDIT_NOTE_DIRECTORY_NAME_RELATIVE_TO_SERVER");
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (string.length() > 0 && this._additionalNote != null) {
            return string + " " + this._additionalNote;
        }
        return string;
    }

    public void releaseResources() {
        this._button.removeActionListener((ActionListener)this);
        this._parentWindow = null;
        this._textField = null;
        this._button = null;
        this._multiLineLabel = null;
    }

    public Window getParentWindow() {
        return this._parentWindow;
    }

    public void setParentWindow(Window window) {
        this._parentWindow = window;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    public int getCheckExist() {
        return this._checkExist;
    }

    public void setCheckExist(int n) {
        this._checkExist = n;
    }

    public int getButtonPosition() {
        return this._buttonPosition;
    }

    public void setButtonPosition(int n) {
        this._buttonPosition = n;
    }

    public int getFileFilter() {
        return this._fileFilter;
    }

    public void setFileFilter(int n) {
        this._fileFilter = n;
    }

    public String getDefaultExtension() {
        return this._defaultExtension;
    }

    public void setDefaultExtension(String string) {
        this._defaultExtension = string;
        this._defaultExtensionLength = string == null ? 0 : string.length();
    }

    public void setAdditionalNote(String string) {
        this._additionalNote = string;
    }

    public boolean isConnectionLocal() {
        return this._isConnectionLocal;
    }

    public void setConnectionLocal(boolean bl) {
        this._isConnectionLocal = bl;
        this._button.setVisible(bl);
        if (!this._seperateLabel && this._multiLineLabel != null) {
            this._multiLineLabel.setText(this.getMessageText());
        }
        if (bl) {
            this.addDocumentListener(this);
        } else {
            this.removeDocumentListener(this);
            this._initFilePath = "";
        }
    }

    public ASETextField getTextField() {
        return this._textField;
    }

    public ASAButton getButton() {
        return this._button;
    }

    public ASEMultiLineLabel getMultiLineLabel() {
        return this._multiLineLabel;
    }

    public String getFileName() {
        return this._textField.getText().trim();
    }

    public void setFileName(String string) {
        this._textField.setText(string);
    }

    public String getInitFilePath() {
        return this._initFilePath;
    }

    public void setInitFilePath(String string) {
        if (string != null) {
            this._initFilePath = string;
        }
    }

    public boolean isEnabled() {
        return this._textField.isEnabled();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._textField.setEnabled(bl);
        this._button.setEnabled(bl && this._isConnectionLocal);
        if (this._multiLineLabel != null) {
            this._multiLineLabel.setEnabled(bl);
        }
    }

    public void alignLeftLabel(JComponent jComponent) {
        if (!this._seperateLabel) {
            int n;
            switch (this._buttonPosition) {
                case 4: {
                    n = this._button.getPreferredSize().height;
                    break;
                }
                case 3: {
                    n = this._textField.getPreferredSize().height;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Locale locale = Locale.getDefault();
            if (locale.getLanguage().equals("zh") || locale.getLanguage().equals("ja")) {
                jComponent.setPreferredSize(new Dimension(jComponent.getPreferredSize().width + 25, n));
            } else {
                jComponent.setPreferredSize(new Dimension(jComponent.getPreferredSize().width, n));
            }
        }
    }

    public void setMultiLineLabel(ASEMultiLineLabel aSEMultiLineLabel) {
        if (this._seperateLabel) {
            this._multiLineLabel = aSEMultiLineLabel;
        }
    }

    private void _browse() {
        String string;
        String string2 = this.getFileName();
        File file = null;
        if (string2.length() == 0) {
            if (this._initFilePath != null && this._initFilePath.length() > 0) {
                file = new File(this._initFilePath);
            }
        } else {
            file = new File(string2);
        }
        if (this._type == 2) {
            string = Support.browseForDirectory(this._parentWindow, file);
        } else if (this._checkExist == 0) {
            string = Support.browseForFile(this._parentWindow, file, this._fileFilter);
        } else {
            if (file != null && file.isFile()) {
                file = file.getParentFile();
            }
            string = Support.browseForNewFile(this._parentWindow, file, this._fileFilter);
        }
        if (string != null) {
            this._textField.setText(this.getFileNameWithDefaultExtension(string).trim());
        }
    }

    private String getFileNameWithDefaultExtension(String string) {
        int n = string.length();
        if (!(this._defaultExtension == null || n <= 0 || n > this._defaultExtensionLength && string.charAt(n - this._defaultExtensionLength - 1) == '.' && string.regionMatches(true, n - this._defaultExtensionLength, this._defaultExtension, 0, this._defaultExtensionLength))) {
            return string + '.' + this._defaultExtension;
        }
        return string;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this._textField.getDocument().addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this._textField.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    private void textValueChanged(DocumentEvent documentEvent) {
        if (this._multiLineLabel != null) {
            this._multiLineLabel.setText(this.getMessageText());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._button) {
            this._browse();
        }
    }

    public void selectAll() {
        this._textField.requestFocus();
        this._textField.selectAll();
    }
}

