/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.aseplugin.go.ASETextField;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ASEIntegerTextField
extends ASETextField {
    private int minValue = 0;
    private int maxValue = 1024;

    public ASEIntegerTextField() {
        this.setValue(this.minValue);
        this.init();
    }

    public ASEIntegerTextField(int n, int n2, int n3) {
        this.setValue(n);
        this.maxValue = n2;
        this.maxValue = n3;
        this.init();
    }

    private void init() {
        this.setDocument(new IntegerDocument(this.minValue, this.maxValue));
        this.setHorizontalAlignment(4);
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setValue(int n) {
        if (n < this.minValue || n > this.maxValue) {
            // empty if block
        }
        this.setText(String.valueOf(n));
    }

    public void setValue(Integer n) {
        if (this.isValid(n)) {
            this.setText(String.valueOf(n));
        }
    }

    public boolean isValid(int n) {
        boolean bl = false;
        if (n >= this.minValue && n <= this.maxValue) {
            bl = true;
        }
        return bl;
    }

    public void setPreferredWidthToDigits(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        try {
            int n2 = (int)(Math.pow(10.0, n) - 1.0);
            int n3 = fontMetrics.stringWidth(String.valueOf(n2));
            this.setPreferredWidth(n3, true);
            this.setMinimumSize(new Dimension(n3, this.getMinimumSize().height));
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
    }

    private class IntegerDocument
    extends PlainDocument {
        int minValue = 0;
        int maxValue = 100;

        public IntegerDocument(int n, int n2) {
            this.minValue = n;
            this.maxValue = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            block10: {
                if (n2 == 0 && (string == null || string.length() == 0)) {
                    return;
                }
                this.writeLock();
                try {
                    if (n2 > 0) {
                        this.remove(n, n2);
                    }
                    if (string == null || string.length() <= 0) break block10;
                    try {
                        int n3 = Integer.parseInt(string);
                        if (n3 > this.maxValue) {
                        } else {
                            int n4;
                            this.insertString(n, string, attributeSet);
                            String string2 = this.getText(0, this.getLength());
                            if (string2 != null && string2.length() != 0 && (n4 = Integer.parseInt(string2)) > this.maxValue) {
                                this.remove(n, 1);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                finally {
                    this.writeUnlock();
                }
            }
        }
    }
}

