/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.asa.ASATextField;
import com.sybase.util.ds.ui.NumericsOnlyDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;

public class ASESpinBox
extends JPanel
implements ActionListener,
FocusListener {
    private static final String INCREMENT_COMMAND = "0";
    private static final String DECREMENT_COMMAND = "1";
    SpinTextField _textField = new SpinTextField();
    SpinButtonPanel _buttonPanel = new SpinButtonPanel();
    int _currentValue;
    int _minimumValue;
    int _maximumValue;
    private int _incrementValue;
    private Vector _spinBoxChangeListeners;
    private boolean _commitOnFocusLost = true;

    public ASESpinBox() {
        this._maximumValue = Integer.MAX_VALUE;
        this._minimumValue = 0;
        this._incrementValue = 1;
        this._spinBoxChangeListeners = new Vector();
        this._init();
    }

    public ASESpinBox(int n) {
        this._maximumValue = Integer.MAX_VALUE;
        this._minimumValue = 0;
        this._incrementValue = 1;
        this._spinBoxChangeListeners = new Vector();
        this._currentValue = n;
        this._init();
    }

    public ASESpinBox(int n, int n2, int n3) {
        this._incrementValue = 1;
        this._spinBoxChangeListeners = new Vector();
        this._currentValue = n;
        this._minimumValue = n2;
        this._maximumValue = n3;
        this._init();
    }

    public ASESpinBox(int n, int n2, int n3, int n4) {
        this._spinBoxChangeListeners = new Vector();
        this._currentValue = n;
        this._minimumValue = n2;
        this._maximumValue = n3;
        this._incrementValue = n4;
        this._init();
    }

    private void _init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this._textField.getBorder());
        this._textField.setBorder(null);
        this._buttonPanel.setPreferredSize(new Dimension(16, this._buttonPanel.getPreferredSize().height));
        this.add((Component)((Object)this._textField), "Center");
        this.add((Component)this._buttonPanel, "East");
        this.setPreferredWidthToDigits(String.valueOf(this._maximumValue).length());
        this._textField.registerKeyboardAction(this, INCREMENT_COMMAND, KeyStroke.getKeyStroke(38, 0), 0);
        this._textField.registerKeyboardAction(this, DECREMENT_COMMAND, KeyStroke.getKeyStroke(40, 0), 0);
        this._textField.addFocusListener(this);
        this._textField.setHorizontalAlignment(4);
        this._textField.setValue(this._currentValue);
        this._updateValue(false);
        this._textField.setHighlighter(new TFHighLighter());
    }

    public void releaseResources() {
        this._textField.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this._textField.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this._textField.removeFocusListener(this);
        this._textField.releaseResources();
        this._buttonPanel.releaseResources();
        this._textField = null;
        this._buttonPanel = null;
        this._spinBoxChangeListeners = null;
    }

    public ASEIntTextField getTextField() {
        return this._textField;
    }

    public int getMinimum() {
        return this._minimumValue;
    }

    public void setMinimum(int n) {
        this._minimumValue = n;
        this._updateValue(false);
    }

    public int getMaximum() {
        return this._maximumValue;
    }

    public void setMaximum(int n) {
        this._maximumValue = n;
        this._updateValue(false);
    }

    public int getIncrement() {
        return this._incrementValue;
    }

    public void setIncrement(int n) {
        this._incrementValue = n;
    }

    public int getValue() {
        return this._currentValue;
    }

    public void setValue(int n) {
        this._currentValue = n;
        this._updateValue(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._textField.setEnabled(bl);
        this._buttonPanel.setEnabled(bl);
    }

    public boolean isEditable() {
        return this._textField.isEditable();
    }

    public void setEditable(boolean bl) {
        this._textField.setEditable(bl);
    }

    public boolean getCommitOnFocusLost() {
        return this._commitOnFocusLost;
    }

    public void setCommitOnFocusLost(boolean bl) {
        this._commitOnFocusLost = bl;
    }

    public void setPreferredWidthToDigits(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        try {
            Insets insets;
            Border border;
            int n2 = (int)(Math.pow(10.0, n) - 1.0);
            int n3 = fontMetrics.stringWidth(String.valueOf(n2));
            Insets insets2 = this._textField.getInsets();
            if (insets2 != null) {
                n3 += insets2.left + insets2.right;
            }
            if ((border = this.getBorder()) != null && (insets = border.getBorderInsets(this)) != null) {
                n3 += insets.left + insets.right;
            }
            this._textField.setPreferredSize(new Dimension(n3, this._textField.getPreferredSize().height));
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isEnabled()) {
            return this._textField.requestFocusInWindow();
        }
        return false;
    }

    @Override
    public void requestFocus() {
        this.requestFocusInWindow();
    }

    public void addSpinBoxChangeListener(ASASpinBoxChangeListener aSASpinBoxChangeListener) {
        this._spinBoxChangeListeners.add(aSASpinBoxChangeListener);
    }

    public void removeSpinBoxChangeListener(ASASpinBoxChangeListener aSASpinBoxChangeListener) {
        this._spinBoxChangeListeners.remove(aSASpinBoxChangeListener);
    }

    protected void fireSpinBoxValueChanged(int n) {
        ASASpinBoxChangeEvent aSASpinBoxChangeEvent = new ASASpinBoxChangeEvent((Object)this, n);
        int n2 = this._spinBoxChangeListeners.size();
        for (int i = 0; i < n2; ++i) {
            ((ASASpinBoxChangeListener)this._spinBoxChangeListeners.get(i)).valueChanged(aSASpinBoxChangeEvent);
        }
    }

    public synchronized void increment() {
        if (this._currentValue > Integer.MAX_VALUE - this._incrementValue) {
            return;
        }
        this._currentValue += this._incrementValue;
        this._updateValue(this.isEnabled());
    }

    public synchronized void decrement() {
        this._currentValue -= this._incrementValue;
        this._updateValue(this.isEnabled());
    }

    public void _commitValue() {
        this._currentValue = this._textField.getValue();
        this._updateValue(false);
    }

    private void _updateValue(boolean bl) {
        if (this._currentValue <= this._minimumValue) {
            this._currentValue = this._minimumValue;
        } else if (this._currentValue >= this._maximumValue) {
            this._currentValue = this._maximumValue;
        }
        if (this._textField.getText().trim().length() == 0 || this._textField.getValue() != this._currentValue || !this._textField.getText().equals(String.valueOf(this._currentValue))) {
            this._textField.setValue(this._currentValue);
        }
        if (bl) {
            this._textField.selectAll();
        }
        this._buttonPanel.upEnabled = this._currentValue < this._maximumValue;
        this._buttonPanel.downEnabled = this._currentValue > this._minimumValue;
        this.fireSpinBoxValueChanged(this._currentValue);
        this._buttonPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(INCREMENT_COMMAND)) {
                this.increment();
            } else if (string.equals(DECREMENT_COMMAND)) {
                this.decrement();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.isEnabled()) {
            this._textField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.isEnabled() && this._commitOnFocusLost) {
            this._commitValue();
        } else {
            this._updateValue(false);
        }
    }

    public class ASEIntTextField
    extends ASATextField {
        public ASEIntTextField() {
            this._init();
        }

        public ASEIntTextField(String string) {
            super(string);
            this._init();
        }

        public ASEIntTextField(int n) {
            super(n);
            this._init();
        }

        public ASEIntTextField(String string, int n) {
            super(string, n);
            this._init();
        }

        private void _init() {
            this.setDocument((Document)new NumericsOnlyDocument(true));
            this.setHorizontalAlignment(4);
        }

        public int getValue() {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                if (this.getText().length() > 0 && Long.parseLong(this.getText()) > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return 0;
            }
        }

        public void setValue(int n) {
            this.setText(String.valueOf(n));
        }

        public void setPreferredWidthToDigits(int n) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            try {
                int n2 = (int)(Math.pow(10.0, n) - 1.0);
                int n3 = fontMetrics.stringWidth(String.valueOf(n2));
                this.setPreferredWidth(n3, true);
                this.setMinimumSize(new Dimension(n3, this.getMinimumSize().height));
            }
            catch (ArithmeticException arithmeticException) {
                return;
            }
        }
    }

    class TFHighLighter
    extends DefaultHighlighter {
        TFHighLighter() {
        }

        @Override
        public void paint(Graphics graphics) {
            try {
                super.paint(graphics);
            }
            catch (Exception exception) {
                return;
            }
        }

        @Override
        public boolean getDrawsLayeredHighlights() {
            return false;
        }
    }

    private final class SpinButtonPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        boolean upEnabled = true;
        boolean downEnabled = true;
        boolean _upEntered;
        boolean _downEntered;
        boolean _upPressed;
        boolean _downPressed;

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            ASESpinBox.this._buttonPanel.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Color color = this.getForeground();
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = 10;
            int n4 = 5;
            int n5 = n / 2 - n3 / 2;
            int n6 = n2 / 4 - n4 / 2 + 1;
            if (this.upEnabled && this._upEntered && this._upPressed) {
                this.getBorder().paintBorder(this, graphics, 0, 0, n, n2 / 2);
                graphics.setColor(SystemColor.controlShadow);
                graphics.fillRect(1, 1, n - 2, n2 / 2 - 2);
            }
            if (this.downEnabled && this._downEntered && this._downPressed) {
                this.getBorder().paintBorder(this, graphics, 0, n2 / 2, n, n2 / 2);
                graphics.setColor(SystemColor.controlShadow);
                graphics.fillRect(1, n2 / 2 + 1, n - 2, n2 / 2 - 2);
            }
            graphics.translate(n5, n6);
            if (this.isEnabled() && this.upEnabled) {
                graphics.setColor(color);
            } else {
                graphics.setColor(SystemColor.textInactiveText);
            }
            graphics.drawLine(4, 0, 4 + (n3 - 9), 0);
            graphics.drawLine(3, 1, 3 + (n3 - 7), 1);
            graphics.drawLine(2, 2, 2 + (n3 - 5), 2);
            graphics.drawLine(1, 3, 1 + (n3 - 3), 3);
            graphics.translate(-n5, -n6);
            n6 = 3 * n2 / 4 - (n4 / 2 + 2);
            graphics.translate(n5, n6);
            if (this.isEnabled() && this.downEnabled) {
                graphics.setColor(color);
            } else {
                graphics.setColor(SystemColor.textInactiveText);
            }
            graphics.drawLine(1, 1, 1 + (n3 - 3), 1);
            graphics.drawLine(2, 2, 2 + (n3 - 5), 2);
            graphics.drawLine(3, 3, 3 + (n3 - 7), 3);
            graphics.drawLine(4, 4, 4 + (n3 - 9), 4);
        }

        private void _pressButton(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getY();
            if (n2 < (n = this.getHeight()) / 2) {
                this._upPressed = true;
            } else {
                this._downPressed = true;
            }
            new SpinButtonThread().start();
        }

        private void _releaseButtons() {
            this._upPressed = false;
            this._downPressed = false;
            ASESpinBox.this._textField.requestFocusInWindow();
            this.repaint();
        }

        private void _updateButtons(MouseEvent mouseEvent) {
            boolean bl;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            boolean bl2 = bl = n >= 0 && n < n3 && n2 >= 0 && n2 < n4;
            if (!bl) {
                this._upEntered = false;
                this._downEntered = false;
            } else if (n2 < n4 / 2) {
                this._upEntered = true;
                this._downEntered = false;
            } else {
                this._upEntered = false;
                this._downEntered = true;
            }
            this.repaint();
        }

        public void releaseResources() {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.isEnabled()) {
                this._pressButton(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isEnabled()) {
                this._releaseButtons();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.isEnabled()) {
                this._updateButtons(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.isEnabled()) {
                this._updateButtons(mouseEvent);
            }
        }

        SpinButtonPanel() {
            this.setBorder(new LineBorder(SystemColor.controlShadow));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        private final class SpinButtonThread
        extends Thread {
            private final int LONG_SLEEP_TIME = 300;
            private final int SHORT_SLEEP_TIME = 100;
            private final int LONG_SLEEP_COUNT = 2;

            @Override
            public void run() {
                int n = 300;
                int n2 = 0;
                while (SpinButtonPanel.this._upPressed || SpinButtonPanel.this._downPressed) {
                    if (SpinButtonPanel.this._upEntered && SpinButtonPanel.this._upPressed) {
                        ASESpinBox.this.increment();
                    } else if (SpinButtonPanel.this._downEntered && SpinButtonPanel.this._downPressed) {
                        ASESpinBox.this.decrement();
                    }
                    try {
                        Thread.sleep(n);
                    }
                    catch (Exception exception) {
                        return;
                    }
                    if (++n2 <= 2) continue;
                    n = 100;
                }
            }

            SpinButtonThread() {
            }
        }
    }

    private final class SpinTextField
    extends ASEIntTextField
    implements KeyListener {
        private void _updateCurrentValue() {
            ASESpinBox.this._commitValue();
        }

        public void releaseResources() {
            this.removeKeyListener(this);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this._updateCurrentValue();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        SpinTextField() {
            this.addKeyListener(this);
        }
    }
}

