/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.aseplugin.bo.ResultSetDetailsPanel;
import com.sybase.aseplugin.util.ui.TableSorter;
import com.sybase.resultSetTable.ClipboardFormat;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ASETable
extends JTable {
    private String _nullDisplayString;
    protected static ClipboardOwner _defaultClipboardOwner = null;
    protected ClipboardFormat _clipboardFormat = new ClipboardFormat();
    protected static final char[] _hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ASETable() {
        this.setModel(new TableSorter(this.getModel()));
        this.initTableHeader();
    }

    public ASETable(int n, int n2) {
        super(n, n2);
        this.setModel(new TableSorter(this.getModel()));
        this.initTableHeader();
    }

    public ASETable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.setModel(new TableSorter(this.getModel()));
        this.initTableHeader();
    }

    public ASETable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.setModel(new TableSorter(this.getModel()));
        this.initTableHeader();
    }

    public ASETable(TableModel tableModel) {
        super(new TableSorter(tableModel));
        this.initTableHeader();
    }

    public ASETable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(new TableSorter(tableModel), tableColumnModel);
        this.initTableHeader();
    }

    public ASETable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(new TableSorter(tableModel), tableColumnModel, listSelectionModel);
        this.initTableHeader();
    }

    void initTableHeader() {
        JTableHeader jTableHeader = this.getTableHeader();
        ((TableSorter)this.getModel()).setTableHeader(jTableHeader);
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(new TableSorter(tableModel));
        this.initTableHeader();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Object object = this.getValueAt(n, n2);
            String string = null;
            if (object instanceof String) {
                string = object.toString();
            } else if (object instanceof JLabel) {
                string = ((JLabel)object).getText();
            } else if (object instanceof char[]) {
                string = object.toString();
            }
            jComponent.setToolTipText(string != null && string.length() > 0 ? string : null);
        }
        return component;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9 && this.getModel().getRowCount() == 0) {
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    public void copy() {
        int n;
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._clipboardFormat.copyWithHeader) {
            int n2 = this.getModel().getColumnCount();
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(this._clipboardFormat.columnDelimiter);
                }
                stringBuffer.append(this.getModel().getColumnName(n));
            }
            stringBuffer.append("\n");
        }
        for (n = 0; n < nArray.length; ++n) {
            this.formatRow(stringBuffer, nArray[n]);
            stringBuffer.append("\n");
        }
        if (_defaultClipboardOwner == null) {
            _defaultClipboardOwner = new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            };
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, _defaultClipboardOwner);
    }

    protected void formatRow(StringBuffer stringBuffer, int n) {
        this._nullDisplayString = ResultSetDetailsPanel.getProfNullDisplay();
        int n2 = this.getModel().getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            if (i > 0) {
                stringBuffer.append(this._clipboardFormat.columnDelimiter);
            }
            if ((object = this.getModel().getValueAt(n, i)) == null) {
                stringBuffer.append(this._nullDisplayString);
                continue;
            }
            if (object instanceof byte[]) {
                if (this._clipboardFormat.formatBinaryAsHex) {
                    this.formatBinaryValue(stringBuffer, (byte[])object);
                    continue;
                }
                object = new String((byte[])object);
            }
            boolean bl = this._clipboardFormat.quoteAllValues || object instanceof String;
            String string = object.toString();
            if (this._clipboardFormat.maxValueLength != 0 && string.length() > this._clipboardFormat.maxValueLength) {
                string = string.substring(0, this._clipboardFormat.maxValueLength);
            }
            this.formatString(stringBuffer, string, bl, this._clipboardFormat.quoteString, this._clipboardFormat.escapeChar);
        }
    }

    protected void formatBinaryValue(StringBuffer stringBuffer, byte[] byArray) {
        stringBuffer.ensureCapacity(stringBuffer.length() + byArray.length * 2 + 2);
        if (byArray.length > 0) {
            stringBuffer.append("0x");
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] >> 4 & 0xF;
                int n2 = byArray[i] & 0xF;
                stringBuffer.append(_hexTable[n]);
                stringBuffer.append(_hexTable[n2]);
            }
        }
    }

    protected void formatString(StringBuffer stringBuffer, String string, boolean bl, String string2, char c) {
        int n;
        boolean bl2 = bl && string2.length() == 1;
        char c2 = bl2 ? string2.charAt(0) : (char)'\u0000';
        if (bl) {
            stringBuffer.append(string2);
        }
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4 = string.charAt(n);
            if (this.isPrintableASCII((char)n4)) {
                if (bl2 && n4 == c2) {
                    stringBuffer.append(string.toCharArray(), n3, n - n3 + 1);
                    stringBuffer.append(c2);
                    n3 = n + 1;
                    continue;
                }
                if (n4 != c) continue;
                stringBuffer.append(string.toCharArray(), n3, n - n3);
                stringBuffer.append(c);
                stringBuffer.append(c);
                n3 = n + 1;
                continue;
            }
            if (n - n3 > 0) {
                stringBuffer.append(string.toCharArray(), n3, n - n3);
            }
            stringBuffer.append(c);
            n3 = n + 1;
            int n5 = n4;
            if (n5 < -1) {
                n5 += 65536;
            }
            if (n5 < 256) {
                stringBuffer.append("x");
                stringBuffer.append(_hexTable[n5 >> 4 & 0xF]);
                stringBuffer.append(_hexTable[n5 & 0xF]);
                continue;
            }
            stringBuffer.append("u");
            stringBuffer.append(_hexTable[n5 >> 12 & 0xF]);
            stringBuffer.append(_hexTable[n5 >> 8 & 0xF]);
            stringBuffer.append(_hexTable[n5 >> 4 & 0xF]);
            stringBuffer.append(_hexTable[n5 & 0xF]);
        }
        if (n - n3 > 0) {
            stringBuffer.append(string.toCharArray(), n3, n - n3);
        }
        if (bl) {
            stringBuffer.append(string2);
        }
    }

    protected boolean isPrintableASCII(char c) {
        int n = Character.getType(c);
        return n != 15 && n != 13 && n != 0;
    }
}

