/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go;

import com.sybase.aseplugin.go.DropDownButtonEvent;
import com.sybase.aseplugin.go.DropDownButtonListener;
import com.sybase.aseplugin.go.SybDropDownButtonModel;
import com.sybase.aseplugin.go.TDDBUI;
import com.sybase.util.SybToolBarButton;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ButtonUI;

public class ASEToolBarDropDownButton
extends SybToolBarButton {
    static final int BORDER_SIZE = 2;
    private EventListenerList _dropDownButtonListeners = new EventListenerList();

    public ASEToolBarDropDownButton(Icon icon, Object[] objectArray) {
        this(icon, objectArray, null);
    }

    public ASEToolBarDropDownButton(Icon icon, Object[] objectArray, Icon[] iconArray) {
        super(icon);
        this.init(objectArray, iconArray);
    }

    private void init(Object[] objectArray, Icon[] iconArray) {
        this.setAlignmentY(0.5f);
        this.setBorder(this.getNoBorder());
        ButtonModel buttonModel = this.getModel();
        super.setModel((ButtonModel)new SybDropDownButtonModel(buttonModel, objectArray, iconArray));
        ButtonUI buttonUI = this.getUI();
        super.setUI((ButtonUI)new TDDBUI(buttonUI, this));
    }

    public void setListData(Object[] objectArray) {
        this.setListData(objectArray, null);
    }

    public void setListData(Object[] objectArray, Icon[] iconArray) {
        SybDropDownButtonModel sybDropDownButtonModel = (SybDropDownButtonModel)this.getModel();
        sybDropDownButtonModel.setListData(objectArray, iconArray);
    }

    public void addDropDownButtonListener(DropDownButtonListener dropDownButtonListener) {
        if (dropDownButtonListener instanceof DropDownButtonListener) {
            this._dropDownButtonListeners.add(DropDownButtonListener.class, dropDownButtonListener);
        }
    }

    public void removeDropDownButtonListener(DropDownButtonListener dropDownButtonListener) {
        if (dropDownButtonListener instanceof DropDownButtonListener) {
            this._dropDownButtonListeners.remove(DropDownButtonListener.class, dropDownButtonListener);
        }
    }

    public void showDropDown() {
        ((SybDropDownButtonModel)this.getModel()).fireDropDownEvent();
    }

    void fireDropDownItemClickedEvent(int n) {
        DropDownButtonEvent dropDownButtonEvent = null;
        Object[] objectArray = this._dropDownButtonListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (dropDownButtonEvent == null) {
                dropDownButtonEvent = new DropDownButtonEvent((Object)this, n);
            }
            ((DropDownButtonListener)objectArray[i + 1]).dropDownItemClicked(dropDownButtonEvent);
        }
    }

    void fireDropDownOpeningEvent() {
        DropDownButtonEvent dropDownButtonEvent = null;
        Object[] objectArray = this._dropDownButtonListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (dropDownButtonEvent == null) {
                dropDownButtonEvent = new DropDownButtonEvent((Object)this);
            }
            ((DropDownButtonListener)objectArray[i + 1]).dropDownOpening(dropDownButtonEvent);
        }
    }

    protected void initializeBorders() {
        if (this._isXP) {
            this._buttonBorder = this._noBorder = BorderFactory.createEmptyBorder(6, 6, 6, 24);
            this._pressedButtonBorder = this._noBorder;
            _pressedButtonBorderColor = SystemColor.controlShadow;
            _pressedButtonColor = this.averageColor(SystemColor.controlLtHighlight, SystemColor.controlShadow);
            _borderColor = this.averageColor(SystemColor.control, SystemColor.controlShadow);
            _enteredColor = this.averageColor(SystemColor.control, SystemColor.controlLtHighlight);
        } else {
            Border border = BorderFactory.createEmptyBorder(2, 2, 2, 20);
            Border border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            this._noBorder = BorderFactory.createCompoundBorder(border2, border);
            this._buttonBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), border);
            this._pressedButtonBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), border);
        }
    }

    protected Border getNoBorder() {
        return this._noBorder;
    }

    protected Border getButtonBorder() {
        return this._buttonBorder;
    }

    protected Border getPressedButtonBorder() {
        return this._pressedButtonBorder;
    }
}

