/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go.prop;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASAButton;
import com.sybase.asa.ASALabel;
import com.sybase.aseplugin.ASEConstants;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.IntegerEditor;
import com.sybase.aseplugin.go.prop.LPMetricTableModel;
import com.sybase.aseplugin.go.prop.TableAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;

public class LoadProfileCommonGOPage
extends ASABaseGridBagPanel
implements ASEConstants,
CellEditorListener {
    private ASALabel nameLabel;
    private ASALabel lpNameText;
    private ASALabel lpTypeText;
    private ASAButton changeBtn;
    private ASALabel sumValueLabel;
    private LPMetricTableModel tableModel;
    private ASETable metricTable;
    private ASALabel loginRedirText;
    private ASALabel minLoadScoreText;
    private ASALabel dynMigrText;
    private static final int METRIC_NAME_COLUMN = 0;
    private static final int METRIC_DATA_COLUMN = 1;
    private static final Vector headings = new Vector();

    public ASABaseGridBagPanel createNamePanel(ImageIcon imageIcon) {
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        this.nameLabel = imageIcon != null ? new ASALabel((Icon)imageIcon, 2) : new ASALabel(ASEUtils.getString("LABC_NAME"));
        this.lpNameText = new ASALabel();
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("LABC_TYPE"));
        this.lpTypeText = new ASALabel();
        int n = 0;
        aSABaseGridBagPanel.add((Component)this.nameLabel, 0, n, 1, 1, 0.3, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.lpNameText, 1, n++, 3, 1, 0.7, 0.0, 17, 2, INSETS_MIDDLE, 0, 0);
        aSABaseGridBagPanel.add((Component)aSALabel, 0, ++n, 1, 1, 0.3, 0.0, 17, 0, INSETS_MIDDLE, 0, 0);
        aSABaseGridBagPanel.add((Component)this.lpTypeText, 1, n, 3, 1, 0.7, 0.0, 17, 2, INSETS_MIDDLE, 0, 0);
        this.add(Box.createGlue(), 0, ++n, 0, 1, 0.0, 1.0, 10, 3, INSETS_NONE, 0, 0);
        return aSABaseGridBagPanel;
    }

    public ASABaseGridBagPanel createChangePanel() {
        ASEMnemGridBagPanel aSEMnemGridBagPanel = new ASEMnemGridBagPanel(INSETS_NONE);
        this.changeBtn = new ASAButton(ASEUtils.getString("BTTN_CHANGE"));
        this.changeBtn.setMnemonic(ASEUtils.getMnemonic("MNEM_CHANGE"));
        aSEMnemGridBagPanel.add((Component)this.changeBtn, 0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 15, 15, 15), 0, 0);
        this.add(Box.createGlue(), 0, 1, 0, 1, 0.0, 1.0, 10, 3, INSETS_NONE, 0, 0);
        return aSEMnemGridBagPanel;
    }

    public ASABaseGridBagPanel createTablePanel(Vector vector) {
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        aSABaseGridBagPanel.setMinimumSize(new Dimension(200, 150));
        this.metricTable = this.createMetricTable(vector);
        TableAction tableAction = new TableAction(this.metricTable);
        this.metricTable.getInputMap().put(KeyStroke.getKeyStroke(9, 0, false), "TAB");
        this.metricTable.getActionMap().put("TAB", tableAction);
        JScrollPane jScrollPane = new JScrollPane(this.metricTable);
        aSABaseGridBagPanel.add((Component)jScrollPane, 0, 0, 0, 0, 1.0, 1.0, 17, 1, INSETS, 0, 0);
        return aSABaseGridBagPanel;
    }

    private ASETable createMetricTable(Vector vector) {
        this.tableModel = new LPMetricTableModel(headings, vector);
        this.tableModel.setColumnEditable(0, false);
        ASETable aSETable = new ASETable(this.tableModel);
        aSETable.setPreferredScrollableViewportSize(new Dimension(180, 120));
        aSETable.setMinimumSize(new Dimension(180, 120));
        aSETable.getColumnModel().getColumn(0).setPreferredWidth(128);
        aSETable.getColumnModel().getColumn(1).setPreferredWidth(60);
        IntegerEditor integerEditor = new IntegerEditor(0, 0, 100);
        aSETable.getColumnModel().getColumn(1).setCellEditor(integerEditor);
        integerEditor.addCellEditorListener(this);
        return aSETable;
    }

    public void setMetricsEditable(boolean bl) {
        this.tableModel.setColumnEditable(1, bl);
        this.metricTable.setEnabled(bl);
    }

    public ASABaseGridBagPanel createSumPanel(int n) {
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("DISP_SDC_LP_SUM_TEXT"));
        this.sumValueLabel = new ASALabel(n + " %");
        aSABaseGridBagPanel.add((Component)aSALabel, 0, 0, 1, 1, 0.3, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)this.sumValueLabel, 1, 0, 0, 1, 0.7, 0.0, 13, 0, INSETS, 0, 0);
        this.add(Box.createGlue(), 0, 1, 0, 1, 0.0, 1.0, 10, 3, INSETS_NONE, 0, 0);
        return aSABaseGridBagPanel;
    }

    public ASABaseGridBagPanel createSumPanel(Vector vector) {
        int n = 0;
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                n += ((Integer)iterator.next()).intValue();
            }
        }
        return this.createSumPanel(n);
    }

    public ASABaseGridBagPanel createThresholdPanel() {
        ASABaseGridBagPanel aSABaseGridBagPanel = new ASABaseGridBagPanel(INSETS_NONE);
        ASABaseGridBagPanel aSABaseGridBagPanel2 = new ASABaseGridBagPanel(INSETS_NONE);
        ASABaseGridBagPanel aSABaseGridBagPanel3 = new ASABaseGridBagPanel(INSETS_NONE);
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("DISP_MIN_LS_COLON_TEXT"));
        this.minLoadScoreText = new ASALabel();
        ASALabel aSALabel2 = new ASALabel(ASEUtils.getString("DISP_THRESHOLDS_HDG_TEXT"));
        ASALabel aSALabel3 = new ASALabel(ASEUtils.getString("DISP_LOGIN_REDIR_COLON_TEXT"));
        this.loginRedirText = new ASALabel();
        ASALabel aSALabel4 = new ASALabel(ASEUtils.getString("DISP_DYN_CONN_MIGR_COLON_TEXT"));
        this.dynMigrText = new ASALabel();
        aSABaseGridBagPanel2.add((Component)aSALabel, 0, 0, 1, 1, 0.5, 1.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel2.add((Component)this.minLoadScoreText, 1, 0, 0, 1, 0.5, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel3.add((Component)aSALabel2, 0, 0, 0, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel3.add((Component)aSALabel3, 0, 1, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT_MIDDLE, 0, 0);
        aSABaseGridBagPanel3.add((Component)this.loginRedirText, 1, 1, 0, 1, 0.0, 0.0, 17, 0, INSETS_MIDDLE, 0, 0);
        aSABaseGridBagPanel3.add((Component)aSALabel4, 0, 2, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT_MIDDLE, 0, 0);
        aSABaseGridBagPanel3.add((Component)this.dynMigrText, 1, 2, 0, 1, 0.0, 0.0, 17, 0, INSETS_MIDDLE, 0, 0);
        aSABaseGridBagPanel3.add(Box.createGlue(), 0, 3, 0, 1, 1.0, 1.0, 10, 1, INSETS_NONE, 0, 0);
        aSABaseGridBagPanel.add((Component)aSABaseGridBagPanel2, 0, 0, 0, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        aSABaseGridBagPanel.add((Component)aSABaseGridBagPanel3, 0, 1, 0, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add(Box.createGlue(), 0, 2, 0, 1, 1.0, 1.0, 10, 3, INSETS_NONE, 0, 0);
        return aSABaseGridBagPanel;
    }

    public int getWeightsSum() {
        int n = 0;
        int n2 = this.metricTable.getRowCount();
        for (int i = 0; i < n2; ++i) {
            n += this.getMetricValue(i);
        }
        return n;
    }

    public Object getChangeBtn() {
        return this.changeBtn;
    }

    public void releaseResources() {
    }

    public void addActionListener(ActionListener actionListener) {
        this.changeBtn.addActionListener(actionListener);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.metricTable.getColumnModel().getColumn(1).getCellEditor().addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.metricTable.getColumnModel().getColumn(1).getCellEditor().removeCellEditorListener(cellEditorListener);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    private void updateSum() {
        int n = 0;
        for (int i = 0; i < this.metricTable.getRowCount(); ++i) {
            Integer n2 = (Integer)this.metricTable.getValueAt(i, 1);
            n += n2.intValue();
        }
        this.sumValueLabel.setText(n + "%");
    }

    public void setLPName(String string) {
        this.lpNameText.setText(string);
    }

    public void setLPType(String string) {
        this.lpTypeText.setText(string);
    }

    public void setMinLoadScore(int n) {
        this.minLoadScoreText.setText(n + "");
    }

    public void setLoginRedir(int n) {
        this.loginRedirText.setText(n + "");
    }

    public void setDynMigr(int n) {
        this.dynMigrText.setText(n + "");
    }

    public void setMetricWeights(Vector vector) {
        if (vector == null || this.metricTable == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.tableModel.setValueAt(vector.get(i), i, 1);
        }
        this.metricTable.tableChanged(new TableModelEvent(this.tableModel));
    }

    public void setMetricWeight(int n, int n2) {
        if (this.metricTable != null) {
            this.tableModel.setValueAt(new Integer(n2), n, 1);
            this.metricTable.tableChanged(new TableModelEvent(this.tableModel));
        }
    }

    public void setSum(int n) {
        if (this.sumValueLabel != null) {
            this.sumValueLabel.setText(n + " %");
        }
    }

    public void sumWeights() {
        int n = this.getWeightsSum();
        this.setSum(n);
    }

    public int getMetricValue(int n) {
        int n2 = -1;
        if (this.metricTable != null) {
            n2 = (Integer)this.tableModel.getValueAt(n, 1);
        }
        return n2;
    }

    static {
        headings.add(ASEUtils.getString("DISP_METRIC_TEXT"));
        headings.add(ASEUtils.getString("DISP_WEIGHT_TEXT"));
    }
}

