/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go.prop;

import com.sybase.asa.ASAButtonGroup;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASAMaskedTextField;
import com.sybase.asa.ASAPanel;
import com.sybase.asa.ASARadioButton;
import com.sybase.asa.ASASeparator;
import com.sybase.aseplugin.ASEException;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.go.ASEBaseGridBagPanel;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;

public class SchedulePropGOPage2
extends ASEBaseGridBagPanel
implements ChangeListener {
    public static final String JSS_STARTAT_TIME = "startAtTime";
    public static final String JSS_STARTBTW_TIME = "startBtwTime";
    public static final String JSS_ENDBTW_TIME = "endBtwTime";
    public static final SimpleDateFormat simpleTimeFormat = new SimpleDateFormat("HH:mm");
    private ASEMnemGridBagPanel _tzPanel;
    private ASEMnemGridBagPanel _timePanel;
    private ASARadioButton _atRadioButton;
    private ASARadioButton _betweenRadioButton;
    private ASAMaskedTextField _startAtTextField;
    private ASAMaskedTextField _startBetweenTextField;
    private ASAMaskedTextField _endBetweenTextField;
    private ASALabel _serverTimeLabel;
    private ASALabel _localTimeLabel;

    public SchedulePropGOPage2() {
        super(1);
        this.createTZPanel();
        this.createTimePanel();
        int n = 0;
        this.add((Component)this.getTZPanel(), 0, n++, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add((Component)new ASASeparator(), 0, n++, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add((Component)this.getTimePanel(), 0, n++, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add(Box.createGlue(), 0, n, 0, 1, 0.0, 1.0, 10, 3, INSETS_NONE, 0, 0);
    }

    public ASAPanel getTZPanel() {
        return this._tzPanel;
    }

    public ASAPanel getTimePanel() {
        return this._timePanel;
    }

    public ASARadioButton getStartAtBtn() {
        return this._atRadioButton;
    }

    public ASARadioButton getBtwBtn() {
        return this._betweenRadioButton;
    }

    public Date getStartTimeField() throws ASEException {
        ASAMaskedTextField aSAMaskedTextField = this._atRadioButton.isSelected() ? this._startAtTextField : this._startBetweenTextField;
        try {
            simpleTimeFormat.setLenient(false);
            return simpleTimeFormat.parse(aSAMaskedTextField.getText());
        }
        catch (ParseException parseException) {
            throw new ASEException(ASEUtils.getString("ERR_SCHED_START_INVALID"));
        }
    }

    public boolean isRepeatable() {
        return this._betweenRadioButton.isSelected();
    }

    public String getStartTime() {
        ASAMaskedTextField aSAMaskedTextField = this._atRadioButton.isSelected() ? this._startAtTextField : this._startBetweenTextField;
        return aSAMaskedTextField.getText();
    }

    public Date getEndTimeField() throws ASEException {
        if (this._betweenRadioButton.isSelected()) {
            try {
                simpleTimeFormat.setLenient(false);
                Date date = simpleTimeFormat.parse(this._endBetweenTextField.getText());
                return date;
            }
            catch (ParseException parseException) {
                throw new ASEException(ASEUtils.getString("ERR_SCHED_END_INVALID"));
            }
        }
        return null;
    }

    public String getEndTime() {
        return this._endBetweenTextField.getText();
    }

    public void setStartTimeField(Date date) {
        String string = simpleTimeFormat.format(date);
        this._startAtTextField.setText(string);
        this._startBetweenTextField.setText(string);
        this._atRadioButton.setSelected(true);
    }

    public void setEndTimeField(Date date) {
        if (date == null) {
            this._endBetweenTextField.setText(ASEUtils.getString("MSG_DEFAULT_ENDTIME"));
            this._atRadioButton.setSelected(true);
        } else {
            String string = simpleTimeFormat.format(date);
            this._endBetweenTextField.setText(string);
        }
    }

    public void selectRepeatingOption(boolean bl) {
        this._betweenRadioButton.setSelected(bl);
        this._atRadioButton.setSelected(!bl);
    }

    public void setServerTime(String string) {
        this._serverTimeLabel.setText(string);
    }

    public void setLocalTime(String string) {
        this._localTimeLabel.setText(string);
    }

    private void createTZPanel() {
        this._tzPanel = new ASEMnemGridBagPanel();
        ASEMnemGridBagPanel aSEMnemGridBagPanel = new ASEMnemGridBagPanel();
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("SCHED_PROP_SENT_TIMEZONE_HINT"));
        ASALabel aSALabel2 = new ASALabel(ASEUtils.getString("SCHED_PROP_SENT_SERVER_TIME"));
        ASALabel aSALabel3 = new ASALabel(ASEUtils.getString("SCHED_PROP_SENT_LOCAL_TIME"));
        this._serverTimeLabel = new ASALabel();
        this._localTimeLabel = new ASALabel();
        int n = 0;
        this._tzPanel.add((Component)aSALabel, 0, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
        this._tzPanel.add((Component)((Object)aSEMnemGridBagPanel), 0, ++n, 2, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        n = 0;
        aSEMnemGridBagPanel.add((Component)aSALabel2, 0, ++n, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        aSEMnemGridBagPanel.add((Component)this._serverTimeLabel, 1, n++, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        aSEMnemGridBagPanel.add((Component)aSALabel3, 0, ++n, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        aSEMnemGridBagPanel.add((Component)this._localTimeLabel, 1, n++, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
    }

    private void createTimePanel() {
        this._timePanel = new ASEMnemGridBagPanel();
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("LABC_START_TIME"));
        this._timePanel.add((Component)aSALabel, 0, 0, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
        this._atRadioButton = new ASARadioButton(ASEUtils.getString("SCHED_PROP_RADB_AT"));
        this._atRadioButton.setMnemonic(ASEUtils.getMnemonic("SCHED_PROP_MNEM_AT"));
        this._atRadioButton.setSelected(true);
        this._startAtTextField = new ASAMaskedTextField("##:##");
        this._startAtTextField.setPreferredWidthToFit();
        this._startAtTextField.getDocument().putProperty("name", JSS_STARTAT_TIME);
        this._betweenRadioButton = new ASARadioButton(ASEUtils.getString("SCHED_PROP_RADB_BETWEEN"));
        this._betweenRadioButton.setMnemonic(ASEUtils.getMnemonic("SCHED_PROP_MNEM_BETWEEN"));
        this._betweenRadioButton.setSelected(false);
        this._startBetweenTextField = new ASAMaskedTextField("##:##");
        this._startBetweenTextField.setPreferredWidthToFit();
        this._startBetweenTextField.getDocument().putProperty("name", JSS_STARTBTW_TIME);
        this._startBetweenTextField.setEnabled(false);
        ASALabel aSALabel2 = new ASALabel(ASEUtils.getString("MSG_AND"));
        this._endBetweenTextField = new ASAMaskedTextField("##:##");
        this._endBetweenTextField.setPreferredWidthToFit();
        this._endBetweenTextField.getDocument().putProperty("name", JSS_ENDBTW_TIME);
        this._endBetweenTextField.setEnabled(false);
        ASAButtonGroup.createButtonGroup((AbstractButton[])new ASARadioButton[]{this._atRadioButton, this._betweenRadioButton});
        this._timePanel.add((Component)this._atRadioButton, 1, 0, 1, 1, 1.0, 0.0, 18, 0, INSETS_NONE, 0, 0);
        this._timePanel.add((Component)this._startAtTextField, 2, 0, 1, 1, 1.0, 0.0, 18, 0, INSETS_NONE, 0, 0);
        this._timePanel.add((Component)this._betweenRadioButton, 1, 1, 1, 1, 1.0, 0.0, 18, 0, INSETS_NONE, 0, 0);
        this._timePanel.add((Component)this._startBetweenTextField, 2, 1, 1, 1, 1.0, 0.0, 18, 0, INSETS_NONE, 0, 0);
        this._timePanel.add((Component)aSALabel2, 3, 1, 1, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
        this._timePanel.add((Component)this._endBetweenTextField, 4, 1, 1, 1, 1.0, 0.0, 18, 0, INSETS_NONE, 0, 0);
        this._atRadioButton.addChangeListener((ChangeListener)this);
        this._betweenRadioButton.addChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this._atRadioButton) {
            boolean bl = this._atRadioButton.isSelected();
            this._startAtTextField.setEnabled(bl);
            this._startBetweenTextField.setEnabled(!bl);
            this._endBetweenTextField.setEnabled(!bl);
        } else if (changeEvent.getSource() == this._betweenRadioButton) {
            boolean bl = this._betweenRadioButton.isSelected();
            this._startAtTextField.setEnabled(!bl);
            this._startBetweenTextField.setEnabled(bl);
            this._endBetweenTextField.setEnabled(bl);
        }
    }

    public void addAllListener(Object object) {
        if (object instanceof ActionListener) {
            this.addActionListener((ActionListener)object);
        }
        if (object instanceof DocumentListener) {
            this.addDocumentListener((DocumentListener)object);
        }
    }

    public void removeAllListener(Object object) {
        if (object instanceof ActionListener) {
            this._atRadioButton.removeActionListener((ActionListener)object);
            this._betweenRadioButton.removeActionListener((ActionListener)object);
            this._startAtTextField.removeActionListener((ActionListener)object);
        }
        if (object instanceof DocumentListener) {
            this._startAtTextField.getDocument().removeDocumentListener((DocumentListener)object);
            this._startBetweenTextField.getDocument().removeDocumentListener((DocumentListener)object);
            this._endBetweenTextField.getDocument().removeDocumentListener((DocumentListener)object);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this._atRadioButton.addActionListener(actionListener);
        this._betweenRadioButton.addActionListener(actionListener);
        this._startAtTextField.addActionListener(actionListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this._startAtTextField.getDocument().addDocumentListener(documentListener);
        this._startBetweenTextField.getDocument().addDocumentListener(documentListener);
        this._endBetweenTextField.getDocument().addDocumentListener(documentListener);
    }
}

