/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.go.prop;

import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASALabel;
import com.sybase.asa.ASAMaskedTextField;
import com.sybase.asa.ASAPanel;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.go.ASEBaseGridBagPanel;
import com.sybase.aseplugin.go.ASEMnemGridBagPanel;
import com.sybase.aseplugin.go.ASETable;
import com.sybase.aseplugin.go.prop.ScheduleTableModel;
import com.sybase.aseplugin.util.ui.MyCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;

public class ScheduledJobPropGOPage2
extends ASEBaseGridBagPanel
implements ActionListener,
ListSelectionListener {
    private ASEMnemGridBagPanel _schedPanel;
    private ASEMnemGridBagPanel _serverPanel;
    private ASEMnemGridBagPanel _execPropPanel;
    private ASEMnemGridBagPanel _postPropPanel;
    private ASETable _schedTable;
    private ScheduleTableModel _schedTableModel;
    private ASAComboBox _serverComboBox;
    private ASAMaskedTextField _timeoutTextField;
    private ASACheckBox _nologCheckBox;
    private ASACheckBox _sharedCheckBox;
    private ASACheckBox _disableCheckBox;
    private ASACheckBox _deleteCheckBox;
    private ASALabel _warningLabel;

    public ScheduledJobPropGOPage2() {
        super(1);
        this.createSchedulePanel();
        this.createServerPanel();
        this.createExecPropPanel();
        this.createPostPropPanel();
        this.add((Component)this.getServerPanel(), 0, 1, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add((Component)this.getExecPropPanel(), 0, 3, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add((Component)this.getPostPropPanel(), 0, 5, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add(Box.createGlue(), 0, 6, 0, 1, 0.0, 1.0, 10, 3, INSETS_NONE, 0, 0);
    }

    public ASAPanel getSchedulePanel() {
        return this._schedPanel;
    }

    public ASAPanel getServerPanel() {
        return this._serverPanel;
    }

    public ASAPanel getExecPropPanel() {
        return this._execPropPanel;
    }

    public ASAPanel getPostPropPanel() {
        return this._postPropPanel;
    }

    public String getScheduleOwner() {
        return (String)this._schedTable.getValueAt(this._schedTable.getSelectedRow(), 1);
    }

    public String getScheduleName() {
        return (String)this._schedTable.getValueAt(this._schedTable.getSelectedRow(), 0);
    }

    public int getSelectedScheduleRow() {
        return this._schedTable.getSelectedRow();
    }

    public int getScheduleColumn() {
        return this._schedTable.getSelectedColumn();
    }

    public String getServerField() {
        return (String)this._serverComboBox.getSelectedItem();
    }

    public int getTimeoutField() {
        int n;
        try {
            n = Integer.parseInt(this._timeoutTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public Document getTimeoutDocument() {
        return this._timeoutTextField.getDocument();
    }

    public boolean getNoLogOutputField() {
        return this._nologCheckBox.isSelected();
    }

    public boolean getSharedField() {
        return this._sharedCheckBox.isSelected();
    }

    public boolean getDisableOnFailureField() {
        return this._disableCheckBox.isSelected();
    }

    public boolean getDeleteOnCompletionField() {
        return this._deleteCheckBox.isSelected();
    }

    public void setScheduleField(Vector vector) {
        if (vector == null) {
            return;
        }
        this._schedTableModel = new ScheduleTableModel(vector);
        this._schedTable.setModel(this._schedTableModel);
        this._schedTable.setDefaultRenderer(this.getClass(), new MyCellRenderer());
        TableColumn tableColumn = this._schedTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(175);
        this._schedTable.setSelectionMode(0);
    }

    public void setServersField(Vector vector) {
        this._serverComboBox.setModel(new DefaultComboBoxModel(vector));
        if (this._serverComboBox.getItemCount() > 0) {
            this._serverComboBox.setSelectedIndex(0);
        }
    }

    public void setServerField(String string) {
        ComboBoxModel comboBoxModel = this._serverComboBox.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!string.equals(comboBoxModel.getElementAt(i))) continue;
            this._serverComboBox.setSelectedItem(string);
            return;
        }
        this._warningLabel.setVisible(true);
        this._warningLabel.setForeground(Color.red);
        this._serverComboBox.addActionListener((ActionListener)this);
    }

    public void setTimeoutField(int n) {
        this._timeoutTextField.setText(String.valueOf(n));
    }

    public void setNoLogOutputField(boolean bl) {
        this._nologCheckBox.setSelected(bl);
    }

    public void setSharedField(boolean bl) {
        this._sharedCheckBox.setSelected(bl);
    }

    public void setDisableOnFailureField(boolean bl) {
        this._disableCheckBox.setSelected(bl);
    }

    public void setDeleteOnCompletionField(boolean bl) {
        this._deleteCheckBox.setSelected(bl);
    }

    private void createSchedulePanel() {
        this._schedPanel = new ASEMnemGridBagPanel();
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("LABC_SCHED_NAME"));
        this._schedTable = new ASETable();
        this._schedTable.setPreferredScrollableViewportSize(new Dimension(250, 100));
        JScrollPane jScrollPane = new JScrollPane(this._schedTable);
        this._schedPanel.add((Component)aSALabel, 0, 0, 0, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0);
        this._schedPanel.add(jScrollPane, 0, 1, 0, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0);
    }

    private void createServerPanel() {
        this._serverPanel = new ASEMnemGridBagPanel();
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("LABC_TARGET_ASE"));
        this._serverComboBox = new ASAComboBox();
        this._warningLabel = new ASALabel(ASEUtils.getString("SCHEDJOB_PROP_SENT_SERVER_WARNING"));
        this._warningLabel.setVisible(false);
        this._serverPanel.add((Component)aSALabel, 0, 0, 0, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
        this._serverPanel.add((Component)this._serverComboBox, 0, 1, 0, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
        this._serverPanel.add((Component)this._warningLabel, 0, 2, 0, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
    }

    private void createExecPropPanel() {
        this._execPropPanel = new ASEMnemGridBagPanel();
        this._timeoutTextField = new ASAMaskedTextField("#####", ' ');
        this._timeoutTextField.setColumns(5);
        this._timeoutTextField.getDocument().putProperty("name", "timeout");
        ASALabel aSALabel = new ASALabel(ASEUtils.getString("LABC_TIMEOUT"));
        ASALabel aSALabel2 = new ASALabel(ASEUtils.getString("MSG_MINUTES"), 0);
        this._nologCheckBox = new ASACheckBox(ASEUtils.getString("SCHEDJOB_PROP_CHKB_LOG_OUTPUT"));
        this._nologCheckBox.setMnemonic(ASEUtils.getMnemonic("SCHEDJOB_PROP_MNEM_LOG_OUTPUT"));
        this._sharedCheckBox = new ASACheckBox(ASEUtils.getString("SCHEDJOB_PROP_CHKB_SHARED"));
        this._sharedCheckBox.setMnemonic(ASEUtils.getMnemonic("SCHEDJOB_PROP_MNEM_SHARED"));
        this._execPropPanel.add((Component)aSALabel, 0, 0, 1, 1, 1.0, 0.0, 18, 0, INSETS, 0, 0);
        this._execPropPanel.add((Component)this._timeoutTextField, 1, 0, 1, 1, 1.0, 0.0, 18, 0, INSETS, 0, 0);
        this._execPropPanel.add((Component)aSALabel2, 2, 0, 0, 1, 1.0, 0.0, 18, 0, INSETS, 0, 0);
        this._execPropPanel.add((Component)this._nologCheckBox, 0, 2, 0, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0);
        this._execPropPanel.add((Component)this._sharedCheckBox, 0, 3, 0, 0, 1.0, 0.0, 18, 2, INSETS, 0, 0);
    }

    private void createPostPropPanel() {
        this._postPropPanel = new ASEMnemGridBagPanel();
        this._disableCheckBox = new ASACheckBox(ASEUtils.getString("SCHEDJOB_PROP_CHKB_DISABLE_ON_FAILURE"));
        this._disableCheckBox.setMnemonic(ASEUtils.getMnemonic("SCHEDJOB_PROP_MNEM_DISABLE_ON_FAILURE"));
        this._deleteCheckBox = new ASACheckBox(ASEUtils.getString("SCHEDJOB_PROP_CHKB_DELETE_ON_COMPLETION"));
        this._deleteCheckBox.setMnemonic(ASEUtils.getMnemonic("SCHEDJOB_PROP_MNEM_DELETE_ON_COMPLETION"));
        this._postPropPanel.add((Component)this._disableCheckBox, 0, 0, 0, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0);
        this._postPropPanel.add((Component)this._deleteCheckBox, 0, 2, 0, 0, 1.0, 0.0, 18, 2, INSETS, 0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._serverComboBox) {
            this._warningLabel.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        boolean bl = listSelectionModel.isSelectionEmpty();
        if (bl) {
            return;
        }
    }

    public void addAllListener(Object object) {
        if (object instanceof ListSelectionListener) {
            this.addListSelectionListener((ListSelectionListener)object);
        }
        if (object instanceof ActionListener) {
            this.addActionListener((ActionListener)object);
        }
        if (object instanceof DocumentListener) {
            this.addDocumentListener((DocumentListener)object);
        }
    }

    public void removeAllListener(Object object) {
        if (object instanceof ListSelectionListener) {
            ListSelectionModel listSelectionModel = this._schedTable.getSelectionModel();
            listSelectionModel.removeListSelectionListener((ListSelectionListener)object);
        }
        if (object instanceof ActionListener) {
            this._serverComboBox.removeActionListener((ActionListener)object);
            this._nologCheckBox.removeActionListener((ActionListener)object);
            this._sharedCheckBox.removeActionListener((ActionListener)object);
            this._disableCheckBox.removeActionListener((ActionListener)object);
            this._deleteCheckBox.removeActionListener((ActionListener)object);
        }
        if (object instanceof DocumentListener) {
            this._timeoutTextField.getDocument().removeDocumentListener((DocumentListener)object);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this._serverComboBox.addActionListener(actionListener);
        this._nologCheckBox.addActionListener(actionListener);
        this._sharedCheckBox.addActionListener(actionListener);
        this._disableCheckBox.addActionListener(actionListener);
        this._deleteCheckBox.addActionListener(actionListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        ListSelectionModel listSelectionModel = this._schedTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this._timeoutTextField.getDocument().addDocumentListener(documentListener);
    }
}

