/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SODBItemInterface;
import com.sybase.aseplugin.so.SOOwnedItemInterface;
import com.sybase.aseplugin.sql.ASConnection;
import java.sql.SQLException;
import java.util.List;

public abstract class ASEBaseDBItemSO
extends ASEBaseItemSO
implements SODBItemInterface,
SOOwnedItemInterface {
    protected DatabaseSO _databaseSO;
    String _currentUser = "";

    public ASEBaseDBItemSO(ASConnection aSConnection, String string, DatabaseSO databaseSO) {
        super(aSConnection, string);
        this._databaseSO = databaseSO;
    }

    @Override
    public final DatabaseSO getDatabaseSO() {
        return this._databaseSO;
    }

    @Override
    public final String getDatabaseName() {
        return this._databaseSO.getName();
    }

    @Override
    public final void useDB() throws SQLException {
        this._databaseSO.useDB();
    }

    @Override
    public String getOwner() {
        return null;
    }

    @Override
    public void setOwner(String string) {
    }

    @Override
    public String getCurrentUser() {
        if (this._currentUser.equals("")) {
            try {
                this._currentUser = this.getConnection().getCurrentUser();
                this.useDB();
                this.getRSet().open("exec sp_helpuser ");
                while (this.getRSet().getNextRow()) {
                    if (!this.getRSet().getColumnString("Login_name").equals(this.getConnection().getCurrentUser())) continue;
                    this._currentUser = this.getRSet().getColumnString("Users_name");
                }
                this.getRSet().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this._currentUser;
    }

    @Override
    public final String getNameWithOwner() {
        if (this.getOwner() == null || this.getOwner().isEmpty() || this.getOwner().equals("%")) {
            return this.getName();
        }
        return this.getName() + " (" + this.getOwner() + ")";
    }

    @Override
    public final List<String[]> getOwnerList() throws SQLException {
        return this._databaseSO.getOwnerList();
    }

    @Override
    public boolean includeCreate() {
        return !this.isInArchiveDB();
    }

    @Override
    public boolean includeDelete() {
        return !this.isInArchiveDB();
    }

    @Override
    public boolean enableCreate() {
        return !this.isInReadOnlyDB();
    }

    @Override
    public boolean enableDelete() {
        if (!this.isInReadOnlyDB()) {
            if (this.getOwner() == null) {
                return true;
            }
            return this.getOwner().equals(this.getCurrentUser()) || this.getConnection().hasSARole();
        }
        return false;
    }

    public final boolean isInReadOnlyDB() {
        return this._databaseSO.getOption("DB_OP_READ_ONLY");
    }

    public final boolean isInArchiveDB() {
        return this._databaseSO.isArchiveDB();
    }
}

