/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;

public class ASESSLCertificate {
    private final int _EMAIL_ADDRESS = 0;
    private final int _COMMON_NAME = 1;
    private final int _ORGANIZATION = 2;
    private final int _ORGANIZATIN_UNIT = 3;
    private final int _LOCATION = 4;
    private final int _STATE = 5;
    private final int _COUNTRY = 6;
    private String _certFilePath;
    private String _emailAddress;
    private String _subjectCommonName;
    private String _organization;
    private String _organizationUnit;
    private String _location;
    private String _state;
    private String _country;
    private String _issuerCommonName;
    private String _validBefore;
    private String _validEnd;

    public ASESSLCertificate(String string) {
        this._certFilePath = string;
        this.initCertificateInfo();
    }

    private void initCertificateInfo() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this._certFilePath);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            String[] stringArray = this.getCertCommonInfo(x509Certificate.getSubjectDN().getName());
            this._emailAddress = stringArray[0];
            this._subjectCommonName = stringArray[1];
            this._organization = stringArray[2];
            this._organizationUnit = stringArray[3];
            this._location = stringArray[4];
            this._state = stringArray[5];
            this._country = stringArray[6];
            String[] stringArray2 = this.getCertCommonInfo(x509Certificate.getIssuerDN().getName());
            this._issuerCommonName = stringArray2[1];
            this._validBefore = DateFormat.getDateInstance().format(x509Certificate.getNotBefore());
            this._validEnd = DateFormat.getDateInstance().format(x509Certificate.getNotAfter());
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] getCertCommonInfo(String string) {
        String[] stringArray = string.split(", ");
        String[] stringArray2 = new String[7];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = string2.substring(string2.indexOf("=") + 1, string2.length());
            if (string2.startsWith("EMAILADDRESS=")) {
                stringArray2[0] = string3;
                continue;
            }
            if (string2.startsWith("CN=")) {
                stringArray2[1] = string3;
                continue;
            }
            if (string2.startsWith("OU=")) {
                stringArray2[3] = string3;
                continue;
            }
            if (string2.startsWith("O=")) {
                stringArray2[2] = string3;
                continue;
            }
            if (string2.startsWith("L=")) {
                stringArray2[4] = string3;
                continue;
            }
            if (string2.startsWith("ST=")) {
                stringArray2[5] = string3;
                continue;
            }
            if (!string2.startsWith("C=")) continue;
            stringArray2[6] = string3;
        }
        return stringArray2;
    }

    public String getCountry() {
        return this._country;
    }

    public String getEmailAddress() {
        return this._emailAddress;
    }

    public String getIssuerCommonName() {
        return this._issuerCommonName;
    }

    public String getLocation() {
        return this._location;
    }

    public String getOrganization() {
        return this._organization;
    }

    public String getOrganizationUnit() {
        return this._organizationUnit;
    }

    public String getState() {
        return this._state;
    }

    public String getSubjectCommonName() {
        return this._subjectCommonName;
    }

    public String getValidBefore() {
        return this._validBefore;
    }

    public String getValidEnd() {
        return this._validEnd;
    }
}

