/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseCodeItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public abstract class AbstractTriggerSO
extends ASEBaseCodeItemSO
implements DateSorter {
    public static final int FLAG_TRIGGER_NOT_INITIALIZED = 0;
    public static final int FLAG_INSERT_TRIGGER = 1;
    public static final int FLAG_UPDATE_TRIGGER = 2;
    public static final int FLAG_DELETE_TRIGGER = 4;
    public static final int FLAG_UPDATE_OF_TRIGGER = 8;
    public static final int COL_NAME = 1;
    public static final int COL_CREATOR = 2;
    public static final int COL_CREATION_DATE = 3;
    public static final int COL_TRIGGER_ID = 4;
    public static final int COL_TRIGGER_DEL_ID = 5;
    public static final int COL_TRIGGER_INS_ID = 6;
    public static final int COL_TRIGGER_UPD_ID = 7;
    int _trigActionFlag = 0;
    int _trigID = 0;
    Object[] _columns;
    String _trigOwner = "";

    public AbstractTriggerSO(ASConnection aSConnection, String string, DatabaseSO databaseSO) {
        super(aSConnection, string, databaseSO);
    }

    public AbstractTriggerSO(ASConnection aSConnection, DatabaseSO databaseSO, Object[] objectArray) {
        super(aSConnection, (String)objectArray[1], databaseSO);
        this._columns = objectArray;
        this._trigOwner = (String)objectArray[2];
        this._trigID = Integer.valueOf((String)objectArray[4]);
        int n = Integer.valueOf((String)objectArray[5]);
        int n2 = Integer.valueOf((String)objectArray[6]);
        int n3 = Integer.valueOf((String)objectArray[7]);
        if (this._trigID == n) {
            this._trigActionFlag |= 4;
        }
        if (this._trigID == n2) {
            this._trigActionFlag |= 1;
        }
        if (this._trigID == n3) {
            this._trigActionFlag |= 2;
        }
    }

    @Override
    public final Date getDate(int n) {
        return (Date)this._columns[3];
    }

    @Override
    public final void create() throws SQLException {
        this.useDB();
        this._conn.executeCommand(this.getSQLText());
    }

    @Override
    public final String getRemoveCode() {
        return SQLs.getString("drop trigger {0}.{1} ", this.getOwner(), this.getName());
    }

    @Override
    public final String getOwner() {
        return this._trigOwner;
    }

    public final String getCreationDate() {
        Date date = (Date)this._columns[3];
        return DateFormat.getDateTimeInstance(2, 3).format(date);
    }

    public final int getTriggerType() {
        return this._trigActionFlag;
    }

    public final boolean isDeleteTrigger() {
        return 0 != (this.getTriggerType() & 4);
    }

    public final boolean isInsertTrigger() {
        return 0 != (this.getTriggerType() & 1);
    }

    public final boolean isUpdateTrigger() {
        return 0 != (this.getTriggerType() & 2);
    }

    public final boolean isUpdateOfTrigger() {
        return 0 != (this.getTriggerType() & 8);
    }

    public final void setTriggerType(int n) {
        this._trigActionFlag = n;
    }

    public final String getEvents() {
        String string = "";
        boolean bl = true;
        if (this.isInsertTrigger()) {
            string = ASEUtils.getString("MSG_TRIG_INSERT");
            bl = false;
        }
        if (this.isUpdateTrigger()) {
            string = string + (!bl ? ", " : "") + ASEUtils.getString("MSG_TRIG_UPDATE");
            bl = false;
        }
        if (this.isDeleteTrigger()) {
            string = string + (!bl ? ", " : "") + ASEUtils.getString("MSG_TRIG_DELETE");
            bl = false;
        }
        return string;
    }

    public final void reName(String string, String string2) throws SQLException {
        Utility.setUser(this.getConnection(), this._trigOwner);
        Utility.reName(this.getConnection(), string, string2, this.getDatabaseName());
        Utility.unSetUser(this.getConnection());
    }

    @Override
    public final void setOwner(String string) {
        this._trigOwner = string;
    }

    public boolean typeExists(String string, String string2) throws SQLException {
        boolean bl = false;
        String string3 = SQLs.getString("select name from {0}.dbo.sysobjects where name = ''{1}'' and type = ''U'' and ( ", this.getDatabaseName(), string, string2);
        String string4 = " deltrig != 0 ";
        String string5 = " instrig != 0 ";
        String string6 = " updtrig != 0 ";
        String string7 = " ) ";
        String string8 = " or ";
        String string9 = string3;
        if (this.isDeleteTrigger()) {
            string9 = string9 + string4;
            bl = true;
        }
        if (this.isInsertTrigger()) {
            if (bl) {
                string9 = string9 + string8;
            }
            string9 = string9 + string5;
            bl = true;
        }
        if (this.isUpdateTrigger() || this.isUpdateOfTrigger()) {
            if (bl) {
                string9 = string9 + string8;
            }
            string9 = string9 + string6;
        }
        string9 = string9 + string7;
        this.getRSet().open(string9);
        boolean bl2 = this.getRSet().getNextRow();
        this.getRSet().close();
        return bl2;
    }

    public final String[] getColumns() {
        return (String[])this._columns;
    }

    public final void setColumns(Object[] objectArray) {
        this._columns = objectArray;
    }

    @Override
    public final String getObjectID() {
        return String.valueOf(this._trigID);
    }

    @Override
    public final String getFullyQualifiedName() {
        return this.getDatabaseName() + "." + this.getOwner() + "." + this.getName();
    }

    public final Vector referESP() throws SQLException {
        String string = SQLs.getString("select O.name, U.name from {0}.dbo.sysdepends D, {0}.dbo.sysobjects O, {0}.dbo.sysusers U  where O.uid = U.uid and O.type = ''{2}'' and O.id = D.depid and D.id = {1} ", this.getDatabaseName(), String.valueOf(this._trigID), "XP");
        return Utility.referESP(this.getConnection(), string);
    }

    public final Vector referProcedure() throws SQLException {
        String string = SQLs.getString("select O.name, U.name from {0}.dbo.sysdepends D, {0}.dbo.sysobjects O, {0}.dbo.sysusers U  where O.uid = U.uid and O.type = ''{2}'' and O.id = D.depid and D.id = {1} ", this.getDatabaseName(), String.valueOf(this._trigID), "P");
        return Utility.referProcedure(this.getConnection(), string);
    }

    public final Vector referTable() throws SQLException {
        String string = SQLs.getString("select O.name, U.name from {0}.dbo.sysdepends D, {0}.dbo.sysobjects O, {0}.dbo.sysusers U where O.uid = U.uid and (O.type = ''S'' or O.type = ''U'') and O.id = D.depid and D.id ={1} ", this.getDatabaseName(), String.valueOf(this._trigID));
        return Utility.referTable(this.getConnection(), string);
    }

    public final Vector referView() throws SQLException {
        String string = SQLs.getString("select O.name, U.name from {0}.dbo.sysdepends D, {0}.dbo.sysobjects O, {0}.dbo.sysusers U  where O.uid = U.uid and O.type = ''{2}'' and O.id = D.depid and D.id = {1} ", this.getDatabaseName(), String.valueOf(this._trigID), "V");
        return Utility.referView(this.getConnection(), string);
    }

    @Override
    public abstract String getTemplateText();

    @Override
    public abstract String getDisplayType();

    static {
        TMPL_DEFAULT_NAME = "trigger-name";
    }
}

