/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.SOCtrInterface;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JLabel;

public class ArchiveDBSO
extends DatabaseSO {
    private String _scratchDB;
    private String _unusedSpace;
    private String _totalSpace;
    private String _usedSpace;
    private static long FLAG_DUMP_COMPRESSED = 0x800000L;
    private static long FLAG_LOG_COMPRESSED = 0x10000000L;

    public ArchiveDBSO(ASConnection aSConnection, String string, SOCtrInterface sOCtrInterface) {
        super(aSConnection, string, sOCtrInterface);
        this._dbType = 11;
    }

    public void setScratchDB(String string) {
        this._scratchDB = string;
    }

    public String getScratchDB() {
        return this._scratchDB;
    }

    public Vector getScratchDatabases() throws SQLException {
        String string = "select name from master.dbo.sysdatabases where status3 & 16777216 = 16777216 order by 1";
        this.getRSet().open(string);
        Vector<String> vector = new Vector<String>();
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString("name"));
        }
        this.getRSet().close();
        return vector;
    }

    @Override
    public void create() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString("create archive database {0} ", this.getName()));
        if (this.getDBDevice().size() > 0) {
            stringBuffer.append(" on ");
        }
        for (int i = 0; i < this.getDBDevice().size(); ++i) {
            Vector vector = (Vector)this.getDBDevice().elementAt(i);
            stringBuffer.append(((JLabel)vector.elementAt(0)).getText()).append(" = ").append(new Integer(((Double)vector.elementAt(1)).intValue()).toString());
            if (i >= this.getDBDevice().size() - 1) continue;
            stringBuffer.append(" , ");
        }
        stringBuffer.append(SQLs.getString(" with scratch_database = {0}", this._scratchDB));
        this.useMasterDB();
        this._conn.executeCommand(stringBuffer.toString());
    }

    @Override
    public void load() throws SQLException {
        if (this.isSuspectOrLoadOrOffline()) {
            return;
        }
        ASResultSet aSResultSet = new ASResultSet(this.getConnection());
        aSResultSet.open(SQLs.getString("select d.dbid, (select name from master.dbo.syslogins where suid = d.suid), convert(datetime, crdate),  d.status, d.status2, d.status3, (select name from {0}.dbo.sysusers where name = ''guest''), (select char_value from {0}.dbo.sysattributes b, {0}.dbo.sysobjects c where c.id = b.object and object_type = ''T'' and char_value != null and name = ''syslogs''),  convert(datetime, crdate), a.char_value from master.dbo.sysattributes a, master.dbo.sysdatabases d where a.attribute = 0 and a.object = d.dbid and a.object_type = ''D''and d.name = ''{0}'' ", this.getName()));
        if (!aSResultSet.getNextRow()) {
            aSResultSet.close();
            return;
        }
        this.setDBID(aSResultSet.getColumnString(1));
        this.setDBOwner(aSResultSet.getColumnString(2));
        this.setCreationDate(aSResultSet.getColumnDate(3));
        this.setStatus(aSResultSet.getColumnLong(4));
        this.setStatus2(aSResultSet.getColumnLong(5));
        this.setStatus3(aSResultSet.getColumnLong(6));
        String string = aSResultSet.getColumnString(7);
        this.hasGuest(!string.trim().equals(""));
        string = aSResultSet.getColumnString(8);
        if (string.trim().equals("")) {
            this.setDBLogIOSize("2");
        } else {
            this.setDBLogIOSize(string);
        }
        this.setDBStrCreationDate(aSResultSet.getColumnString(9));
        this._scratchDB = aSResultSet.getColumnString(10);
        aSResultSet.close();
        this.setLoaded(true);
    }

    public boolean isDataCompressed() {
        return (this.getStatus3() & FLAG_DUMP_COMPRESSED) != 0L;
    }

    public boolean isLogCompressed() {
        return (this.getStatus3() & FLAG_LOG_COMPRESSED) != 0L;
    }

    @Override
    public void refreshAllocations() throws SQLException {
        this.useDB();
        this.getRSet().open("exec sp_spaceused");
        while (this.getRSet().getNextRow()) {
            this._totalSpace = this.getRSet().getColumnString("modified_pages_size");
            this._unusedSpace = this.getRSet().getColumnString("unused");
        }
        String string = this._totalSpace.substring(0, this._totalSpace.indexOf(77)).trim();
        String string2 = this._unusedSpace.substring(0, this._unusedSpace.indexOf(77)).trim();
        float f = Float.parseFloat(string) - Float.parseFloat(string2);
        this._usedSpace = new Float(f).toString() + " MB";
        this.getRSet().close();
    }

    public String getSpace() {
        return this._totalSpace;
    }

    public String getUsedSpace() {
        return this._usedSpace;
    }

    @Override
    public String getUnusedSpace() {
        return this._unusedSpace;
    }

    @Override
    public boolean includeCreate() {
        return false;
    }
}

