/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.PublicationSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.RLMetaData;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class ArticleSO
extends ASEBaseItemSO {
    private String _ddb;
    private PublicationSO _pubSO = null;
    protected String _ds;
    protected String _db;
    protected String _type;
    protected String _name = null;
    protected String _owner = null;
    protected String _shadowTable = null;
    protected String _newArticleFields = null;
    protected boolean _articleExists;
    public static final int FIELD_NAME_COL = 0;
    public static final int FIELD_DATATYPE_COL = 1;
    public static final int FIELD_COLID_COL = 2;

    public ArticleSO(ASConnection aSConnection, String string) {
        super(aSConnection);
        Debug.wassert(aSConnection != null, this, "Null network connection parameter");
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty ddb parameter");
        this._ddb = string;
    }

    public PublicationSO getPublication() {
        return this._pubSO;
    }

    public void setPublication(PublicationSO publicationSO) {
        Debug.wassert(publicationSO != null, this, "Null publication semantic object parameter.");
        this._pubSO = publicationSO;
    }

    public String getDDB() {
        return this._ddb;
    }

    public static String formatName(String string, String string2) {
        Debug.wassert(string != null && string.length() > 0, "Invalid owner");
        Debug.wassert(string2 != null && string2.length() > 0, "Invalid name");
        return string + string2;
    }

    @Override
    public String getDisplayName() {
        return this._name;
    }

    public String getLongName() {
        return this.getOwner() + "." + this.getDisplayName();
    }

    public void load(ASResultSet aSResultSet) throws SQLException {
        Debug.wassert(aSResultSet != null, this, "Null result set");
        this._ds = aSResultSet.getColumnString(1);
        if (this._ds == null || this._ds.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_ART_DS_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._db = aSResultSet.getColumnString(2);
        if (this._db == null || this._db.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_ART_DB_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._type = aSResultSet.getColumnString(7);
        if (!this.isTable() && !this.isProcedure()) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_ART_TYPE_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._name = aSResultSet.getColumnString(5);
        if (this._name == null || this._name.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_ART_NAME_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._owner = aSResultSet.getColumnString(4);
        if (this._owner == null || this._owner.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_ART_OWNER_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._shadowTable = aSResultSet.getColumnString(9);
    }

    @Override
    public void create() throws SQLException {
        Debug.wassert(this.getPublication() != null, this, "Publication semantic object attribute is not set.");
        String string = this.getPublication().getDisplayName();
        Debug.wassert(string != null && string.length() > 0, this, "Publication name is null or blank");
        String string2 = this.getDisplayName();
        Debug.wassert(string2 != null && string2.length() > 0, this, "Article name is null or blank");
        String string3 = this.getOwner();
        Debug.wassert(string3 != null && string3.length() > 0, this, "Owner name is null or blank");
        if (this.isProcedure() && (this._newArticleFields == null || this._newArticleFields.length() == 0)) {
            this._newArticleFields = "0";
        }
        if (this._articleExists || this._newArticleFields == null) {
            Object[] objectArray = new String[]{this.getDDB(), string, string3, string2};
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            String string4 = rLSQLResourceBundle.getString("CREATE_ARTICLE_NOFLDS", objectArray);
            this.getConnection().executeCommand(string4);
        } else {
            Object[] objectArray = new String[]{this.getDDB(), string, string3, string2, this._newArticleFields};
            RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
            String string5 = rLSQLResourceBundle.getString("CREATE_ARTICLE", objectArray);
            this.getConnection().executeCommand(string5);
        }
    }

    @Override
    public void remove() throws SQLException {
        Debug.wassert(this.getPublication() != null, this, "Publication semantic object attribute is not set.");
        String string = this.getPublication().getDisplayName();
        Object[] objectArray = new String[]{this.getDDB(), string, this.getOwner(), this.getDisplayName()};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string2 = rLSQLResourceBundle.getString("DROP_ARTICLE", objectArray);
        this.getConnection().executeCommand(string2);
    }

    public String getServer() {
        return this._ds;
    }

    public void setServer(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty data server name");
        this._ds = string;
    }

    public String getDatabase() {
        return this._db;
    }

    public void setDatabase(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty database name");
        this._db = string;
    }

    public void setArticleName(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty article name");
        this._name = string;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setOwner(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Null or empty owner");
        this._owner = string;
    }

    public String getArticleType() {
        return this._type;
    }

    public boolean isTable() {
        boolean bl = false;
        if (this.getArticleType() != null) {
            bl = this.getArticleType().equals("table");
        }
        return bl;
    }

    public boolean isProcedure() {
        boolean bl = false;
        if (this.getArticleType() != null) {
            bl = this.getArticleType().equals("procedure");
        }
        return bl;
    }

    public String getTypeString() {
        if (this.isTable()) {
            return ASEUtils.getString("DISP_TABLE_ARTICLE");
        }
        if (this.isProcedure()) {
            return ASEUtils.getString("DISP_PROC_ARTICLE");
        }
        Debug.wassert(false, this, "Unexpected Article Type");
        return null;
    }

    public void setTableType() {
        this._type = "table";
    }

    public void setProcedureType() {
        this._type = "procedure";
    }

    public void setNewFields(String string) {
        this._newArticleFields = string;
    }

    public void setArticleExists(boolean bl) {
        this._articleExists = bl;
    }

    public String getShadowTable() {
        return this._shadowTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getFields(ASConnection aSConnection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        Debug.wassert(aSConnection != null, "Invalid connection parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter");
        Debug.wassert(string4 != null && string4.length() > 0, "Null or empty owner parameter");
        Debug.wassert(string5 != null && string5.length() > 0, "Null or empty name parameter");
        Vector vector = new Vector();
        Object[] objectArray = new String[]{string, string2, string3, string4, string5};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            String string6 = rLSQLResourceBundle.getString("QUERY_ARTICLE_FIELDS_FOR_CONN", objectArray);
            aSResultSet.open(string6);
            while (aSResultSet.getNextRow()) {
                String string7;
                Vector<Object> vector2 = new Vector<Object>();
                String string8 = aSResultSet.getColumnString(8);
                if (string8 == null || string8.length() == 0) {
                    string7 = ASEUtils.getString("ERR_INVALID_SQL_ART_FIELD_FLD");
                    SQLException sQLException = new SQLException(string7);
                    throw sQLException;
                }
                vector2.addElement(string8);
                string7 = aSResultSet.getColumnString(9);
                if (string7 == null || string7.length() == 0) {
                    String string9 = ASEUtils.getString("ERR_INVALID_SQL_ART_DT_FLD");
                    SQLException sQLException = new SQLException(string9);
                    throw sQLException;
                }
                int n = aSResultSet.getColumnInt(10);
                int n2 = aSResultSet.getColumnInt(11);
                vector2.addElement(RLMetaData.FormatDatatype(aSConnection, string7, n, n, n2));
                vector2.addElement(new Integer(aSResultSet.getColumnInt(7)));
                vector.addElement(vector2);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getFields(ASConnection aSConnection, String string, String string2, String string3, String string4) throws SQLException {
        Debug.wassert(aSConnection != null, "Invalid connection parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty publication parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty owner parameter");
        Debug.wassert(string4 != null && string4.length() > 0, "Null or empty name parameter");
        Vector vector = new Vector();
        Object[] objectArray = new String[]{string, string2, string3, string4};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_ARTICLE_FIELDS_FOR_PUB", objectArray));
            while (aSResultSet.getNextRow()) {
                String string5;
                Vector<Object> vector2 = new Vector<Object>();
                String string6 = aSResultSet.getColumnString(8);
                if (string6 == null || string6.length() == 0) {
                    string5 = ASEUtils.getString("ERR_INVALID_SQL_ART_FIELD_FLD");
                    SQLException sQLException = new SQLException(string5);
                    throw sQLException;
                }
                vector2.addElement(string6);
                string5 = aSResultSet.getColumnString(9);
                if (string5 == null || string5.length() == 0) {
                    String string7 = ASEUtils.getString("ERR_INVALID_SQL_ART_DT_FLD");
                    SQLException sQLException = new SQLException(string7);
                    throw sQLException;
                }
                int n = aSResultSet.getColumnInt(10);
                int n2 = aSResultSet.getColumnInt(11);
                vector2.addElement(RLMetaData.FormatDatatype(aSConnection, string5, n, n, n2));
                vector2.addElement(new Integer(aSResultSet.getColumnInt(7)));
                vector.addElement(vector2);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPrimaryArticles(ASConnection aSConnection, String string, String string2) throws SQLException {
        Debug.wassert(aSConnection != null, "Null connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty ddb parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty publication parameter");
        Vector<ArticleSO> vector = new Vector<ArticleSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_ARTICLES", string, string2));
            while (aSResultSet.getNextRow()) {
                ArticleSO articleSO = new ArticleSO(aSConnection, string);
                articleSO.load(aSResultSet);
                vector.addElement(articleSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPrimaryArticles(ASConnection aSConnection, String string, String string2, String string3) throws SQLException {
        Debug.wassert(aSConnection != null, "Null connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty ddb parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter");
        Vector<ArticleSO> vector = new Vector<ArticleSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_ARTICLES_FOR_CONN", string, string2, string3));
            while (aSResultSet.getNextRow()) {
                ArticleSO articleSO = new ArticleSO(aSConnection, string);
                articleSO.load(aSResultSet);
                vector.addElement(articleSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPrimaryArticles(ASConnection aSConnection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        Debug.wassert(aSConnection != null, "Invalid connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty DDB parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter");
        Debug.wassert(string4 != null && string4.length() > 0, "Null or empty owner parameter");
        Debug.wassert(string5 != null && string5.length() > 0, "Null or empty article name parameter");
        Vector<ArticleSO> vector = new Vector<ArticleSO>();
        Object[] objectArray = new String[]{string, string2, string3, string4, string5};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_ARTICLES_BY_NAME", objectArray));
            while (aSResultSet.getNextRow()) {
                ArticleSO articleSO = new ArticleSO(aSConnection, string);
                articleSO.load(aSResultSet);
                vector.addElement(articleSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getShadowTable(ASConnection aSConnection, String string, String string2, String string3, String string4) throws SQLException {
        Debug.wassert(aSConnection != null, "Invalid connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty DDB parameter");
        Debug.wassert(string2 != null && string2.length() > 0, "Null or empty publication parameter");
        Debug.wassert(string3 != null && string3.length() > 0, "Null or empty owner parameter");
        Debug.wassert(string4 != null && string4.length() > 0, "Null or empty article name parameter");
        String string5 = null;
        Object[] objectArray = new String[]{string, string2, string3, string4};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_ARTICLE_BY_PUB", objectArray));
            if (aSResultSet.getNextRow()) {
                string5 = aSResultSet.getColumnString(9);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return string5;
    }

    @Override
    public Object[] getAttributes() {
        return null;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("ART_PROP_DISP_TYPE");
    }
}

