/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.MBeanSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.JMXException;
import com.sybase.ua.security.ac.ARL;
import com.sybase.ua.security.ac.PermissionValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanAttributeInfo;

public class AttributeSO
extends ASEBaseItemSO {
    public static final String ACCESS_READONLY = "RO";
    public static final String ACCESS_WRITEONLY = "WO";
    public static final String ACCESS_READWRITE = "RW";
    private MBeanSO _mbean;
    private MBeanAttributeInfo _attrInfo;
    private Object _value;

    public AttributeSO(MBeanSO mBeanSO, MBeanAttributeInfo mBeanAttributeInfo) {
        this._mbean = mBeanSO;
        String string = mBeanAttributeInfo.getName();
        this.setName(string.substring(0, 1).toLowerCase() + string.substring(1));
        this._attrInfo = mBeanAttributeInfo;
    }

    public String getDescription() {
        return this._attrInfo.getDescription();
    }

    public String getReturnType() {
        String string = this._attrInfo.getType();
        string = Utility.convertArrayType(string);
        return string;
    }

    public String getAccess() {
        String string = "";
        if (this._attrInfo.isReadable() && this._attrInfo.isWritable()) {
            string = ACCESS_READWRITE;
        }
        if (this._attrInfo.isReadable() && !this._attrInfo.isWritable()) {
            string = ACCESS_READONLY;
        }
        if (!this._attrInfo.isReadable() && this._attrInfo.isWritable()) {
            string = ACCESS_WRITEONLY;
        }
        return string;
    }

    public boolean isWritable() {
        return this._attrInfo.isWritable();
    }

    public boolean isReadable() {
        return this._attrInfo.isReadable();
    }

    public boolean isTypeSupported() {
        String string = this.getReturnType();
        if (string.equals("boolean")) {
            return true;
        }
        if (string.equals("java.lang.String")) {
            return true;
        }
        if (string.equals("int")) {
            return true;
        }
        if (string.equals("long")) {
            return true;
        }
        if (string.equals("short")) {
            return true;
        }
        if (string.equals("double")) {
            return true;
        }
        if (string.equals("float")) {
            return true;
        }
        return string.equals("char[]");
    }

    @Override
    public Object[] getAttributes() {
        return new Object[]{this.getName(), this.getAccess(), this.getDescription(), this.getReturnType()};
    }

    public void setValue() {
        try {
            this._value = this._mbean.getAttributeValue(this.getName());
        }
        catch (JMXException jMXException) {
            this._value = ASEUtils.getString("MSG_ERROR_RETRIEVE_PROP");
        }
        catch (AgentConnectionException agentConnectionException) {
            this._value = ASEUtils.getString("MSG_NO_AUTHORIZATION_FOR_PROP");
        }
        catch (IOException iOException) {
            this._value = ASEUtils.getString("MSG_TYPE_NOT_SUPPORTED");
        }
    }

    public Object getValue() {
        String string = this.getReturnType();
        if (this._value == null) {
            return null;
        }
        if (this._value.toString().indexOf("Error retrieving value") > -1) {
            return this._value;
        }
        if (string.indexOf("[]") > 0 && this.checkPermission("read")) {
            String string2 = new String();
            if (string.indexOf("boolean[]") > -1) {
                boolean[] blArray = (boolean[])this._value;
                for (int i = 0; i < blArray.length; ++i) {
                    string2 = string2 + "[" + blArray[i] + "]";
                }
                return string2;
            }
            if (string.indexOf("byte[]") > -1) {
                byte[] byArray = (byte[])this._value;
                for (int i = 0; i < byArray.length; ++i) {
                    string2 = string2 + "[" + byArray[i] + "]";
                }
                return string2;
            }
            if (string.indexOf("char[]") > -1) {
                char[] cArray = (char[])this._value;
                for (int i = 0; i < cArray.length; ++i) {
                    string2 = string2 + "[" + cArray[i] + "]";
                }
                return string2;
            }
            if (string.indexOf("double[]") > -1) {
                double[] dArray = (double[])this._value;
                for (int i = 0; i < dArray.length; ++i) {
                    string2 = string2 + "[" + dArray[i] + "]";
                }
                return string2;
            }
            if (string.indexOf("float[]") > -1) {
                float[] fArray = (float[])this._value;
                for (int i = 0; i < fArray.length; ++i) {
                    string2 = string2 + "[" + fArray[i] + "]";
                }
                return string2;
            }
            if (string.indexOf("int[]") > -1) {
                int[] nArray = (int[])this._value;
                for (int i = 0; i < nArray.length; ++i) {
                    string2 = string2 + "[" + nArray[i] + "]";
                }
                return string2;
            }
            if (string.indexOf("long[]") > -1) {
                long[] lArray = (long[])this._value;
                for (int i = 0; i < lArray.length; ++i) {
                    string2 = string2 + "[" + lArray[i] + "]";
                }
                return string2;
            }
            if (string.indexOf("[]") > 0) {
                Object[] objectArray = (Object[])this._value;
                for (int i = 0; i < objectArray.length; ++i) {
                    string2 = string2 + "[" + objectArray[i].toString() + "]";
                }
                return string2;
            }
            return this._value;
        }
        return this._value;
    }

    public void store(Object object) throws Exception {
        this._mbean.setAttribute(this.getName(), object);
        this._value = object;
    }

    public String[] getPermissionNames() {
        ARL aRL = this._mbean.getARL();
        List list = aRL.getAttributePermissionValues();
        if (list != null) {
            PermissionValue permissionValue2;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PermissionValue permissionValue2 : list) {
                if (permissionValue2.getName().equalsIgnoreCase("write") && !this.isWritable() || permissionValue2.getName().equalsIgnoreCase("read") && !this.isReadable()) continue;
                arrayList.add(permissionValue2.getName());
            }
            permissionValue2 = arrayList.toArray();
            String[] stringArray = new String[((PermissionValue)permissionValue2).length];
            for (int i = 0; i < ((PermissionValue)permissionValue2).length; ++i) {
                stringArray[i] = (String)permissionValue2[i];
            }
            return stringArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public Boolean getPermission(String string, String string2) {
        ARL aRL = this._mbean.getARL();
        return new Boolean(aRL.hasAttributePermission(this.getName(), string, string2));
    }

    public void setPermissions(String string, String[] stringArray) {
        ARL aRL = this._mbean.getARL();
        aRL.setAttributePermissions(this.getName(), string, stringArray);
    }

    public Boolean isSecurityModuleSupported(String string) {
        ARL aRL = this._mbean.getARL();
        if (aRL.isSecurityModSupportedByAttr(this.getName(), string)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setSecurityModules(String[] stringArray) {
        ARL aRL = this._mbean.getARL();
        aRL.setAttributeSecurityModules(this.getName(), stringArray);
    }

    public void saveARL() throws Exception {
        this._mbean.saveARL();
        this._mbean.reloadACLCache();
    }

    public boolean checkPermission(String string) {
        return this._mbean.checkAttributePermission(this.getName(), string);
    }

    public MBeanSO getMBean() {
        return this._mbean;
    }
}

