/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.MonitorServerSO;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.ua.plugin.AgentPluginException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Vector;
import org.jdom.JDOMException;

public class BackupServerSO2
extends MonitorServerSO {
    public static final int BACKUP_SERVER_POLICY_DEDICATED = 0;
    public static final int BACKUP_SERVER_POLICY_ROUND_ROBIN = 1;
    public boolean _enableHA;
    private int _backupServerPolicy = 1;

    public BackupServerSO2(ASConnection aSConnection, SOItemInterface sOItemInterface, ServerSO serverSO) {
        super(aSConnection, sOItemInterface, serverSO);
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("BACKUP_SERVER_TYPE_NAME");
    }

    public void setBackupServerPolicy(int n) {
        this._backupServerPolicy = n;
    }

    public int getBackupServerPolicy() {
        return this._backupServerPolicy;
    }

    @Override
    public void creatServer(ICluster iCluster) throws AgentPluginException, RemoteException, ClusterConfigException, SQLException, AgentPluginException, IOException {
        iCluster.setMultipleBackupServersPresent(true);
        iCluster.setBackupServerName(null);
        iCluster.setBackupServersPolicy(this.getBackupServerPolicy() == 1 ? "$ROUNDROBIN" : "$DEDICATED");
        Vector vector = this.getNodes();
        String string = null;
        Integer n = null;
        String string2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            string = ((Object[])vector.get(i))[0].toString();
            n = (Integer)((Object[])vector.get(i))[1];
            string2 = ((Object[])vector.get(i))[2].toString();
            IServer iServer = this.getInstanceByName(iCluster, string);
            iServer.setBackupServerName(string + "_BS");
            iServer.setBackupServerPort(n.toString());
            iServer.setBackupServerLogFile(string2);
        }
        this._serverSO.createBackupServer(iCluster);
        this.modifyHAMode(this.isEnableHA());
    }

    @Override
    public void removeServer() throws AgentPluginException, ClusterConfigException, JDOMException, IOException, SQLException {
        ICluster iCluster = this.getCluster();
        iCluster.setMultipleBackupServersPresent(true);
        this._serverSO.dropBackupServer(iCluster);
    }

    @Override
    public void updateServer() throws AgentPluginException, ClusterConfigException, SQLException, JDOMException, IOException {
        ICluster iCluster = this.getCluster();
        iCluster.setBackupServersPolicy(this.getBackupServerPolicy() == 1 ? "$ROUNDROBIN" : "$DEDICATED");
        iCluster.setMultipleBackupServersPresent(true);
        iCluster.setBackupServerName(null);
        Vector vector = this.getNodes();
        String string = null;
        Integer n = null;
        for (int i = 0; i < vector.size(); ++i) {
            string = ((Object[])vector.get(i))[0].toString();
            n = (Integer)((Object[])vector.get(i))[1];
            IServer iServer = this.getInstanceByName(iCluster, string);
            iServer.setBackupServerName(string + "_BS");
            iServer.setBackupServerPort(n.toString());
        }
        this._serverSO.setMultipleBackupServerProperties(iCluster);
    }

    public void setEnableHA(boolean bl) {
        this._enableHA = bl;
    }

    public boolean isEnableHA() {
        return this._enableHA;
    }

    public boolean getHAMode() throws SQLException {
        this.getRSet().open("exec sp_configure 'enable backupserver HA'");
        this.getRSet().getNextRow();
        String string = this.getRSet().getColumnString("Run Value");
        return string.trim().equals("1");
    }

    public void modifyHAMode(boolean bl) throws SQLException {
        this._conn.executeCommand(bl ? "exec sp_configure 'enable backupserver HA', 1" : "exec sp_configure 'enable backupserver HA', 0");
    }
}

