/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.CachesCtrSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class CacheSO
extends ASEBaseItemSO {
    public static final String DEFAULT_DATA_CACHE = "default data cache";
    public static final String TYPE_LOG_ONLY = "logonly";
    public static final String TYPE_MIXED = "mixed";
    public static final String CACHE_TYPE_DATA_AND_LOG = "mixed";
    public static final String CACHE_TYPE_LOG_ONLY = "logonly";
    public static final String CACHE_TYPE_IM_DATABASE = "inmemory_storage";
    public static int CACHE_SCOPE_SMP = 0;
    public static int CACHE_SCOPE_SDC_GLOBAL = 1;
    public static int CACHE_SCOPE_SDC_LOCAL = 2;
    public static int IM_CACHE_SCOPE_SMP = 3;
    public static int IM_CACHE_SCOPE_SDC_GLOBAL = 4;
    public static int IM_CACHE_SCOPE_SDC_LOCAL = 5;
    protected static final int NAME = 0;
    protected static final int STATUS = 1;
    protected static final int CONFIGURATEDSIZE = 2;
    protected static final int RUNNINGSIZE = 3;
    protected static final int USEDSIZEBYIMDBDEV = 4;
    private int SY_CACHE_DEFAULT = 1;
    private int SY_CACHE_DBLOG = 2;
    private int SY_CACHE_LOG = 4;
    private int SY_CACHE_IN_MEMORY = 196640;
    private int SY_CACHE_ACTIVE = 32;
    private int SY_CACHE_ACTIVE_PENDING = 64;
    private int SY_CACHE_DEL_PENDING = 128;
    private int SY_CACHE_DEL_PENDING_SDC = 16384;
    private int _status;
    private String _runningsize = "";
    private String _configuredSize = "";
    private String _usedSizeByIMDBDev = "0.00";
    private String _cachesize = "";
    private String _cachetype = "";
    private String _cachedisplaysize = "";
    private String _cachedisplayunit = "";
    private Vector _tableVector;
    private Vector _indexVector;
    private Hashtable _memorySize;
    private Hashtable _washSize;
    private Hashtable _prefetchLimit;
    private String _globalPrefetchLimit;
    private Hashtable _usedSize;
    private Hashtable _previousExistPoolSize;
    private Hashtable _sdcInstances;
    private int _cacheScope = CACHE_SCOPE_SMP;
    private static final int SY_CHANGE_CACHE_TYPE_SUCCESSFUL = 10861;

    public CacheSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
    }

    public CacheSO(ASConnection aSConnection) {
        this(aSConnection, "");
    }

    protected void load(String[] stringArray) {
        this._status = Integer.parseInt(stringArray[1]);
        this._runningsize = stringArray[3];
        this._configuredSize = stringArray[2];
        if (stringArray.length > 4 && this.isInMemoryStorage()) {
            this._usedSizeByIMDBDev = stringArray[4];
        }
    }

    public boolean isDefaultDataCache() {
        return this.isDefault();
    }

    public int getCacheScope() {
        return this._cacheScope;
    }

    public void setCacheScope(int n) {
        if (n == CACHE_SCOPE_SMP) {
            this._cacheScope = CACHE_SCOPE_SMP;
        } else if (n == CACHE_SCOPE_SDC_GLOBAL) {
            this._cacheScope = CACHE_SCOPE_SDC_GLOBAL;
        } else if (n == CACHE_SCOPE_SDC_LOCAL) {
            this._cacheScope = CACHE_SCOPE_SDC_LOCAL;
        } else if (n == IM_CACHE_SCOPE_SMP) {
            this._cacheScope = IM_CACHE_SCOPE_SMP;
        }
    }

    @Override
    public void create() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_cacheconfig {0}, ''{1}K'' ", this.getName(), this._cachesize);
        if (!this._cachetype.equals("")) {
            string = string + ", " + this._cachetype;
        }
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string = string + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string);
    }

    public Vector getBindingObjets() throws SQLException {
        Vector<Vector> vector = new Vector<Vector>();
        this.initTableAndIndex();
        vector.addElement(this.getDBList());
        vector.addElement(this.getTableList());
        vector.addElement(this.getIndexList());
        return vector;
    }

    @Override
    public CacheSO findObject() throws SQLException {
        CachesCtrSO cachesCtrSO = new CachesCtrSO(this.getConnection());
        Object[] objectArray = new Object[]{this.getName()};
        List list = cachesCtrSO.open(1, objectArray);
        return list.isEmpty() ? null : (CacheSO)list.get(0);
    }

    @Override
    public void remove() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_cacheconfig ''{0}'', ''0'' ", this.getName());
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string = string + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string);
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public String getStatus() {
        String string = "";
        if ((this._status & this.SY_CACHE_ACTIVE_PENDING) != 0) {
            string = ASEUtils.getString("MSG_ACTIVATION_PENDING");
        } else if ((this._status & this.SY_CACHE_DEL_PENDING) != 0 || (this._status & this.SY_CACHE_DEL_PENDING_SDC) != 0) {
            string = ASEUtils.getString("MSG_DELETION_PENDING");
        } else if (this.isActive()) {
            string = ASEUtils.getString("MSG_ACTIVE");
        }
        return string;
    }

    public boolean isActive() {
        boolean bl = (this._status & this.SY_CACHE_ACTIVE) != 0;
        return bl;
    }

    public double dividedByMB(double d) {
        return Utility.getKBToMB(d);
    }

    public double dividedByGB(double d) {
        return Utility.getKBToGB(d);
    }

    public double dividedByPage(double d) {
        return Utility.getKBToPageSize(this._conn, d);
    }

    public double multipleByPage(double d) {
        return Utility.getPageSizeToKB(this._conn, d);
    }

    public double multipleByMB(double d) {
        return Utility.getMBToKB(d);
    }

    public double multipleByGB(double d) {
        return Utility.getGBToKB(d);
    }

    public String getRunningSize() {
        double d = 0.0;
        if (this._runningsize.length() > 0) {
            d = this.dividedByMB(Float.valueOf(this._runningsize).floatValue());
        }
        double d2 = Utility.getPrecision(d, 2);
        return String.valueOf(d2);
    }

    public String getConfiguredSize() {
        double d = 0.0;
        if (this._configuredSize.length() > 0) {
            d = this.dividedByMB(Float.valueOf(this._configuredSize).floatValue());
        }
        double d2 = Utility.getPrecision(d, 2);
        return String.valueOf(d2);
    }

    public void setCacheSize(String string) {
        this._cachesize = string;
    }

    public String getCacheSize() {
        return this._cachesize;
    }

    public void setCacheType(String string) {
        this._cachetype = string;
    }

    public String getCacheType() {
        return this._cachetype;
    }

    public boolean isInMemoryStorage() {
        if (this._conn.isIMDBApplicable()) {
            return (this._status & this.SY_CACHE_IN_MEMORY) == this.SY_CACHE_IN_MEMORY;
        }
        return false;
    }

    public void setCacheDisplaySize(String string) {
        this._cachedisplaysize = string;
    }

    public String getCacheDisplaySize() {
        return this._cachedisplaysize;
    }

    public void setCacheDisplayUnit(String string) {
        this._cachedisplayunit = string;
    }

    public String getCacheDisplayUnit() {
        return this._cachedisplayunit;
    }

    @Override
    public boolean exists() throws SQLException {
        String string = SQLs.getString("select name from master.dbo.sysconfigures where parent = 19 and config = parent and name = ''{0}''", this.getName());
        this.getRSet().open(string);
        boolean bl = this.getRSet().getNextRow();
        this.getRSet().close();
        return bl;
    }

    public boolean isDefault() {
        boolean bl = (this._status & this.SY_CACHE_DEFAULT) != 0;
        return bl;
    }

    public boolean isDeletePending() {
        boolean bl = (this._status & this.SY_CACHE_DEL_PENDING) != 0 || (this._status & this.SY_CACHE_DEL_PENDING_SDC) != 0;
        return bl;
    }

    public double getKBRunningSize() {
        if (this._runningsize.length() == 0) {
            this._runningsize = "0";
        }
        double d = Double.valueOf(this._runningsize);
        return d;
    }

    public double getKBConfiguredSize() {
        if (this._configuredSize.length() == 0) {
            this._configuredSize = "0";
        }
        double d = Double.valueOf(this._configuredSize);
        return d;
    }

    public int getRemainingSpace() throws SQLException {
        this.getRSet().open("select additional_free_memory = (max(b.value) - min(b.value)) * 2 from \tmaster.dbo.sysconfigures a, master.dbo.syscurconfigs b where a.name in ('max memory', 'total logical memory') and a.config = b.config");
        this.getRSet().getNextRow();
        return this.getRSet().getColumnInt(1);
    }

    public int getOverheadInKB(int n) throws SQLException {
        this.getRSet().open(SQLs.getString("select config_admin( 12 , 0 , {0} , 0 , NULL , NULL ) ", n + ""));
        this.getRSet().getNextRow();
        return this.getRSet().getColumnInt(1);
    }

    public boolean isMixed() {
        boolean bl = (this._status & this.SY_CACHE_DBLOG) != 0;
        return bl;
    }

    public boolean isLogOnly() {
        boolean bl = (this._status & this.SY_CACHE_LOG) != 0;
        return bl;
    }

    public void setMixed() throws SQLException {
        block3: {
            String string = SQLs.getString("exec sp_cacheconfig ''{0}'', ''mixed'' ", this.getName());
            if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
                string = string + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
            }
            try {
                this._conn.executeCommand(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 10861) break block3;
                throw sQLException;
            }
        }
    }

    public void setLogOnly() throws SQLException {
        block3: {
            String string = SQLs.getString("exec sp_cacheconfig ''{0}'', ''logonly'' ", this.getName());
            if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
                string = string + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
            }
            try {
                this._conn.executeCommand(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 10861) break block3;
                throw sQLException;
            }
        }
    }

    public void setConfigSize(double d) throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_cacheconfig ''{0}'', ''{1}K'' ", this.getName(), String.valueOf(d));
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string = string + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string);
    }

    public void initUsedSizeHashtable() {
        int n;
        this._memorySize = new Hashtable();
        this._washSize = new Hashtable();
        this._prefetchLimit = new Hashtable();
        this._usedSize = new Hashtable();
        this._previousExistPoolSize = new Hashtable();
        for (int i = n = this.getConnection().getPageSize() / 1024; i <= 8 * n; i *= 2) {
            this._usedSize.put(new Integer(i), new Boolean(false));
            this._previousExistPoolSize.put(new Integer(i), new Boolean(false));
            this._washSize.put(new Integer(i), "-");
            this._prefetchLimit.put(new Integer(i), "-1");
        }
    }

    public double getMemorySizeValue(Integer n) {
        return (Double)this._memorySize.get(n);
    }

    public void putMemorySizeValue(Integer n, Double d) {
        this._memorySize.put(n, d);
    }

    public boolean getUsedSizeValue(Integer n) {
        return (Boolean)this._usedSize.get(n);
    }

    public boolean getpreviousExistPoolSize(Integer n) {
        return (Boolean)this._previousExistPoolSize.get(n);
    }

    public void putUsedSizeValue(Integer n, Boolean bl) {
        this._usedSize.put(n, bl);
    }

    public String getWashSizeValue(Integer n) {
        return (String)this._washSize.get(n);
    }

    public void putWashSizeValue(Integer n, String string) {
        this._washSize.put(n, string);
    }

    public String getPrefetchLimitValue(Integer n) {
        return (String)this._prefetchLimit.get(n);
    }

    public Vector bufferPoolInit() throws SQLException {
        Vector vector = new Vector();
        if (this._globalPrefetchLimit == null) {
            this._globalPrefetchLimit = String.valueOf(this.getConnection().getSPConfigRunValue("global async prefetch limit"));
        }
        String string = SQLs.getString("select substring( a.comment, 1, charindex(''K'', a.comment) -1), b.value, b.memory_used, a.value4 from master.dbo.sysconfigures a, master.dbo.syscurconfigs b where a.parent = 19 and a.config != a.parent and b.config = a.config and a.name = ''{0}'' and b.comment = a.name ", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<String> vector2 = new Vector<String>();
            this._memorySize.put(new Integer(this.getRSet().getColumnString(1)), new Double(this.getRSet().getColumnString(2)));
            this._washSize.put(new Integer(this.getRSet().getColumnString(1)), this.getRSet().getColumnString(3));
            this._usedSize.put(new Integer(this.getRSet().getColumnString(1)), new Boolean(true));
            this._previousExistPoolSize.put(new Integer(this.getRSet().getColumnString(1)), new Boolean(true));
            String string2 = this.getRSet().getColumnString(4);
            String string3 = string2.equals("-1") ? this._globalPrefetchLimit : string2;
            this._prefetchLimit.put(new Integer(this.getRSet().getColumnString(1)), string3);
            vector2.addElement(this.getRSet().getColumnString(1));
            vector2.addElement(this.getKBToMB(new Double(this.getRSet().getColumnString(2))));
            vector2.addElement(this.getRSet().getColumnString(3));
            vector2.addElement(string3);
            vector2.addElement("-1");
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public String getKBToKB(double d) {
        return String.valueOf(d);
    }

    public String getKBToMB(double d) {
        return String.valueOf(Utility.getPrecision(Utility.getKBToMB(d), 2));
    }

    public String getKBToPage(double d) {
        return String.valueOf(Utility.getPrecision(Utility.getKBToPageSize(this._conn, d), 2));
    }

    public String getKBToGB(double d) {
        return String.valueOf(Utility.getPrecision(Utility.getKBToGB(d), 4));
    }

    public String getMBToPage(double d) {
        return String.valueOf(Utility.getPrecision(Utility.getMBToPageSize(this._conn, d), 2));
    }

    public double getPageToKB(double d) {
        return Utility.getPageSizeToKB(this._conn, d);
    }

    public double getMBToKB(double d) {
        return Utility.getMBToKB(d);
    }

    public double getGBToKB(double d) {
        return Utility.getGBToKB(d);
    }

    public double getMBToGB(double d) {
        return Utility.getMBToGB(d);
    }

    public double getPageSize() {
        return this._conn.getPageSize();
    }

    public void dropPoolSize(String string) throws SQLException {
        String string2 = SQLs.getString("exec sp_poolconfig ''{0}'', ''0K'', ''{1}K'' ", this.getName(), string);
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string2 = string2 + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string2);
    }

    public void addPoolSize(String string, String string2, String string3) throws SQLException {
        Object[] objectArray = new Object[]{this.getName(), string, string2, string3};
        String string4 = SQLs.getString("exec sp_poolconfig ''{0}'', ''{1}K'', ''{2}K'', ''{3}K'' ", objectArray);
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string4 = string4 + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string4);
    }

    public void setPrefetchLimit(String string, String string2) throws SQLException {
        Object[] objectArray = new Object[]{this.getName(), string, string2};
        String string3 = SQLs.getString("exec sp_poolconfig ''{0}'', ''{1}K'', ''local async prefetch limit={2}'' ", objectArray);
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string3 = string3 + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string3);
    }

    public void changeWashSize(String string, String string2) throws SQLException {
        String string3 = SQLs.getString("exec sp_poolconfig ''{0}'', ''{1}K'', ''wash={2}K'' ", this.getName(), string, string2);
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string3 = string3 + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string3);
    }

    public void changePoolSize(String string, String string2, String string3) throws SQLException {
        Object[] objectArray = new String[]{this.getName(), string, string2, string3};
        String string4 = SQLs.getString("exec sp_poolconfig ''{0}'', ''{1}K'', ''{2}K'', ''{3}K'' ", objectArray);
        if (this.getCacheScope() == CACHE_SCOPE_SDC_LOCAL) {
            string4 = string4 + SQLs.getString(" ,''instance {0}''", this._conn.getServerName());
        }
        this._conn.executeCommand(string4);
    }

    public Vector getDBList() throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getDatabaseSmallImage());
        String string = SQLs.getString("select db_name( object ), null, null, object_type, (select b.name from master.dbo.syslogins b, master.dbo.sysdatabases c where b.suid = c.suid and c.dbid = a.object) from master.dbo.sysattributes a where char_value = ''{0}'' ", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            if (this.getRSet().getColumnString(1).length() == 0) break;
            vector2.addElement(new JLabel(this.getRSet().getColumnString(1), imageIcon, 2));
            vector2.addElement(this.getRSet().getColumnString(5));
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    public void initTableAndIndex() throws SQLException {
        this._tableVector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getTableSmallImage());
        this._indexVector = new Vector();
        ImageIcon imageIcon2 = new ImageIcon(ASEImages.getIndexSmallImage());
        Vector vector = this.getDBChoice();
        for (int i = 0; i < vector.size(); ++i) {
            String string = SQLs.getString("select ''{0}'', a.object, (select b.name from {0}.dbo.sysobjects b where b.id = a.object ), 'null', object_type, (select b.name from {0}.dbo.sysusers b, {0}.dbo.sysobjects c where b.uid = c.uid and c.id = a.object), (select convert(char(1), b.type) from {0}.dbo.sysobjects b ", ((JLabel)vector.elementAt(i)).getText(), this.getName());
            string = string + SQLs.getString(" where b.id = a.object ) from {0}.dbo.sysattributes a where char_value = ''{1}'' and object_type = ''T'' union all select ''{0}'', a.object, (select b.name from {0}.dbo.sysobjects b where b.id = a.object ), (select b.name from {0}.dbo.sysindexes b where b.indid = a.object_info1 and b.id = a.object ), object_type, (select b.name from {0}.dbo.sysusers b, {0}.dbo.sysobjects c where b.uid = c.uid and c.id = a.object), (select convert(char(1), b.type) from {0}.dbo.sysobjects b where b.id = a.object ) from {0}.dbo.sysattributes a where char_value = ''{1}'' and object_type = ''I'' ", ((JLabel)vector.elementAt(i)).getText(), this.getName());
            ASResultSet aSResultSet = this.getLocalResultSet(((JLabel)vector.elementAt(i)).getText());
            if (aSResultSet == null) continue;
            aSResultSet.open(string);
            while (aSResultSet.getNextRow()) {
                Vector<Object> vector2;
                String string2 = this.getRSet().getColumnString(5);
                if (string2.compareTo("T") == 0) {
                    vector2 = new Vector<Object>();
                    vector2.addElement(new JLabel(this.getRSet().getColumnString(3), imageIcon, 2));
                    vector2.addElement(this.getRSet().getColumnString(6));
                    vector2.addElement(this.getRSet().getColumnString(1));
                    this._tableVector.addElement(vector2);
                    continue;
                }
                if (string2.compareTo("I") != 0) continue;
                vector2 = new Vector();
                vector2.addElement(new JLabel(this.getRSet().getColumnString(4), imageIcon2, 2));
                vector2.addElement(this.getRSet().getColumnString(3));
                vector2.addElement(this.getRSet().getColumnString(1));
                vector2.addElement(this.getRSet().getColumnString(2));
                vector2.addElement(this.getRSet().getColumnString(6));
                this._indexVector.addElement(vector2);
            }
            aSResultSet.close();
        }
    }

    private ASResultSet getLocalResultSet(String string) {
        String string2;
        ASResultSet aSResultSet = this.getRSet();
        if (this._conn.isCluster() && (string2 = this.getSDCInstanceName(string)) != null) {
            new SDCInstancesCtrSO(this.getConnection()).initLocalConnections();
            ASConnection aSConnection = SDCInstancesCtrSO.getLocalConnection(this.getConnection().getServerServerName(), string2);
            if (aSConnection == null) {
                return null;
            }
            aSResultSet = aSConnection.getRSet();
        }
        return aSResultSet;
    }

    public Vector getTableList() {
        return this._tableVector;
    }

    public Vector getIndexList() {
        return this._indexVector;
    }

    public Vector getDBChoice() throws SQLException {
        Vector<JLabel> vector = new Vector<JLabel>();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getDatabaseSmallImage());
        if (this._conn.isCluster()) {
            SDCInstancesCtrSO sDCInstancesCtrSO = new SDCInstancesCtrSO(this.getConnection());
            List list = sDCInstancesCtrSO.getSDCNormalDBList(1);
            for (DatabaseSO databaseSO : list) {
                if (this.getCacheScope() != CACHE_SCOPE_SDC_GLOBAL && !this._conn.getServerName().equals(databaseSO.getSDCInstanceName()) && databaseSO.getSDCInstanceName() != null) continue;
                vector.addElement(new JLabel(databaseSO.getName(), imageIcon, 2));
            }
        } else {
            DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
            List<DatabaseSO> list = databasesCtrSO.getNormalDBList(1);
            for (DatabaseSO databaseSO : list) {
                vector.addElement(new JLabel(databaseSO.getName(), imageIcon, 2));
            }
        }
        return vector;
    }

    public Vector fillDialogTable(String string) throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getTableSmallImage());
        String string2 = SQLs.getString("select A.name, B.name, A.crdate, A.id, convert( char(1), A.type) from {0}.dbo.sysobjects A, {1}.dbo.sysusers B where A.uid = B.uid and ", string, string);
        String string3 = "type in ('S', 'U')";
        String string4 = string2 + string3;
        ASResultSet aSResultSet = this.getLocalResultSet(string);
        if (aSResultSet == null) {
            return vector;
        }
        aSResultSet.open(string4);
        while (aSResultSet.getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(aSResultSet.getColumnString(1), imageIcon, 2));
            vector2.addElement(aSResultSet.getColumnString(2));
            vector2.addElement(string);
            vector.addElement(vector2);
        }
        aSResultSet.close();
        return vector;
    }

    public Vector fillDialogIndex(String string) throws SQLException {
        Vector vector = new Vector();
        ImageIcon imageIcon = new ImageIcon(ASEImages.getIndexSmallImage());
        String string2 = SQLs.getString("select i.name, o.name, o.id, u.name, i.status, convert( char(1), o.type) from {0}.dbo.sysobjects o, {0}.dbo.sysindexes i, {0}.dbo.sysusers u where i.id = o.id and u.uid = o.uid and i.indid between 1 and 254 order by i.name", string);
        ASResultSet aSResultSet = this.getLocalResultSet(string);
        if (aSResultSet == null) {
            return vector;
        }
        aSResultSet.open(string2);
        while (aSResultSet.getNextRow()) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(new JLabel(aSResultSet.getColumnString(1), imageIcon, 2));
            vector2.addElement(aSResultSet.getColumnString(2));
            vector2.addElement(string);
            vector2.addElement(aSResultSet.getColumnString(3));
            vector2.addElement(aSResultSet.getColumnString(4));
            vector.addElement(vector2);
        }
        aSResultSet.close();
        return vector;
    }

    public void bindDB(String string) throws SQLException {
        this.useMasterDB();
        String string2 = "exec sp_bindcache  '" + this.getName() + "', " + string;
        this._conn.executeCommand(string2);
    }

    public void unbindDB(String string) throws SQLException {
        this.useMasterDB();
        String string2 = "exec sp_unbindcache  " + string;
        this._conn.executeCommand(string2);
    }

    public void useCheckPoint(String string) throws SQLException {
        this.useDB(string);
        this._conn.executeCommand("checkpoint");
    }

    public void bindTable(String string, String string2, String string3) throws SQLException {
        this.useDB(string3);
        String string4 = "exec sp_bindcache ";
        String string5 = string4 + "'" + this.getName() + "'," + string3 + ",'" + string2 + "." + string + "'";
        this._conn.executeCommand(string5);
    }

    public void unbindTable(String string, String string2, String string3) throws SQLException {
        this.useDB(string3);
        String string4 = "exec sp_unbindcache ";
        String string5 = string4 + string3 + ",'" + string2 + "." + string + "'";
        this._conn.executeCommand(string5);
    }

    public void bindIndex(String string, String string2, String string3, String string4) throws SQLException {
        this.useDB(string3);
        String string5 = "exec sp_bindcache ";
        String string6 = string5 + "'" + this.getName() + "'," + string3 + ",'" + string4 + "." + string2 + " '," + string;
        this._conn.executeCommand(string6);
    }

    public void unbindIndex(String string, String string2, String string3, String string4) throws SQLException {
        this.useDB(string3);
        String string5 = "exec sp_unbindcache ";
        String string6 = string5 + string3 + ",'" + string4 + "." + string2 + " '," + string;
        this._conn.executeCommand(string6);
    }

    public String getOwnerTableName(String string, String string2) throws SQLException {
        String string3 = Utility.getOwnerName(this.getConnection(), string2, string);
        return string3;
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getStatus(), this.getRunningSize(), this.getConfiguredSize(), this.getUnUsedSize()};
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_CACHE_TYPE");
    }

    @Override
    public boolean includeDelete() {
        return this.getName() != null && !this.getName().equals(DEFAULT_DATA_CACHE);
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSARole();
    }

    public String getGlobalPrefetchLimit() {
        return this._globalPrefetchLimit;
    }

    private String getSDCInstanceName(String string) {
        String string2;
        if (this._sdcInstances == null) {
            this.loadSDCInstancesHash();
        }
        if ((string2 = (String)this._sdcInstances.get(string)) == null) {
            this.loadSDCInstancesHash();
            string2 = (String)this._sdcInstances.get(string);
        }
        return string2;
    }

    private void loadSDCInstancesHash() {
        this._sdcInstances = new Hashtable();
        String string = "select DBName = d.name, Owner = l.name, DBID = d.dbid, InstanceId = d.instanceid, InstanceName = i.name from master.dbo.sysdatabases d, master.dbo.sysinstances i, master.dbo.syslogins l where \td.suid = l.suid and d.instanceid = i.id";
        Object[] objectArray = new String[]{};
        string = SQLs.getString(string, objectArray);
        try {
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                String string2 = this.getRSet().getColumnString(1);
                String string3 = this.getRSet().getColumnString(5);
                this._sdcInstances.put(string2, string3);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Vector getIMDBDeviceList() throws SQLException {
        Vector vector = new Vector();
        if (this.isInMemoryStorage()) {
            this.getRSet().open(SQLs.getString("select NAME=d.name,SIZE=ltrim(str((1. + (d.high - d.low)) / (1048576. / @@pagesize), 10, 2)) from master.dbo.sysdevices d where d.phyname like ''{0}'' group by d.name order by 1", new Object[]{this.getName()}));
            while (this.getRSet().getNextRow()) {
                String[] stringArray = this.getRSet().getColumnsAsArray();
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement(stringArray[0].trim());
                vector2.addElement(stringArray[1].trim());
                vector.addElement(vector2);
            }
            this.getRSet().close();
        }
        return vector;
    }

    public String getUnUsedSize() {
        if (!this.isInMemoryStorage()) {
            return this.getRunningSize();
        }
        double d = 0.0;
        if (this._usedSizeByIMDBDev.length() > 0) {
            d = Float.valueOf(this._usedSizeByIMDBDev).floatValue();
        }
        double d2 = Float.valueOf(this.getRunningSize()).floatValue();
        double d3 = Utility.getPrecision(d2 - d, 2);
        return String.valueOf(d3);
    }

    public double getKBUnUsedSize() {
        double d = Double.valueOf(this.getUnUsedSize());
        double d2 = Utility.getPrecision(Utility.getMBToKB(d), 2);
        return d2;
    }

    public String getIMDBName() throws SQLException {
        if (!this.isInMemoryStorage()) {
            return "";
        }
        String string = "";
        if (!this._conn.isCluster()) {
            Object[] objectArray = new Object[]{"%", this.getName()};
            String string2 = SQLs.getString("select d.phyname, c.name from master.dbo.sysusages u, master.dbo.sysdevices d, master.dbo.sysdatabases c where d.vdevno = u.vdevno and d.status2&8=8 and u.dbid = c.dbid and c.status4&4096=4096 and c.name like ''{0}'' and d.phyname like ''{1}''", objectArray);
            this.getRSet().open(string2);
            if (this.getRSet().getNextRow()) {
                string = this.getRSet().getColumnString(2);
            }
            this.getRSet().close();
        }
        return string;
    }
}

