/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.DatabaseBO;
import com.sybase.aseplugin.bo.JavaObjectsCtrBO;
import com.sybase.aseplugin.so.ASEBaseTableItemSO;
import com.sybase.aseplugin.so.DatabaseSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.DomainDatatypes;
import com.sybase.aseplugin.so.JavaClassSO;
import com.sybase.aseplugin.so.JavaClassesCtrSO;
import com.sybase.aseplugin.so.KeySO;
import com.sybase.aseplugin.so.TableSO;
import com.sybase.aseplugin.so.UserTypeSO;
import com.sybase.aseplugin.so.UserTypesCtrSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.aseplugin.util.perm.GroupPermission;
import com.sybase.aseplugin.util.perm.PublicPermission;
import com.sybase.aseplugin.util.perm.RolePermission;
import com.sybase.aseplugin.util.perm.SyPermission;
import com.sybase.aseplugin.util.perm.UserPermission;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class ColumnSO
extends ASEBaseTableItemSO {
    public static final int NEW_COLUMN = 1;
    public static final int EXISTING_COLUMN = 2;
    public static final int DELETED_COLUMN = 3;
    public static final int EDITED_COLUMN = 4;
    public static final int SKIPPED_COLUMN = 5;
    public static int SYBCOL_ALLOW_NULLS = 8;
    public static int SYBCOL_IDENTIFIER = 128;
    private static final int COMPUTED_COL_STATUS2 = 16;
    private static final int MATERIALIZED_COL_STATUS2 = 32;
    private static final int FUNC_INDEX_COL_STATUS3 = 1;
    public static final String YES = ASEUtils.getString("MSG_YES");
    public static final String NO = ASEUtils.getString("MSG_NO");
    static final String ACTION_SELECT = "select";
    static final String ACTION_UPDATE = "update";
    static final String ACTION_REFERENCES = "references";
    static final String ACTION_DECRYPT = "decrypt";
    private String _sRuleName;
    private String _sRuleOwner;
    private Vector _vDefaults;
    private Vector _vRules;
    private String _sDefaultName;
    private String _sDefaultOwner;
    private String _sInlineDefaultText;
    private int _columnState;
    private DomainDatatypes _baseTypes;
    protected String[] _attrib;
    String _tmpColumnName;
    boolean _tmpIdentity;
    String _tmpAllowNulls;
    boolean _tmpPrimaryKey;
    boolean _tmpMaterialized;
    String _tmpComputedColumnExpression;
    private boolean _tmpComputedKey;
    String _tmpDataType;
    String _tmpLength;
    String _tmpPrecision;
    String _tmpScale;
    int _tmpXStatus;
    String _tmpInlineDefaultText;
    String _tmpBoundDefaultId;
    String _tmpBoundRuleId;
    int _tmpDefaultSelection;
    String _tmpDefaultName;
    String _tmpDefaultOwner;
    String _tmpRuleName;
    String _tmpRuleOwner;
    private Vector _userPermissionList;
    private Vector _groupPermissionList;
    private Vector _rolePermissionList;
    private Vector _grouplistPermissionList;
    private Vector _publicPermissionList;
    public static final int CONST_UNICHARSIZE = 2;
    TreeMap _eks;
    String _sKey;
    boolean _bEncrypt;
    boolean _tmpEncrypt;
    public String defaultKey;
    String _tmpKey;
    boolean _bDecryptDefault;
    boolean _tmpDecryptDefault;
    String _sDecryptDefaultText;
    String _tmpDecryptDefaultText;
    private boolean _hasDefaultKey;

    public ColumnSO(ASConnection aSConnection, String string, TableSO tableSO) {
        super(aSConnection, string, tableSO);
        this._baseTypes = this._conn.getDomainDatatypes();
        this._attrib = new String[16];
        this._tmpColumnName = "";
        this._tmpAllowNulls = "";
        this._tmpComputedColumnExpression = "";
        this._tmpDataType = "";
        this._tmpLength = "";
        this._tmpPrecision = "";
        this._tmpScale = "";
        this._tmpXStatus = -1;
        this._tmpBoundDefaultId = "";
        this._tmpBoundRuleId = "";
        this._tmpDefaultSelection = -1;
        this._userPermissionList = new Vector();
        this._groupPermissionList = new Vector();
        this._rolePermissionList = new Vector();
        this._grouplistPermissionList = new Vector();
        this._publicPermissionList = new Vector();
        this._eks = null;
        this._sKey = "";
        this.defaultKey = ASEUtils.getString("DISP_DEFAULT_TEXT");
        this._tmpKey = ASEUtils.encryptPassword(this.defaultKey);
        this._sDecryptDefaultText = "";
        this._tmpDecryptDefaultText = "";
        this._hasDefaultKey = false;
        this._columnState = 1;
        this._tableSO = tableSO;
        this._tmpColumnName = this.getName();
    }

    ColumnSO(ASConnection aSConnection, String string, TableSO tableSO, TreeMap treeMap, boolean bl) {
        super(aSConnection, string, tableSO);
        this._baseTypes = this._conn.getDomainDatatypes();
        this._attrib = new String[16];
        this._tmpColumnName = "";
        this._tmpAllowNulls = "";
        this._tmpComputedColumnExpression = "";
        this._tmpDataType = "";
        this._tmpLength = "";
        this._tmpPrecision = "";
        this._tmpScale = "";
        this._tmpXStatus = -1;
        this._tmpBoundDefaultId = "";
        this._tmpBoundRuleId = "";
        this._tmpDefaultSelection = -1;
        this._userPermissionList = new Vector();
        this._groupPermissionList = new Vector();
        this._rolePermissionList = new Vector();
        this._grouplistPermissionList = new Vector();
        this._publicPermissionList = new Vector();
        this._eks = null;
        this._sKey = "";
        this.defaultKey = ASEUtils.getString("DISP_DEFAULT_TEXT");
        this._tmpKey = ASEUtils.encryptPassword(this.defaultKey);
        this._sDecryptDefaultText = "";
        this._tmpDecryptDefaultText = "";
        this._hasDefaultKey = false;
        this._columnState = 1;
        this._tableSO = tableSO;
        this._tmpColumnName = this.getName();
        this._eks = treeMap;
        this.setHasDefaultKey(bl);
    }

    public void reName(String string) throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_rename ''{0}'', ''{1}''", this._tableSO.getName() + "." + this.getName(), string));
        this._tmpColumnName = string;
    }

    public void load(String[] stringArray) throws SQLException {
        this._attrib = stringArray;
        this._attrib[1] = this._baseTypes.getUnsignedIntType(this._attrib[1]);
        this._columnState = 2;
        this.refreshTmpVariables();
        if (this.isDecryptDefaultApplicable()) {
            this.setDecryptDefault();
        }
        this.setupEKList();
    }

    public void refreshTmpVariables() throws SQLException {
        this._tmpColumnName = this.getName();
        this._tmpIdentity = this.isIdentifier();
        this._tmpAllowNulls = this.allowsNulls();
        this._tmpDataType = this.getDatatype();
        this._tmpLength = this.getLength();
        this._tmpPrecision = this.getPrecision();
        this._tmpScale = this.getNumericScale();
        this._tmpXStatus = this.getXStatus();
        this._tmpDefaultSelection = -1;
        this._tmpBoundDefaultId = this.getBoundDefaultId();
        this._tmpBoundRuleId = this.getBoundRuleId();
        this._tmpInlineDefaultText = this.getInlineDefaultText();
        this._tmpDefaultName = this.getDefaultName();
        this._tmpDefaultOwner = this.getDefaultOwner();
        this._tmpRuleName = this.getRuleName();
        this._tmpRuleOwner = this.getRuleOwner();
        this._tmpMaterialized = this.isColumnMaterialized();
    }

    public void setupEKList() throws SQLException {
        if (this.getConnection().isEncryptedKeyEnabled()) {
            this.setEncryptionKeysList();
        }
    }

    public String getTmpColumnName() {
        return this._tmpColumnName;
    }

    public void setTmpColumnName(String string) {
        this._tmpColumnName = string;
    }

    public boolean getTmpIdentity() {
        return this._tmpIdentity;
    }

    public void setTmpIdentity(boolean bl) {
        this._tmpIdentity = bl;
    }

    public String IsIdentity() {
        return this._tmpIdentity ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
    }

    public String getTmpAllowNulls() {
        return this._tmpAllowNulls;
    }

    public void setTmpAllowNulls(String string) {
        this._tmpAllowNulls = string;
    }

    public boolean getTmpPrimaryKey() {
        return this._tmpPrimaryKey;
    }

    public void setTmpPrimaryKey(boolean bl) {
        this._tmpPrimaryKey = bl;
    }

    public boolean getTmpComputedKey() {
        return this._tmpComputedKey;
    }

    public void setTmpComputedKey(boolean bl) {
        this._tmpComputedKey = bl;
    }

    public String getTmpDataType() {
        return this._tmpDataType;
    }

    public void setTmpDataType(String string) {
        this._tmpDataType = string;
    }

    public String getTmpLength() {
        return this._tmpLength;
    }

    public void setTmpLength(String string) {
        this._tmpLength = string;
    }

    public String getTmpPrecision() {
        return this._tmpPrecision;
    }

    public void setTmpPrecision(String string) {
        this._tmpPrecision = string;
    }

    public String getTmpScale() {
        return this._tmpScale;
    }

    public void setTmpScale(String string) {
        this._tmpScale = string;
    }

    public void setTmpXStatus(int n) {
        this._tmpXStatus = n;
    }

    public int getTmpXStatus() {
        return this._tmpXStatus;
    }

    public void setTmpInlineDefaultText(String string) {
        this._tmpInlineDefaultText = string;
    }

    public String getTmpInlineDefaultText() {
        return this._tmpInlineDefaultText;
    }

    public String getTmpBoundDefaultId() {
        return this._tmpBoundDefaultId;
    }

    public String getTmpBoundRuleId() {
        return this._tmpBoundRuleId;
    }

    public void setTmpDefaultSelection(int n) {
        this._tmpDefaultSelection = n;
    }

    public int getTmpDefaultSelection() {
        return this._tmpDefaultSelection;
    }

    public String getTmpDefaultName() {
        return this._tmpDefaultName;
    }

    public void setTmpDefaultName(String string) {
        this._tmpDefaultName = string;
    }

    public String getTmpDefaultOwner() {
        return this._tmpDefaultOwner;
    }

    public void setTmpDefaultOwner(String string) {
        this._tmpDefaultOwner = string;
    }

    public String getTmpRuleName() {
        return this._tmpRuleName;
    }

    public void setTmpRuleName(String string) {
        this._tmpRuleName = string;
    }

    public String getTmpRuleOwner() {
        return this._tmpRuleOwner;
    }

    public void setTmpRuleOwner(String string) {
        this._tmpRuleOwner = string;
    }

    private String getLengthPrecision() {
        String string = null;
        if (this._baseTypes.hasWidthType(this._attrib[1]) && !this._attrib[3].equals("1")) {
            string = this._attrib[1] + "(" + this._attrib[3] + ")";
        } else if (this._baseTypes.hasScaleType(this._attrib[1])) {
            string = this._attrib[1] + "(" + this._attrib[4] + "," + this._attrib[5] + ")";
        }
        return string;
    }

    @Override
    public void create() throws SQLException {
        String string = "";
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.getDatabaseName());
        vector.addElement(this.getTableOwner());
        vector.addElement(this.getTableName());
        vector.addElement(this.getTmpColumnName());
        if (this.getTmpComputedKey()) {
            if (this.getTmpMaterialized()) {
                vector.addElement("AS " + this.getTmpComputedExpression() + " MATERIALIZED ");
            } else {
                vector.addElement("AS " + this.getTmpComputedExpression());
            }
        } else {
            if (this._baseTypes.hasWidthType(this._tmpDataType)) {
                vector.addElement(this._tmpDataType + "(" + this._tmpLength + ")");
            } else if (this._baseTypes.hasScaleType(this._tmpDataType)) {
                vector.addElement(this._tmpDataType + "(" + this._tmpPrecision + "," + this._tmpScale + ")");
            } else {
                vector.addElement(this._tmpDataType);
            }
            if (this._tmpDefaultSelection == 2) {
                string = this._tmpInlineDefaultText.length() == 0 ? string + "default null " : string + "default " + this._tmpInlineDefaultText + " ";
            }
            string = this._tmpIdentity ? string + "identity " : (this._tmpAllowNulls.equals(YES) ? string + "null " : string + "not null ");
        }
        if (this._tmpXStatus == 0) {
            string = string + "in row ";
        } else if (this._tmpXStatus == 1) {
            string = string + "off row ";
        }
        if (this.getConnection().isEncryptedKeyEnabled()) {
            if (this.getTmpEncrypt()) {
                string = string + "encrypt ";
                if (!this.getTmpKey().equals(this.defaultKey)) {
                    string = string + "with " + this.getTmpKey() + " ";
                }
            }
            if (this.getTmpDecryptDefault()) {
                string = string + "decrypt_default " + this.getTmpDecryptDefaultText().trim();
            }
        }
        Object[] objectArray = vector.toArray(new String[vector.size()]);
        this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} add {3} {4} ", objectArray) + string);
        if (this._tmpRuleName != null) {
            this.bindRule(this._tmpRuleName, this._tmpRuleOwner);
        }
        if (this._tmpDefaultSelection == 1) {
            this.bindDefault(this._tmpDefaultName, this._tmpDefaultOwner);
        }
        this.setName(this.getTmpColumnName());
    }

    @Override
    public void remove() throws SQLException {
        boolean bl = false;
        DatabaseSO databaseSO = this._tableSO.getDatabaseSO();
        bl = databaseSO.getOption("DB_OP_ALLOW_BULK");
        if (!bl && !databaseSO.isMaster()) {
            databaseSO.setOption("DB_OP_ALLOW_BULK", true);
        }
        Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getTmpColumnName()};
        this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} drop {3}", objectArray));
        if (!bl && !this._databaseSO.isMaster()) {
            databaseSO.setOption("DB_OP_ALLOW_BULK", bl);
        }
    }

    public boolean alterDatatypeNullOrNotNull(boolean bl, String string, String string2, String string3) throws SQLException {
        String string4 = "";
        string4 = bl ? "null" : "not null";
        if (this._baseTypes.hasWidthType(string)) {
            Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getTmpColumnName(), string, string2, string4};
            this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} modify {3} {4} ( {5} ) {6}", objectArray));
            this.setDatatype(string);
            this.setLength(string2);
        } else if (this._baseTypes.hasScaleType(string)) {
            Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getTmpColumnName(), string, string2, string3, string4};
            this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} modify {3} {4} ( {5},{6} ) {7}", objectArray));
            this.setDatatype(string);
            this.setPrecision(string2);
            this.setNumericScale(string3);
        } else {
            Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getTmpColumnName(), string, string4};
            this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} modify {3} {4} {5}", objectArray));
            this.setDatatype(string);
        }
        if (bl) {
            this.setAllowNulls(YES);
        } else {
            this.setAllowNulls(NO);
        }
        return true;
    }

    public int getXStatus() {
        int n = -1;
        try {
            n = new Integer(this._attrib[13]);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public String getLength() {
        String string = this.getDatatype();
        if (string != null && (string.equals("unichar") || string.equals("univarchar"))) {
            int n = Integer.parseInt(this._attrib[3]);
            return n / 2 + "";
        }
        return this._attrib[3];
    }

    public void setLength(String string) {
        this._attrib[3] = string;
    }

    public void setPrecision(String string) {
        this._attrib[4] = string;
    }

    public String getPrecision() {
        return this._attrib[4];
    }

    public String getDatatype() {
        return this._attrib[1];
    }

    public String getDisplayDatatype() {
        String string = this.getLengthPrecision();
        return string == null ? this.getDatatype() : string;
    }

    public void setDatatype(String string) {
        this._attrib[1] = string;
    }

    public void setStatus(String string) {
        this._attrib[8] = string;
    }

    int getStatus() {
        return new Integer(this._attrib[8]);
    }

    public String getNumericScale() {
        return this._attrib[5];
    }

    public void setNumericScale(String string) {
        this._attrib[5] = string;
    }

    public String getID() {
        return this._attrib[11];
    }

    @Override
    public String getOwner() {
        return this.getTableOwner();
    }

    public void setAllowNulls(String string) {
        this._attrib[2] = string;
    }

    public String allowsNulls() {
        return this._attrib[2].equals("Y") ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
    }

    public boolean allowNulls() {
        return this._attrib[2].equals("Y");
    }

    public String getColID() {
        return this._attrib[11];
    }

    public boolean isJava() {
        return !this._attrib[9].equals("0");
    }

    boolean isIdentifier() {
        return (this.getStatus() & SYBCOL_IDENTIFIER) != 0;
    }

    public void setIdentifier() {
        int n = this.getStatus() | SYBCOL_IDENTIFIER;
        this.setStatus(new Integer(n).toString());
    }

    public String getBoundRuleId() {
        return this._attrib[6];
    }

    public String getBoundDefaultId() {
        return this._attrib[7];
    }

    public String getRuleName() {
        return this._sRuleName;
    }

    public void setRuleName(String string) {
        this._sRuleName = string;
    }

    public String getDefaultName() {
        return this._sDefaultName;
    }

    public void setDefaultName(String string) {
        this._sDefaultName = string;
    }

    public String getRuleOwner() {
        return this._sRuleOwner;
    }

    public void setRuleOwner(String string) {
        this._sRuleOwner = string;
    }

    public String getDefaultOwner() {
        return this._sDefaultOwner;
    }

    public void setDefaultOwner(String string) {
        this._sDefaultOwner = string;
    }

    public String getInlineDefaultText() throws SQLException {
        if (this._sInlineDefaultText != null) {
            return this._sInlineDefaultText;
        }
        if (this.getDefaultName() == null && !this._tmpBoundDefaultId.equals("0")) {
            this.getRSet().open(SQLs.getString("select TEXT=C.text from {0}.dbo.syscomments C where C.id={1}", this.getDatabaseName(), this._tmpBoundDefaultId));
            String string = "";
            while (this.getRSet().getNextRow()) {
                string = this.getRSet().getColumnString(1);
            }
            this.getRSet().close();
            if (string.startsWith("default") || string.startsWith("DEFAULT")) {
                string = string.substring(7);
                this._sInlineDefaultText = string.trim();
            } else {
                this._sInlineDefaultText = null;
            }
        } else {
            this._sInlineDefaultText = null;
        }
        return this._sInlineDefaultText;
    }

    public Vector getRules() throws SQLException {
        if (this._vRules != null) {
            return this._vRules;
        }
        this.getRSet().open(SQLs.getString("select NAME=O.name, OBJECT_ID=O.id, OWNER=U.name, CREATION_DATE=O.crdate from {0}.dbo.sysobjects O, {0}.dbo.sysusers U, {0}.dbo.sysprocedures P where O.uid = U.uid and O.id = P.id and P.sequence = 0 and P.status & 4096 != 4096 and O.type = ''R''", this.getDatabaseName()));
        this._vRules = new Vector();
        while (this.getRSet().getNextRow()) {
            String string = this.getRSet().getColumnString(1);
            String string2 = this.getRSet().getColumnString(3);
            String string3 = this.getRSet().getColumnString(2);
            this._vRules.addElement(string + " ( " + string2 + " )");
            if (this._tmpBoundRuleId.equals("0") || !this.getRSet().getColumnString(2).equals(this._tmpBoundRuleId)) continue;
            this.setRuleName(string);
            this.setRuleOwner(string2);
            this._tmpRuleName = string;
            this._tmpRuleOwner = string2;
        }
        this.getRSet().close();
        return this._vRules;
    }

    public Vector getDefaults() throws SQLException {
        if (this._vDefaults != null) {
            return this._vDefaults;
        }
        this.getRSet().open(SQLs.getString("select NAME=O.name, OBJECT_ID=O.id, OWNER=U.name, CREATION_DATE=O.crdate from {0}.dbo.sysobjects O, {0}.dbo.sysusers U, {0}.dbo.sysprocedures P  where O.uid = U.uid and O.id = P.id and P.sequence = 0 and P.status & 4096 != 4096 and O.type = ''D''", this.getDatabaseName()));
        this._vDefaults = new Vector();
        while (this.getRSet().getNextRow()) {
            String string = this.getRSet().getColumnString(1);
            String string2 = this.getRSet().getColumnString(3);
            String string3 = this.getRSet().getColumnString(2);
            this._vDefaults.addElement(string + " ( " + string2 + " )");
            if (this._tmpBoundDefaultId.equals("0") || !this.getRSet().getColumnString(2).equals(this._tmpBoundDefaultId)) continue;
            this.setDefaultName(string);
            this.setDefaultOwner(string2);
            this._tmpDefaultName = string;
            this._tmpDefaultOwner = string2;
        }
        this.getRSet().close();
        return this._vDefaults;
    }

    public Vector getCheckConstraints() throws SQLException {
        String string;
        String string2;
        String string3;
        Vector<Vector> vector = new Vector<Vector>();
        if (this.getID() == null) {
            return vector;
        }
        this.getRSet().open(SQLs.getString("select NAME=O.name, OWNER=U.name, TEXT=C.text from {0}.dbo.sysobjects O, {0}.dbo.sysusers U, {0}.dbo.sysprocedures P, {0}.dbo.sysconstraints CON, {0}.dbo.syscomments C where C.id = O.id and O.uid = U.uid and O.id = P.id and O.id = CON.constrid and CON.tableid = {1} and CON.colid = {2} and P.sequence = 0 and P.status & 4096 = 4096 and O.type = ''R''", this.getDatabaseName(), this.getTableObjectID(), "0"));
        int n = 1;
        int n2 = 2;
        int n3 = 3;
        block0: while (this.getRSet().getNextRow()) {
            string3 = this.getRSet().getColumnString(n);
            string2 = this.getRSet().getColumnString(n2);
            string = this.getRSet().getColumnString(n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f()<>=+-*/~!@%^&(){}[]|:;'\",.?");
            while (stringTokenizer.hasMoreElements()) {
                Vector vector2;
                String string4 = stringTokenizer.nextToken();
                if (!this.getTmpColumnName().equals(string4)) continue;
                boolean bl = false;
                int n4 = 0;
                for (n4 = 0; n4 < vector.size(); ++n4) {
                    vector2 = (Vector)vector.elementAt(n4);
                    if (!((String)vector2.elementAt(0)).equals(string3) || !((String)vector2.elementAt(1)).equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector2 = (Vector)vector.elementAt(n4);
                    StringBuffer stringBuffer = new StringBuffer((String)vector2.elementAt(2));
                    stringBuffer.append(string);
                    vector2.setElementAt(stringBuffer.toString(), 2);
                    continue block0;
                }
                vector2 = new Vector();
                vector2.addElement(string3);
                vector2.addElement(string2);
                vector2.addElement(string);
                vector.addElement(vector2);
                continue block0;
            }
        }
        this.getRSet().close();
        this.getRSet().open(SQLs.getString("select NAME=O.name, OWNER=U.name, TEXT=C.text from {0}.dbo.sysobjects O, {0}.dbo.sysusers U, {0}.dbo.sysprocedures P, {0}.dbo.sysconstraints CON, {0}.dbo.syscomments C where C.id = O.id and O.uid = U.uid and O.id = P.id and O.id = CON.constrid and CON.tableid = {1} and CON.colid = {2} and P.sequence = 0 and P.status & 4096 = 4096 and O.type = ''R''", this.getDatabaseName(), this.getTableObjectID(), this.getID()));
        while (this.getRSet().getNextRow()) {
            Vector vector3;
            string3 = this.getRSet().getColumnString(n);
            string2 = this.getRSet().getColumnString(n2);
            string = this.getRSet().getColumnString(n3);
            boolean bl = false;
            int n5 = 0;
            for (n5 = 0; n5 < vector.size(); ++n5) {
                vector3 = (Vector)vector.elementAt(n5);
                if (!((String)vector3.elementAt(0)).equals(string3) || !((String)vector3.elementAt(1)).equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                vector3 = (Vector)vector.elementAt(n5);
                StringBuffer stringBuffer = new StringBuffer((String)vector3.elementAt(2));
                stringBuffer.append(string);
                vector3.setElementAt(stringBuffer.toString(), 2);
                continue;
            }
            vector3 = new Vector();
            vector3.addElement(string3);
            vector3.addElement(string2);
            vector3.addElement(string);
            vector.addElement(vector3);
        }
        this.getRSet().close();
        return vector;
    }

    public void removeCheckConstraint(Vector vector) throws SQLException {
        String string = (String)vector.elementAt(0);
        String string2 = (String)vector.elementAt(1);
        this.useDB(this.getDatabaseName());
        this.setUser(string2);
        Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), string};
        this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} drop constraint {3}", objectArray));
    }

    public void removeInlineDefault() throws SQLException {
        this.addInlineDefault(null);
    }

    public void addInlineDefault(String string) throws SQLException {
        Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getTmpColumnName(), string};
        this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} replace {3} default {4}", objectArray));
        this._sInlineDefaultText = string;
    }

    public void bindDefault(String string, String string2) throws SQLException {
        this.useDB();
        this.setUser();
        Object[] objectArray = new String[]{string2, string, this.getTableName(), this.getTmpColumnName()};
        this._conn.executeCommand(SQLs.getString("exec sp_bindefault ''{0}.{1}'', ''{2}.{3}''", objectArray));
        this.setDefaultOwner(string);
        this.setDefaultName(string2);
    }

    public void unbindDefault() throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_unbindefault ''{0}.{1}''", this.getTableName(), this.getTmpColumnName()));
        this.setDefaultOwner(null);
        this.setDefaultName(null);
    }

    public void bindRule(String string, String string2) throws SQLException {
        this.useDB();
        this.setUser();
        Object[] objectArray = new String[]{string2, string, this.getTableName(), this.getTmpColumnName()};
        this._conn.executeCommand(SQLs.getString("exec sp_bindrule ''{0}.{1}'', ''{2}.{3}''", objectArray));
        this.setRuleOwner(string2);
        this.setRuleName(string);
    }

    public void unbindRule() throws SQLException {
        this.useDB();
        this.setUser();
        this._conn.executeCommand(SQLs.getString("exec sp_unbindrule ''{0}.{1}''", this.getTableName(), this.getTmpColumnName()));
        this.setRuleOwner(null);
        this.setRuleName(null);
    }

    public String getConstraintSearchCondition(String string) {
        string = string.substring(string.indexOf("(") + 1);
        string.trim();
        string = string.substring(0, string.length() - 1);
        return string;
    }

    public boolean isInPrimaryKey() throws SQLException {
        Vector vector = this._tableSO.getPrimaryKeyColumns();
        return vector != null && vector.contains(this.getTmpColumnName());
    }

    public void setPrimaryKey() {
        this._tableSO.addTmpPrimaryKeys(this.getTmpColumnName());
    }

    public void unSetPrimaryKey() {
        this._tableSO.deleteTmpPrimaryKeys(this.getTmpColumnName());
    }

    public boolean defaultAllowNull() {
        return this._tableSO.getDatabaseSO().getOption("DB_OP_ALLOW_NULLS");
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getDisplayDatatype(), this.allowsNulls(), this.getID()};
    }

    private void setUser(String string) throws SQLException {
        Utility.setUser(this.getConnection(), string);
    }

    private void setUser() throws SQLException {
        Utility.setUser(this.getConnection(), this.getTableOwner());
    }

    public int getColumnState() {
        return this._columnState;
    }

    public boolean setColumnState(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4 && n != 5) {
            return false;
        }
        this._columnState = n;
        return true;
    }

    public Vector getSysUserDataType(DatabaseBO databaseBO) throws SQLException {
        Object object;
        Vector<String[]> vector = new Vector<String[]>();
        DatabaseSO databaseSO = (DatabaseSO)databaseBO.getSO();
        Vector vector2 = this._baseTypes.getAllDomainTypes(databaseSO.getName());
        for (int i = 0; i < vector2.size(); ++i) {
            object = (String)vector2.elementAt(i);
            vector.add(new String[]{object, "0"});
        }
        UserTypesCtrSO userTypesCtrSO = new UserTypesCtrSO(this.getConnection(), (DatabaseSO)databaseBO.getSO());
        object = userTypesCtrSO.open(1);
        if (object != null && object.size() > 0) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                UserTypeSO userTypeSO = (UserTypeSO)iterator.next();
                String string = userTypeSO.getName();
                vector.add(new String[]{string, "1"});
            }
        }
        return vector;
    }

    public Vector getJavaDataType(DatabaseBO databaseBO) throws SQLException {
        JavaClassesCtrSO javaClassesCtrSO;
        List list;
        JavaObjectsCtrBO javaObjectsCtrBO;
        Vector<String[]> vector = new Vector<String[]>();
        String string = this._conn.getVersion();
        if (string.compareTo("12.0") >= 0 && (javaObjectsCtrBO = databaseBO.getJavaObjectsCtrBO()) != null && (list = (javaClassesCtrSO = new JavaClassesCtrSO(this.getConnection(), (DatabaseSO)databaseBO.getSO())).open(1)) != null && list.size() > 0) {
            for (JavaClassSO javaClassSO : list) {
                String string2 = javaClassSO.getName();
                vector.add(new String[]{string2, "2"});
            }
        }
        return vector;
    }

    public String getOrder() {
        return this._attrib[16];
    }

    public String getStatus2() {
        return this._attrib[14];
    }

    public String getStatus3() {
        return this._attrib[15];
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("MSG_COLUMN_TYPE");
    }

    public boolean isComputedColumn() {
        if (this._tableSO.isComputedColApplicable() && this.getStatus2() != null) {
            return (new Integer(this.getStatus2()) & 0x10) > 0;
        }
        return false;
    }

    public boolean isColumnMaterialized() {
        if (this._tableSO.isComputedColApplicable() && this.getStatus2() != null) {
            return (new Integer(this.getStatus2()) & 0x20) > 0;
        }
        return false;
    }

    public boolean isColumnFunctionalIndex() {
        if (this._tableSO.isComputedColApplicable() && this.getStatus3() != null) {
            return (new Integer(this.getStatus3()) & 1) > 0;
        }
        return false;
    }

    public String getComputedColumnExpression() throws SQLException {
        this.getRSet().open(SQLs.getString("select text from {0}.dbo.syscomments where id = (select computedcol from {0}.dbo.syscolumns where id = {2} and name = ''{1}'')", this.getDatabaseName(), this.getName(), this._tableSO.getTableObjectID()));
        String string = "";
        while (this.getRSet().getNextRow()) {
            string = this.getRSet().getColumnString(1);
        }
        this.getRSet().close();
        if (!string.equals("")) {
            string = string.trim();
            String string2 = (string = string.substring(string.indexOf("AS") + 2).trim()).toUpperCase();
            int n = string2.lastIndexOf("MATERIALIZED");
            if (n != -1) {
                string = string.substring(0, n).trim();
                n = string2.lastIndexOf("NOT");
                if (n != -1) {
                    string = string.substring(0, n).trim();
                }
            }
        }
        return string;
    }

    public void setTmpMaterialized(boolean bl) {
        this._tmpMaterialized = bl;
    }

    public void setTmpComputedColumnExpression(String string) {
        this._tmpComputedColumnExpression = string;
    }

    public String getTmpComputedExpression() {
        return this._tmpComputedColumnExpression;
    }

    public boolean getTmpMaterialized() {
        return this._tmpMaterialized;
    }

    public void updateComputedCol() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        if (!this._tmpComputedColumnExpression.equals("") && !this.getComputedColumnExpression().equals(this._tmpComputedColumnExpression)) {
            bl = true;
        }
        if (this.isColumnMaterialized() != this._tmpMaterialized) {
            bl2 = true;
        }
        if (bl || bl2) {
            String string = "";
            if (bl) {
                string = "AS " + this._tmpComputedColumnExpression;
            }
            if (bl2) {
                string = string + (this._tmpMaterialized ? " MATERIALIZED" : " NOT MATERIALIZED");
            }
            Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getName(), string};
            this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} modify {3} {4}", objectArray));
        }
    }

    public void setPermissionLists(boolean bl) throws SQLException {
        SyPermission syPermission;
        String string;
        boolean bl2;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        int n;
        int n2;
        Vector vector;
        int n3;
        String string6;
        int n4 = 0;
        int n5 = 1;
        int n6 = 2;
        int n7 = 3;
        int n8 = 4;
        int n9 = 5;
        int n10 = 6;
        int n11 = 41;
        if (bl) {
            n11 = 169;
        }
        this._userPermissionList = new Vector();
        this._groupPermissionList = new Vector();
        this._grouplistPermissionList = new Vector();
        this._publicPermissionList = new Vector();
        this.getRSet().open(SQLs.getString("select u.name, u.gid  from {0}.dbo.sysusers u, {0}.dbo.sysusers g where u.gid!=u.uid and u.gid=g.uid and u.gid=g.gid order by 1 ", this.getDatabaseName()));
        while (this.getRSet().getNextRow()) {
            string6 = this.getRSet().getColumnString(1);
            n3 = Integer.parseInt(this.getRSet().getColumnString(2));
            vector = Utility.getColsPermission(this._conn, this.getDatabaseName(), this.getTableOwner() + "." + this.getTableName(), string6);
            n2 = 0;
            n = 0;
            bl6 = false;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            for (int i = 0; i < vector.size(); ++i) {
                object = (Vector)vector.elementAt(i);
                string5 = (String)((Vector)object).elementAt(n5);
                string4 = (String)((Vector)object).elementAt(n9);
                string3 = (String)((Vector)object).elementAt(n4);
                string2 = (String)((Vector)object).elementAt(n6);
                bl2 = Boolean.valueOf((String)((Vector)object).elementAt(n10));
                string = (String)((Vector)object).elementAt(n7);
                if (!string4.equals(this.getName()) && !string4.equalsIgnoreCase("all") || !string5.equals(string6)) continue;
                if (string.equals(ACTION_SELECT)) {
                    if (string2.equals("grant")) {
                        n2 |= 1;
                        if (!bl2) continue;
                        n |= 1;
                        continue;
                    }
                    if (!string2.equals("revoke")) continue;
                    bl6 = true;
                    continue;
                }
                if (string.equals(ACTION_UPDATE)) {
                    if (string2.equals("grant")) {
                        n2 |= 8;
                        if (!bl2) continue;
                        n |= 8;
                        continue;
                    }
                    if (!string2.equals("revoke")) continue;
                    bl5 = true;
                    continue;
                }
                if (string.equals(ACTION_REFERENCES)) {
                    if (string2.equals("grant")) {
                        n2 |= 0x20;
                        if (!bl2) continue;
                        n |= 0x20;
                        continue;
                    }
                    if (!string2.equals("revoke")) continue;
                    bl4 = true;
                    continue;
                }
                if (!string.equals(ACTION_DECRYPT)) continue;
                if (string2.equals("grant")) {
                    n2 |= 0x80;
                    if (!bl2) continue;
                    n |= 0x80;
                    continue;
                }
                if (!string2.equals("revoke")) continue;
                bl3 = true;
            }
            syPermission = new UserPermission(n2, true, n);
            ((UserPermission)syPermission).setIdentity(string6, n3);
            syPermission.initializeSelectRevoke(bl6);
            syPermission.initializeUpdateRevoke(bl5);
            syPermission.initializeReferenceRevoke(bl4);
            syPermission.initializeDecryptRevoke(bl3);
            ((UserPermission)syPermission).setChoiceOfCol(n11);
            this._userPermissionList.addElement(syPermission);
        }
        this.getRSet().close();
        this.getRSet().open(SQLs.getString("select u.name, u.gid  from {0}.dbo.sysusers u, {0}.dbo.sysusers g where u.gid=u.uid and u.gid=g.uid and u.gid=g.gid and u.gid not in (select lrid from {0}.dbo.sysroles) order by 1 ", this.getDatabaseName()));
        while (this.getRSet().getNextRow()) {
            string6 = this.getRSet().getColumnString(1);
            n3 = Integer.parseInt(this.getRSet().getColumnString(2));
            vector = Utility.getColsPermission(this._conn, this.getDatabaseName(), this.getTableOwner() + "." + this.getTableName(), string6);
            n2 = 0;
            n = 0;
            bl6 = false;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            for (int i = 0; i < vector.size(); ++i) {
                object = (Vector)vector.elementAt(i);
                string5 = (String)((Vector)object).elementAt(n5);
                string4 = (String)((Vector)object).elementAt(n9);
                string3 = (String)((Vector)object).elementAt(n4);
                string2 = (String)((Vector)object).elementAt(n6);
                bl2 = Boolean.valueOf((String)((Vector)object).elementAt(n10));
                string = (String)((Vector)object).elementAt(n7);
                if (!string4.equals(this.getName()) && !string4.equalsIgnoreCase("all") || !string5.equals(string6)) continue;
                if (string.equals(ACTION_SELECT)) {
                    if (string2.equals("grant")) {
                        n2 |= 1;
                        if (!bl2) continue;
                        n |= 1;
                        continue;
                    }
                    if (!string2.equals("revoke")) continue;
                    bl6 = true;
                    continue;
                }
                if (string.equals(ACTION_UPDATE)) {
                    if (string2.equals("grant")) {
                        n2 |= 8;
                        if (!bl2) continue;
                        n |= 8;
                        continue;
                    }
                    if (!string2.equals("revoke")) continue;
                    bl5 = true;
                    continue;
                }
                if (string.equals(ACTION_REFERENCES)) {
                    if (string2.equals("grant")) {
                        n2 |= 0x20;
                        if (!bl2) continue;
                        n |= 0x20;
                        continue;
                    }
                    if (!string2.equals("revoke")) continue;
                    bl4 = true;
                    continue;
                }
                if (!string.equals(ACTION_DECRYPT)) continue;
                if (string2.equals("grant")) {
                    n2 |= 0x80;
                    if (!bl2) continue;
                    n |= 0x80;
                    continue;
                }
                if (!string2.equals("revoke")) continue;
                bl3 = true;
            }
            syPermission = new GroupPermission(n2, true, n);
            ((GroupPermission)syPermission).setIdentity(string6, n3);
            syPermission.initializeSelectRevoke(bl6);
            syPermission.initializeUpdateRevoke(bl5);
            syPermission.initializeReferenceRevoke(bl4);
            syPermission.initializeDecryptRevoke(bl3);
            ((GroupPermission)syPermission).setChoiceOfCol(n11);
            this._groupPermissionList.addElement(syPermission);
            object = new GroupPermission(n2, true, n);
            ((GroupPermission)object).setIdentity(string6, n3);
            ((SyPermission)object).initializeSelectRevoke(bl6);
            ((SyPermission)object).initializeUpdateRevoke(bl5);
            ((SyPermission)object).initializeReferenceRevoke(bl4);
            ((SyPermission)object).initializeDecryptRevoke(bl3);
            ((GroupPermission)object).setChoiceOfCol(n11);
            this._grouplistPermissionList.addElement(object);
        }
        this.getRSet().close();
        string6 = "public";
        n3 = Integer.parseInt(this.getTableObjectID());
        vector = Utility.getColsPermission(this._conn, this.getDatabaseName(), this.getTableOwner() + "." + this.getTableName(), string6);
        n2 = 0;
        n = 0;
        bl6 = false;
        bl5 = false;
        bl4 = false;
        bl3 = false;
        for (int i = 0; i < vector.size(); ++i) {
            object = (Vector)vector.elementAt(i);
            string5 = (String)((Vector)object).elementAt(n5);
            string4 = (String)((Vector)object).elementAt(n9);
            string3 = (String)((Vector)object).elementAt(n4);
            string2 = (String)((Vector)object).elementAt(n6);
            bl2 = Boolean.valueOf((String)((Vector)object).elementAt(n10));
            string = (String)((Vector)object).elementAt(n7);
            if (!string4.equals(this.getName()) && !string4.equalsIgnoreCase("all")) continue;
            if (string5.equals(string6)) {
                if (string.equals(ACTION_SELECT)) {
                    if (string2.equals("grant")) {
                        n2 |= 1;
                        if (bl2) {
                            n |= 1;
                        }
                    } else if (string2.equals("revoke")) {
                        bl6 = true;
                    }
                } else if (string.equals(ACTION_UPDATE)) {
                    if (string2.equals("grant")) {
                        n2 |= 8;
                        if (bl2) {
                            n |= 8;
                        }
                    } else if (string2.equals("revoke")) {
                        bl5 = true;
                    }
                } else if (string.equals(ACTION_REFERENCES)) {
                    if (string2.equals("grant")) {
                        n2 |= 0x20;
                        if (bl2) {
                            n |= 0x20;
                        }
                    } else if (string2.equals("revoke")) {
                        bl4 = true;
                    }
                } else if (string.equals(ACTION_DECRYPT)) {
                    if (string2.equals("grant")) {
                        n2 |= 0x80;
                        if (bl2) {
                            n |= 0x80;
                        }
                    } else if (string2.equals("revoke")) {
                        bl3 = true;
                    }
                }
            }
            if (!string5.equals("public")) continue;
            if (string.equals(ACTION_SELECT)) {
                if (string2.equals("grant")) {
                    n2 |= 1;
                    if (!bl2) continue;
                    n |= 1;
                    continue;
                }
                if (!string2.equals("revoke")) continue;
                bl6 = true;
                continue;
            }
            if (string.equals(ACTION_UPDATE)) {
                if (string2.equals("grant")) {
                    n2 |= 8;
                    if (!bl2) continue;
                    n |= 8;
                    continue;
                }
                if (!string2.equals("revoke")) continue;
                bl5 = true;
                continue;
            }
            if (string.equals(ACTION_REFERENCES)) {
                if (string2.equals("grant")) {
                    n2 |= 0x20;
                    if (!bl2) continue;
                    n |= 0x20;
                    continue;
                }
                if (!string2.equals("revoke")) continue;
                bl4 = true;
                continue;
            }
            if (!string.equals(ACTION_DECRYPT)) continue;
            if (string2.equals("grant")) {
                n2 |= 0x80;
                if (!bl2) continue;
                n |= 0x80;
                continue;
            }
            if (!string2.equals("revoke")) continue;
            bl3 = true;
        }
        PublicPermission publicPermission = new PublicPermission(n2, true, n);
        publicPermission.setIdentity(string6, n3);
        publicPermission.initializeSelectRevoke(bl6);
        publicPermission.initializeUpdateRevoke(bl5);
        publicPermission.initializeReferenceRevoke(bl4);
        publicPermission.initializeDeleteRevoke(bl3);
        this._publicPermissionList.addElement(publicPermission);
        this.getRSet().close();
    }

    public void setRolePermissionLists(boolean bl) throws SQLException {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        int n7 = 6;
        int n8 = 41;
        if (bl) {
            n8 = 169;
        }
        this._rolePermissionList = new Vector();
        for (Object e : Utility.getRoleInServer(this.getConnection())) {
            String string = e.toString();
            this.getRSet().open(SQLs.getString("select ''{0}'', role_id(''{0}'')", string));
            while (this.getRSet().getNextRow()) {
                String string2 = this.getRSet().getColumnString(1);
                int n9 = Integer.parseInt(this.getRSet().getColumnString(2));
                Vector vector = Utility.getColsPermission(this._conn, this.getDatabaseName(), this.getTableOwner() + "." + this.getTableName(), string2);
                int n10 = 0;
                int n11 = 0;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = (Vector)vector.elementAt(i);
                    String string3 = (String)vector2.elementAt(n2);
                    String string4 = (String)vector2.elementAt(n6);
                    String string5 = (String)vector2.elementAt(n);
                    String string6 = (String)vector2.elementAt(n3);
                    boolean bl6 = Boolean.valueOf((String)vector2.elementAt(n7));
                    String string7 = (String)vector2.elementAt(n4);
                    if (!string4.equals(this.getName()) && !string4.equalsIgnoreCase("all") || !string3.equals(string2)) continue;
                    if (string7.equals(ACTION_SELECT)) {
                        if (string6.equals("grant")) {
                            n10 |= 1;
                            if (!bl6) continue;
                            n11 |= 1;
                            continue;
                        }
                        if (!string6.equals("revoke")) continue;
                        bl2 = true;
                        continue;
                    }
                    if (string7.equals(ACTION_UPDATE)) {
                        if (string6.equals("grant")) {
                            n10 |= 8;
                            if (!bl6) continue;
                            n11 |= 8;
                            continue;
                        }
                        if (!string6.equals("revoke")) continue;
                        bl3 = true;
                        continue;
                    }
                    if (string7.equals(ACTION_REFERENCES)) {
                        if (string6.equals("grant")) {
                            n10 |= 0x20;
                            if (!bl6) continue;
                            n11 |= 0x20;
                            continue;
                        }
                        if (!string6.equals("revoke")) continue;
                        bl4 = true;
                        continue;
                    }
                    if (!string7.equals(ACTION_DECRYPT)) continue;
                    if (string6.equals("grant")) {
                        n10 |= 0x80;
                        if (!bl6) continue;
                        n11 |= 0x80;
                        continue;
                    }
                    if (!string6.equals("revoke")) continue;
                    bl5 = true;
                }
                RolePermission rolePermission = new RolePermission(n10, true, n11);
                rolePermission.setIdentity(string2, n9);
                rolePermission.initializeSelectRevoke(bl2);
                rolePermission.initializeUpdateRevoke(bl3);
                rolePermission.initializeReferenceRevoke(bl4);
                rolePermission.initializeDecryptRevoke(bl5);
                rolePermission.setChoiceOfCol(n8);
                this._rolePermissionList.addElement(rolePermission);
            }
            this.getRSet().close();
        }
    }

    public Vector getUserPermissionList() {
        return this._userPermissionList;
    }

    public Vector getGroupPermissionList() {
        return this._groupPermissionList;
    }

    public Vector getRolePermissionList() {
        return this._rolePermissionList;
    }

    public Vector getGroupListPermissionList() {
        return this._grouplistPermissionList;
    }

    public Vector getPublicPermissionList() {
        return this._publicPermissionList;
    }

    public void setDecryptDefault() throws SQLException {
        String string = "";
        this.getRSet().open(SQLs.getString("select object from {0}..sysattributes where class=25 and attribute=1 and object_info1={1} and object_info2={2}", this.getDatabaseName(), this.getTableObjectID(), this.getID()));
        while (this.getRSet().getNextRow()) {
            string = this.getRSet().getColumnString(1);
        }
        this.getRSet().close();
        if (!string.equals("")) {
            this._tmpDecryptDefault = true;
            this._bDecryptDefault = true;
            this.getRSet().open(SQLs.getString("select text from {0}.dbo.syscomments where id = {1}", this.getDatabaseName(), string));
            while (this.getRSet().getNextRow()) {
                this._tmpDecryptDefaultText = this.getRSet().getColumnString(1);
                this._sDecryptDefaultText = this._tmpDecryptDefaultText = this._tmpDecryptDefaultText.replaceAll("DECRYPT DEFAULT  ", "");
            }
            this.getRSet().close();
        }
    }

    public void alterDecryptDefault(boolean bl, String string) throws SQLException {
        Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getTmpColumnName()};
        if (!bl) {
            String string2 = SQLs.getString("alter table {0}.{1}.{2} replace {3} drop decrypt_default", objectArray);
            this._conn.executeCommand(string2);
        } else {
            String string3 = SQLs.getString("alter table {0}.{1}.{2} replace {3} decrypt_default", objectArray);
            this._conn.executeCommand(string3 + " " + string.trim());
        }
    }

    public boolean isDecryptDefaultApplicable() {
        return KeySO.getPhase(this.getConnection()) == 2.0f || this.getConnection().getVersion().compareTo("12.5.4") >= 0 && this.getConnection().isESD(5) && this.getConnection().getVersion().compareTo("15.0") < 0;
    }

    private void setEncryptionKeysList() throws SQLException {
        Object object;
        Object object2;
        if (this._eks == null) {
            this._eks = new TreeMap();
            DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
            object2 = databasesCtrSO.getNormalDBList(1);
            object = object2.iterator();
            while (object.hasNext()) {
                Object object3;
                DatabaseSO databaseSO = (DatabaseSO)object.next();
                try {
                    String string = SQLs.getString("select o.name, u.name, o.id, o.crdate from {0}.dbo.sysobjects o, {0}.dbo.sysusers u where u.uid = o.uid and o.type=''EK''", databaseSO.getName());
                    this.getRSet().open(string);
                    while (this.getRSet().getNextRow()) {
                        object3 = databaseSO.getName() + "." + this.getRSet().getColumnString(2) + "." + this.getRSet().getColumnString(1);
                        this._eks.put(databaseSO.getName() + this.getRSet().getColumnString(3), object3);
                    }
                    this.getRSet().close();
                    this.getRSet().open("select u.name+'.'+o.name from sysobjects o, sysencryptkeys k, sysusers u where ((k.type & 4)>0) and o.id=k.id and u.uid=o.uid");
                    if (this.getRSet().getNextRow()) {
                        this._hasDefaultKey = true;
                    }
                    this.getRSet().close();
                }
                catch (SQLException sQLException) {
                    try {
                        this.useDB(databaseSO.getName());
                        this.getRSet().open("exec sp_encryption help");
                        object3 = new Vector<String>();
                        Vector<String> vector = new Vector<String>();
                        if (this.getRSet().getNextRow()) {
                            String string;
                            String string2;
                            vector.add(this.getRSet().getColumnString(1));
                            ((Vector)object3).add(databaseSO.getName() + "." + this.getRSet().getColumnString(2) + "." + this.getRSet().getColumnString(1));
                            this._hasDefaultKey = this.getRSet().getColumnCount() > 3 ? (string2 = this.getRSet().getColumnString(8)).indexOf("default") > 0 : (string = this.getRSet().getColumnString(3)).indexOf("default") > 0;
                        }
                        this.getRSet().close();
                        for (int i = 0; i < vector.size(); ++i) {
                            String string = SQLs.getString("select id, crdate from {0}..sysobjects where name=''{1}''", databaseSO.getName(), vector.elementAt(i));
                            this.getRSet().open(string);
                            while (this.getRSet().getNextRow()) {
                                this._eks.put(databaseSO.getName() + this.getRSet().getColumnString(1), ((Vector)object3).elementAt(i));
                            }
                            this.getRSet().close();
                        }
                    }
                    catch (SQLException sQLException2) {}
                }
            }
        }
        try {
            this.setEncryptionKey();
        }
        catch (SQLException sQLException) {
            object2 = "select status2 from {0}.dbo.syscolumns where id={1} and colid={2}";
            this.getRSet().open(SQLs.getString((String)object2, this.getDatabaseName(), this.getTableObjectID(), this.getColID()));
            while (this.getRSet().getNextRow()) {
                object = this.getRSet().getColumnString(1);
                if (object == null || ((String)object).length() == 0) {
                    this._bEncrypt = false;
                    this._tmpEncrypt = false;
                    continue;
                }
                if ((Integer.parseInt((String)object) & 0x80) <= 0) continue;
                this._bEncrypt = true;
                this._tmpEncrypt = true;
            }
        }
    }

    public Collection getEncryptionKeysList() throws SQLException {
        this.setEncryptionKeysList();
        return this._eks.values();
    }

    public void setEncryptionKey() throws SQLException {
        String string = "select column_ek=C.encrkeyid, encrkeydb from {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X where C.id = {1} and C.usertype *= T.usertype and C.xtype *= X.xtid and C.name like ''{2}'' ";
        this.getRSet().open(SQLs.getString(string, this._tableSO.getDatabaseName(), this._tableSO.getTableObjectID(), this.getName(), new Integer(1)));
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1);
            String string3 = this.getRSet().getColumnString(2);
            string3 = string3 == null || string3.length() == 0 ? this.getDatabaseName() : string3;
            this._tmpEncrypt = this._bEncrypt = string2 != null && string2.length() > 0;
            this._sKey = (String)this._eks.get(string3 + string2);
        }
        this._sKey = this._sKey != null ? this._sKey : this.defaultKey;
        this._tmpKey = ASEUtils.encryptPassword(this._sKey);
    }

    public void alterEncryptionKey(boolean bl, boolean bl2, String string) throws SQLException {
        Object[] objectArray = new String[]{this.getDatabaseName(), this.getTableOwner(), this.getTableName(), this.getTmpColumnName()};
        this.useDB();
        if (!bl) {
            this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} modify {3} decrypt", objectArray));
        } else if (!bl2) {
            this._conn.executeCommand(SQLs.getString("alter table {0}.{1}.{2} modify {3} encrypt", objectArray));
        } else {
            String string2 = SQLs.getString("alter table {0}.{1}.{2} modify {3} encrypt", objectArray);
            string2 = string2 + " with " + string;
            this._conn.executeCommand(string2);
        }
    }

    public boolean getEncrypt() {
        return this._bEncrypt;
    }

    public String IsEncrypted() {
        return this.getEncrypt() ? ASEUtils.getString("MSG_YES") : ASEUtils.getString("MSG_NO");
    }

    public boolean getTmpEncrypt() {
        return this._tmpEncrypt;
    }

    public void setTmpEncrypt(boolean bl) {
        this._tmpEncrypt = bl;
    }

    public boolean getTmpDecryptDefault() {
        return this._tmpDecryptDefault;
    }

    public boolean getDecryptDefault() {
        return this._bDecryptDefault;
    }

    public void setTmpDecryptDefault(boolean bl) {
        this._tmpDecryptDefault = bl;
    }

    public String getTmpDecryptDefaultText() {
        return this._tmpDecryptDefaultText;
    }

    public void setTmpDecryptDefaultText(String string) {
        this._tmpDecryptDefaultText = string;
    }

    public String getDecryptDefaultText() {
        return this._sDecryptDefaultText;
    }

    public String getKey() {
        return this._sKey;
    }

    public String getTmpKey() {
        return ASEUtils.decryptPassword(this._tmpKey);
    }

    public void setTmpKey(String string) {
        this._tmpKey = ASEUtils.encryptPassword(string);
    }

    public void setHasDefaultKey(boolean bl) {
        this._hasDefaultKey = bl;
    }

    public boolean isPlainKey(String string) {
        if (string.equals(this.defaultKey)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        try {
            this.useDB(string2);
            String string3 = "exec sp_encryption help, '" + string + "'";
            this.getRSet().open(string3);
            while (this.getRSet().getNextRow()) {
                if (this.getRSet().getColumnInt("Initialization Vector") != 0 || this.getRSet().getColumnInt("Pad") != 0) continue;
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }
}

