/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ASEProvider;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import com.sybase.util.ds.DirectoryServiceHelper;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class ConfigSSLSO
extends ASEBaseItemSO {
    public static final int rootSelfSigned = 0;
    public static final int root3rdParty = 1;
    public static final int full3rdParty = 2;
    public static final int clearUpSSL = 3;
    private int _rootCertType;
    private SSLCertificate _rootCertificate = new SSLCertificate();
    private SSLCertificate _serverCertificate = new SSLCertificate();
    private boolean _shutdownServer;
    private boolean _addAdditionalSSLPort;
    private String _sslPortNumber;
    private String _passwordForKeystore;
    public static String sybPath = null;
    public static String sybASEName = null;
    public static String sybOCSName = null;
    public static String sybJREName = null;
    public static String rootCertDirName = null;
    public static String rootCertPath = null;
    public static String serverCertPath = null;
    public static String certUtilsPath = null;
    public static String certreqFullPath = null;
    public static String certauthFullPath = null;
    public String rootInputFileName = null;
    public String rootRequestFileName = null;
    public String rootPrivateKeyFileName = null;
    public String rootCAFileName = null;
    public String rootCertificateFileName = null;
    public String serverInputFileName = null;
    public String serverRequestFileName = null;
    public String serverPrivateKeyFileName = null;
    public String serverOutputFileName = null;
    public String serverCertificateFileName = null;
    public String serverDSQueryCertificateFileName = null;
    public static String certificates = "certificates";
    public static String certreq = "certreq";
    public static String certauth = "certauth";
    public static String keytool = "keytool";
    public static final String DSA = "DSA";
    public static final String RSA = "RSA";
    private final String CERTAUTH_SUCCESS = "3000";
    public String interfacesPath = null;
    private List _servicesWithSameIP = null;

    public ConfigSSLSO(ASConnection aSConnection, String string, ServerSO serverSO) {
        super(aSConnection, string, serverSO);
        this._init();
    }

    private void _init() {
        sybPath = ASEProvider.getSybasePath();
        if (sybPath == null) {
            sybPath = "";
        }
        sybASEName = Utils.getEnVariable((String)"SYBASE_ASE");
        String string = this.getConnection().getVersion();
        if (sybASEName == null) {
            sybASEName = string.compareTo("15") >= 0 ? "ASE-15_0" : "ASE-12_5";
            this.checkNoEnv("SYBASE_ASE", true);
        }
        if ((sybOCSName = Utils.getEnVariable((String)"SYBASE_OCS")) == null) {
            sybOCSName = string.compareTo("15") >= 0 ? "OCS-15_0" : "OCS-12_5";
            this.checkNoEnv("SYBASE_OCS", true);
        }
        if ((sybJREName = Utils.getEnVariable((String)"SYBASE_JRE6")) == null) {
            sybJREName = "";
            this.checkNoEnv("SYBASE_JRE6", false);
        }
        rootCertDirName = ASEUtils.OS_WINDOWS ? "ini" : "config";
        rootCertPath = sybPath + File.separator + rootCertDirName + File.separator;
        serverCertPath = sybPath + File.separator + sybASEName + File.separator + certificates + File.separator;
        certUtilsPath = sybPath + File.separator + sybOCSName + File.separator;
        certreqFullPath = certUtilsPath + "bin" + File.separator + certreq;
        certauthFullPath = certUtilsPath + "bin" + File.separator + certauth;
        String string2 = sybPath + File.separator + "interfaces";
        String string3 = sybPath + File.separator + "ini" + File.separator + "sql.ini";
        this.interfacesPath = ASEUtils.OS_WINDOWS ? string3 : string2;
        String string4 = this.getConnection().getServerName();
        this.rootInputFileName = serverCertPath + string4 + "_TRC.req_input";
        this.rootRequestFileName = serverCertPath + string4 + "_TRC.req";
        this.rootPrivateKeyFileName = serverCertPath + string4 + "_TRC.prk";
        this.rootCAFileName = serverCertPath + string4 + "_TRC.txt";
        this.rootCertificateFileName = rootCertPath + "trusted.txt";
        this.serverInputFileName = serverCertPath + string4 + ".req_input";
        this.serverRequestFileName = serverCertPath + string4 + ".req";
        this.serverPrivateKeyFileName = serverCertPath + string4 + ".prk";
        this.serverOutputFileName = serverCertPath + string4 + "_req.txt";
        this.serverCertificateFileName = serverCertPath + string4 + ".crt";
        this.serverDSQueryCertificateFileName = serverCertPath + string4 + ".txt";
        this.initSameIPServicesInInterfaces();
    }

    private void checkNoEnv(String string, boolean bl) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERR_ENV_VARIABLE_NOT_DEFINED"), string);
        if (bl) {
            Support.showWarning(this.getConnection(), this.getClass(), aSEMessageText.toString());
        } else {
            Support.showError(this.getConnection(), this.getClass(), aSEMessageText.toString());
        }
    }

    private void initSameIPServicesInInterfaces() {
        this._servicesWithSameIP = new Vector();
        try {
            DirectoryServiceHelper directoryServiceHelper = new DirectoryServiceHelper(true, false);
            SyInterfacesDriver syInterfacesDriver = directoryServiceHelper.getInterfacesDriver(Boolean.FALSE);
            String[] stringArray = syInterfacesDriver.getSubjects();
            String string = Utils.getIP((String)this.getConnection().getHostName());
            for (int i = 0; i < stringArray.length; ++i) {
                Service service;
                String string2;
                List list = syInterfacesDriver.getServices(stringArray[i]);
                Object[] objectArray = list.toArray();
                for (int j = 0; j < objectArray.length && ASConnection.isServerLocal(string2 = (service = (Service)objectArray[j]).getHost()); ++j) {
                    this._servicesWithSameIP.add(service);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPortNumberDuplicated(String string) {
        Object[] objectArray = this._servicesWithSameIP.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Service service = (Service)objectArray[i];
            if (!service.getPort().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean removeConfigurations() throws SQLException {
        this.enableSSL(false);
        if (this.hasExistingCertificate()) {
            this.dropCertificates();
        }
        return this.removeSSLFilter();
    }

    public void enableSSL(boolean bl) throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_configure ''enable ssl'', {0}", bl ? 1 : 0);
        this._conn.executeCommand(string);
    }

    public String getExistingCertificate() throws SQLException {
        this.useMasterDB();
        String string = "exec sp_ssladmin 'lscert'";
        this.getRSet().open(string);
        String string2 = "";
        if (this.getRSet().getNextRow()) {
            string2 = this.getRSet().getColumnString(1);
        }
        return string2;
    }

    public boolean hasExistingCertificate() throws SQLException {
        return this.getExistingCertificate().length() > 0;
    }

    public void addCertificate() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_ssladmin ''addcert'', ''{0}'', ''{1}''", this.serverCertificateFileName, this._serverCertificate.getPassword());
        this._conn.executeCommand(string);
    }

    public void dropCertificates() throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("exec sp_ssladmin ''dropcert'', ''{0}''", this.getExistingCertificate());
        this._conn.executeCommand(string);
    }

    public boolean modifyInterfaces() {
        String string = this.getConnection().getPortNumber();
        String string2 = this._sslPortNumber;
        boolean bl = string.equals(string2);
        try {
            SyInterfacesDriver syInterfacesDriver = new SyInterfacesDriver(this.interfacesPath);
            String string3 = this.getConnection().getServerName();
            Vector vector = (Vector)syInterfacesDriver.getServices(string3);
            if (vector == null) {
                String string4 = this._conn.getHostName();
                String string5 = "TCP";
                Service service = new Service("master", string5, string4, string);
                service.setFilter("");
                Service service2 = new Service("master", service.getValue());
                Service service3 = new Service(1, service.getValue());
                syInterfacesDriver.setValue(string3, service2);
                syInterfacesDriver.setValue(string3, service3);
                if (!bl) {
                    service.setFilter("ssl");
                    Service service4 = new Service(0, service.getValue());
                    service4.setPort(string2);
                    Service service5 = new Service(1, service.getValue());
                    service5.setPort(string2);
                    syInterfacesDriver.setValue(string3, service4);
                    syInterfacesDriver.setValue(string3, service5);
                }
                syInterfacesDriver.saveFile();
            } else {
                if (bl) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Service service = (Service)vector.get(i);
                        String string6 = service.getPort();
                        if (string6 != null && string6.equals(string)) {
                            service.setFilter("ssl");
                            syInterfacesDriver.setLine(string3, service);
                            continue;
                        }
                        if (!service.isSSL()) continue;
                        service.setFilter("");
                        syInterfacesDriver.setLine(string3, service);
                    }
                } else {
                    Service service = null;
                    for (int i = 0; i < vector.size(); ++i) {
                        service = (Service)vector.get(i);
                        if (!service.isSSL()) continue;
                        service.setFilter("");
                        syInterfacesDriver.setLine(string3, service);
                    }
                    service.setFilter("");
                    Service service6 = new Service(0, service.getValue());
                    service6.setFilter("ssl");
                    service6.setPort(string2);
                    Service service7 = new Service(1, service.getValue());
                    service7.setFilter("ssl");
                    service7.setPort(string2);
                    syInterfacesDriver.setValue(string3, service6);
                    syInterfacesDriver.setValue(string3, service7);
                }
                syInterfacesDriver.saveFile();
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private boolean removeSSLFilter() {
        try {
            SyInterfacesDriver syInterfacesDriver = new SyInterfacesDriver(this.interfacesPath);
            String string = this.getConnection().getServerName();
            Vector vector = (Vector)syInterfacesDriver.getServices(string);
            Service service = null;
            for (int i = 0; i < vector.size(); ++i) {
                service = (Service)vector.get(i);
                if (service == null) continue;
                service.setFilter("");
                syInterfacesDriver.setLine(string, service);
            }
            syInterfacesDriver.saveFile();
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName()};
    }

    public void setRootCertType(int n) {
        this._rootCertType = n;
    }

    public int getRootCertType() {
        return this._rootCertType;
    }

    public void setShutdownServer(boolean bl) {
        this._shutdownServer = bl;
    }

    public boolean getShutdownServer() {
        return this._shutdownServer;
    }

    public void setAddAdditionalSSLPort(boolean bl) {
        this._addAdditionalSSLPort = bl;
    }

    public boolean getAddAdditionalSSLPort() {
        return this._addAdditionalSSLPort;
    }

    public void setSSLPort(String string) {
        this._sslPortNumber = string;
    }

    public String getSSLPort() {
        return this._sslPortNumber;
    }

    public SSLCertificate getRootCertificate() {
        return this._rootCertificate;
    }

    public SSLCertificate getServerCertificate() {
        return this._serverCertificate;
    }

    public void setRootCertificate(SSLCertificate sSLCertificate) {
        this._rootCertificate = sSLCertificate;
    }

    public String getPasswordForKeystore() {
        return ASEUtils.decryptPassword(this._passwordForKeystore);
    }

    public void setPasswordForKeystore(String string) {
        this._passwordForKeystore = ASEUtils.encryptPassword(string);
    }

    private boolean createRequestInputFile(boolean bl) {
        try {
            if (!this.hasCertificatePath() && !this.createCertificatePath()) {
                return false;
            }
            SSLCertificate sSLCertificate = bl ? this._rootCertificate : this._serverCertificate;
            String string = bl ? this.rootInputFileName : this.serverInputFileName;
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            Vector<String> vector = new Vector<String>();
            vector.add("req_certtype=server");
            vector.add("req_keytype=" + sSLCertificate.getKeyType());
            vector.add("req_keylength=" + sSLCertificate.getKeyLength());
            vector.add("req_country=" + sSLCertificate.getCountry());
            vector.add("req_state=" + sSLCertificate.getState());
            vector.add("req_locality=" + sSLCertificate.getLocality());
            vector.add("req_organization=" + sSLCertificate.getOrganization());
            vector.add("req_orgunit=" + sSLCertificate.getOrgUnit());
            vector.add("req_commonname=" + sSLCertificate.getCommonName());
            this.writeFile(dataOutputStream, vector);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public boolean creatRootCertificate() {
        String[] stringArray = null;
        try {
            if (!this.createRequestInputFile(true)) {
                return false;
            }
            String[] stringArray2 = new String[]{certreqFullPath, "-F", this.rootInputFileName, "-R", this.rootRequestFileName, "-K", this.rootPrivateKeyFileName, "-P", this._rootCertificate.getPassword()};
            ASEUtils.execProcess(stringArray2, null);
            String[] stringArray3 = new String[]{certauthFullPath, "-r", "-C", this.rootRequestFileName, "-Q", this.rootRequestFileName, "-K", this.rootPrivateKeyFileName, "-P", this._rootCertificate.getPassword(), "-O", this.rootCAFileName};
            stringArray = ASEUtils.execProcess(stringArray3, null);
            if (stringArray[1] != null && stringArray[1].length() > 0 && stringArray[1].indexOf("3000") == -1) {
                Support.showError(this.getConnection(), this.getClass(), stringArray[1]);
                return false;
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public boolean createServerCertificate() {
        String[] stringArray = null;
        try {
            if (!this.createRequestInputFile(false)) {
                return false;
            }
            String[] stringArray2 = new String[]{certreqFullPath, "-F", this.serverInputFileName, "-R", this.serverRequestFileName, "-K", this.serverPrivateKeyFileName, "-P", this._serverCertificate.getPassword()};
            ASEUtils.execProcess(stringArray2, null);
            String[] stringArray3 = new String[]{certauthFullPath, "-C", this.rootCAFileName, "-Q", this.serverRequestFileName, "-K", this.rootPrivateKeyFileName, "-P", this._rootCertificate.getPassword(), "-O", this.serverOutputFileName};
            stringArray = ASEUtils.execProcess(stringArray3, null);
            if (stringArray[1] != null && stringArray[1].length() > 0 && stringArray[1].indexOf("3000") == -1) {
                Support.showError(this.getConnection(), this.getClass(), stringArray[1]);
                return false;
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public boolean makeCertificates() {
        String[] stringArray = new String[]{this.serverOutputFileName, this.serverPrivateKeyFileName};
        try {
            if (!this.copyFile(stringArray, this.serverCertificateFileName, false)) {
                return false;
            }
            if (!this.copyFile(new String[]{this.rootCAFileName}, this.rootCertificateFileName, true)) {
                return false;
            }
            if (!this.copyFile(new String[]{this.rootCAFileName}, this.serverDSQueryCertificateFileName, false)) {
                return false;
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public String importKeyStore() throws IOException {
        if (sybJREName == "") {
            this.checkNoEnv("SYBASE_JRE", false);
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(sybJREName);
        stringBuffer.append(File.separator).append("bin").append(File.separator).append(keytool);
        String string = stringBuffer.toString();
        Date date = new Date();
        String string2 = String.valueOf(date.getTime());
        String[] stringArray = new String[]{string, "-import", "-noprompt", "-alias", string2, "-storepass", this.getPasswordForKeystore(), "-file", this.serverDSQueryCertificateFileName};
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray);
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = ASEUtils.handleProcess(process, stringBuffer2, stringBuffer3);
        String string3 = stringBuffer3.toString();
        String string4 = stringBuffer2.toString();
        if (n != 0 && string4.length() > 0) {
            throw new IOException(string4);
        }
        if (n == 0 && (string4.length() > 0 || string3.length() > 0)) {
            return (string4.length() == 0 ? "" : string4 + " ") + string3;
        }
        return "";
    }

    public boolean writeFile(DataOutputStream dataOutputStream, Vector vector) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            if (this.writeLine(dataOutputStream, (String)vector.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean writeLine(DataOutputStream dataOutputStream, String string) throws IOException {
        if (dataOutputStream == null) {
            return false;
        }
        dataOutputStream.writeBytes(string + "\n");
        return true;
    }

    public boolean deleteTemporaryFiles() {
        boolean bl = this.deleteTemporaryFile(this.rootInputFileName);
        boolean bl2 = bl = bl && this.deleteTemporaryFile(this.rootRequestFileName);
        if (this.getRootCertType() == 0) {
            bl = bl && this.deleteTemporaryFile(this.rootPrivateKeyFileName);
            bl = bl && this.deleteTemporaryFile(this.rootCAFileName);
        }
        bl = bl && this.deleteTemporaryFile(this.serverInputFileName);
        boolean bl3 = bl = bl && this.deleteTemporaryFile(this.serverRequestFileName);
        if (this.getRootCertType() == 0 || this.getRootCertType() == 1) {
            bl = bl && this.deleteTemporaryFile(this.serverPrivateKeyFileName);
            bl = bl && this.deleteTemporaryFile(this.serverOutputFileName);
        }
        return bl;
    }

    private boolean deleteTemporaryFile(String string) {
        if (!ASEUtils.isExistingFile(string)) {
            return true;
        }
        return ASEUtils.deleteFile(string);
    }

    public boolean copyFile(String[] stringArray, String string, boolean bl) {
        try {
            FileWriter fileWriter = new FileWriter(string, bl);
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                FileReader fileReader = new FileReader(stringArray[i]);
                while ((n = fileReader.read()) != -1) {
                    fileWriter.write(n);
                }
                fileReader.close();
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            Support.showDetailsError(this.getConnection(), this.getClass(), iOException.getMessage(), iOException);
            return false;
        }
        return true;
    }

    private boolean hasCertificatePath() {
        return ASEUtils.isExistingDirectory(serverCertPath);
    }

    private boolean createCertificatePath() {
        return ASEUtils.createDirectory(serverCertPath);
    }

    public boolean hasSSLConfiguration() throws SQLException {
        String string = "enable ssl";
        boolean bl = this.getConnection().getSPConfigConfigValue(string) == 1 || this.hasExistingCertificate() || this.hasExistingSSLFilter();
        return bl;
    }

    public boolean hasExistingSSLFilter() {
        try {
            SyInterfacesDriver syInterfacesDriver = new SyInterfacesDriver(this.interfacesPath);
            String string = this.getConnection().getServerName();
            Vector vector = (Vector)syInterfacesDriver.getServices(string);
            if (vector == null) {
                return false;
            }
            Service service = null;
            for (int i = 0; i < vector.size(); ++i) {
                service = (Service)vector.get(i);
                if (!service.isSSL()) continue;
                return true;
            }
        }
        catch (Exception exception) {
            Support.showDetailsError(this.getConnection(), this.getClass(), exception.getMessage(), exception);
            return false;
        }
        return false;
    }

    public static class SSLCertificate {
        private String _keyType = null;
        private String _keyLength = null;
        private String _country = null;
        private String _state = null;
        private String _locality = null;
        private String _organization = null;
        private String _orgUnit = null;
        private String _commonName = null;
        private String _password = null;

        public void setKeyType(String string) {
            this._keyType = string;
        }

        public String getKeyType() {
            return this._keyType;
        }

        public void setKeyLength(String string) {
            this._keyLength = string;
        }

        public String getKeyLength() {
            return this._keyLength;
        }

        public void setCountry(String string) {
            this._country = string;
        }

        public String getCountry() {
            return this._country;
        }

        public void setState(String string) {
            this._state = string;
        }

        public String getState() {
            return this._state;
        }

        public void setLocality(String string) {
            this._locality = string;
        }

        public String getLocality() {
            return this._locality;
        }

        public void setOrganization(String string) {
            this._organization = string;
        }

        public String getOrganization() {
            return this._organization;
        }

        public void setOrgUnit(String string) {
            this._orgUnit = string;
        }

        public String getOrgUnit() {
            return this._orgUnit;
        }

        public void setCommonName(String string) {
            this._commonName = string;
        }

        public String getCommonName() {
            return this._commonName;
        }

        public void setPassword(String string) {
            this._password = ASEUtils.encryptPassword(string);
        }

        public String getPassword() {
            return ASEUtils.decryptPassword(this._password);
        }
    }
}

