/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.so.PublicationSO;
import com.sybase.aseplugin.so.ReplicationSO;
import com.sybase.aseplugin.so.ReplicationStatusSO;
import com.sybase.aseplugin.so.SubscriptionSO;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.RLSQLResourceBundle;
import com.sybase.aseplugin.util.Debug;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ConnectionSO
extends ReplicationStatusSO {
    ReplicationSO _repSO = null;
    protected String _DS = null;
    protected String _DB = null;
    protected String _connType;
    protected String _lastCommitTable = null;
    protected String _maintUser = null;
    protected String _logLocator = null;

    public ConnectionSO(ASConnection aSConnection, String string, ReplicationSO replicationSO) {
        super(aSConnection);
        this._repSO = replicationSO;
        Debug.wassert(aSConnection != null, this, "Null network connection parameter");
    }

    public ReplicationSO getReplicationSO() {
        return this._repSO;
    }

    public synchronized String getDDB() {
        return this._repSO.getDDB();
    }

    public static String formatName(String string, String string2) {
        Debug.wassert(string != null && string.length() > 0, "Invalid data server name");
        Debug.wassert(string2 != null && string2.length() > 0, "Invalid database name");
        return string + "." + string2;
    }

    @Override
    public String getDisplayName() {
        return this.getServer() + "." + this.getDatabase();
    }

    public String getLongName() {
        return this.getConnectionType() + "." + this.getServer() + "." + this.getDatabase();
    }

    public void load(ASResultSet aSResultSet) throws SQLException {
        Debug.wassert(aSResultSet != null, this, "Null result set");
        this._connType = aSResultSet.getColumnString(1);
        if (!this.isPrimary() && !this.isReplicate()) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_CONN_TYPE_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._DS = aSResultSet.getColumnString(2);
        this._DB = aSResultSet.getColumnString(3);
        if (this._DS == null || this._DS.length() == 0 || this._DB == null || this._DB.length() == 0) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_CONN_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this._lastCommitTable = aSResultSet.getColumnString(5);
        this._maintUser = aSResultSet.getColumnString(4);
        this._logLocator = aSResultSet.getColumnString(6);
        int n = aSResultSet.getColumnInt(7);
        if (n != 1 && n != 0 && n != -1 && n != 3) {
            String string = ASEUtils.getString("ERR_INVALID_SQL_SUB_STATUS_FLD");
            SQLException sQLException = new SQLException(string);
            throw sQLException;
        }
        this.setState(n);
        this.setReasonCode(aSResultSet.getColumnString(8));
    }

    @Override
    public void create() throws SQLException {
        String string = this.getServer();
        Debug.wassert(string != null && string.length() > 0, this, "Server name is null or blank");
        String string2 = this.getDatabase();
        Debug.wassert(string2 != null && string2.length() > 0, this, "Database name is null or blank");
        String string3 = this.getMaintUser();
        Debug.wassert(string3 != null && string3.length() > 0, this, "Maintenance user is null or blank");
        Object[] objectArray = new String[]{this.getDDB(), string, string2, string3};
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string4 = null;
        if (this.isPrimary()) {
            string4 = string3.equals(ASEUtils.getString("REP_CONN_DEFAULT_USER")) ? rLSQLResourceBundle.getString("CREATE_PRIMARY_CONN_DEF_USER", objectArray) : rLSQLResourceBundle.getString("CREATE_PRIMARY_CONN", objectArray);
        } else if (this.isReplicate()) {
            string4 = string3.equals(ASEUtils.getString("REP_CONN_DEFAULT_USER")) ? rLSQLResourceBundle.getString("CREATE_REPLICATE_CONN_DEF_USER", objectArray) : rLSQLResourceBundle.getString("CREATE_REPLICATE_CONN", objectArray);
        } else {
            Debug.wassert(false, this, "Invalid Connection Type");
        }
        this.getConnection().executeCommand(string4);
        Debug.trace(this, "executeCommand results: ");
    }

    @Override
    public void remove() throws SQLException {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = null;
        if (this.isPrimary()) {
            string = rLSQLResourceBundle.getString("DROP_PRIMARY_CONN", this.getDDB(), this.getServer(), this.getDatabase());
        } else if (this.isReplicate()) {
            string = rLSQLResourceBundle.getString("DROP_REPLICATE_CONN", this.getDDB(), this.getServer(), this.getDatabase());
        } else {
            Debug.wassert(false, this, "Invalid Connection Type");
        }
        this.getConnection().executeCommand(string);
    }

    public String getServer() {
        return this._DS;
    }

    public void setServer(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Attempting to set data server name to null or blank.");
        this._DS = string;
    }

    public String getDatabase() {
        return this._DB;
    }

    public void setDatabase(String string) {
        Debug.wassert(string != null && string.length() > 0, this, "Attempting to set database name to null or blank.");
        this._DB = string;
    }

    public String getConnectionType() {
        return this._connType;
    }

    public boolean isPrimary() {
        boolean bl = false;
        if (this._connType != null) {
            bl = this._connType.equals("PRI");
        }
        return bl;
    }

    public boolean isReplicate() {
        boolean bl = false;
        if (this._connType != null) {
            bl = this._connType.equals("REP");
        }
        return bl;
    }

    public String getTypeString() {
        String string = null;
        if (this.isPrimary()) {
            string = ASEUtils.getString("DISP_PRIMARY_CONN");
        } else if (this.isReplicate()) {
            string = ASEUtils.getString("DISP_REPLICATE_CONN");
        } else {
            Debug.wassert(false, this, "Invalid Connection Type");
        }
        return string;
    }

    public String getLastCommitTable() {
        return this._lastCommitTable;
    }

    public String getMaintUser() {
        return this._maintUser;
    }

    public void setMaintUser(String string) {
        this._maintUser = string;
    }

    public String getLogLocator() {
        return this._logLocator;
    }

    public void setPrimaryConnType() {
        this._connType = "PRI";
    }

    public void setReplicateConnType() {
        this._connType = "REP";
    }

    public String resume() {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = this.isPrimary() ? rLSQLResourceBundle.getString("RESUME_PRIMARY_CONN", this.getDDB(), this.getServer(), this.getDatabase()) : rLSQLResourceBundle.getString("RESUME_REPLICATE_CONN", this.getDDB(), this.getServer(), this.getDatabase());
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        return string;
    }

    public String suspend() {
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = this.isPrimary() ? rLSQLResourceBundle.getString("SUSPEND_PRIMARY_CONN", this.getDDB(), this.getServer(), this.getDatabase()) : rLSQLResourceBundle.getString("SUSPEND_REPLICATE_CONN", this.getDDB(), this.getServer(), this.getDatabase());
        Debug.wassert(string != null && string.length() > 0, this, "Invalid SQL Resource");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getConnections(ASConnection aSConnection, String string, ReplicationSO replicationSO) throws SQLException {
        Debug.wassert(aSConnection != null, "Null connection parameter");
        Debug.wassert(string != null && string.length() > 0, "Null or empty ddb parameter");
        Vector<ConnectionSO> vector = new Vector<ConnectionSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_CONNECTIONS", string));
            while (aSResultSet.getNextRow()) {
                ConnectionSO connectionSO = new ConnectionSO(aSConnection, string, replicationSO);
                connectionSO.load(aSResultSet);
                vector.addElement(connectionSO);
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && !sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getReplicateConnections(ASConnection aSConnection, String string, ReplicationSO replicationSO) throws SQLException {
        Vector<ConnectionSO> vector = new Vector<ConnectionSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(rLSQLResourceBundle.getString("QUERY_REP_CONNECTIONS", string));
            while (aSResultSet.getNextRow()) {
                ConnectionSO connectionSO = new ConnectionSO(aSConnection, string, replicationSO);
                connectionSO.load(aSResultSet);
                vector.addElement(connectionSO);
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getSQLState().equals("JZ0R2")) {
                throw sQLException;
            }
        }
        finally {
            try {
                aSResultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector.elements();
    }

    @Override
    public List open(int n, Object[] objectArray) throws SQLException {
        Vector vector = null;
        if (this.isPrimary()) {
            Debug.trace(this, "Open Primary Connection - " + this.getDisplayName());
            vector = this.getPublications();
        } else if (this.isReplicate()) {
            Debug.trace(this, "Open Replicate Connection - " + this.getDisplayName());
            vector = this.getSubscriptions();
        } else {
            Debug.wassert(false, "Invalid Connection Type");
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getPublications() throws SQLException {
        Vector<PublicationSO> vector = new Vector<PublicationSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("QUERY_PUBLICATIONS", this.getDDB(), this.getServer(), this.getDatabase());
        try {
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                PublicationSO publicationSO = new PublicationSO(this.getConnection(), this.getDDB());
                publicationSO.load(this.getRSet());
                vector.addElement(publicationSO);
            }
        }
        finally {
            try {
                this.getRSet().close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getSubscriptions() throws SQLException {
        Vector<SubscriptionSO> vector = new Vector<SubscriptionSO>();
        RLSQLResourceBundle rLSQLResourceBundle = RLSQLResourceBundle.getSQLBundle("");
        String string = rLSQLResourceBundle.getString("QUERY_SUBSCRIPTIONS", this.getDDB(), this.getServer(), this.getDatabase());
        try {
            this.getRSet().open(string);
            while (this.getRSet().getNextRow()) {
                SubscriptionSO subscriptionSO = new SubscriptionSO(this.getConnection(), this.getDDB(), this);
                subscriptionSO.load(this.getRSet());
                vector.addElement(subscriptionSO);
            }
        }
        finally {
            try {
                this.getRSet().close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("CONN_PROP_DISP_TYPE");
    }
}

