/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.DatabaseDevicesCtrSO;
import com.sybase.aseplugin.so.SDCInstancesCtrSO;
import com.sybase.aseplugin.so.ServerSO;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.ASResultSet;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class DatabaseDeviceSO
extends ASEBaseItemSO {
    private String[] _attrib = new String[10];
    private String _ddname;
    private String _ddphysicalname;
    private String _ddsize;
    private String _ddstartingaddress;
    private boolean _ddmirrorchecked;
    private String _sdcInstanceName;
    private String _quorumDevicePath;
    private int _databaseDeviceType = 1;
    private boolean _ddselectedsync = true;
    private boolean _ddselectedDirectIO = false;
    private String _growBySize = "";
    private String _maxSize = "";
    private Boolean _isAutoExpansionApplicable;
    public static final int NAME = 0;
    public static final int SIZE = 1;
    public static final int UNUSEDSIZE = 2;
    public static final int PHYSICALNAME = 3;
    public static final int STATUS = 4;
    public static final int MIRROR = 5;
    public static final int LOW = 6;
    public static final int HIGH = 7;
    public static final int DEVICENUM = 8;
    public static final int STATUS2 = 9;
    private final int SY_DEV_DEFAULT_DISK = 1;
    private final int SY_DEV_PHYSICAL_DISK = 2;
    private final int SY_DEV_SKIP_HEADER = 4;
    private final int SY_DEV_LOGICAL_DISK = 8;
    private final int SY_DEV_DUMP_DEVICE = 16;
    private final int SY_DEV_SERIAL_WRITES = 32;
    private final int SY_DEV_MIRRORED = 64;
    private final int SY_DEV_READS_MIRRORED = 128;
    private final int SY_DEV_SECONDARY_MIRROR = 256;
    private final int SY_DEV_MIRROR_ENABLED = 512;
    private Boolean _isDirectIOSupported = null;
    private boolean _isSkipAlloc = false;

    public DatabaseDeviceSO(ASConnection aSConnection, String string) {
        super(aSConnection, string);
    }

    public DatabaseDeviceSO(ASConnection aSConnection, String string, String string2) {
        super(aSConnection, string);
        this._sdcInstanceName = string2;
    }

    public void load(String[] stringArray) {
        this._attrib = stringArray;
        try {
            int n = this._attrib[1].indexOf(".");
            if (n != -1) {
                this._attrib[1] = this._attrib[1].substring(0, n + 3);
            }
            if ((n = this._attrib[2].indexOf(".")) != -1) {
                this._attrib[2] = this._attrib[2].substring(0, n + 3);
            } else if (this._attrib[2].equals("")) {
                this._attrib[2] = this._attrib[1];
            }
            double d = Double.parseDouble(this._attrib[2]);
            if (d < 0.01) {
                this._attrib[2] = "0.00";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getIMDBDevCreatedSQL() {
        return SQLs.getString("disk init name=''{0}'', physname=''{1}'', size=''{2}'', type = ''inmemory''", new String[]{this._ddname, this._ddphysicalname, this._ddsize});
    }

    private String getDBDevCreatedSQL() {
        String string = SQLs.getString("disk init name=''{0}'', physname=''{1}'', vdevno={2}, size={3}, cntrltype=0", new String[]{this._ddname, this._ddphysicalname, this._attrib[8], this._ddsize});
        if (this._ddstartingaddress != null && !this._ddstartingaddress.equals("")) {
            string = string + SQLs.getString(", vstart={0}", this._ddstartingaddress);
        }
        string = string + ", dsync=" + this._ddselectedsync;
        if (this._isDirectIOSupported.booleanValue()) {
            string = string + ", directio=" + this._ddselectedDirectIO;
        }
        if (this._isSkipAlloc) {
            string = string + ", skip_alloc= true";
        }
        return string;
    }

    @Override
    public void create() throws SQLException {
        this.useMasterDB();
        String string = null;
        string = this._databaseDeviceType == 2 ? this.getIMDBDevCreatedSQL() : this.getDBDevCreatedSQL();
        if (this.isLocalSDCDevice()) {
            string = string + SQLs.getString(", instance={0}", this._sdcInstanceName);
        }
        this._conn.executeCommand(string);
        if (this._ddmirrorchecked) {
            this._conn.executeCommand(SQLs.getString("disk mirror name=''{0}'', mirror=''{1}'', writes = ''{2}''", this._ddname, this._attrib[5], "serial"));
        }
        if (!this._growBySize.equals("") || !this._maxSize.equals("")) {
            this.setAutoExpansionAttributes(this._growBySize, this._maxSize);
        }
    }

    @Override
    public void remove() throws SQLException {
        this.useMasterDB();
        this._conn.executeCommand(SQLs.getString("exec sp_dropdevice ''{0}''", this._attrib[0]));
    }

    public boolean isDirectIOSupported() {
        if (this._isDirectIOSupported != null) {
            return this._isDirectIOSupported;
        }
        try {
            if (this._conn.getVersion().compareTo("15") < 0) {
                this._isDirectIOSupported = new Boolean(false);
                return false;
            }
            this._conn.executeCommand(SQLs.getString("USE {0}", new String[]{"master"}));
            this._conn.executeCommand("disk init");
            this._isDirectIOSupported = new Boolean(false);
            return false;
        }
        catch (SQLException sQLException) {
            this._isDirectIOSupported = new Boolean(sQLException != null && sQLException.getLocalizedMessage() != null && sQLException.getLocalizedMessage().toLowerCase().indexOf("directio") != -1);
            return this._isDirectIOSupported;
        }
    }

    @Override
    public String getDisplayName() {
        return this._attrib[0];
    }

    public String getSize() {
        return this._attrib[1];
    }

    public String getUnusedSize() {
        return this._attrib[2];
    }

    public String getPhysicalName() {
        return this._attrib[3];
    }

    public void setDatabaseDeviceName(String string) {
        this._ddname = string;
    }

    public void setDatabaseDevicePhysicalName(String string) {
        this._ddphysicalname = string;
    }

    public void setDatabaseDeviceNumber(String string) {
        this._attrib[8] = string;
    }

    public void setDatabaseDeviceSize(String string) {
        this._ddsize = string;
    }

    public void setDatabaseDeviceStartingAddress(String string) {
        this._ddstartingaddress = string;
    }

    public void setMirrorPath(String string) {
        this._attrib[5] = string;
    }

    public void setMirrorChecked(boolean bl) {
        this._ddmirrorchecked = bl;
    }

    public void setSDCInstanceName(String string) {
        this._sdcInstanceName = string;
    }

    public String getDatabaseDeviceName() {
        return this._ddname;
    }

    public String getDatabaseDevicePhysicalName() {
        return this._ddphysicalname;
    }

    public String getDatabaseDeviceNumber() {
        return this._attrib[8];
    }

    public String getDatabaseDeviceSize() {
        return this._ddsize;
    }

    public String getDatabaseDeviceStartingAddress() {
        return this._ddstartingaddress;
    }

    public String getMirrorPath() {
        return this._attrib[5];
    }

    public boolean getMirrorChecked() {
        return this._ddmirrorchecked;
    }

    public String getSDCInstanceName() {
        return this._sdcInstanceName;
    }

    public boolean isLocalSDCDevice() {
        return this._sdcInstanceName != null && this._sdcInstanceName.length() > 0;
    }

    public String getDeviceType() {
        int n = 0;
        String string = "";
        if ((Integer.parseInt(this._attrib[4]) & 1) != 0) {
            ++n;
            string = string + ASEUtils.getString("MSG_DEFAULT_DISK");
        }
        if ((Integer.parseInt(this._attrib[4]) & 2) != 0) {
            if (n > 0) {
                string = string + " | ";
            }
            ++n;
            string = string + ASEUtils.getString("MSG_PHYSICAL_DISK");
        }
        if ((Integer.parseInt(this._attrib[4]) & 8) != 0) {
            if (n > 0) {
                string = string + " | ";
            }
            ++n;
            string = string + ASEUtils.getString("MSG_LOGICAL_DISK");
        }
        if ((Integer.parseInt(this._attrib[4]) & 4) != 0) {
            if (n > 0) {
                string = string + " | ";
            }
            ++n;
            string = string + ASEUtils.getString("MSG_SKIP_HEADER");
        }
        if ((Integer.parseInt(this._attrib[4]) & 0x10) != 0) {
            if (n > 0) {
                string = string + " | ";
            }
            ++n;
            string = string + ASEUtils.getString("DNAME_DUMPDEVICES");
        }
        return string;
    }

    public boolean getSelectedDefault() {
        return (Integer.parseInt(this._attrib[4]) & 1) != 0;
    }

    public boolean getSelectedSync() {
        return (Integer.parseInt(this._attrib[4]) & 0x4000) != 0;
    }

    public void setDatabaseDeviceSync(boolean bl) {
        this._ddselectedsync = bl;
    }

    public boolean getDatabaseDeviceSync() {
        return this._ddselectedsync;
    }

    public boolean getSelectedDirectIO() {
        return this.getConnection().getVersion().compareTo("15") >= 0 && (Integer.parseInt(this._attrib[9]) & 1) == 1;
    }

    public void setDatabaseDeviceDirectIO(boolean bl) {
        this._ddselectedDirectIO = bl;
    }

    public boolean getDatabaseDeviceDirectIO() {
        return this._ddselectedDirectIO;
    }

    public boolean getDatabaseDeviceCachedIO() {
        return !this._ddselectedsync && !this._ddselectedDirectIO;
    }

    public String getLow() {
        return this._attrib[6];
    }

    public String getHigh() {
        return this._attrib[7];
    }

    public void modifyDefault(boolean bl) throws SQLException {
        this._conn.executeCommand(SQLs.getString(bl ? "exec sp_diskdefault {0}, defaulton" : "exec sp_diskdefault {0}, defaultoff", this._attrib[0]));
    }

    public void modifySync(boolean bl) throws SQLException {
        this._conn.executeCommand(SQLs.getString(bl ? "exec sp_deviceattr {0}, dsync, true" : "exec sp_deviceattr {0}, dsync, false", this._attrib[0]));
    }

    public void modifyDirectIO(boolean bl) throws SQLException {
        this._conn.executeCommand(SQLs.getString(bl ? "exec sp_deviceattr {0}, directio, true" : "exec sp_deviceattr {0}, directio, false", this._attrib[0]));
    }

    public boolean isMirrored() {
        return (Integer.parseInt(this._attrib[4]) & 0x40) != 0;
    }

    public boolean isMirroredEnabled() {
        return (Integer.parseInt(this._attrib[4]) & 0x200) != 0;
    }

    public boolean isPrimaryDisabled() {
        return (Integer.parseInt(this._attrib[4]) & 0x100) != 0;
    }

    public boolean usesSerialWrites() {
        return (Integer.parseInt(this._attrib[4]) & 0x20) != 0;
    }

    public void reMirrorDevice() throws SQLException {
        this.useMasterDB();
        this._conn.executeCommand(SQLs.getString("disk remirror name = ''{0}''", this._attrib[0]));
    }

    public void unMirrorDevice(boolean bl, boolean bl2) throws SQLException {
        String string = ", ";
        String string2 = "mode = remove";
        String string3 = "side = 'primary'";
        String string4 = SQLs.getString("disk unmirror name= ''{0}''", this._attrib[0]);
        if (bl2) {
            string4 = string4 + string;
            string4 = string4 + string3;
        }
        if (bl) {
            string4 = string4 + string;
            string4 = string4 + string2;
        }
        this.useMasterDB();
        this._conn.executeCommand(string4);
    }

    public void createMirrorDevice(String string, boolean bl) throws SQLException {
        String string2 = bl ? SQLs.getString("disk mirror name=''{0}'', mirror=''{1}'', writes = ''{2}''", this._attrib[0], string, "serial") : SQLs.getString("disk mirror name=''{0}'', mirror=''{1}'', writes = ''{2}''", this._attrib[0], string, "noserial");
        this.useMasterDB();
        this._conn.executeCommand(string2);
    }

    @Override
    public Object[] getAttributes() {
        return this._attrib;
    }

    public double getKBToPageSize(double d) {
        return d / 2.0;
    }

    public double getPageSizeToKB(double d) {
        return d * 2.0;
    }

    public double getMBToPageSize(double d) {
        return this.getKBToPageSize(d) * 1024.0;
    }

    public double getPageSizeToMB(double d) {
        return this.getPageSizeToKB(d) / 1024.0;
    }

    public double getPageSizeToGB(double d) {
        return this.getPageSizeToMB(d) / 1024.0;
    }

    public double getGBToPageSize(double d) {
        return this.getMBToPageSize(d) * 1024.0;
    }

    public int getMaxCreatableDevices() throws SQLException {
        this.getRSet().open("select value from master.dbo.sysconfigures where config=116");
        this.getRSet().getNextRow();
        return this.getRSet().getColumnInt(1);
    }

    public boolean isMirrorConfigured() throws SQLException {
        String string = "exec sp_configure 'disable disk mirroring'";
        this.getRSet().open(string);
        int n = 0;
        while (this.getRSet().getNextRow()) {
            n = this.getRSet().getColumnInt(5);
        }
        this.getRSet().close();
        return n == 0;
    }

    public boolean isResizeApplicable() {
        return this.getConnection().getVersion().compareTo("12.5.0.1") >= 0 && this.getConnection().hasSARole() && !this.isIMDBDevice();
    }

    public void increaseDiskSize(double d) throws SQLException {
        this.useMasterDB();
        String string = SQLs.getString("disk resize name = ''{0}'' , size = ''{1}M'' {2}", this.getName(), Double.toString(d), this._isSkipAlloc ? ", skip_alloc = true" : "");
        this._conn.executeCommand(string);
    }

    public String getDefaultGrowBySize() throws SQLException {
        this.getRSet().open("select char_value from master..sysattributes where class = 19 and attribute = 71 and object_type = 'DV' and object_cinfo = 'default' and object = 4");
        if (this.getRSet().getNextRow()) {
            return this.getRSet().getColumnString(1);
        }
        return null;
    }

    public void setAutoExpansionAttributes(String string, String string2) throws SQLException {
        String string3 = "";
        string3 = string.equals("") ? "null ,'" + string2 + "'" : (this._maxSize.equals("") ? "'" + string + "'" : "'" + string + "'" + ",'" + string2 + "'");
        String string4 = SQLs.getString("exec sp_dbextend ''set'', ''device'',''{0}'',{1}", this.getName(), string3);
        this._conn.executeCommand(string4);
    }

    public void setMaxSize(String string) {
        this._maxSize = string;
    }

    public void setGrowBySize(String string) {
        this._growBySize = string;
    }

    public boolean isAutoExpansionApplicable() throws SQLException {
        if (this._isAutoExpansionApplicable != null) {
            return this._isAutoExpansionApplicable;
        }
        if (this._conn.getVersion().compareTo("12.5.1") < 0) {
            this._isAutoExpansionApplicable = new Boolean(false);
            return false;
        }
        if (this._conn.hasSARole() && this._conn.isExpansionProcedureInstalled()) {
            this._isAutoExpansionApplicable = new Boolean(true);
            return true;
        }
        this._isAutoExpansionApplicable = new Boolean(false);
        return false;
    }

    public void clearPolicies() throws SQLException {
        this._conn.executeCommand(SQLs.getString("exec sp_dbextend ''clear'', ''device'',''{0}''", this.getName()));
    }

    public Vector getPolicies() throws SQLException {
        Vector<String[]> vector = new Vector<String[]>();
        boolean bl = true;
        String string = SQLs.getString("exec sp_dbextend ''list'', ''device'', ''{0}'' ", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            if (!this.getRSet().getColumnString("name").equals(this.getName())) continue;
            if (this.getRSet().getColumnString("item").equals("growby")) {
                vector.add(new String[]{"g", this.getRSet().getColumnString("value")});
                bl = false;
            }
            if (!this.getRSet().getColumnString("item").equals("maxsize")) continue;
            vector.add(new String[]{"m", this.getRSet().getColumnString("value")});
        }
        if (bl) {
            vector.add(new String[]{"d", this.getDefaultGrowBySize()});
        }
        return vector;
    }

    public void modifyAutoExpansionAttributes(String string, String string2) throws SQLException {
        if (!string.equals("")) {
            String string3 = SQLs.getString("exec sp_dbextend ''modify'', ''device'',''{0}'',{1}", this.getName(), "'growby', '" + string + "'");
            this._conn.executeCommand(string3);
        }
        if (!string2.equals("")) {
            this._conn.executeCommand(SQLs.getString("exec sp_dbextend ''modify'', ''device'',''{0}'',{1}", this.getName(), "'maxSize', '" + string2 + "'"));
        }
    }

    @Override
    public String getDisplayType() {
        if (this.isIMDBDevice()) {
            return ASEUtils.getString("DNAME_IM_DATABASE_DEVICE");
        }
        return ASEUtils.getString("MSG_DATABASE_DEVICE_TYPE");
    }

    public String getDBDeviceInfoSQL() {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            if (this.isIMDBDevice()) {
                return "select d.name, (d.high - d.low + 1) / {0}, convert(int, round(a.low * (convert(float, u.size)/1048576), 0)), u.segmap from master.dbo.sysusages u, master.dbo.spt_values a, master.dbo.sysdevices d where d.vdevno = u.vdevno and u.dbid = db_id( ''{1}'' ) and d.status2&8=8 and a.type = ''E'' and a.number = 1 order by 1";
            }
            return "select d.name, (d.high - d.low + 1) / {0}, convert(int, round(a.low * (convert(float, u.size)/1048576), 0)), u.segmap from master.dbo.sysusages u, master.dbo.spt_values a, master.dbo.sysdevices d where d.vdevno = u.vdevno and u.dbid = db_id( ''{1}'' ) and d.status & 2 = 2 and a.type = ''E'' and a.number = 1 order by 1";
        }
        return "select d.name, (d.high - d.low + 1) / {0}, convert(int, round(a.low * (convert(float, u.size)/1048576), 0)), u.segmap from master.dbo.sysusages u, master.dbo.spt_values a, master.dbo.sysdevices d where d.low <= u.vstart and d.high >= u.size + u.vstart -1 and u.dbid = db_id( ''{1}'' ) and d.status & 2 = 2 and a.type = ''E'' and a.number = 1 order by 1";
    }

    public Vector getDeviceData() throws SQLException {
        if (this.getConnection().getVersion().compareTo("15") >= 0) {
            return Utility.openQuery2("select name, vdevno from master.dbo.sysdevices where cntrltype = 0 order by vdevno", this._conn);
        }
        return Utility.openQuery2("select d.name, DEVICENUM=convert(tinyint, substring(convert(binary(4),d.low),v.low,1)) from master.dbo.sysdevices d, master.dbo.spt_values v where v.type = 'E' and v.number = 3 and d.cntrltype = 0 order by DEVICENUM", this._conn);
    }

    public String[] getSegment(String string, String string2) throws SQLException {
        new SDCInstancesCtrSO(this.getConnection()).initLocalConnections();
        ASConnection aSConnection = SDCInstancesCtrSO.getLocalConnection(this.getConnection().getServerServerName(), string);
        if (aSConnection == null) {
            return null;
        }
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        String string3 = SQLs.getString("select distinct S.name from master.dbo.sysusages U, master.dbo.sysdevices D, {0}.dbo.syssegments S where U.dbid=db_id(''{0}'') and (D.status&2=2 or D.status2&8=8) and ((U.segmap/((S.segment&1)+1))/power(2,(S.segment&30)))&1=1 and D.vdevno=U.vdevno and D.name=''{1}''", string2, this.getName());
        aSResultSet.open(string3);
        Vector<String> vector = new Vector<String>();
        while (aSResultSet.getNextRow()) {
            String[] stringArray = aSResultSet.getColumnsAsArray();
            vector.addElement(stringArray[0].trim());
        }
        aSResultSet.close();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public String getQuorumDevicePath() throws SQLException {
        if (this._quorumDevicePath == null) {
            this.getRSet().open("select @@quorum_physname");
            if (this.getRSet().getNextRow()) {
                this._quorumDevicePath = this.getRSet().getColumnString(1);
            }
            this.getRSet().close();
        }
        return this._quorumDevicePath;
    }

    public String[] getSegment(String string) throws SQLException {
        String string2 = "";
        string2 = this.getConnection().getVersion().compareTo("15") >= 0 ? "select distinct S.name from master.dbo.sysusages U, master.dbo.sysdevices D, {0}.dbo.syssegments S where U.dbid=db_id(''{0}'') and (D.status&2=2 or D.status2&8=8) and ((U.segmap/((S.segment&1)+1))/power(2,(S.segment&30)))&1=1 and D.vdevno=U.vdevno and D.name=''{1}''" : "select distinct S.name from master.dbo.sysusages U, master.dbo.sysdevices D, {0}.dbo.syssegments S where U.dbid=db_id(''{0}'') and D.status&2=2 and D.low <= U.vstart and D.high >= U.vstart+(U.size - 1) and ((U.segmap/((S.segment&1)+1))/power(2,(S.segment&30)))&1 = 1 and D.name=''{1}''";
        this.getRSet().open(SQLs.getString(string2, string, this.getName()));
        Vector<String> vector = new Vector<String>();
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[0].trim());
        }
        this.getRSet().close();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public Vector getDatabaseList() throws SQLException {
        Vector vector = new Vector();
        String string = "";
        string = this.getConnection().getVersion().compareTo("15") >= 0 ? "select a.name, a.dbid, sum(b.size)/{1}, (select l.name from master.dbo.syslogins l where l.suid=a.suid) from master.dbo.sysdatabases a, master.dbo.sysusages b, master.dbo.sysdevices c where (a.dbid=b.dbid) and b.vdevno = c.vdevno and (c.name=''{0}'') and ((a.status&0x20)=0) and ((a.status&0x100)=0) group by a.name" : "select a.name, a.dbid, sum(b.size)/{1}, (select l.name from master.dbo.syslogins l where l.suid=a.suid) from master.dbo.sysdatabases a, master.dbo.sysusages b, master.dbo.sysdevices c where (a.dbid=b.dbid) and (b.vstart<=c.high) and (b.vstart>=c.low) and (c.name=''{0}'') and ((a.status&0x20)=0) and ((a.status&0x100)=0) group by a.name";
        this.getRSet().open(SQLs.getString(string, new Object[]{this.getName(), Utility.getMBToPageSize(this._conn) + ""}));
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(stringArray[0].trim());
            vector2.addElement(stringArray[3].trim());
            vector2.addElement(stringArray[2].trim());
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSARole();
    }

    public boolean isSkipAllocApplicable() {
        return this.getConnection().getVersion().compareTo("15.0.2") >= 0;
    }

    public void setSkipAlloc(boolean bl) {
        this._isSkipAlloc = bl;
    }

    public boolean isSkipAlloc() {
        return this._isSkipAlloc;
    }

    @Override
    public DatabaseDeviceSO findObject() throws SQLException {
        DatabaseDevicesCtrSO databaseDevicesCtrSO = new DatabaseDevicesCtrSO(this.getConnection());
        Object[] objectArray = new Object[]{this.getName()};
        DatabaseDeviceSO databaseDeviceSO = null;
        databaseDevicesCtrSO.setDatabaseDeviceType(1);
        List list = databaseDevicesCtrSO.open(1, objectArray);
        if (null != list && !list.isEmpty() && null != (databaseDeviceSO = (DatabaseDeviceSO)list.get(0))) {
            return databaseDeviceSO;
        }
        databaseDevicesCtrSO.setDatabaseDeviceType(2);
        list = databaseDevicesCtrSO.open(1, objectArray);
        if (null != list && !list.isEmpty() && null != (databaseDeviceSO = (DatabaseDeviceSO)list.get(0))) {
            return databaseDeviceSO;
        }
        return databaseDeviceSO;
    }

    public Vector getDBListwithServerInstanceInfo() throws SQLException {
        Vector vector = new Vector();
        this.getRSet().open("select i.name, d.name, i.engines_online from master.dbo.sysinstances i, master.dbo.sysdatabases d where i.id = d.instanceid union select @@instancename, name, 1 from master.dbo.sysdatabases where instanceid = null");
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            Vector<String> vector2 = new Vector<String>();
            if (!stringArray[2].trim().equals("1")) continue;
            vector2.addElement(stringArray[0].trim());
            vector2.addElement(stringArray[1].trim());
            vector.addElement(vector2);
        }
        this.getRSet().close();
        return vector;
    }

    @Override
    public boolean exists() throws SQLException {
        Vector vector = this.getDeviceData();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            String string = stringArray[0];
            if (!this.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Object[] getIOFencingCheckResult(String string) {
        Object[] objectArray = new Object[]{null, null};
        if (this._conn.isCluster() && !this.isLocalSDCDevice()) {
            ServerSO serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO();
            if (null == serverSO || !serverSO.isUAFMonitored()) {
                objectArray[0] = new Boolean(true);
                String string2 = ASEUtils.getString("SDC_MSG_IOFENCING_OPERATION_FAILED");
                objectArray[1] = string2;
            } else {
                try {
                    objectArray = serverSO.getIOFencingCheckResult(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return objectArray;
    }

    public Boolean isManagedByVCS(String string) {
        ServerSO serverSO;
        Boolean bl = null;
        if (this._conn.isCluster() && !this.isLocalSDCDevice() && null != (serverSO = (ServerSO)ContainerViewBO.getServerBO(this.getConnection()).getSO()) && serverSO.isUAFMonitored()) {
            try {
                bl = serverSO.isManagedByVCS(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public void setDatabaseDeviceType(int n) {
        this._databaseDeviceType = n;
    }

    public int getDatabaseDeviceType() {
        return this._databaseDeviceType;
    }

    public boolean isIMDBDevice() {
        if (this._conn.isIMDBApplicable()) {
            return this._databaseDeviceType == 2;
        }
        return false;
    }
}

