/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.so;

import com.sybase.aseplugin.ASEImages;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.so.ASEBaseItemSO;
import com.sybase.aseplugin.so.ArchiveDBSO;
import com.sybase.aseplugin.so.CacheSO;
import com.sybase.aseplugin.so.CachesCtrSO;
import com.sybase.aseplugin.so.DatabaseDeviceSO;
import com.sybase.aseplugin.so.DatabaseDevicesCtrSO;
import com.sybase.aseplugin.so.DatabasesCtrSO;
import com.sybase.aseplugin.so.DateSorter;
import com.sybase.aseplugin.so.ProxyServer;
import com.sybase.aseplugin.so.RemoteDatabase;
import com.sybase.aseplugin.so.RemoteServerSO;
import com.sybase.aseplugin.so.RemoteServersCtrSO;
import com.sybase.aseplugin.so.SOCtrInterface;
import com.sybase.aseplugin.so.SOItemInterface;
import com.sybase.aseplugin.so.Utility;
import com.sybase.aseplugin.sql.ASConnection;
import com.sybase.aseplugin.sql.SQLs;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class DatabaseSO
extends ASEBaseItemSO
implements DateSorter {
    public static final String DB_OP_DBO_ONLY = "DB_OP_DBO_ONLY";
    public static final String DB_OP_SINGLE_USER = "DB_OP_SINGLE_USER";
    public static final String DB_OP_ALLOW_BULK = "DB_OP_ALLOW_BULK";
    public static final String DB_OP_TRUNCATE_LOG = "DB_OP_TRUNCATE_LOG";
    public static final String DB_OP_ALLOW_NULLS = "DB_OP_ALLOW_NULLS";
    public static final String DB_OP_DDL_IN_TRAN = "DB_OP_DDL_IN_TRAN";
    public static final String DB_OP_READ_ONLY = "DB_OP_READ_ONLY";
    public static final String DB_OP_ABORT_ON_FULL = "DB_OP_ABORT_ON_FULL";
    public static final String DB_OP_AUTO_IDENTITY = "DB_OP_AUTO_IDENTITY";
    public static final String DB_OP_ADD_IDENTITY = "DB_OP_ADD_IDENTITY";
    private static long FLAG_DB_OFFLINE = 16L;
    private static long FLAG_DB_FOR_LOAD = 32L;
    private static long FLAG_DB_SUSPECT = 256L;
    private static long FLAG_DB_QUIESCE = 128L;
    private static long FLAG_DB_OFFLINE_UNTIL_RECOVERY = 32L;
    private static long DEGRADE_TO_WARNINIG_SQL_VENDOR_CODE = 19120L;
    private static long FLAG_DB_DML_LOGGING = 256L;
    private boolean _loaded = false;
    private boolean _blnForProxyUpdate = false;
    private String _dbOwner = "";
    private Date _dbCreationDate;
    private boolean _dbHasGuest = false;
    private boolean _dbWithOverride = false;
    private long _dbStatus = 0L;
    private long _dbStatus2 = 0L;
    private long _dbStatus3 = 0L;
    private String _dbBoundCache = "";
    private String _dbLogIOSize = "";
    private String _dbLogFileCache = "";
    private String _dblastChance = "";
    private String _dbStrCreationDate = null;
    private String _dbStrLastDumpDate = null;
    private String _dbRemoteLocation = null;
    protected boolean _isQuiesceHold;
    protected String _dbDeviceList = "";
    protected String _logDeviceList = "";
    protected int _dbType = 1;
    protected String _durability = "";
    protected String _template = "";
    protected boolean _areBatching = false;
    protected boolean _overRide = false;
    protected double _MBTotalSpace = 0.0;
    private String _dbID = "99";
    private Vector _dbdevice = new Vector();
    private Vector _dblog = new Vector();
    private Vector _logCacheList = new Vector();
    private Vector _poolList = new Vector();
    private Vector _deviceList = new Vector();
    private Vector _vProxyServers = new Vector();
    private String _boundCache = null;
    protected String _sdcInstanceName = null;
    public static final int ATTR_COL_DB_NAME = 1;
    public static final int ATTR_COL_OWNER = 2;
    public static final int ATTR_COL_DATE_CREATED = 3;
    public static final String ASIQ = "ASIQ";
    public static final String ASAnywhere = "ASAnywhere";
    public static final String direct_connect = "direct_connect";
    public static final String ASEnterprise = "ASEnterprise";
    public static final String DURABILITY_NO_RECOVERY_TEXT = "NO_RECOVERY";
    public static final String DURABILITY_SHUTDOWN_TEXT = "AT_SHUTDOWN";
    public static final String DURABILITY_FULL_TEXT = "FULL";
    public static final int DURABILITY_NO_RECOVERY = 6;
    public static final int DURABILITY_SHUTDOWN = 5;
    public static final int DURABILITY_FULL = 1;
    public static final String TEMPLATE_DATABASE_NULL = "NULL";
    public static final String TEMPLATE_DATABASE_FOR_LOAD = "FOR LOAD";
    public static String SYB_SYSTEM_DB = "sybsystemdb";
    public static String SYB_SYSTEM_PROCS_DB = "sybsystemprocs";
    public static String SYB_PCI_DB = "sybpcidb";
    private Boolean _isAutoExpansionApplicable;
    private String _growBySize;
    private boolean _migratePolicies;
    private String _reservedSpace;
    private String _spaceUsedByData;
    private String _spaceUsedByIndex;
    private String _unusedSpace;
    private String _logTotalSpace;
    private String _logFreeSpace;
    private String _logUsedSpace;
    private String _logReservedSpace;

    public DatabaseSO(ASConnection aSConnection, String string, SOCtrInterface sOCtrInterface) {
        super(aSConnection, string, sOCtrInterface);
    }

    public Vector open(int n) {
        Vector vector = null;
        if (this.isSuspectOrLoadOrOffline()) {
            return vector;
        }
        vector = new Vector();
        return vector;
    }

    public boolean isSuspect() {
        return (this._dbStatus & FLAG_DB_SUSPECT) != 0L;
    }

    public boolean isSuspectOrLoadOrOffline() {
        return this.isForLoad() || this.isSuspect() || this.isOffline();
    }

    public boolean isArchiveDB() {
        return this._dbType == 11;
    }

    public boolean isProxyDB() {
        return this._dbType == 2;
    }

    public boolean isTempDB() {
        return this._dbType == 3;
    }

    public boolean isSDCGlobalTempDB() {
        return this._dbType == 6;
    }

    public boolean isInIMDBFamily() {
        return this.isInMemoryDB() || this.isTempInMemoryDB();
    }

    public boolean isInMemoryDB() {
        return this._dbType == 12;
    }

    public boolean isTempInMemoryDB() {
        return this._dbType == 13;
    }

    public boolean isSDCLocalInMemoryTempDB() {
        return this._dbType == 14;
    }

    public boolean isDurabilityAlterable() {
        return !this.isInIMDBFamily() && !this.isTempDB() && !this.isSystem() && !this.isSDCGlobalTempDB() && !this.isSDCLocalTempDB();
    }

    public boolean isDurabilityApplicable() {
        return this._conn.isIMDBApplicable();
    }

    public boolean isDMLLoggingAlterable() {
        return !this._durability.equalsIgnoreCase(DURABILITY_FULL_TEXT) && !this.isSystem();
    }

    public boolean isTemplateDBApplicable() {
        if (this._conn.isIMDBApplicable()) {
            return this.isInMemoryDB();
        }
        return false;
    }

    public boolean isTemplateDBAlterable() {
        return this.isTemplateDBApplicable() && !this.isForLoad();
    }

    public boolean isArchiveDBLoadTranApplicable() {
        return this.getConnection().getVersion().compareTo("15.0.2") >= 0 || this.getConnection().getVersion().compareTo("12.5.4") >= 0 && this.getConnection().isESD(2) && this.getConnection().getVersion().compareTo("15.0") < 0;
    }

    public boolean isOffline() {
        return (this._dbStatus2 & FLAG_DB_OFFLINE) == FLAG_DB_OFFLINE || (this._dbStatus2 & FLAG_DB_OFFLINE_UNTIL_RECOVERY) == FLAG_DB_OFFLINE_UNTIL_RECOVERY;
    }

    public void load() throws SQLException {
        if (this.isSuspectOrLoadOrOffline()) {
            return;
        }
        this.getRSet().open(SQLs.getString("select dbid, (select name from master.dbo.syslogins where suid = a.suid), convert(datetime, crdate), convert(datetime, dumptrdate), (select char_value from master.dbo.sysattributes b where object_type = ''D'' and object = a.dbid and b.class = 3), status, status2, (select name from {0}.dbo.sysusers where name = ''guest''), (select char_value from {0}.dbo.sysattributes b, {0}.dbo.sysobjects c where c.id = b.object and object_type = ''T'' and char_value != null and name = ''syslogs''), (select int_value from {0}.dbo.sysattributes b, {0}.dbo.sysobjects c where c.id = b.object and object_type = ''T'' and char_value = null and name = ''syslogs''), (select name from {0}.dbo.syssegments s, {0}.dbo.systhresholds t where s.segment = t.segment and convert( bit, t.status & 1 ) = 1), convert(datetime, crdate), convert(datetime, dumptrdate), a.def_remote_loc from master.dbo.sysdatabases a where a.name = ''{0}'' ", this.getName()));
        if (!this.getRSet().getNextRow()) {
            this.getRSet().close();
            return;
        }
        this._dbID = this.getRSet().getColumnString(1);
        this._dbOwner = this.getRSet().getColumnString(2);
        this._dbCreationDate = this.getRSet().getColumnDate(3);
        String string = this.getRSet().getColumnString(8);
        this._dbHasGuest = !string.trim().equals("");
        this._dbStatus = this.getRSet().getColumnLong(6);
        this._dbStatus2 = this.getRSet().getColumnLong(7);
        string = this.getRSet().getColumnString(5);
        this._dbBoundCache = string.trim().equals("") ? ASEUtils.getString("MSG_DEFAULT_DATA_CACHE") : string;
        string = this.getRSet().getColumnString(10);
        this._dbLogIOSize = string.trim().equals("") ? "2" : string;
        this._dbLogFileCache = this.getRSet().getColumnString(9);
        this._dblastChance = this.getRSet().getColumnString(11);
        this._dbStrCreationDate = this.getRSet().getColumnString(12);
        this._dbStrLastDumpDate = this.getRSet().getColumnString(13);
        this._dbRemoteLocation = this.getRSet().getColumnString(14);
        this.getRSet().close();
        this._loaded = true;
    }

    public void load(Object[] objectArray) throws SQLException {
        this.setName((String)objectArray[0]);
        this._dbOwner = (String)objectArray[1];
        this._dbID = (String)objectArray[2];
        this._dbCreationDate = (Date)objectArray[3];
        this._dbStrCreationDate = (String)objectArray[4];
        this._dbStatus = Integer.parseInt((String)objectArray[5]);
        this._dbStatus2 = Integer.parseInt((String)objectArray[6]);
        this._dbStatus3 = Integer.parseInt((String)objectArray[7]);
        this._loaded = true;
        this._MBTotalSpace = Double.parseDouble((String)objectArray[8]);
        this._dbRemoteLocation = (String)objectArray[9];
        if (this.isArchiveDB()) {
            ((ArchiveDBSO)this).load();
        }
    }

    public void loadDurability() throws SQLException {
        this.getRSet().open(SQLs.getString("select durability from master.dbo.sysdatabases where name = ''{0}''", this.getName()));
        if (this.getRSet().getNextRow()) {
            this._durability = this.getDurability(this.getRSet().getColumnInt(1));
        }
        this.getRSet().close();
    }

    public String getDurability() {
        return this._durability;
    }

    private String getDurability(int n) {
        switch (n) {
            case 6: {
                return DURABILITY_NO_RECOVERY_TEXT;
            }
            case 5: {
                return DURABILITY_SHUTDOWN_TEXT;
            }
            case 1: {
                return DURABILITY_FULL_TEXT;
            }
        }
        return DURABILITY_FULL_TEXT;
    }

    public void setDurability(String string) {
        this._durability = string;
    }

    public void setTemplateDB(String string) {
        this._template = string;
    }

    public String getTemplateDB() {
        if (null == this._template || this._template.length() == 0) {
            this._template = TEMPLATE_DATABASE_NULL;
        }
        return this._template;
    }

    public boolean hasTemplate() {
        return this._template.length() > 0;
    }

    public boolean isModelTempateDB() {
        return this._template.equalsIgnoreCase(TEMPLATE_DATABASE_NULL);
    }

    public boolean isForLoadTempateDB() {
        return this._template.equalsIgnoreCase(TEMPLATE_DATABASE_FOR_LOAD);
    }

    public void loadTemplateDB() throws SQLException {
        this.getRSet().open(SQLs.getString("select def_remote_loc from master.dbo.sysdatabases where name=''{0}''", this.getName()));
        if (this.getRSet().getNextRow()) {
            this._template = this.getRSet().getColumnString(1);
        }
        this.getRSet().close();
    }

    public void alterTemplateDB(String string) throws SQLException {
        this.useMasterDB();
        String string2 = SQLs.getString("alter database {0} set template = {1}", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    @Override
    public void create() throws SQLException {
        String string = "create database {0} ";
        if (this.isInMemoryDB()) {
            string = "create inmemory database {0} ";
        }
        this.create(string);
    }

    @Override
    public SOItemInterface findObject() throws SQLException {
        DatabasesCtrSO databasesCtrSO = new DatabasesCtrSO(this.getConnection());
        Object[] objectArray = new Object[]{this.getName()};
        SOItemInterface sOItemInterface = null;
        List list = null;
        if (this.getConnection().isCluster()) {
            databasesCtrSO.setDatabaseType(5);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
            databasesCtrSO.setDatabaseType(6);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
            databasesCtrSO.setDatabaseType(7);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
            databasesCtrSO.setDatabaseType(8);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
            databasesCtrSO.setDatabaseType(9);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
        }
        databasesCtrSO.setDatabaseType(1);
        list = databasesCtrSO.open(1, objectArray);
        if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
            return sOItemInterface;
        }
        databasesCtrSO.setDatabaseType(2);
        list = databasesCtrSO.open(1, objectArray);
        if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
            return sOItemInterface;
        }
        if (this.getConnection().getVersion().compareTo("12.5.0.3") >= 0) {
            databasesCtrSO.setDatabaseType(3);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
        }
        if (this.getConnection().isArchiveDBApplicable()) {
            databasesCtrSO.setDatabaseType(11);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
        }
        if (this.getConnection().isIMDBApplicable()) {
            databasesCtrSO.setDatabaseType(12);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
            databasesCtrSO.setDatabaseType(13);
            list = databasesCtrSO.open(1, objectArray);
            if (null != list && !list.isEmpty() && null != (sOItemInterface = (SOItemInterface)list.get(0))) {
                return sOItemInterface;
            }
        }
        return sOItemInterface;
    }

    protected String getPrefixforOption(String string) {
        String string2 = " with";
        if (string.indexOf("with") > -1) {
            string2 = ",";
        }
        return string2;
    }

    protected void create(String string) throws SQLException {
        Vector vector;
        int n;
        StringBuffer stringBuffer = new StringBuffer(SQLs.getString(string, this.getName()));
        if (this.isSDCLocalTempDB()) {
            String string2 = SQLs.getString(" for instance {0}", this._sdcInstanceName);
            stringBuffer.append(string2);
        }
        if (this.isTemplateDBAlterable() && null != this._template && this._template.length() > 0 && !this.isModelTempateDB()) {
            stringBuffer.append(SQLs.getString(" USE {0} AS TEMPLATE ", this._template));
        }
        if (this._dbdevice.size() > 0) {
            stringBuffer.append(" on ");
        }
        for (n = 0; n < this._dbdevice.size(); ++n) {
            vector = (Vector)this._dbdevice.elementAt(n);
            stringBuffer.append(((JLabel)vector.elementAt(0)).getText()).append(" = ").append(new Integer(((Double)vector.elementAt(1)).intValue()).toString());
            if (n >= this._dbdevice.size() - 1) continue;
            stringBuffer.append(" , ");
        }
        if (this._dblog.size() > 0) {
            stringBuffer.append(" log on ");
        }
        for (n = 0; n < this._dblog.size(); ++n) {
            vector = (Vector)this._dblog.elementAt(n);
            stringBuffer.append(((JLabel)vector.elementAt(0)).getText()).append(" = ").append(new Integer(((Double)vector.elementAt(1)).intValue()).toString());
            if (n >= this._dblog.size() - 1) continue;
            stringBuffer.append(" , ");
        }
        if (this.isWithOverride()) {
            stringBuffer.append(" with override ");
        }
        if (this.isDurabilityApplicable() && null != this._durability && this._durability.length() > 0) {
            stringBuffer.append(this.getPrefixforOption(stringBuffer.toString())).append(" DURABILITY=").append(this._durability);
        }
        if (this.getDefaultRemoteLocation() != null) {
            stringBuffer.append(SQLs.getString(" with default_location=''{0}'' ", this.getDefaultRemoteLocation()));
        }
        if (this.isOptionOn(FLAG_DB_FOR_LOAD)) {
            stringBuffer.append(" for load ");
        }
        if (this.isForProxyUpdate()) {
            stringBuffer.append(" for proxy_update ");
        }
        this.useMasterDB();
        this._conn.executeCommand(stringBuffer.toString());
        if (this.isForLoad()) {
            return;
        }
        if (this.hasGuest()) {
            this.useDB();
            this._conn.executeCommand("exec sp_adduser 'guest'");
        }
        if (this._growBySize != null) {
            this.modifyDefaultPolicies();
        }
        if (this._migratePolicies) {
            this.migratePoliciesFromModel();
        }
    }

    public void reallocateSpace() throws SQLException {
        this.useMasterDB();
        this._conn.executeCommand(SQLs.getString("alter database {0} for load", this.getName()));
    }

    public void checkpoint() throws SQLException {
        this.useDB();
        this._conn.executeCommand("checkpoint");
    }

    public void online() throws SQLException {
        this._conn.executeCommand(SQLs.getString("online database {0} ", this.getName()));
    }

    @Override
    public void remove() throws SQLException {
        this.useMasterDB();
        if (!this.isSuspect()) {
            this._conn.executeCommand(SQLs.getString("drop database {0} ", this.getName()));
        } else {
            this._conn.executeCommand(SQLs.getString("dbcc dbrepair ({0}, dropdb)", this.getName()));
        }
    }

    public String getOwner() {
        return this._dbOwner;
    }

    public String getCreationDate() {
        return this._dbStrCreationDate;
    }

    @Override
    public Date getDate(int n) {
        return this._dbCreationDate;
    }

    public String getLastDumpDate() {
        return this._dbStrLastDumpDate;
    }

    public boolean hasGuest() {
        return this._dbHasGuest;
    }

    public boolean getSettingForDMLLOGGING() throws SQLException {
        boolean bl = false;
        String string = SQLs.getString("select status4 from master..sysdatabases where name like ''{0}''", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            String string2 = this.getRSet().getColumnString(1);
            if (((long)Integer.parseInt(string2) & FLAG_DB_DML_LOGGING) == FLAG_DB_DML_LOGGING) {
                bl = false;
                continue;
            }
            bl = true;
        }
        this.getRSet().close();
        return bl;
    }

    public boolean isMaster() {
        return Integer.parseInt(this._dbID) == 1;
    }

    public String getLogIOSize() {
        return this._dbLogIOSize;
    }

    public String getBoundCache() {
        return this._dbBoundCache;
    }

    public boolean isSystem() {
        if (Integer.parseInt(this._dbID) <= 3 || this.getName().equalsIgnoreCase(SYB_SYSTEM_DB) || this.getName().equalsIgnoreCase(SYB_SYSTEM_PROCS_DB) || this.getName().equalsIgnoreCase(SYB_PCI_DB)) {
            return true;
        }
        if (this._conn.isCluster()) {
            long l = this._dbStatus3 & Long.parseLong(DatabasesCtrSO.SPT_VALUE_LOCAL_SYSTEM_TEMP_DB);
            return l == Long.parseLong(DatabasesCtrSO.SPT_VALUE_LOCAL_SYSTEM_TEMP_DB);
        }
        return false;
    }

    public boolean isSDCLocalTempDB() {
        return this._sdcInstanceName != null && this._sdcInstanceName.length() > 0;
    }

    public void setSDCInstanceName(String string) {
        this._sdcInstanceName = string;
    }

    public String getSDCInstanceName() {
        return this._sdcInstanceName;
    }

    public String getID() {
        return this._dbID;
    }

    protected boolean isLoaded() {
        return this._loaded;
    }

    public synchronized void load(boolean bl) throws SQLException {
        if (bl || !this._loaded) {
            this._loaded = false;
            this.load();
            this._loaded = true;
        }
    }

    boolean isOptionOn(long l) {
        return (this._dbStatus & l) != 0L;
    }

    boolean isOption2On(long l) {
        return (this._dbStatus2 & l) != 0L;
    }

    public void setWithOverride(boolean bl) {
        this._dbWithOverride = bl;
    }

    public boolean isWithOverride() {
        return this._dbWithOverride;
    }

    public void setForProxyUpdate(boolean bl) {
        this._blnForProxyUpdate = bl;
    }

    public boolean isForProxyUpdate() {
        return this._blnForProxyUpdate;
    }

    public void setForLoad(boolean bl) {
        this._dbStatus = bl ? (this._dbStatus |= FLAG_DB_FOR_LOAD) : (this._dbStatus &= FLAG_DB_FOR_LOAD ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean isForLoad() {
        return (this._dbStatus & FLAG_DB_FOR_LOAD) != 0L;
    }

    public void setGuestAccount(boolean bl) {
        this._dbHasGuest = bl;
    }

    public void setDBDevice(Vector vector) {
        this._dbdevice = vector;
    }

    public void setDBLog(Vector vector) {
        this._dblog = vector;
    }

    public String getCacheName() {
        return this._boundCache;
    }

    public List getActiveCaches() throws SQLException {
        CachesCtrSO cachesCtrSO = new CachesCtrSO(this.getConnection());
        if (this.getConnection().isCluster()) {
            if (this.isSDCLocalTempDB()) {
                cachesCtrSO.setCacheScope(CacheSO.CACHE_SCOPE_SDC_LOCAL);
            } else {
                cachesCtrSO.setCacheScope(CacheSO.CACHE_SCOPE_SDC_GLOBAL);
            }
        } else {
            cachesCtrSO.setCacheScope(CacheSO.CACHE_SCOPE_SMP);
        }
        List list = cachesCtrSO.getActiveCaches();
        Vector<CacheSO> vector = new Vector<CacheSO>();
        for (CacheSO cacheSO : list) {
            if (cacheSO.isInMemoryStorage()) continue;
            vector.add(cacheSO);
        }
        return vector;
    }

    public void setCache(String string) throws SQLException {
        this.useMasterDB();
        String string2 = "default data cache";
        String string3 = "exec sp_bindcache ";
        String string4 = "exec sp_unbindcache ";
        try {
            if (string.compareTo(string2) == 0) {
                String string5 = string4 + " '" + this.getName() + "' ";
                this._conn.executeCommand(string5);
            } else {
                String string6 = string3 + " '" + string + "', '" + this.getName() + "' ";
                this._conn.executeCommand(string6);
            }
        }
        catch (SQLException sQLException) {
            if ((long)sQLException.getErrorCode() == DEGRADE_TO_WARNINIG_SQL_VENDOR_CODE) {
                Support.showWarning(this._conn, this.getClass(), sQLException.getLocalizedMessage());
            }
            throw sQLException;
        }
    }

    public void setOwnerSQL(String string, boolean bl) throws SQLException {
        this.useDB();
        String string2 = SQLs.getString("exec sp_changedbowner ''{0}''", string);
        if (bl) {
            string2 = string2 + ", true";
        }
        this._conn.executeCommand(string2);
    }

    public void alterDefaultLocation(String string) throws SQLException {
        String string2 = null;
        this.useMasterDB();
        string2 = this.getDefaultRemoteLocation();
        if (string2 != null && string2.length() != 0) {
            this._conn.executeCommand(SQLs.getString("exec sp_defaultloc {0}, {1}", this.getName(), TEMPLATE_DATABASE_NULL));
        }
        try {
            this._conn.executeCommand(SQLs.getString("exec sp_defaultloc {0}, {1}", this.getName(), "'" + string + "'"));
        }
        catch (SQLException sQLException) {
            if (string2 != null && string2.length() != 0) {
                this._conn.executeCommand(SQLs.getString("exec sp_defaultloc {0}, {1}", this.getName(), "'" + string2 + "'"));
            }
            throw sQLException;
        }
    }

    public void syncProxyTables() throws SQLException {
        this.useMasterDB();
        this._conn.executeCommand(SQLs.getString("alter database {0} for proxy_update", this.getName()));
    }

    public void setGuestAccountSQL(boolean bl) throws SQLException {
        this.useDB();
        if (bl) {
            this._conn.executeCommand("exec sp_adduser 'guest'");
        } else {
            String string = SQLs.getString("exec sp_dropuser {0}", "guest");
            this._conn.executeCommand(string);
        }
    }

    public void setDMLLOGINGSQL(boolean bl) throws SQLException {
        this.useMasterDB();
        if (bl) {
            String string = SQLs.getString("alter database {0} set dml_logging = full", this.getName());
            this._conn.executeCommand(string);
        } else {
            String string = SQLs.getString("alter database {0} set dml_logging = minimal", this.getName());
            this._conn.executeCommand(string);
        }
    }

    public Vector getLoginNameList() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open(SQLs.getString("select suid, dbname, fullname, name, status, language, totcpu, totio, accdate, pwdate from master.dbo.syslogins where name like ''{0}''", "%"));
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[3].trim());
        }
        this.getRSet().close();
        return vector;
    }

    public Vector getAvailableUserGroups() throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = SQLs.getString("select name from {0}.dbo.sysusers where gid=uid and gid not in (select lrid from {0}.dbo.sysroles) order by 1 ", this.getName());
        this.getRSet().open(string);
        while (this.getRSet().getNextRow()) {
            vector.addElement(this.getRSet().getColumnString(1));
        }
        this.getRSet().close();
        return vector;
    }

    public void createUser(String string, String string2, String string3) throws SQLException {
        this.useDB(this.getName());
        String string4 = SQLs.getString("exec sp_adduser ''{0}'' , ''{1}'' , {2} ", string, string2, "'" + string3 + "'");
        this._conn.executeCommand(string4);
        this.useMasterDB();
    }

    public void refresh() throws SQLException {
        this.getRSet().open(SQLs.getString("select dbid, (select name from master.dbo.syslogins where suid = a.suid), convert(datetime, crdate), convert(datetime, dumptrdate), (select char_value from master.dbo.sysattributes b where object_type = ''D'' and object = a.dbid and b.class = 3), status, status2, (select name from {0}.dbo.sysusers where name = ''guest''), (select char_value from {0}.dbo.sysattributes b, {0}.dbo.sysobjects c where c.id = b.object and object_type = ''T'' and char_value != null and name = ''syslogs''), (select int_value from {0}.dbo.sysattributes b, {0}.dbo.sysobjects c where c.id = b.object and object_type = ''T'' and char_value = null and name = ''syslogs''), (select name from {0}.dbo.syssegments s, {0}.dbo.systhresholds t where s.segment = t.segment and convert( bit, t.status & 1 ) = 1), convert(datetime, crdate), convert(datetime, dumptrdate), a.def_remote_loc from master.dbo.sysdatabases a where a.name = ''{0}'' ", this.getName()));
        if (!this.getRSet().getNextRow()) {
            this.getRSet().close();
            return;
        }
        this._boundCache = this.getRSet().getColumnString(5);
        if (this._boundCache.length() == 0) {
            this._boundCache = ASEUtils.getString("MSG_DEFAULT_DATA_CACHE");
        }
        this.getRSet().close();
    }

    public void refreshAllocations() throws SQLException {
        this.useDB();
        ResultSet resultSet = this.getRSet().open("exec sp_spaceused");
        Statement statement = resultSet.getStatement();
        while (resultSet.next()) {
        }
        while (!statement.getMoreResults()) {
        }
        resultSet = statement.getResultSet();
        while (resultSet.next()) {
            this._reservedSpace = resultSet.getString("reserved");
            this._spaceUsedByData = resultSet.getString("data");
            this._spaceUsedByIndex = resultSet.getString("index_size");
            this._unusedSpace = resultSet.getString("unused");
        }
        this.getRSet().close();
        if (this.isSpaceUsedSyslogsApplicable()) {
            resultSet = this.getRSet().open("exec sp_spaceused syslogs");
            while (resultSet.next()) {
                this._logTotalSpace = resultSet.getString("total_pages").trim();
                this._logFreeSpace = resultSet.getString("free_pages").trim();
                this._logUsedSpace = resultSet.getString("used_pages").trim();
                this._logReservedSpace = resultSet.getString("reserved_pages").trim();
            }
            this.getRSet().close();
        }
    }

    public boolean isSpaceUsedSyslogsApplicable() {
        return this.getConnection().getVersion().compareTo("12.5.1") >= 0;
    }

    public double getTotalSpaceinMB() {
        return this._MBTotalSpace;
    }

    public String getReserveSpace() {
        return this._reservedSpace;
    }

    public String getSpaceUsedByData() {
        return this._spaceUsedByData;
    }

    public String getSpaceUsedByIndex() {
        return this._spaceUsedByIndex;
    }

    public String getUnusedSpace() {
        return this._unusedSpace;
    }

    public String getUnreservedSpace() {
        double d = Utility.getMBToKB(this._MBTotalSpace);
        double d2 = 0.0;
        if (this._reservedSpace != null && this._reservedSpace.length() > 0) {
            int n = this._reservedSpace.indexOf(" KB");
            String string = this._reservedSpace.substring(0, n);
            d2 = Double.valueOf(string);
        }
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(d - d2);
    }

    public String getLogTotalPages() {
        return this._logTotalSpace;
    }

    public String getLogFreePages() {
        return this._logFreeSpace;
    }

    public String getLogUsedPages() {
        return this._logUsedSpace;
    }

    public String getLogReservedPages() {
        return this._logReservedSpace;
    }

    public double getPageSize() {
        return this._conn.getPageSize();
    }

    public boolean getOptionStatus(String string) throws SQLException {
        this.getRSet().open(SQLs.getString("select type, number from master.dbo.spt_values where name like ''%'' + ''{0}'' + ''%''", string));
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string2.equals("D")) {
                return (this._dbStatus & (long)Integer.parseInt(string3)) != 0L;
            }
            if (string2.equals("D2")) {
                return (this._dbStatus2 & (long)Integer.parseInt(string3)) != 0L;
            }
            if (!string2.equals("D3")) continue;
            return (this._dbStatus3 & (long)Integer.parseInt(string3)) != 0L;
        }
        return false;
    }

    public void setOptionStatus(String string, boolean bl) throws SQLException {
        this.useMasterDB();
        String string2 = "exec sp_dboption";
        String string3 = "checkpoint";
        String string4 = string2 + " '" + this.getName() + "' , '" + string + "' , " + new Boolean(bl).toString();
        this._conn.executeCommand(string4);
        this.useDB();
        this.load(true);
        this._conn.executeCommand(string3);
    }

    public boolean getOption(String string) {
        if (string.compareTo(DB_OP_ALLOW_BULK) == 0) {
            return (this._dbStatus & 4L) != 0L;
        }
        if (string.compareTo(DB_OP_TRUNCATE_LOG) == 0) {
            return (this._dbStatus & 8L) != 0L;
        }
        if (string.compareTo(DB_OP_DDL_IN_TRAN) == 0) {
            return (this._dbStatus & 0x200L) != 0L;
        }
        if (string.compareTo(DB_OP_READ_ONLY) == 0) {
            return (this._dbStatus & 0x400L) != 0L;
        }
        if (string.compareTo(DB_OP_DBO_ONLY) == 0) {
            return (this._dbStatus & 0x800L) != 0L;
        }
        if (string.compareTo(DB_OP_SINGLE_USER) == 0) {
            return (this._dbStatus & 0x1000L) != 0L;
        }
        if (string.compareTo(DB_OP_ALLOW_NULLS) == 0) {
            return (this._dbStatus & 0x2000L) != 0L;
        }
        if (string.compareTo(DB_OP_ABORT_ON_FULL) == 0) {
            return (this._dbStatus2 & 1L) != 0L;
        }
        if (string.compareTo(DB_OP_AUTO_IDENTITY) == 0) {
            return (this._dbStatus2 & 4L) != 0L;
        }
        if (string.compareTo(DB_OP_ADD_IDENTITY) == 0) {
            return (this._dbStatus2 & 8L) != 0L;
        }
        return false;
    }

    public void setOption(String string, boolean bl) throws SQLException {
        int n;
        String string2 = "";
        this.useMasterDB();
        if (string.compareTo(DB_OP_ALLOW_BULK) == 0) {
            n = 4;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "select into/bulkcopy" + "' , " + new Boolean(bl).toString();
            this._dbStatus ^= (long)n;
        } else if (string.compareTo(DB_OP_TRUNCATE_LOG) == 0) {
            n = 8;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "trunc log on chkpt" + "' , " + new Boolean(bl).toString();
            this._dbStatus ^= (long)n;
        } else if (string.compareTo(DB_OP_DDL_IN_TRAN) == 0) {
            n = 512;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "ddl in tran" + "' , " + new Boolean(bl).toString();
            this._dbStatus ^= (long)n;
        } else if (string.compareTo(DB_OP_READ_ONLY) == 0) {
            n = 1024;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "read only" + "' , " + new Boolean(bl).toString();
            this._dbStatus ^= (long)n;
        }
        if (string.compareTo(DB_OP_DBO_ONLY) == 0) {
            n = 2048;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "dbo use only" + "' , " + new Boolean(bl).toString();
            this._dbStatus ^= (long)n;
        } else if (string.compareTo(DB_OP_SINGLE_USER) == 0) {
            n = 4096;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "single user" + "' , " + new Boolean(bl).toString();
            this._dbStatus ^= (long)n;
        } else if (string.compareTo(DB_OP_ALLOW_NULLS) == 0) {
            n = 8192;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "allow nulls by default" + "' , " + new Boolean(bl).toString();
            this._dbStatus ^= (long)n;
        } else if (string.compareTo(DB_OP_ABORT_ON_FULL) == 0) {
            n = 1;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "abort tran on log full" + "' , " + new Boolean(bl).toString();
            this._dbStatus2 ^= (long)n;
        } else if (string.compareTo(DB_OP_AUTO_IDENTITY) == 0) {
            n = 4;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "auto identity" + "' , " + new Boolean(bl).toString();
            this._dbStatus2 ^= (long)n;
        } else if (string.compareTo(DB_OP_ADD_IDENTITY) == 0) {
            n = 8;
            string2 = "exec sp_dboption '" + this.getName() + "' , '" + "identity in nonunique index" + "' , " + new Boolean(bl).toString();
            this._dbStatus2 ^= (long)n;
        }
        this._conn.executeCommand(string2);
        this.useDB();
        this._conn.executeCommand("checkpoint");
    }

    public void fillLogList() throws SQLException {
        this.getRSet().open("select a.name, substring( a.comment, 1, charindex('K', a.comment) -1), b.value, a.value3 * convert( int, substring( a.comment, 1, charindex('K', a.comment ) -1)) from master.dbo.sysconfigures a, master.dbo.syscurconfigs b where a.parent = 19 and a.config != a.parent and b.config = a.config and b.comment = a.name and a.status & 4 = 4 order by name");
        this._logCacheList.removeAllElements();
        this._poolList.removeAllElements();
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            this._logCacheList.addElement(stringArray[0].trim());
            this._poolList.addElement(stringArray[1].trim());
        }
        this.getRSet().close();
    }

    public Vector getlogCacheList() {
        return this._logCacheList;
    }

    public Vector getpoolList() {
        return this._poolList;
    }

    public String getLogCache() {
        return this._dbLogFileCache;
    }

    public String[] getVectorToArray(Vector vector) {
        return Utility.getVectorToArray(vector);
    }

    public String getLastChanceThreshold() {
        return this._dblastChance;
    }

    public void setLogCache(String string) throws SQLException {
        String string2 = ASEUtils.getString("MSG_NONE");
        boolean bl = this.getOption(DB_OP_SINGLE_USER);
        if (!bl) {
            this.setOption(DB_OP_SINGLE_USER, true);
        }
        this._dbLogFileCache = string;
        if (string.compareTo(string2) == 0) {
            String string3 = "exec sp_unbindcache  '" + this.getName() + "', " + "'syslogs'";
            this._conn.executeCommand(string3);
        } else {
            String string4 = "exec sp_bindcache  '" + string + "', '" + this.getName() + "', " + "'syslogs'";
            this._conn.executeCommand(string4);
        }
        if (!bl) {
            this.setOption(DB_OP_SINGLE_USER, false);
        }
    }

    public void setLogIOSize(String string) throws SQLException {
        String string2 = "exec sp_logiosize '" + string + "' ";
        this._conn.executeCommand(string2);
    }

    public Vector fillDevicesForDB() throws SQLException {
        Object object;
        this._deviceList = new Vector();
        int n = 3;
        int n2 = 2;
        int n3 = 3;
        int n4 = 4;
        int n5 = 7;
        DatabaseDeviceSO databaseDeviceSO = new DatabaseDeviceSO(this._conn, "");
        if (this.isInIMDBFamily()) {
            databaseDeviceSO.setDatabaseDeviceType(2);
        }
        String string = SQLs.getString(databaseDeviceSO.getDBDeviceInfoSQL(), String.valueOf(Utility.getMBToPageSize(this._conn)), this.getName());
        Vector<String[]> vector = Utility.openQuery2(string, this._conn);
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = vector.elementAt(i);
            object = stringArray[0];
            int n6 = Integer.parseInt(stringArray[n]);
            double d = Double.valueOf(stringArray[n2]);
            int n7 = -1;
            boolean bl = this instanceof ArchiveDBSO;
            for (int j = 0; j < this._deviceList.size() && n7 == -1; ++j) {
                Vector vector2 = (Vector)this._deviceList.elementAt(j);
                String string2 = (String)vector2.elementAt(0);
                int n8 = (Integer)vector2.elementAt(2);
                if (((String)object).compareTo(string2) != 0) continue;
                boolean bl2 = false;
                if (bl) {
                    bl2 = true;
                } else if (n8 == n6) {
                    bl2 = true;
                }
                if (!bl2) continue;
                double d2 = (Double)vector2.elementAt(1);
                vector2.removeElementAt(1);
                vector2.insertElementAt(new Double(d + d2), 1);
                vector2.removeElementAt(2);
                vector2.insertElementAt(new Integer(n8), 2);
                n7 = j;
            }
            if (n7 != -1) continue;
            Vector<Object> vector3 = new Vector<Object>();
            vector3.addElement(object);
            vector3.addElement(new Double(d));
            vector3.addElement(new Integer(n6));
            this._deviceList.addElement(vector3);
        }
        ImageIcon imageIcon = new ImageIcon(ASEImages.getDeviceSmallImage());
        for (int i = 0; i < this._deviceList.size(); ++i) {
            object = (Vector)this._deviceList.elementAt(i);
            String string3 = (String)((Vector)object).elementAt(0);
            JLabel jLabel = new JLabel(string3, imageIcon, 0);
            ((Vector)object).removeElementAt(0);
            ((Vector)object).insertElementAt(jLabel, 0);
            int n9 = (Integer)((Vector)object).elementAt(2);
            if (n9 == n5) {
                ((Vector)object).removeElementAt(2);
                ((Vector)object).insertElementAt(ASEUtils.getString("MSG_DATA_AND_LOG"), 2);
                continue;
            }
            if (n9 == n3) {
                ((Vector)object).removeElementAt(2);
                ((Vector)object).insertElementAt(ASEUtils.getString("MSG_DATA"), 2);
                continue;
            }
            if (n9 != n4) continue;
            ((Vector)object).removeElementAt(2);
            ((Vector)object).insertElementAt(ASEUtils.getString("MSG_LOG"), 2);
        }
        return this._deviceList;
    }

    public void moveLogToData(String string) throws SQLException {
        this.useMasterDB();
        this._conn.executeCommand(SQLs.getString("exec sp_logdevice ''{0}'', ''{1}''", this.getName(), string));
    }

    public void addDBDSize(String string, double d, int n) throws SQLException {
        this.useMasterDB();
        String string2 = "";
        string2 = n == 0 ? SQLs.getString("alter database {0} on {1} = {2}", this.getName(), string, new Integer(new Double(d).intValue()).toString()) : SQLs.getString("alter database {0} log on {1} = {2}", this.getName(), string, new Integer(new Double(d).intValue()).toString());
        if (this.isForLoad()) {
            string2 = string2 + " for load ";
        }
        this._conn.executeCommand(string2);
    }

    public void newDBD(String string, String string2, boolean bl, int n) throws SQLException {
        this.useMasterDB();
        String string3 = "";
        string3 = n == 0 ? (!bl ? SQLs.getString("alter database {0} on {1} = {2}", this.getName(), string, string2) : SQLs.getString("alter database {0} on {1} = {2}", this.getName(), string, string2) + " WITH OVERRIDE") : (!bl ? SQLs.getString("alter database {0} log on {1} = {2}", this.getName(), string, string2) : SQLs.getString("alter database {0} log on {1} = {2}", this.getName(), string, string2) + " WITH OVERRIDE");
        if (this.isForLoad()) {
            string3 = string3 + " for load ";
        }
        this._conn.executeCommand(string3);
    }

    public String checkDatabaseConsistency(String string) throws SQLException {
        return Utility.checkDatabaseConsistency(this.getConnection(), this, string);
    }

    public boolean isDumpOrLoadInProgress() throws SQLException {
        String string = SQLs.getString("select P.cmd, D.name from master.dbo.sysprocesses P, master.dbo.sysdatabases D where ( P.cmd = ''DUMP DATABASE'' or P.cmd = ''LOAD DATABASE'' ) and D.name = ''{0}'' and P.dbid = D.dbid", this.getName());
        Vector<String[]> vector = Utility.openQuery2(string, this._conn);
        return vector.size() > 0;
    }

    protected void setDBID(String string) {
        this._dbID = string;
    }

    protected void setDBOwner(String string) {
        this._dbOwner = string;
    }

    protected void setCreationDate(Date date) {
        this._dbCreationDate = date;
    }

    protected void hasGuest(boolean bl) {
        this._dbHasGuest = bl;
    }

    protected void setStatus(long l) {
        this._dbStatus = l;
    }

    protected void setStatus2(long l) {
        this._dbStatus2 = l;
    }

    protected void setStatus3(long l) {
        this._dbStatus3 = l;
    }

    protected long getStatus3() {
        return this._dbStatus3;
    }

    protected void setDBLogIOSize(String string) {
        this._dbLogIOSize = string;
    }

    protected void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    protected void setDBStrCreationDate(String string) {
        this._dbStrCreationDate = string;
    }

    public String getServerName() {
        return this._conn.getServerName();
    }

    @Override
    public Object[] getAttributes() {
        return new String[]{this.getName(), this.getOwner(), this.getCreationDate()};
    }

    public List<String[]> getOwnerList() throws SQLException {
        return Utility.getOwners(this.getConnection(), this.getName());
    }

    public void useDB() throws SQLException {
        this.useDB(this.getName());
    }

    public Vector getListDumpDevice() throws SQLException {
        String string = SQLs.getString("select name from master.dbo.sysdevices where cntrltype >1 and (status & 12 != 12)", new Integer(1));
        return Utility.openQuery2(string, this.getConnection());
    }

    public Vector getListArchiveDBDumpDevice() throws SQLException {
        String string = SQLs.getString("select name from master.dbo.sysdevices where cntrltype = 0 and status & 12 = 12 order by {0}", new Integer(1));
        return Utility.openQuery2(string, this.getConnection());
    }

    public Vector getListRemoveBackupServer() throws SQLException {
        Vector<String> vector = new Vector<String>();
        RemoteServersCtrSO remoteServersCtrSO = new RemoteServersCtrSO(this.getConnection());
        List list = remoteServersCtrSO.open(1, null);
        for (int i = 0; i < list.size(); ++i) {
            RemoteServerSO remoteServerSO = (RemoteServerSO)list.get(i);
            if (remoteServerSO.getName().equals("SYB_BACKUP")) continue;
            vector.add(remoteServerSO.getName());
        }
        return vector;
    }

    public long getModelDBSize() throws SQLException {
        long l = -1L;
        this.getRSet().open("exec sp_helpdb model ");
        this.getRSet().getNextRow();
        try {
            l = (long)Double.parseDouble(this.getRSet().getColumnString(2).substring(0, this.getRSet().getColumnString(2).length() - 2));
        }
        catch (NumberFormatException numberFormatException) {
            this.getRSet().close();
            return -1L;
        }
        this.getRSet().close();
        return l;
    }

    public long getDefaultDBSize() throws SQLException {
        long l = -1L;
        this.getRSet().open("select value from master.dbo.sysconfigures where name = 'default database size'");
        this.getRSet().getNextRow();
        try {
            l = Long.parseLong(this.getRSet().getColumnString(1));
        }
        catch (NumberFormatException numberFormatException) {
            this.getRSet().close();
            return -1L;
        }
        this.getRSet().close();
        return l;
    }

    protected Vector getDBLog() {
        return this._dblog;
    }

    public Vector getDBDevice() {
        return this._dbdevice;
    }

    public void clearProxyServerList() {
        this._vProxyServers.removeAllElements();
    }

    private Vector getProxyServers() throws SQLException {
        if (this._vProxyServers.isEmpty()) {
            this.getRSet().open("select NAME=s.srvname, TYPE=v.name from master.dbo.sysservers s, master.dbo.spt_values v where s.srvclass = v.number and v.type = 'X' and v.name not in ('ASEJB','SYSSERVERS.SRVCLASS','access_server','local') order by s.srvname");
            while (this.getRSet().getNextRow()) {
                String string = this.getRSet().getColumnString(1);
                String string2 = this.getRSet().getColumnString(2);
                if (string.compareTo(string.toUpperCase()) == 0 && string.endsWith("_XP") || string.equals("SYB_BACKUP")) continue;
                ProxyServer proxyServer = new ProxyServer(string, string2, this.getRSet());
                this._vProxyServers.addElement(proxyServer);
            }
            this.getRSet().close();
        }
        return this._vProxyServers;
    }

    public boolean hasCISMappingForRemoteServer(String string) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        return proxyServer.hasCISMapping();
    }

    public String[] getProxyServerNames() throws SQLException {
        Vector vector = this.getProxyServers();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((ProxyServer)vector.elementAt(i)).getName();
        }
        return stringArray;
    }

    public boolean isGatewayLess(String string) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        return proxyServer.isGatewayLess();
    }

    public boolean hasDBsInRemoteServer(String string) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        return proxyServer.hasDB();
    }

    public String[] getRemoteDatabases(String string) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        Vector vector = proxyServer.getRemoteDatabases();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((RemoteDatabase)vector.elementAt(i)).getName();
        }
        return stringArray;
    }

    private int getProxyServerIndex(String string) throws SQLException {
        String[] stringArray = this.getProxyServerNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void setFilterSysTable(String string, String string2, boolean bl) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        RemoteDatabase remoteDatabase = proxyServer.findRemDB(string2);
        remoteDatabase.setFilterSysTable(bl);
    }

    public boolean getFilterSysTable(String string, String string2) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        RemoteDatabase remoteDatabase = proxyServer.findRemDB(string2);
        return remoteDatabase.getFilterSysTable();
    }

    public Vector getRemoteUsers(String string, String string2) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        RemoteDatabase remoteDatabase = proxyServer.findRemDB(string2);
        return remoteDatabase.getUsers();
    }

    public Vector getRemoteTables(String string, String string2) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        RemoteDatabase remoteDatabase = proxyServer.findRemDB(string2);
        return remoteDatabase.getTablesAndViews();
    }

    public Vector getRPCs(String string, String string2) throws SQLException {
        ProxyServer proxyServer = (ProxyServer)this._vProxyServers.elementAt(this.getProxyServerIndex(string));
        RemoteDatabase remoteDatabase = proxyServer.findRemDB(string2);
        return remoteDatabase.getRPCs();
    }

    public void setDBType(int n) {
        this._dbType = n;
    }

    public int getDBType() {
        return this._dbType;
    }

    public boolean isProxy() {
        return !this._dbRemoteLocation.equals("");
    }

    public void alterDurability(String string) throws SQLException {
        this.useMasterDB();
        String string2 = SQLs.getString("alter database {0} set durability = {1}", this.getName(), string);
        this._conn.executeCommand(string2);
    }

    public boolean isQuiesceHold() {
        return (this._dbStatus3 & FLAG_DB_QUIESCE) != 0L;
    }

    public void quiesceHold(String string, String string2, boolean bl, String string3, boolean bl2) throws SQLException {
        String string4 = SQLs.getString("quiesce database {0} hold {1} ", string, string2);
        if (bl) {
            string4 = string4 + " for external dump ";
        }
        if (string3 != null) {
            string4 = string4 + SQLs.getString(" to ''{0}''", string3);
            if (bl2) {
                string4 = string4 + " with override ";
            }
        }
        this._conn.executeCommand(string4);
    }

    public void quiesceRelease(String string) throws SQLException {
        this._conn.executeCommand(SQLs.getString("quiesce database {0} release", string));
    }

    public Vector getQuiesceTagList() throws SQLException {
        Vector vector = new Vector();
        this.getRSet().executeRPC("$monOpenDatabases");
        boolean bl = false;
        Vector<String> vector2 = new Vector<String>();
        while (this.getRSet().getNextRow()) {
            String string = this.getRSet().getColumnString("QuiesceTag");
            if (string.equals("")) continue;
            String string2 = this.getRSet().getColumnString("DBName");
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)((Vector)vector.elementAt(i)).elementAt(0);
                if (!string3.equals(string)) continue;
                string3 = (String)((Vector)vector.elementAt(i)).elementAt(1);
                string3 = string3 + ", " + string2;
                ((Vector)vector.elementAt(i)).setElementAt(string3, 1);
                bl = true;
                break;
            }
            if (!bl) {
                vector2 = new Vector();
                vector2.addElement(string);
                vector2.addElement(string2);
                vector.addElement(vector2);
                continue;
            }
            bl = false;
        }
        this.getRSet().close();
        return vector;
    }

    public void unMount(String string, String string2, boolean bl, String string3) throws SQLException {
        String string4 = SQLs.getString("unmount database {0} to ''{1}''", string, string2);
        boolean bl2 = false;
        if (bl) {
            string4 = string4 + " with override ,";
            bl2 = true;
        }
        if (string3.length() != 0) {
            string4 = string4 + (bl2 ? "" : "with");
            string4 = string4 + " " + SQLs.getString("waitfor=''{0}''", string3);
            bl2 = false;
        }
        if (bl2) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        this.useMasterDB();
        this._conn.executeCommand(string4);
    }

    public Vector getDatabaseDeviceDatabaseList(String string) throws SQLException {
        Vector<String[]> vector = new Vector<String[]>();
        String string2 = "";
        string2 = this.getConnection().getVersion().compareTo("15") >= 0 ? "select distinct DEVICE_NAME=dev.name, DB_NAME=db_name(u2.dbid) from master.dbo.sysusages u1, master.dbo.sysdevices dev, master.dbo.sysusages u2 where (u1.vdevno = dev.vdevno) and (u2.vdevno = dev.vdevno) and dev.status & 2 = 2 and db_name(u1.dbid) in (select distinct db_name(u2.dbid) from master.dbo.sysusages u1, master.dbo.sysdevices dev, master.dbo.sysusages u2 where db_name(u1.dbid) in ({0}) and (u1.vdevno = dev.vdevno) and (u2.vdevno = dev.vdevno) and dev.status & 2 = 2) order by 1" : "select distinct DEVICE_NAME=dev.name, DB_NAME=db_name(u2.dbid) from master.dbo.sysusages u1, master.dbo.sysdevices dev, master.dbo.sysusages u2 where (u1.vstart between dev.low and dev.high) and (u2.vstart between dev.low and dev.high) and dev.status & 2 = 2 and db_name(u1.dbid) in (select distinct db_name(u2.dbid) from master.dbo.sysusages u1, master.dbo.sysdevices dev, master.dbo.sysusages u2 where db_name(u1.dbid) in ({0}) and (u1.vstart between dev.low and dev.high) and (u2.vstart between dev.low and dev.high) and dev.status & 2 = 2) order by 1";
        this.getRSet().open(SQLs.getString(string2, string));
        String string3 = "";
        boolean bl = true;
        String[] stringArray = new String[3];
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (this.getRSet().getNextRow()) {
            String string4 = this.getRSet().getColumnString(1);
            String string5 = this.getRSet().getColumnString(2);
            if (bl) {
                string3 = string4;
                bl = false;
            }
            if (string4.equals(string3)) {
                if (string.indexOf("'" + string5 + "'") != -1) {
                    stringBuffer.append(string5).append(", ");
                } else {
                    stringBuffer2.append(string5).append(", ");
                }
            } else {
                stringArray = new String[3];
                stringArray[0] = stringBuffer.toString();
                if (!stringArray[0].equals("")) {
                    stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 2);
                }
                stringArray[1] = string3;
                stringArray[2] = stringBuffer2.toString();
                if (!stringArray[2].equals("")) {
                    stringArray[2] = stringArray[2].substring(0, stringArray[2].length() - 2);
                }
                vector.addElement(stringArray);
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
                if (string.indexOf("'" + string5 + "'") != -1) {
                    stringBuffer.append(string5).append(", ");
                } else {
                    stringBuffer2.append(string5).append(", ");
                }
            }
            string3 = string4;
        }
        stringArray = new String[3];
        stringArray[0] = stringBuffer.toString();
        if (!stringArray[0].equals("")) {
            stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 2);
        }
        stringArray[1] = string3;
        stringArray[2] = stringBuffer2.toString();
        if (!stringArray[2].equals("")) {
            stringArray[2] = stringArray[2].substring(0, stringArray[2].length() - 2);
        }
        vector.addElement(stringArray);
        return vector;
    }

    public void mount(String string, String string2, boolean bl, String string3) throws SQLException {
        String string4 = SQLs.getString("mount database {0} from ''{1}''", string, string2);
        if (bl) {
            string4 = string4 + " with verify";
        }
        if (string3 != null) {
            string4 = string4 + " " + SQLs.getString("using {0}", string3);
        }
        this.useMasterDB();
        this._conn.executeCommand(string4);
    }

    public Vector decodeDeviceSpecificationFromManifest(String string) throws SQLException, StringIndexOutOfBoundsException {
        Vector vector = new Vector();
        String string2 = this._conn.executeReturnWarningMsg("master", SQLs.getString("mount database all from ''{0}'' with listonly", string));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            Vector<String> vector2 = new Vector<String>();
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(61);
            String string4 = string3.substring(n + 1);
            string4 = string4.trim();
            string4 = string4.substring(1, string4.length() - 1);
            String string5 = string3.substring(0, n);
            string5 = string5.trim();
            string5 = string5.substring(1, string5.length() - 1);
            vector2.addElement(string4);
            vector2.addElement(string5);
            vector.addElement(vector2);
        }
        return vector;
    }

    public String isBackupServerUp() {
        String string = "";
        try {
            String string2 = SQLs.getString("exec {0}...sp_who", "SYB_BACKUP");
            this.getRSet().open(string2);
        }
        catch (SQLException sQLException) {
            string = sQLException.getMessage();
        }
        return string;
    }

    public boolean isTempDBGroupApplicable() throws SQLException {
        if (this.getConnection().getVersion().compareTo("12.5.0.3") < 0) {
            return false;
        }
        String string = SQLs.getString("select object_cinfo, int_value from master..sysattributes where class = 16 and attribute = 0 and object_type = ''GR'' order by {0} ", new Integer(1));
        this.getRSet().open(string);
        if (this.getRSet().getNextRow()) {
            return true;
        }
        this.getRSet().close();
        return false;
    }

    public Enumeration getdbOptionData() throws SQLException {
        Vector<String> vector = new Vector<String>();
        this.getRSet().open("exec sp_dboption");
        while (this.getRSet().getNextRow()) {
            String[] stringArray = this.getRSet().getColumnsAsArray();
            vector.addElement(stringArray[0]);
        }
        this.getRSet().close();
        return vector.elements();
    }

    public boolean getAvailableDBDevice() throws SQLException {
        DatabaseDevicesCtrSO databaseDevicesCtrSO = new DatabaseDevicesCtrSO(this.getConnection());
        List list = databaseDevicesCtrSO.open(1, null);
        if (list != null && list.size() > 0) {
            for (DatabaseDeviceSO databaseDeviceSO : list) {
                if (!databaseDeviceSO.getSelectedDefault()) continue;
                return true;
            }
        }
        return false;
    }

    public void setDefaultRemoteLocation(String string) {
        this._dbRemoteLocation = string;
    }

    public String getDefaultRemoteLocation() {
        return this._dbRemoteLocation;
    }

    @Override
    public String getDisplayType() {
        return ASEUtils.getString("DISP_DATABASE_TEXT");
    }

    public boolean isAutoExpansionApplicable() throws SQLException {
        if (this._isAutoExpansionApplicable != null) {
            return this._isAutoExpansionApplicable;
        }
        if (this._conn.getVersion().compareTo("12.5.1") < 0) {
            this._isAutoExpansionApplicable = new Boolean(false);
            return false;
        }
        if ((this.getOwner().equals(this._conn.getUser()) || this._conn.hasSARole()) && this._conn.isExpansionProcedureInstalled()) {
            this._isAutoExpansionApplicable = new Boolean(true);
            return true;
        }
        this._isAutoExpansionApplicable = new Boolean(false);
        return false;
    }

    public String getDefaultGrowBySize() throws SQLException {
        this.getRSet().open("select char_value from master..sysattributes where class = 19 and attribute = 51 and object_type = 'DB' and object_cinfo = 'default' and object = 1");
        if (this.getRSet().getNextRow()) {
            return this.getRSet().getColumnString(1);
        }
        return "0";
    }

    public void setGrowBySize(String string) {
        this._growBySize = string;
    }

    public void migratePoliciesfromModel(boolean bl) {
        this._migratePolicies = bl;
    }

    private void modifyDefaultPolicies() throws SQLException {
        this.useDB();
        String string = SQLs.getString("exec sp_dbextend ''modify'',''database'',''default'',null,''growby'',''{0}''", this._growBySize);
        this._conn.executeCommand(string);
    }

    private void migratePoliciesFromModel() throws SQLException {
        this.useDB("model");
        this.getRSet().open("exec sp_dbextend 'list','database','model'");
        this.useDB();
        while (this.getRSet().getNextRow()) {
            String string;
            if (!this.getRSet().getColumnString("name").equals("model")) continue;
            if (this.getRSet().getColumnString("item").equals("growby")) {
                string = SQLs.getString("exec sp_dbextend ''set'',''database'',''{0}'',''{1}'',''{2}''", this.getName(), this.getRSet().getColumnString("segment"), this.getRSet().getColumnString("value"));
                this._conn.executeCommand(string);
            }
            if (!this.getRSet().getColumnString("item").equals("maxsize")) continue;
            string = SQLs.getString("exec sp_dbextend ''set'',''database'',''{0}'',''{1}'',null,''{2}''", this.getName(), this.getRSet().getColumnString("segment"), this.getRSet().getColumnString("value"));
            this._conn.executeCommand(string);
        }
    }

    public boolean systemDefaultHasSet() throws SQLException {
        if (!this.getConnection().isEncryptedKeyEnabled()) {
            return false;
        }
        boolean bl = false;
        this.getRSet().open(SQLs.getString("select * from {0}..sysattributes where class=25 and attribute=0", this.getName()));
        while (this.getRSet().getNextRow()) {
            bl = true;
        }
        return bl;
    }

    public int getMinPasswordLength() {
        int n = 6;
        try {
            n = this.getConnection().getSPConfigRunValue("minimum password length");
        }
        catch (SQLException sQLException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public void createSystemEncryptionPassword(String string) throws SQLException {
        this.useDB();
        this._conn.executeCommand(SQLs.getString("sp_encryption system_encr_passwd, ''{0}''", string));
    }

    public void alterSystemEncryptionPassword(String string, String string2) throws SQLException {
        this.useDB();
        this._conn.executeCommand(SQLs.getString("sp_encryption system_encr_passwd, ''{0}'',  ''{1}''", string, string2));
    }

    public void deleteSystemEncryptionPassword(String string) throws SQLException {
        this.useDB();
        this._conn.executeCommand(SQLs.getString("sp_encryption system_encr_passwd, null, ''{0}''", string));
    }

    public String getDefaultDevicesList() throws SQLException {
        String string = "";
        this.getRSet().open("select name from master..sysdevices where ((status & 1) != 0) ");
        while (this.getRSet().getNextRow()) {
            if (string.equals("")) {
                string = this.getRSet().getColumnString(1);
                continue;
            }
            string = string + "," + this.getRSet().getColumnString(1);
        }
        return string;
    }

    @Override
    public boolean enableCreate() {
        return !this.getOption(DB_OP_READ_ONLY);
    }

    @Override
    public boolean includeCreate() {
        return !this.isArchiveDB();
    }

    @Override
    public boolean includeDelete() {
        return !this.isSystem();
    }

    @Override
    public boolean enableDelete() {
        return this._conn.hasSARole();
    }

    public boolean hasScalarFunction() {
        return this.getConnection().getVersion().compareTo("15.0.2") >= 0;
    }

    public boolean hasTableFunction() {
        return false;
    }

    public String getIMCacheName() throws SQLException {
        if (!this.isInIMDBFamily()) {
            return "";
        }
        String string = "";
        if (!this._conn.isCluster()) {
            Object[] objectArray = new Object[]{this.getName(), "%"};
            String string2 = SQLs.getString("select d.phyname, c.name from master.dbo.sysusages u, master.dbo.sysdevices d, master.dbo.sysdatabases c where d.vdevno = u.vdevno and d.status2&8=8 and u.dbid = c.dbid and c.status4&4096=4096 and c.name like ''{0}'' and d.phyname like ''{1}''", objectArray);
            this.getRSet().open(string2);
            if (this.getRSet().getNextRow()) {
                string = this.getRSet().getColumnString(1);
            }
            this.getRSet().close();
        }
        return string;
    }
}

